/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.kalman;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.tracking.SpotTracker;
import fiji.plugin.trackmate.tracking.jaqaman.JaqamanLinker;
import fiji.plugin.trackmate.tracking.jaqaman.costfunction.CostFunction;
import fiji.plugin.trackmate.tracking.jaqaman.costfunction.FeaturePenaltyCostFunction;
import fiji.plugin.trackmate.tracking.jaqaman.costfunction.SquareDistCostFunction;
import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.JaqamanLinkingCostMatrixCreator;
import fiji.plugin.trackmate.tracking.kalman.CVMKalmanFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import net.imglib2.algorithm.Benchmark;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.scijava.Cancelable;

public class KalmanTracker
implements SpotTracker,
Benchmark,
Cancelable {
    private static final double ALTERNATIVE_COST_FACTOR = 1.05;
    private static final double PERCENTILE = 1.0;
    private static final String BASE_ERROR_MSG = "[KalmanTracker] ";
    private SimpleWeightedGraph<Spot, DefaultWeightedEdge> graph;
    private String errorMessage;
    private Logger logger = Logger.VOID_LOGGER;
    private final SpotCollection spots;
    private final double maxSearchRadius;
    private final int maxFrameGap;
    private final double initialSearchRadius;
    private final Map<String, Double> featurePenalties;
    private boolean savePredictions = false;
    private SpotCollection predictionsCollection;
    private long processingTime;
    private boolean isCanceled;
    private String cancelReason;

    public KalmanTracker(SpotCollection spots, double maxSearchRadius, int maxFrameGap, double initialSearchRadius, Map<String, Double> featurePenalties) {
        this.spots = spots;
        this.maxSearchRadius = maxSearchRadius;
        this.maxFrameGap = maxFrameGap;
        this.initialSearchRadius = initialSearchRadius;
        this.featurePenalties = featurePenalties;
    }

    public SimpleWeightedGraph<Spot, DefaultWeightedEdge> getResult() {
        return this.graph;
    }

    public boolean checkInput() {
        return true;
    }

    public boolean process() {
        long start = System.currentTimeMillis();
        this.isCanceled = false;
        this.cancelReason = null;
        this.graph = new SimpleWeightedGraph(DefaultWeightedEdge.class);
        this.predictionsCollection = new SpotCollection();
        double maxCost = this.maxSearchRadius * this.maxSearchRadius;
        CostFunction<Spot, Spot> nucleatingCostFunction = this.getCostFunction(this.featurePenalties);
        double maxInitialCost = this.initialSearchRadius * this.initialSearchRadius;
        CostFunction<Spot, Spot> costFunction = this.getCostFunction(this.featurePenalties);
        NavigableSet<Integer> keySet = this.spots.keySet();
        Iterator<Integer> frameIterator = keySet.iterator();
        Collection<Object> previousOrphanSpots = new ArrayList();
        if (!frameIterator.hasNext()) {
            return true;
        }
        int firstFrame = frameIterator.next();
        while (true) {
            previousOrphanSpots = KalmanTracker.generateSpotList(this.spots, firstFrame);
            if (!frameIterator.hasNext()) {
                return true;
            }
            if (!previousOrphanSpots.isEmpty()) break;
            firstFrame = frameIterator.next();
        }
        Collection<Object> orphanSpots = new ArrayList();
        int secondFrame = frameIterator.next();
        while (true) {
            orphanSpots = KalmanTracker.generateSpotList(this.spots, secondFrame);
            if (!frameIterator.hasNext()) {
                return true;
            }
            if (!orphanSpots.isEmpty()) break;
            secondFrame = frameIterator.next();
        }
        double positionProcessStd = this.maxSearchRadius / 3.0;
        double velocityProcessStd = this.maxSearchRadius / 3.0;
        double meanSpotRadius = 0.0;
        for (Spot spot : orphanSpots) {
            meanSpotRadius += spot.getFeature("RADIUS").doubleValue();
        }
        double positionMeasurementStd = (meanSpotRadius /= (double)orphanSpots.size()) / 10.0;
        HashMap<CVMKalmanFilter, Spot> kalmanFiltersMap = new HashMap<CVMKalmanFilter, Spot>(orphanSpots.size());
        int p = 1;
        for (int frame = secondFrame; frame <= (Integer)keySet.last(); ++frame) {
            double cost;
            DefaultWeightedEdge edge;
            if (this.isCanceled()) {
                return true;
            }
            ++p;
            List<Spot> measurements = KalmanTracker.generateSpotList(this.spots, frame);
            HashMap<Spot, CVMKalmanFilter> predictionMap = new HashMap<Spot, CVMKalmanFilter>(kalmanFiltersMap.size());
            for (CVMKalmanFilter kf : kalmanFiltersMap.keySet()) {
                double[] X = kf.predict();
                Spot s = (Spot)kalmanFiltersMap.get(kf);
                Spot predSpot = new Spot(X[0], X[1], X[2], s.getFeature("RADIUS"), s.getFeature("QUALITY"));
                if (null != this.featurePenalties) {
                    predSpot.copyFeatures(s, this.featurePenalties);
                }
                predictionMap.put(predSpot, kf);
                if (!this.savePredictions) continue;
                Spot pred = new Spot(X[0], X[1], X[2], s.getFeature("RADIUS"), s.getFeature("QUALITY"));
                pred.setName("Pred_" + s.getName());
                pred.putFeature("RADIUS", s.getFeature("RADIUS"));
                this.predictionsCollection.add(predSpot, frame);
            }
            ArrayList predictions = new ArrayList(predictionMap.keySet());
            HashSet childlessKFs = new HashSet(kalmanFiltersMap.keySet());
            orphanSpots = new HashSet<Spot>(measurements);
            if (!predictions.isEmpty() && !measurements.isEmpty()) {
                JaqamanLinkingCostMatrixCreator<Spot, Spot> crm = new JaqamanLinkingCostMatrixCreator<Spot, Spot>(predictions, measurements, costFunction, maxCost, 1.05, 1.0);
                JaqamanLinker<Spot, Spot> linker = new JaqamanLinker<Spot, Spot>(crm);
                if (!linker.checkInput() || !linker.process()) {
                    this.errorMessage = "[KalmanTracker] Error linking candidates in frame " + frame + ": " + linker.getErrorMessage();
                    return false;
                }
                Object agnts = linker.getResult();
                Map<Spot, Double> costs = linker.getAssignmentCosts();
                for (Spot spotty : agnts.keySet()) {
                    CVMKalmanFilter kf = (CVMKalmanFilter)predictionMap.get(spotty);
                    Spot source = (Spot)kalmanFiltersMap.get(kf);
                    Spot target = (Spot)agnts.get(spotty);
                    this.graph.addVertex((Object)source);
                    this.graph.addVertex((Object)target);
                    edge = (DefaultWeightedEdge)this.graph.addEdge((Object)source, (Object)target);
                    cost = costs.get(spotty);
                    this.graph.setEdgeWeight((Object)edge, cost);
                    kf.update(KalmanTracker.toMeasurement(target));
                    kalmanFiltersMap.put(kf, target);
                    orphanSpots.remove(target);
                    childlessKFs.remove(kf);
                }
            }
            if (!previousOrphanSpots.isEmpty() && !orphanSpots.isEmpty()) {
                JaqamanLinkingCostMatrixCreator<Spot, Spot> ic = new JaqamanLinkingCostMatrixCreator<Spot, Spot>(previousOrphanSpots, orphanSpots, nucleatingCostFunction, maxInitialCost, 1.05, 1.0);
                JaqamanLinker newLinker = new JaqamanLinker(ic);
                if (!newLinker.checkInput() || !newLinker.process()) {
                    this.errorMessage = "[KalmanTracker] Error linking spots from frame " + (frame - 1) + " to frame " + frame + ": " + newLinker.getErrorMessage();
                    return false;
                }
                Object newAssignments = newLinker.getResult();
                Map assignmentCosts = newLinker.getAssignmentCosts();
                for (Spot source : newAssignments.keySet()) {
                    Spot target = (Spot)newAssignments.get(source);
                    orphanSpots.remove(target);
                    double[] XP = KalmanTracker.estimateInitialState(source, target);
                    CVMKalmanFilter kt = new CVMKalmanFilter(XP, Double.MIN_NORMAL, positionProcessStd, velocityProcessStd, positionMeasurementStd);
                    kalmanFiltersMap.put(kt, target);
                    this.graph.addVertex((Object)source);
                    this.graph.addVertex((Object)target);
                    edge = (DefaultWeightedEdge)this.graph.addEdge((Object)source, (Object)target);
                    cost = assignmentCosts.get(source);
                    this.graph.setEdgeWeight((Object)edge, cost);
                }
            }
            previousOrphanSpots = orphanSpots;
            for (CVMKalmanFilter kf : childlessKFs) {
                kf.update(null);
                if (kf.getNOcclusion() <= this.maxFrameGap) continue;
                kalmanFiltersMap.remove(kf);
            }
            double progress = (double)p / (double)keySet.size();
            this.logger.setProgress(progress);
        }
        if (this.savePredictions) {
            this.predictionsCollection.setVisible(true);
        }
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public SpotCollection getPredictions() {
        return this.predictionsCollection;
    }

    public void setSavePredictions(boolean doSave) {
        this.savePredictions = doSave;
    }

    public void setNumThreads() {
    }

    public void setNumThreads(int numThreads) {
    }

    public int getNumThreads() {
        return 1;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private static final double[] toMeasurement(Spot spot) {
        double[] d = new double[]{spot.getDoublePosition(0), spot.getDoublePosition(1), spot.getDoublePosition(2)};
        return d;
    }

    private static final double[] estimateInitialState(Spot first, Spot second) {
        double[] xp = new double[]{second.getDoublePosition(0), second.getDoublePosition(1), second.getDoublePosition(2), second.diffTo(first, "POSITION_X"), second.diffTo(first, "POSITION_Y"), second.diffTo(first, "POSITION_Z")};
        return xp;
    }

    private static final List<Spot> generateSpotList(SpotCollection spots, int frame) {
        ArrayList<Spot> list = new ArrayList<Spot>(spots.getNSpots(frame, true));
        Iterator<Spot> iterator = spots.iterator(frame, true);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    protected CostFunction<Spot, Spot> getCostFunction(Map<String, Double> featurePenalties) {
        if (null == featurePenalties || featurePenalties.isEmpty()) {
            return new SquareDistCostFunction();
        }
        return new FeaturePenaltyCostFunction(featurePenalties);
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void cancel(String reason) {
        this.isCanceled = true;
        this.cancelReason = reason;
    }

    public String getCancelReason() {
        return this.cancelReason;
    }
}

