/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.util.JLabelLogger;
import fiji.plugin.trackmate.util.QualityHistogramChart;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.function.DoubleConsumer;
import javax.swing.JButton;
import javax.swing.JPanel;

public class DetectionPreviewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String TOOLTIP_PREVIEW = "<html>Preview the current settings on the current frame.<p>Advice: change the settings until you get at least <br><b>all</b> the spots you want, and do not mind the <br>spurious spots too much. You will get a chance to <br>get rid of them later.</html>";
    private static final String TOOLTIP_CANCEL = "<html>Cancel the current preview.</html>";
    private static final int MAX_HEIGHT = 150;
    final Logger logger;
    final JButton btnPreview;
    final JButton btnCancel;
    final JButton btnClear;
    final QualityHistogramChart chart;

    public DetectionPreviewPanel(DoubleConsumer thresholdUpdater, String axisLabel) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWeights = new double[]{1.0, 0.0};
        gridBagLayout.rowWeights = new double[]{1.0, 0.0};
        this.setLayout(gridBagLayout);
        this.chart = new QualityHistogramChart(thresholdUpdater, axisLabel);
        GridBagConstraints gbcHistogram = new GridBagConstraints();
        gbcHistogram.gridwidth = 2;
        gbcHistogram.insets = new Insets(0, 0, 5, 0);
        gbcHistogram.fill = 1;
        gbcHistogram.gridx = 0;
        gbcHistogram.gridy = 0;
        this.add((Component)this.chart, gbcHistogram);
        JLabelLogger labelLogger = new JLabelLogger();
        labelLogger.setText(" ");
        GridBagConstraints gbcLabelLogger = new GridBagConstraints();
        gbcLabelLogger.insets = new Insets(5, 5, 0, 5);
        gbcLabelLogger.fill = 1;
        gbcLabelLogger.gridx = 0;
        gbcLabelLogger.gridy = 1;
        this.add((Component)labelLogger, gbcLabelLogger);
        this.logger = labelLogger.getLogger();
        this.btnPreview = new JButton("Preview", Icons.PREVIEW_ICON);
        this.btnPreview.setToolTipText(TOOLTIP_PREVIEW);
        this.btnPreview.setFont(Fonts.SMALL_FONT);
        this.btnCancel = new JButton("Cancel", Icons.CANCEL_ICON);
        this.btnCancel.setToolTipText(TOOLTIP_CANCEL);
        this.btnCancel.setVisible(false);
        this.btnCancel.setFont(Fonts.SMALL_FONT);
        this.btnClear = new JButton("Clear", Icons.BIN_ICON);
        this.btnClear.setToolTipText("<html>Clear the preview results <br>at the current frame.</html>");
        this.btnClear.setFont(Fonts.SMALL_FONT);
        this.btnClear.setVisible(false);
        JPanel btnPanel = new JPanel();
        btnPanel.add(this.btnClear);
        btnPanel.add(this.btnPreview);
        btnPanel.add(this.btnCancel);
        GridBagConstraints gbcBtnPreview = new GridBagConstraints();
        gbcBtnPreview.anchor = 12;
        gbcBtnPreview.insets = new Insets(5, 5, 0, 0);
        gbcBtnPreview.gridx = 1;
        gbcBtnPreview.gridy = 1;
        this.add((Component)btnPanel, gbcBtnPreview);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        if (preferredSize.width < 240) {
            preferredSize.width = 240;
        }
        if (preferredSize.height > 150) {
            preferredSize.height = 150;
        }
        return preferredSize;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension maxSize = super.getMaximumSize();
        maxSize.height = 150;
        return maxSize;
    }
}

