/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util;

import com.itextpdf.text.DocumentException;
import fiji.plugin.trackmate.features.ModelDataset;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.util.ChartExporter;
import fiji.plugin.trackmate.util.ExportableChartValueTable;
import ij.IJ;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;

public class ExportableChartPanel
extends ChartPanel {
    private static final long serialVersionUID = 1L;
    private static File currentDir;

    public ExportableChartPanel(JFreeChart chart) {
        super(chart);
    }

    public ExportableChartPanel(JFreeChart chart, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        super(chart, properties, save, print, zoom, tooltips);
    }

    public ExportableChartPanel(JFreeChart chart, int width, int height, int minimumDrawWidth, int minimumDrawHeight, int maximumDrawWidth, int maximumDrawHeight, boolean useBuffer, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        super(chart, width, height, minimumDrawWidth, minimumDrawHeight, maximumDrawWidth, maximumDrawHeight, useBuffer, properties, save, print, zoom, tooltips);
    }

    public ExportableChartPanel(JFreeChart chart, int width, int height, int minimumDrawWidth, int minimumDrawHeight, int maximumDrawWidth, int maximumDrawHeight, boolean useBuffer, boolean properties, boolean copy, boolean save, boolean print, boolean zoom, boolean tooltips) {
        super(chart, width, height, minimumDrawWidth, minimumDrawHeight, maximumDrawWidth, maximumDrawHeight, useBuffer, properties, copy, save, print, zoom, tooltips);
    }

    protected JPopupMenu createPopupMenu(boolean properties, boolean copy, boolean save, boolean print, boolean zoom) {
        JPopupMenu menu = super.createPopupMenu(properties, copy, false, print, zoom);
        menu.addSeparator();
        JMenuItem displayTableItem = new JMenuItem("Display data tables");
        displayTableItem.setActionCommand("TABLES");
        displayTableItem.addActionListener(e -> this.createDataTable());
        menu.add(displayTableItem);
        JMenuItem exportToFile = new JMenuItem("Export plot to file");
        exportToFile.addActionListener(e -> this.doSaveAs());
        menu.add(exportToFile);
        return menu;
    }

    private void createDataTable() {
        XYPlot plot = null;
        try {
            plot = this.getChart().getXYPlot();
        }
        catch (ClassCastException e) {
            return;
        }
        int nSets = plot.getDatasetCount();
        for (int i = 0; i < nSets; ++i) {
            ModelDataset dataset = (ModelDataset)plot.getDataset(i);
            String xFeature = dataset.getXFeature();
            String xStr = plot.getDomainAxis().getLabel();
            String xFeatureName = ExportableChartPanel.labelFromStr(xStr);
            String xUnits = ExportableChartPanel.unitsFromStr(xStr);
            String tableTitle = plot.getChart().getTitle().getText();
            String yUnits = ExportableChartPanel.unitsFromStr(plot.getRangeAxis().getLabel());
            ExportableChartValueTable table = new ExportableChartValueTable(dataset, xFeature, xFeatureName, xUnits, tableTitle, yUnits);
            GuiUtils.positionWindow(table, SwingUtilities.getWindowAncestor((Component)((Object)this)));
            table.setVisible(true);
        }
    }

    private static final String unitsFromStr(String str) {
        int i1 = str.lastIndexOf(40);
        int i2 = str.lastIndexOf(41);
        if (i1 >= 0 && i2 >= 0 && i2 > i1 + 1) {
            return str.substring(i1 + 1, i2);
        }
        if (i2 == i1 + 1) {
            return "";
        }
        return str;
    }

    private static final String labelFromStr(String str) {
        int i = str.indexOf(40);
        if (i <= 0) {
            return str;
        }
        if (i > 1) {
            return str.substring(0, i - 1);
        }
        return str.substring(0, i);
    }

    public void doSaveAs() {
        File file;
        if (null == currentDir) {
            currentDir = this.getDefaultDirectoryForSaveAs();
        }
        if (IJ.isMacintosh()) {
            Container dialogParent = this.getParent();
            while (!(dialogParent instanceof Frame)) {
                dialogParent = dialogParent.getParent();
            }
            Frame frame = (Frame)dialogParent;
            FileDialog dialog = new FileDialog(frame, "Export chart to PNG, PDF or SVG", 1);
            FilenameFilter filter = (dir, name) -> name.endsWith(".png") || name.endsWith(".pdf") || name.endsWith(".svg");
            dialog.setFilenameFilter(filter);
            dialog.setDirectory(currentDir == null ? null : currentDir.getAbsolutePath());
            dialog.setFile(this.getChart().getTitle().getText().replaceAll("\\.+$", "") + ".pdf");
            dialog.setVisible(true);
            String selectedFile = dialog.getFile();
            if (null == selectedFile) {
                return;
            }
            file = new File(dialog.getDirectory(), selectedFile);
            currentDir = new File(dialog.getDirectory());
        } else {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Export chart to PNG, PDF or SVG");
            fileChooser.setCurrentDirectory(currentDir);
            fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("PNG Image File", "png"));
            fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Portable Document File (PDF)", "pdf"));
            fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Scalable Vector Graphics (SVG)", "svg"));
            fileChooser.setSelectedFile(new File(currentDir, this.getChart().getTitle().getText().replaceAll("\\.+$", "") + ".pdf"));
            int option = fileChooser.showSaveDialog((Component)((Object)this));
            if (option != 0) {
                return;
            }
            file = fileChooser.getSelectedFile();
            currentDir = fileChooser.getCurrentDirectory();
        }
        try {
            if (file.getPath().endsWith(".png")) {
                ChartUtils.saveChartAsPNG((File)file, (JFreeChart)this.getChart(), (int)this.getWidth(), (int)this.getHeight());
            } else if (file.getPath().endsWith(".pdf")) {
                ChartExporter.exportChartAsPDF(file, this.getChart(), this.getWidth(), this.getHeight());
            } else if (file.getPath().endsWith(".svg")) {
                ChartExporter.exportChartAsSVG(file, this.getChart(), this.getWidth(), this.getHeight());
            } else {
                IJ.error((String)"Invalid file extension.", (String)"Please choose a filename with one of the 3 supported extension: .png, .pdf or .svg.");
            }
        }
        catch (DocumentException | IOException e) {
            e.printStackTrace();
        }
    }
}

