/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotRoi;
import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.util.SpotNeighborhood;
import fiji.plugin.trackmate.util.TMUtils;
import java.util.Iterator;
import net.imagej.ImgPlus;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RealLocalizable;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class SpotUtil {
    public static final <T extends RealType<T>> IterableInterval<T> iterable(SpotRoi roi, RealLocalizable center, ImgPlus<T> img) {
        SpotRoiIterable<T> neighborhood = new SpotRoiIterable<T>(roi, center, img);
        if (neighborhood.dimension(0) <= 1L && neighborhood.dimension(1) <= 1L) {
            return SpotUtil.makeSinglePixelIterable(center, img);
        }
        return neighborhood;
    }

    public static final <T extends RealType<T>> IterableInterval<T> iterable(Spot spot, ImgPlus<T> img) {
        SpotRoi roi = spot.getRoi();
        if (null != roi && DetectionUtils.is2D(img)) {
            return SpotUtil.iterable(roi, spot, img);
        }
        SpotNeighborhood<T> neighborhood = new SpotNeighborhood<T>(spot, img);
        int npixels = (int)neighborhood.size();
        if (npixels <= 1) {
            return SpotUtil.makeSinglePixelIterable(spot, img);
        }
        return neighborhood;
    }

    private static <T> IterableInterval<T> makeSinglePixelIterable(RealLocalizable center, ImgPlus<T> img) {
        double[] calibration = TMUtils.getSpatialCalibration(img);
        long[] min = new long[img.numDimensions()];
        long[] max = new long[img.numDimensions()];
        for (int d = 0; d < min.length; ++d) {
            long cx;
            min[d] = cx = Math.round(center.getDoublePosition(d) / calibration[d]);
            max[d] = cx + 1L;
        }
        FinalInterval interval = new FinalInterval(min, max);
        return Views.interval(img, (Interval)interval);
    }

    private static final class SpotRoiIterable<T extends RealType<T>>
    implements IterableInterval<T> {
        private final SpotRoi roi;
        private final RealLocalizable center;
        private final ImgPlus<T> img;
        private final FinalInterval interval;

        public SpotRoiIterable(SpotRoi roi, RealLocalizable center, ImgPlus<T> img) {
            this.roi = roi;
            this.center = center;
            this.img = img;
            double[] x = roi.toPolygonX(img.averageScale(0), 0.0, center.getDoublePosition(0), 1.0);
            double[] y = roi.toPolygonX(img.averageScale(1), 0.0, center.getDoublePosition(1), 1.0);
            long minX = (long)Math.floor(Util.min((double[])x));
            long maxX = (long)Math.ceil(Util.max((double[])x));
            long minY = (long)Math.floor(Util.min((double[])y));
            long maxY = (long)Math.ceil(Util.max((double[])y));
            this.interval = Intervals.createMinMax((long[])new long[]{minX, minY, maxX, maxY});
        }

        public long size() {
            int n = 0;
            Cursor<T> cursor = this.cursor();
            while (cursor.hasNext()) {
                cursor.fwd();
                ++n;
            }
            return n;
        }

        public T firstElement() {
            return (T)((RealType)this.cursor().next());
        }

        public Object iterationOrder() {
            return this;
        }

        public double realMin(int d) {
            return this.interval.realMin(d);
        }

        public double realMax(int d) {
            return this.interval.realMax(d);
        }

        public int numDimensions() {
            return 2;
        }

        public long min(int d) {
            return this.interval.min(d);
        }

        public long max(int d) {
            return this.interval.max(d);
        }

        public Cursor<T> cursor() {
            return new MyCursor<T>(this.roi, this.center, this.img);
        }

        public Cursor<T> localizingCursor() {
            return this.cursor();
        }

        public Iterator<T> iterator() {
            return this.cursor();
        }
    }

    private static final class MyCursor<T extends RealType<T>>
    implements Cursor<T> {
        private final SpotRoi roi;
        private final RealLocalizable center;
        private final ImgPlus<T> img;
        private final FinalInterval interval;
        private Cursor<T> cursor;
        private final double[] x;
        private final double[] y;
        private boolean hasNext;
        private RandomAccess<T> ra;

        public MyCursor(SpotRoi roi, RealLocalizable center, ImgPlus<T> img) {
            this.roi = roi;
            this.center = center;
            this.img = img;
            this.x = roi.toPolygonX(img.averageScale(0), 0.0, center.getDoublePosition(0), 1.0);
            this.y = roi.toPolygonY(img.averageScale(1), 0.0, center.getDoublePosition(1), 1.0);
            long minX = (long)Math.floor(Util.min((double[])this.x));
            long maxX = (long)Math.ceil(Util.max((double[])this.x));
            long minY = (long)Math.floor(Util.min((double[])this.y));
            long maxY = (long)Math.ceil(Util.max((double[])this.y));
            this.interval = Intervals.createMinMax((long[])new long[]{minX, minY, maxX, maxY});
            this.reset();
        }

        public T get() {
            return (T)((RealType)this.ra.get());
        }

        public void fwd() {
            this.ra.setPosition(this.cursor);
            this.fetch();
        }

        private void fetch() {
            while (this.cursor.hasNext()) {
                this.cursor.fwd();
                if (!MyCursor.isInside(this.cursor, this.x, this.y)) continue;
                this.hasNext = this.cursor.hasNext();
                return;
            }
            this.hasNext = false;
        }

        private static final boolean isInside(Localizable localizable, double[] x, double[] y) {
            double xl = localizable.getDoublePosition(0);
            double yl = localizable.getDoublePosition(1);
            boolean inside = false;
            int i = 0;
            int j = x.length - 1;
            while (i < x.length) {
                double xj = x[j];
                double yj = y[j];
                double xi = x[i];
                double yi = y[i];
                if (yi > yl != yj > yl && xl < (xj - xi) * (yl - yi) / (yj - yi) + xi) {
                    inside = !inside;
                }
                j = i++;
            }
            return inside;
        }

        public void reset() {
            IntervalView view = Views.interval(this.img, (Interval)this.interval);
            this.cursor = view.localizingCursor();
            this.ra = Views.extendMirrorSingle(this.img).randomAccess();
            this.fetch();
        }

        public double getDoublePosition(int d) {
            return this.ra.getDoublePosition(d);
        }

        public int numDimensions() {
            return 2;
        }

        public void jumpFwd(long steps) {
            int i = 0;
            while ((long)i < steps) {
                this.fwd();
                ++i;
            }
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public T next() {
            this.fwd();
            return this.get();
        }

        public long getLongPosition(int d) {
            return this.ra.getLongPosition(d);
        }

        public Cursor<T> copy() {
            return new MyCursor<T>(this.roi, this.center, this.img);
        }
    }
}

