/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util.cli;

import fiji.plugin.trackmate.util.cli.CommandCLIConfigurator;
import fiji.plugin.trackmate.util.cli.CondaCLIConfigurator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public abstract class Configurator {
    protected final List<Argument<?, ?>> arguments = new ArrayList();
    protected final List<SelectableArguments> selectables = new ArrayList<SelectableArguments>();
    protected final Map<Argument<?, ?>, Function<?, ?>> forwardUITranslators = new HashMap();
    protected final Map<Argument<?, ?>, Function<?, ?>> backwardUITranslators = new HashMap();

    public List<Argument<?, ?>> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public List<SelectableArguments> getSelectables() {
        return Collections.unmodifiableList(this.selectables);
    }

    public List<Argument<?, ?>> getSelectedArguments() {
        ArrayList selectedArguments = new ArrayList(this.arguments);
        for (SelectableArguments selectable : this.selectables) {
            selectable.filter(selectedArguments);
        }
        return selectedArguments;
    }

    protected SelectableArguments addSelectableArguments() {
        SelectableArguments sa = new SelectableArguments();
        this.selectables.add(sa);
        return sa;
    }

    protected FlagAdder addFlag() {
        return new FlagAdder();
    }

    protected StringAdder addStringArgument() {
        return new StringAdder();
    }

    protected PathAdder addPathArgument() {
        return new PathAdder();
    }

    protected IntAdder addIntArgument() {
        return new IntAdder();
    }

    protected DoubleAdder addDoubleArgument() {
        return new DoubleAdder();
    }

    protected ChoiceAdder addChoiceArgument() {
        return new ChoiceAdder();
    }

    protected <T extends Argument<?, ?>> T addExtraArgument(T extraArg) {
        this.arguments.add(extraArg);
        return extraArg;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(super.toString() + "\n");
        this.arguments.forEach(str::append);
        return str.toString();
    }

    public String check() {
        StringBuilder str = new StringBuilder();
        for (Argument<?, ?> arg : this.getSelectedArguments()) {
            if (arg.isInCLI() && arg.getArgument() == null) {
                str.append("Argument '" + arg.getName() + "' does not define the argument switch.\n");
            }
            if (!arg.isRequired() || arg.isSet() || arg.hasDefaultValue()) continue;
            str.append("Argument '" + arg.getName() + "' is required but is not set and does not define a default value.\n");
        }
        return str.length() == 0 ? null : str.toString();
    }

    protected <O> void setDisplayTranslator(Argument<?, O> arg, Function<O, O> forward, Function<O, O> backward) {
        if (arg instanceof ChoiceArgument) {
            throw new IllegalArgumentException("ChoiceArgument does not support display translators.");
        }
        if (arg instanceof Flag) {
            throw new IllegalArgumentException("Flag does not support display translators.");
        }
        this.forwardUITranslators.put(arg, forward);
        this.backwardUITranslators.put(arg, backward);
    }

    public static class SelectableArguments {
        private final List<Argument<?, ?>> args = new ArrayList();
        private String key;
        private int selected = 0;

        public SelectableArguments add(Argument<?, ?> arg) {
            if (!this.args.contains(arg)) {
                this.args.add(arg);
            }
            return this;
        }

        public SelectableArguments key(String key) {
            this.key = key;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        private void filter(List<Argument<?, ?>> arguments) {
            HashSet toRemove = new HashSet();
            for (Argument argument : arguments) {
                if (!this.args.contains(argument) || argument.equals(this.getSelection())) continue;
                toRemove.add(argument);
            }
            arguments.removeAll(toRemove);
        }

        public void select(int selection) {
            this.selected = Math.max(0, Math.min(this.args.size() - 1, selection));
        }

        public void select(Argument<?, ?> arg) {
            int sel = this.args.indexOf(arg);
            if (sel < 0) {
                this.selected = 0;
                return;
            }
            this.selected = sel;
        }

        public void select(String key) {
            for (int i = 0; i < this.args.size(); ++i) {
                if (!key.equals(this.args.get(i).getKey())) continue;
                this.selected = i;
                return;
            }
            this.selected = 0;
        }

        public Argument<?, ?> getSelection() {
            return this.args.get(this.selected);
        }

        public int getSelected() {
            return this.selected;
        }

        public List<Argument<?, ?>> getArguments() {
            return this.args;
        }
    }

    protected class FlagAdder
    extends Adder<Flag, FlagAdder, Boolean> {
        private FlagAdder() {
            super(Configurator.this);
        }

        @Override
        public Flag get() {
            Flag arg = (Flag)((Flag)((Flag)((Flag)((Flag)((Flag)((Flag)((Flag)((Flag)new Flag().name(this.name)).help(this.help)).argument(this.argument)).defaultValue((Boolean)this.defaultValue)).required(this.required)).units(this.units)).visible(this.visible)).inCLI(this.inCLI)).key(this.key);
            Configurator.this.arguments.add(arg);
            return arg;
        }
    }

    protected class StringAdder
    extends Adder<StringArgument, StringAdder, String> {
        private StringAdder() {
            super(Configurator.this);
        }

        @Override
        public StringArgument get() {
            StringArgument arg = (StringArgument)((StringArgument)((StringArgument)((StringArgument)((StringArgument)((StringArgument)((StringArgument)((StringArgument)((StringArgument)new StringArgument().name(this.name)).help(this.help)).argument(this.argument)).defaultValue((String)this.defaultValue)).required(this.required)).units(this.units)).visible(this.visible)).inCLI(this.inCLI)).key(this.key);
            Configurator.this.arguments.add(arg);
            return arg;
        }
    }

    protected class PathAdder
    extends Adder<PathArgument, PathAdder, String> {
        private PathAdder() {
            super(Configurator.this);
        }

        @Override
        public PathArgument get() {
            PathArgument arg = (PathArgument)((PathArgument)((PathArgument)((PathArgument)((PathArgument)((PathArgument)((PathArgument)((PathArgument)((PathArgument)new PathArgument().name(this.name)).help(this.help)).argument(this.argument)).defaultValue((String)this.defaultValue)).required(this.required)).units(this.units)).visible(this.visible)).inCLI(this.inCLI)).key(this.key);
            Configurator.this.arguments.add(arg);
            return arg;
        }
    }

    protected class IntAdder
    extends BoundedAdder<IntArgument, IntAdder, Integer> {
        protected IntAdder() {
            super(Configurator.this);
        }

        @Override
        public IntArgument get() {
            IntArgument arg = (IntArgument)((IntArgument)((IntArgument)((IntArgument)((IntArgument)((IntArgument)((IntArgument)((IntArgument)((IntArgument)((IntArgument)((IntArgument)new IntArgument().name(this.name)).help(this.help)).argument(this.argument)).defaultValue((Integer)this.defaultValue)).max((Integer)this.max)).min((Integer)this.min)).required(this.required)).units(this.units)).visible(this.visible)).inCLI(this.inCLI)).key(this.key);
            Configurator.this.arguments.add(arg);
            return arg;
        }
    }

    protected class DoubleAdder
    extends BoundedAdder<DoubleArgument, DoubleAdder, Double> {
        private DoubleAdder() {
            super(Configurator.this);
        }

        @Override
        public DoubleArgument get() {
            DoubleArgument arg = (DoubleArgument)((DoubleArgument)((DoubleArgument)((DoubleArgument)((DoubleArgument)((DoubleArgument)((DoubleArgument)((DoubleArgument)((DoubleArgument)((DoubleArgument)((DoubleArgument)new DoubleArgument().name(this.name)).help(this.help)).argument(this.argument)).defaultValue((Double)this.defaultValue)).max((Double)this.max)).min((Double)this.min)).required(this.required)).units(this.units)).visible(this.visible)).inCLI(this.inCLI)).key(this.key);
            Configurator.this.arguments.add(arg);
            return arg;
        }
    }

    protected class ChoiceAdder
    extends Adder<ChoiceArgument, ChoiceAdder, String> {
        private final List<String> choices;
        private final List<String> mappeds;

        private ChoiceAdder() {
            super(Configurator.this);
            this.choices = new ArrayList<String>();
            this.mappeds = new ArrayList<String>();
        }

        public ChoiceAdder addChoice(String choice) {
            return this.addChoice(choice, choice);
        }

        public ChoiceAdder addChoice(String choice, String mapped) {
            if (!this.choices.contains(choice)) {
                this.choices.add(choice);
                this.mappeds.add(mapped);
            }
            return this;
        }

        public Adder<ChoiceArgument, ChoiceAdder, String> addChoiceAll(Collection<String> c) {
            for (String in : c) {
                this.addChoice(in);
            }
            return this;
        }

        @Override
        public ChoiceAdder defaultValue(String defaultChoice) {
            int sel = this.choices.indexOf(defaultChoice);
            if (sel < 0) {
                throw new IllegalArgumentException("Unknown selection '" + defaultChoice + "' for parameter '" + this.name + "'. Must be one of " + StringUtils.join(this.choices, (String)", ") + ".");
            }
            return (ChoiceAdder)super.defaultValue(defaultChoice);
        }

        @Override
        public ChoiceAdder defaultValue(int selected) {
            if (selected < 0 || selected >= this.choices.size()) {
                throw new IllegalArgumentException("Invalid index for selection of parameter '" + this.name + "'. Must be in scale 0 to " + (this.choices.size() - 1) + " in " + StringUtils.join(this.choices, (String)", ") + ".");
            }
            return this.defaultValue(this.choices.get(selected));
        }

        @Override
        public ChoiceArgument get() {
            ChoiceArgument arg = (ChoiceArgument)((ChoiceArgument)((ChoiceArgument)((ChoiceArgument)((ChoiceArgument)((ChoiceArgument)((ChoiceArgument)((ChoiceArgument)new ChoiceArgument().name(this.name)).help(this.help)).argument(this.argument)).required(this.required)).units(this.units)).visible(this.visible)).inCLI(this.inCLI)).key(this.key);
            for (int i = 0; i < this.choices.size(); ++i) {
                arg.addChoice(this.choices.get(i), this.mappeds.get(i));
            }
            arg.defaultValue((String)this.defaultValue);
            Configurator.this.arguments.add(arg);
            return arg;
        }
    }

    public static abstract class Argument<T extends Argument<T, O>, O> {
        protected boolean visible = true;
        protected String name;
        protected String help;
        private String key;
        private String argument;
        private boolean inCLI = true;
        private O value;
        private O defaultValue;
        private boolean required = false;
        private String units;

        T argument(String argument) {
            this.argument = argument;
            return (T)this;
        }

        public String getArgument() {
            return this.argument;
        }

        T required(boolean required) {
            this.required = required;
            return (T)this;
        }

        public boolean isRequired() {
            return this.required;
        }

        T units(String units) {
            this.units = units;
            return (T)this;
        }

        public String getUnits() {
            return this.units;
        }

        T defaultValue(O defaultValue) {
            this.defaultValue = defaultValue;
            return (T)this;
        }

        public O getDefaultValue() {
            return this.defaultValue;
        }

        public boolean hasDefaultValue() {
            return this.defaultValue != null;
        }

        public void set(O value) {
            this.value = value;
        }

        public O getValue() {
            return this.value;
        }

        public boolean isSet() {
            return this.value != null;
        }

        public Object getValueObject() {
            return this.getValue();
        }

        public abstract void setValueObject(Object var1);

        T inCLI(boolean inCLI) {
            this.inCLI = inCLI;
            return (T)this;
        }

        public boolean isInCLI() {
            return this.inCLI;
        }

        T visible(boolean visible) {
            this.visible = visible;
            return (T)this;
        }

        public boolean isVisible() {
            return this.visible;
        }

        T name(String name) {
            this.name = name;
            return (T)this;
        }

        T help(String help) {
            this.help = help;
            return (T)this;
        }

        T key(String key) {
            this.key = key;
            return (T)this;
        }

        public String getName() {
            return this.name;
        }

        public String getHelp() {
            return this.help;
        }

        public String getKey() {
            return this.key;
        }

        public abstract void accept(ArgumentVisitor var1);

        public String toString() {
            return this.getClass().getSimpleName() + " (" + this.getName() + ")\n - help: " + this.getHelp() + "\n - key: " + this.getKey() + "\n - argument: " + this.getArgument() + "\n - visible: " + this.isVisible() + "\n - is set: " + this.isSet() + "\n" + (String)(this.isSet() ? " - value: " + String.valueOf(this.getValue()) + "\n" : "") + " - has default value: " + this.hasDefaultValue() + "\n" + (String)(this.hasDefaultValue() ? " - default value: " + String.valueOf(this.getDefaultValue()) + "\n" : "") + " - required: " + this.isRequired() + "\n - units: " + this.getUnits() + "\n";
        }
    }

    public static class ChoiceArgument
    extends Argument<ChoiceArgument, String> {
        private final List<String> choices = new ArrayList<String>();
        private final List<String> displays = new ArrayList<String>();
        private int selected = -1;

        private ChoiceArgument() {
        }

        private ChoiceArgument addChoice(String choice, String displayed) {
            if (!this.choices.contains(choice)) {
                this.choices.add(choice);
                this.displays.add(displayed);
            }
            return this;
        }

        public List<String> getDisplays() {
            return this.displays;
        }

        @Override
        public void accept(ArgumentVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public boolean isSet() {
            return this.selected >= 0;
        }

        @Override
        public String getValue() {
            return this.choices.get(this.selected);
        }

        public int getSelectedIndex() {
            return this.selected;
        }

        @Override
        public void set(String choice) {
            int sel = this.choices.indexOf(choice);
            if (sel < 0) {
                throw new IllegalArgumentException("Unknown selection '" + choice + "' for parameter '" + this.name + "'. Must be one of: [ " + StringUtils.join(this.choices, (String)", ") + " ].");
            }
            this.selected = sel;
        }

        @Override
        public void set(int selected) {
            if (selected < 0 || selected >= this.choices.size()) {
                throw new IllegalArgumentException("Invalid index for selection of parameter '" + this.name + "'. Must be in scale 0 to " + (this.choices.size() - 1) + " in " + StringUtils.join(this.choices, (String)", ") + ".");
            }
            this.selected = selected;
        }

        @Override
        public void setValueObject(Object val) {
            if (!String.class.isInstance(val)) {
                throw new IllegalArgumentException("Argument '" + this.name + "' expects String. Got " + val.getClass().getSimpleName());
            }
            String v = (String)val;
            this.set(v);
        }

        @Override
        ChoiceArgument defaultValue(String defaultChoice) {
            int sel = this.choices.indexOf(defaultChoice);
            if (sel < 0) {
                throw new IllegalArgumentException("Unknown selection '" + defaultChoice + "' for parameter '" + this.name + "'. Must be one of " + StringUtils.join(this.choices, (String)", ") + ".");
            }
            super.defaultValue(defaultChoice);
            return this;
        }

        @Override
        ChoiceArgument defaultValue(int selected) {
            if (selected < 0 || selected >= this.choices.size()) {
                throw new IllegalArgumentException("Invalid index for selection of parameter '" + this.name + "'. Must be in scale 0 to " + (this.choices.size() - 1) + " in " + StringUtils.join(this.choices, (String)", ") + ".");
            }
            super.defaultValue(this.choices.get(selected));
            return this;
        }

        @Override
        public String toString() {
            String str = super.toString();
            return str + " - choices: " + String.valueOf(this.choices) + "\n - display strings: " + String.valueOf(this.displays) + "\n";
        }
    }

    public static class Flag
    extends Argument<Flag, Boolean> {
        Flag() {
        }

        public void set() {
            this.set(true);
        }

        @Override
        public void accept(ArgumentVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public void setValueObject(Object val) {
            if (!Boolean.class.isInstance(val)) {
                throw new IllegalArgumentException("Argument '" + this.name + "' expects Boolean. Got " + val.getClass().getSimpleName());
            }
            Boolean v = (Boolean)val;
            this.set(v);
        }
    }

    public static abstract class BoundedValueArgument<T extends BoundedValueArgument<T, O>, O>
    extends Argument<T, O> {
        private O min;
        private O max;

        private BoundedValueArgument() {
        }

        T min(O min) {
            this.min = min;
            return (T)this;
        }

        public O getMax() {
            return this.max;
        }

        T max(O max) {
            this.max = max;
            return (T)this;
        }

        public O getMin() {
            return this.min;
        }

        public boolean hasMin() {
            return this.min != null;
        }

        public boolean hasMax() {
            return this.max != null;
        }

        @Override
        public String toString() {
            String str = super.toString();
            return str + " - has min: " + this.hasMin() + "\n" + (String)(this.hasMin() ? " - min: " + String.valueOf(this.getMin()) + "\n" : "") + " - has max: " + this.hasMax() + "\n" + (String)(this.hasMax() ? " - max: " + String.valueOf(this.getMax()) + "\n" : "");
        }
    }

    public static class DoubleArgument
    extends BoundedValueArgument<DoubleArgument, Double> {
        @Override
        public void accept(ArgumentVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public void setValueObject(Object val) {
            if (!Double.class.isInstance(val)) {
                throw new IllegalArgumentException("Argument '" + this.name + "' expects Double. Got " + val.getClass().getSimpleName());
            }
            Double v = (Double)val;
            this.set(v);
        }
    }

    public static class IntArgument
    extends BoundedValueArgument<IntArgument, Integer> {
        IntArgument() {
        }

        @Override
        public void accept(ArgumentVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public void setValueObject(Object val) {
            if (!Integer.class.isInstance(val)) {
                throw new IllegalArgumentException("Argument '" + this.name + "' expects Integer. Got " + val.getClass().getSimpleName());
            }
            Integer v = (Integer)val;
            this.set(v);
        }
    }

    public static abstract class AbstractStringArgument<T extends AbstractStringArgument<T>>
    extends Argument<T, String> {
        @Override
        public void setValueObject(Object val) {
            if (!String.class.isInstance(val)) {
                throw new IllegalArgumentException("Argument '" + this.name + "' expects String. Got " + val.getClass().getSimpleName());
            }
            String v = (String)val;
            this.set(v);
        }
    }

    public static class StringArgument
    extends AbstractStringArgument<StringArgument> {
        private StringArgument() {
        }

        @Override
        public void accept(ArgumentVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class PathArgument
    extends AbstractStringArgument<PathArgument> {
        private PathArgument() {
        }

        @Override
        public void accept(ArgumentVisitor visitor) {
            visitor.visit(this);
        }
    }

    private abstract class BoundedAdder<A extends BoundedValueArgument<A, O>, T extends BoundedAdder<A, T, O>, O>
    extends Adder<A, T, O> {
        protected O min;
        protected O max;

        private BoundedAdder(Configurator configurator) {
            super(configurator);
        }

        public T min(O min) {
            this.min = min;
            return (T)this;
        }

        public T max(O max) {
            this.max = max;
            return (T)this;
        }
    }

    abstract class Adder<A extends Argument<A, O>, T extends Adder<A, T, O>, O> {
        protected String name;
        protected String help;
        protected String key;
        protected boolean required;
        protected String units;
        protected O defaultValue;
        protected String argument;
        protected boolean visible = true;
        protected boolean inCLI = true;

        Adder(Configurator this$0) {
        }

        public T argument(String argument) {
            this.argument = argument;
            return (T)this;
        }

        public T visible(boolean visible) {
            this.visible = visible;
            return (T)this;
        }

        public T name(String name) {
            this.name = name;
            return (T)this;
        }

        public T help(String help) {
            this.help = help;
            return (T)this;
        }

        public T key(String key) {
            this.key = key;
            return (T)this;
        }

        public T required(boolean required) {
            this.required = required;
            return (T)this;
        }

        public T units(String units) {
            this.units = units;
            return (T)this;
        }

        public T defaultValue(O defaultValue) {
            this.defaultValue = defaultValue;
            return (T)this;
        }

        public T inCLI(boolean inCLI) {
            this.inCLI = inCLI;
            return (T)this;
        }

        public abstract A get();
    }

    public static interface ArgumentVisitor {
        default public void visit(Flag flag) {
            throw new UnsupportedOperationException();
        }

        default public void visit(StringArgument stringArgument) {
            throw new UnsupportedOperationException();
        }

        default public void visit(DoubleArgument doubleArgument) {
            throw new UnsupportedOperationException();
        }

        default public void visit(IntArgument intArgument) {
            throw new UnsupportedOperationException();
        }

        default public void visit(ChoiceArgument choiceArgument) {
            throw new UnsupportedOperationException();
        }

        default public void visit(PathArgument pathArgument) {
            throw new UnsupportedOperationException();
        }

        default public void visit(CommandCLIConfigurator.ExecutablePath executablePath) {
            throw new UnsupportedOperationException();
        }

        default public void visit(CondaCLIConfigurator.CondaEnvironmentCommand condaEnvironmentCommand) {
            throw new UnsupportedOperationException();
        }
    }
}

