/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import net.imagej.display.ColorTables;
import net.imglib2.display.ColorTable;
import org.scijava.ui.awt.AWTImageTools;

public final class SwingColorBar
extends JComponent {
    private static final int DEFAULT_HEIGHT = 24;
    private final int height;
    private BufferedImage bar;
    private Dimension preferredSize;

    public SwingColorBar() {
        this(24);
    }

    public SwingColorBar(int height) {
        this(null, height);
    }

    public SwingColorBar(ColorTable lut) {
        this(lut, 24);
    }

    public SwingColorBar(ColorTable lut, int height) {
        this.height = height;
        if (lut != null) {
            this.setColorTable(lut);
        }
    }

    public void setColorTable(ColorTable colorTable) {
        if (this.bar == null || this.bar.getWidth() != colorTable.getLength()) {
            this.bar = AWTImageTools.createImage((int)colorTable.getLength(), (int)1);
        }
        Graphics gfx = this.bar.getGraphics();
        for (int i = 0; i < colorTable.getLength(); ++i) {
            int argb = colorTable.lookupARGB(0.0, (double)colorTable.getLength(), (double)i);
            gfx.setColor(new Color(argb, false));
            gfx.drawLine(i, 0, i, 1);
        }
        gfx.dispose();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, this.height);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        return new Dimension(this.bar == null ? 0 : this.bar.getWidth(), this.height);
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        this.preferredSize = preferredSize;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.bar == null) {
            return;
        }
        g.drawImage(this.bar, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    public static void main(String[] args) {
        ColorTable[] luts = new ColorTable[]{ColorTables.FIRE, ColorTables.ICE, ColorTables.SPECTRUM, ColorTables.RED, ColorTables.GREEN, ColorTables.BLUE, ColorTables.CYAN, ColorTables.MAGENTA, ColorTables.YELLOW, ColorTables.GRAYS, ColorTables.REDGREEN, ColorTables.RGB332};
        JFrame frame = new JFrame();
        frame.setTitle("LUTs");
        JPanel pane = new JPanel();
        frame.setContentPane(pane);
        pane.setLayout(new BoxLayout(pane, 1));
        frame.setDefaultCloseOperation(3);
        for (ColorTable lut : luts) {
            SwingColorBar colorBar = new SwingColorBar(lut);
            colorBar.setBorder(new LineBorder(Color.black));
            pane.add(colorBar);
        }
        frame.pack();
        frame.setVisible(true);
    }
}

