/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.loaders.lw3d;

import java.util.Vector;
import org.scijava.java3d.loaders.lw3d.LwoSurface;
import org.scijava.java3d.loaders.lw3d.ParserObject;
import org.scijava.vecmath.Vector3f;

class ShapeHolder
extends ParserObject {
    Vector facetSizesList;
    Vector facetIndicesList;
    int[] facetIndicesArray;
    int currentNumIndices = 0;
    int numSurf;
    int numVerts;
    int[] facetIndices;
    int[] facetSizes;
    int[] normalIndices;
    float[] normalCoords;
    float[] coordsArray;

    ShapeHolder() {
    }

    ShapeHolder(int debugVals) {
        super(debugVals);
    }

    void printGeometryData(LwoSurface surface) {
        int indicesIndex = 0;
        System.out.println("\nPolygon Data:");
        System.out.println("  Surface color = " + surface.color);
        System.out.println("  Surface diffuse = " + surface.diffuseColor);
        for (int i = 0; i < this.facetSizes.length; ++i) {
            int polySize = this.facetSizes[i];
            System.out.println("Facet of size " + polySize);
            for (int j = 0; j < polySize; ++j) {
                int coordIndex = 3 * this.facetIndices[indicesIndex++];
                System.out.println("x, y, z = " + this.coordsArray[coordIndex] + ", " + this.coordsArray[coordIndex + 1] + ", " + this.coordsArray[coordIndex + 2]);
            }
        }
    }

    void createArrays(boolean reverseWinding) {
        this.debugOutputLn(1, "createArrays()");
        this.facetIndices = new int[this.currentNumIndices];
        if (reverseWinding) {
            int facetBeginIndex = 0;
            for (int facetIndex = 0; facetIndex < this.facetSizesList.size(); ++facetIndex) {
                int currFaceSize = (Integer)this.facetSizesList.elementAt(facetIndex);
                int[] tempFace = new int[currFaceSize];
                for (int j = 0; j < currFaceSize; ++j) {
                    this.facetIndices[facetBeginIndex + j] = this.facetIndicesArray[facetBeginIndex + currFaceSize - j - 1];
                }
                facetBeginIndex += currFaceSize;
            }
        } else {
            for (int i = 0; i < this.facetIndices.length; ++i) {
                this.facetIndices[i] = this.facetIndicesArray[i];
            }
        }
        this.debugOutputLn(8, "facetIndices.len and coordsArray.len = " + this.facetIndices.length + ", " + this.coordsArray.length);
        if ((Integer)this.facetSizesList.elementAt(0) < 3) {
            this.debugOutputLn(8, "Using direct geometry because facetIndices is of size " + this.facetIndices.length + " and coordsArray is of length " + this.coordsArray.length);
            float[] newCoordsArray = new float[this.facetIndices.length * 3];
            int newCoordsIndex = 0;
            for (int i = 0; i < this.facetIndices.length; ++i) {
                newCoordsArray[newCoordsIndex++] = this.coordsArray[this.facetIndices[i] * 3];
                newCoordsArray[newCoordsIndex++] = this.coordsArray[this.facetIndices[i] * 3 + 1];
                newCoordsArray[newCoordsIndex++] = this.coordsArray[this.facetIndices[i] * 3 + 2];
            }
            this.coordsArray = newCoordsArray;
            this.facetIndices = null;
        }
        this.facetSizes = new int[this.facetSizesList.size()];
        for (int i = 0; i < this.facetSizes.length; ++i) {
            this.facetSizes[i] = (Integer)this.facetSizesList.elementAt(i);
        }
        this.facetSizesList = null;
        this.facetIndicesList = null;
        this.facetIndicesArray = null;
    }

    void nullify() {
        this.facetSizesList = null;
        this.facetIndicesList = null;
        this.facetIndicesArray = null;
        this.facetSizes = null;
        this.facetIndices = null;
        this.normalCoords = null;
        this.normalIndices = null;
    }

    void calcNormals() {
        this.debugOutputLn(1, "calcNormals()");
        this.debugOutputLn(8, "coordsLength, facetsizes.len = " + this.coordsArray.length + ", " + this.facetSizes.length);
        if (this.facetSizes[0] > 2) {
            if (this.facetIndices != null) {
                this.normalIndices = new int[this.facetIndices.length];
                this.normalCoords = new float[this.facetIndices.length * 3];
            } else {
                this.normalCoords = new float[this.coordsArray.length];
            }
            this.debugOutputLn(8, "normalCoords, incides len = " + this.normalCoords.length + ", " + (this.facetIndices == null ? 0 : this.normalIndices.length));
            int facetIndex = 0;
            int tempIndex = -1;
            for (int i = 0; i < this.facetSizes.length; ++i) {
                Vector3f norm;
                int currFacetSize = this.facetSizes[i];
                if (currFacetSize < 3) {
                    norm = new Vector3f(0.0f, 0.0f, 1.0f);
                } else {
                    int index3;
                    int index2;
                    int index1;
                    if (this.facetIndices != null) {
                        index1 = this.facetIndices[facetIndex];
                        index2 = this.facetIndices[facetIndex + 1];
                        index3 = this.facetIndices[facetIndex + 2];
                    } else {
                        index1 = facetIndex;
                        index2 = facetIndex + 1;
                        index3 = facetIndex + 2;
                    }
                    Vector3f v1 = new Vector3f(this.coordsArray[index2 * 3] - this.coordsArray[index1 * 3], this.coordsArray[index2 * 3 + 1] - this.coordsArray[index1 * 3 + 1], this.coordsArray[index2 * 3 + 2] - this.coordsArray[index1 * 3 + 2]);
                    Vector3f v2 = new Vector3f(this.coordsArray[index3 * 3] - this.coordsArray[index1 * 3], this.coordsArray[index3 * 3 + 1] - this.coordsArray[index1 * 3 + 1], this.coordsArray[index3 * 3 + 2] - this.coordsArray[index1 * 3 + 2]);
                    norm = new Vector3f();
                    norm.cross(v1, v2);
                    norm.normalize(norm);
                }
                for (int j = 0; j < currFacetSize; ++j) {
                    int normIndex = facetIndex + j;
                    this.normalCoords[normIndex * 3] = norm.x;
                    this.normalCoords[normIndex * 3 + 1] = norm.y;
                    this.normalCoords[normIndex * 3 + 2] = norm.z;
                    if (this.facetIndices == null) continue;
                    this.normalIndices[normIndex] = normIndex;
                }
                facetIndex += currFacetSize;
            }
        }
        this.debugOutputLn(1, "done with calcNormals()");
    }
}

