/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.LZWEncoder2;
import ij.plugin.NeuQuant;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class AnimatedGifEncoder2 {
    protected int width;
    protected int height;
    protected boolean transparent = false;
    protected int transIndex;
    protected int repeat = -1;
    protected int delay = 50;
    protected boolean started = false;
    protected OutputStream out;
    protected ImagePlus image;
    protected byte[] pixels;
    protected byte[] indexedPixels;
    protected int colorDepth;
    protected byte[] colorTab;
    protected int lctSize = 7;
    protected int dispose = 0;
    protected boolean closeStream = false;
    protected boolean firstFrame = true;
    protected boolean sizeSet = false;
    protected int sample = 2;
    protected byte[] gct = null;
    protected boolean gctused = false;
    protected boolean autotransparent = false;
    protected boolean GCTextracted = false;
    protected boolean GCTloadedExternal = false;
    protected int GCTred = 0;
    protected int GCTgrn = 0;
    protected int GCTbl = 0;
    protected int GCTcindex = 0;
    protected boolean GCTsetTransparent = false;
    protected boolean GCToverideIndex = false;
    protected boolean GCToverideColor = false;
    String name;

    AnimatedGifEncoder2() {
    }

    public boolean addFrame(ImagePlus image) {
        if (image == null || !this.started) {
            return false;
        }
        boolean ok = true;
        try {
            int type;
            if (this.firstFrame) {
                if (!this.sizeSet) {
                    this.setSize(image.getWidth(), image.getHeight());
                }
                if (this.gctused) {
                    this.writeLSDgct();
                }
                if (this.GCTloadedExternal) {
                    this.colorTab = this.gct;
                    this.TransparentIndex(this.colorTab);
                    this.writePalette();
                    if (this.repeat >= 0) {
                        this.writeNetscapeExt();
                    }
                }
                if (!this.gctused) {
                    this.writeLSD();
                    if (this.repeat >= 0) {
                        this.writeNetscapeExt();
                    }
                }
                this.firstFrame = false;
            }
            if ((type = image.getType()) == 0 || type == 3) {
                this.Process8bitCLT(image);
            } else if (type == 4) {
                this.packrgb(image);
                this.OverRideQuality(image.getWidth() * image.getHeight());
                if (this.gctused && this.gct == null) {
                    this.analyzePixels();
                    this.colorTab = this.gct;
                    this.TransparentIndex(this.colorTab);
                    this.writePalette();
                    if (this.repeat >= 0) {
                        this.writeNetscapeExt();
                    }
                } else {
                    this.analyzePixels();
                }
            } else {
                throw new IllegalArgumentException("Image must be 8-bit or RGB");
            }
            this.TransparentIndex(this.colorTab);
            this.writeGraphicCtrlExt();
            this.writeImageDesc();
            if (!this.gctused) {
                this.writePalette();
            }
            this.writePixels();
        }
        catch (IOException e) {
            ok = false;
        }
        return ok;
    }

    void TransparentIndex(byte[] colorTab) {
        if (this.autotransparent || !this.GCTsetTransparent) {
            return;
        }
        if (colorTab == null) {
            throw new IllegalArgumentException("Color Table not loaded.");
        }
        int len = colorTab.length;
        this.setTransparent(true);
        if (!this.GCToverideColor && !this.GCToverideIndex) {
            this.transIndex = this.GCTcindex;
            return;
        }
        if (this.GCToverideIndex) {
            this.GCTcindex = this.findClosest(colorTab, this.GCTred, this.GCTgrn, this.GCTbl);
        }
        this.transIndex = this.GCTcindex;
        int pindex = 3 * this.GCTcindex;
        if (pindex > len - 3) {
            throw new IllegalArgumentException("Index (" + this.transIndex + ") too large for Color Lookup table.");
        }
        colorTab[pindex++] = (byte)this.GCTred;
        colorTab[pindex++] = (byte)this.GCTgrn;
        colorTab[pindex] = (byte)this.GCTbl;
    }

    public boolean setoptions() {
        String[] GCTtype = new String[]{"Do not use", "Load from Current Image", "Load from another Image RGB or 8 Bit", "Use another RGB to create a new color table "};
        String[] DisposalType = new String[]{"No Disposal", "Do not Dispose", "Restore to Background", "Restore to previous"};
        String[] TransparencyType = new String[]{"No Transparency", "Automatically Set if Available (8 bit only)", "Set to Index", "Set to index with specified color", "Set to the index that is closest to specified color"};
        int setdelay = this.delay * 10;
        int gctType = 0;
        if (this.GCTloadedExternal) {
            gctType = 2;
        }
        if (this.GCTextracted && this.GCTloadedExternal) {
            gctType = 3;
        }
        if (this.gctused && !this.GCTextracted && !this.GCTloadedExternal) {
            gctType = 1;
        }
        int setTrans = 1;
        if (!(this.autotransparent || this.GCTsetTransparent || this.GCToverideIndex || this.GCToverideColor)) {
            setTrans = 0;
        }
        if (this.GCTsetTransparent && !this.GCToverideIndex && !this.GCToverideColor) {
            setTrans = 2;
        }
        if (this.GCTsetTransparent && this.GCToverideIndex && !this.GCToverideColor) {
            setTrans = 4;
        }
        if (this.GCTsetTransparent && !this.GCToverideIndex && this.GCToverideColor) {
            setTrans = 3;
        }
        int red = this.GCTred;
        int grn = this.GCTgrn;
        int bl = this.GCTbl;
        int cindex = this.GCTcindex;
        this.setRepeat(0);
        this.autotransparent = false;
        this.GCTsetTransparent = false;
        this.GCToverideIndex = false;
        this.GCToverideColor = false;
        this.setTransparent(false);
        switch (setTrans) {
            case 0: {
                break;
            }
            case 1: {
                this.autotransparent = true;
                break;
            }
            case 2: {
                if (cindex > -1) {
                    this.GCTsetTransparent = true;
                    this.GCTcindex = cindex;
                    break;
                }
                IJ.error("Incorrect color index must have value between 0 and 255");
                break;
            }
            case 3: {
                if (cindex > -1 && red > -1) {
                    this.GCTsetTransparent = true;
                    this.GCToverideColor = true;
                    this.GCTcindex = cindex;
                    this.GCTred = red;
                    this.GCTgrn = grn;
                    this.GCTbl = bl;
                    break;
                }
                IJ.error("Incorrect colors or color index, they must have values between 0 and 255.");
                break;
            }
            case 4: {
                if (red > -1) {
                    this.GCTsetTransparent = true;
                    this.GCToverideIndex = true;
                    this.GCTred = red;
                    this.GCTgrn = grn;
                    this.GCTbl = bl;
                    break;
                }
                IJ.error("Incorrect colors, they must have values between 0 and 255.");
                break;
            }
        }
        this.gctused = false;
        this.GCTextracted = false;
        this.GCTloadedExternal = false;
        return true;
    }

    void Process8bitCLT(ImagePlus image) {
        int k;
        this.colorDepth = 8;
        this.setTransparent(false);
        ByteProcessor pg = new ByteProcessor(image.getImage());
        ColorModel cm = pg.getColorModel();
        if (!(cm instanceof IndexColorModel)) {
            throw new IllegalArgumentException("Image must be 8-bit");
        }
        this.indexedPixels = (byte[])pg.getPixels();
        IndexColorModel m = (IndexColorModel)cm;
        if (this.autotransparent) {
            this.transIndex = m.getTransparentPixel();
            if (this.transIndex > -1 && this.transIndex < 256) {
                this.setTransparent(true);
            } else {
                this.transIndex = 0;
            }
        }
        int mapSize = m.getMapSize();
        if (this.gctused && this.gct == null) {
            this.gct = new byte[mapSize * 3];
            for (int i = 0; i < mapSize; ++i) {
                k = i * 3;
                this.colorTab[k] = (byte)m.getRed(i);
                this.colorTab[k + 1] = (byte)m.getGreen(i);
                this.colorTab[k + 2] = (byte)m.getBlue(i);
            }
            try {
                if (!this.GCTloadedExternal) {
                    this.colorTab = this.gct;
                    this.writePalette();
                    if (this.repeat >= 0) {
                        this.writeNetscapeExt();
                    }
                }
            }
            catch (IOException e) {
                System.err.println("Caught IOException: " + e.getMessage());
            }
        }
        if (this.gctused) {
            this.colorTab = this.gct;
        } else {
            this.colorTab = new byte[mapSize * 3];
            for (int i = 0; i < mapSize; ++i) {
                k = i * 3;
                this.colorTab[k] = (byte)m.getRed(i);
                this.colorTab[k + 1] = (byte)m.getGreen(i);
                this.colorTab[k + 2] = (byte)m.getBlue(i);
            }
        }
    }

    public boolean finish() {
        if (!this.started) {
            return false;
        }
        boolean ok = true;
        this.started = false;
        try {
            this.out.write(59);
            this.out.flush();
            if (this.closeStream) {
                this.out.close();
            }
        }
        catch (IOException e) {
            ok = false;
        }
        this.GCTextracted = false;
        this.GCTloadedExternal = false;
        this.transIndex = 0;
        this.transparent = false;
        this.gct = null;
        this.out = null;
        this.image = null;
        this.pixels = null;
        this.indexedPixels = null;
        this.colorTab = null;
        this.closeStream = false;
        this.firstFrame = true;
        return ok;
    }

    public void loadGCT8bit(ImagePlus image) {
        int type = image.getType();
        if (type != 0 && type != 3 || image == null) {
            throw new IllegalArgumentException("Color Table Image must be 8 bit");
        }
        this.gctused = true;
        this.GCTloadedExternal = true;
        this.gct = null;
        this.Process8bitCLT(image);
    }

    public void extractGCTrgb(ImagePlus image) {
        if (image == null || 4 != image.getType()) {
            throw new IllegalArgumentException("Color Table Image must be RGB");
        }
        this.packrgb(image);
        this.gctused = true;
        this.GCTextracted = true;
        this.GCTloadedExternal = true;
        this.gct = null;
        this.OverRideQuality(image.getWidth() * image.getHeight());
        this.analyzePixels();
        this.pixels = null;
    }

    void packrgb(ImagePlus image) {
        int len = image.getWidth() * image.getHeight();
        ImageProcessor imp = image.getProcessor();
        int[] pix = (int[])imp.getPixels();
        this.pixels = new byte[len * 3];
        for (int i = 0; i < len; ++i) {
            int k = i * 3;
            this.pixels[k + 2] = (byte)((pix[i] & 0xFF0000) >> 16);
            this.pixels[k + 1] = (byte)((pix[i] & 0xFF00) >> 8);
            this.pixels[k] = (byte)(pix[i] & 0xFF);
        }
    }

    public void loadGCTrgb(ImagePlus image) {
        if (image == null || 4 != image.getType()) {
            throw new IllegalArgumentException("Color Table Image must be RGB");
        }
        int len = image.getWidth() * image.getHeight();
        if (len > 255) {
            len = 255;
        }
        ImageProcessor imp = image.getProcessor();
        int[] pix = (int[])imp.getPixels();
        this.gct = new byte[len * 3];
        for (int i = 0; i < len; ++i) {
            int k = i * 3;
            this.gct[k] = (byte)((pix[i] & 0xFF0000) >> 16);
            this.gct[k + 1] = (byte)((pix[i] & 0xFF00) >> 8);
            this.gct[k + 2] = (byte)(pix[i] & 0xFF);
        }
        this.gctused = true;
        this.GCTloadedExternal = true;
    }

    public void setGCT(boolean flag) {
        this.gctused = flag;
    }

    public void setDelay(int ms) {
        this.delay = Math.round((float)ms / 10.0f);
    }

    public void setDispose(int code) {
        if (code >= 0) {
            this.dispose = code;
        }
    }

    public void setFrameRate(float fps) {
        if (fps != 0.0f) {
            this.delay = Math.round(100.0f / fps);
        }
    }

    public void setQuality(int quality) {
        if (quality < 1) {
            quality = 1;
        }
        this.sample = quality;
    }

    public void GlobalColorTableused(boolean gtu) {
        this.gctused = gtu;
    }

    public void setRepeat(int iter) {
        if (iter >= 0) {
            this.repeat = iter;
        }
    }

    public void setSize(int w, int h) {
        if (this.started && !this.firstFrame) {
            return;
        }
        this.width = w;
        this.height = h;
        if (this.width < 1) {
            this.width = 320;
        }
        if (this.height < 1) {
            this.height = 240;
        }
        this.sizeSet = true;
    }

    public void setTransparent(boolean c) {
        this.transparent = c;
    }

    public boolean start(OutputStream os) {
        if (os == null) {
            return false;
        }
        boolean ok = true;
        this.closeStream = false;
        this.out = os;
        try {
            this.writeString("GIF89a");
        }
        catch (IOException e) {
            ok = false;
        }
        this.started = ok;
        return this.started;
    }

    public boolean start(String file) {
        boolean ok = true;
        try {
            this.out = new BufferedOutputStream(new FileOutputStream(file));
            ok = this.start(this.out);
            this.closeStream = true;
        }
        catch (IOException e) {
            ok = false;
        }
        this.started = ok;
        return this.started;
    }

    public void OverRideQuality(int npixs) {
        this.sample = npixs > 100000 ? 10 : npixs / 10000;
        if (this.sample < 1) {
            this.sample = 1;
        }
    }

    protected void analyzePixels() {
        byte temp;
        int i;
        NeuQuant nq;
        int len = this.pixels.length;
        int nPix = len / 3;
        this.indexedPixels = new byte[nPix];
        if (this.gctused && this.gct == null) {
            nq = new NeuQuant(this.pixels, len, this.sample);
            this.colorTab = nq.process();
            this.gct = new byte[this.colorTab.length];
            for (i = 0; i < this.colorTab.length; i += 3) {
                temp = this.colorTab[i];
                this.colorTab[i] = this.colorTab[i + 2];
                this.colorTab[i + 2] = temp;
                this.gct[i] = this.colorTab[i];
                this.gct[i + 1] = this.colorTab[i + 1];
                this.gct[i + 2] = this.colorTab[i + 2];
            }
            if (this.GCTextracted) {
                this.indexedPixels = null;
                return;
            }
        }
        if (!this.gctused) {
            nq = new NeuQuant(this.pixels, len, this.sample);
            this.colorTab = nq.process();
            for (i = 0; i < this.colorTab.length; i += 3) {
                temp = this.colorTab[i];
                this.colorTab[i] = this.colorTab[i + 2];
                this.colorTab[i + 2] = temp;
            }
            int k = 0;
            for (int i2 = 0; i2 < nPix; ++i2) {
                this.indexedPixels[i2] = (byte)nq.map(this.pixels[k++] & 0xFF, this.pixels[k++] & 0xFF, this.pixels[k++] & 0xFF);
            }
            this.pixels = null;
            this.colorDepth = 8;
            this.lctSize = 7;
        }
        if (this.gctused) {
            this.colorTab = this.gct;
            int k = 0;
            for (int j = 0; j < nPix; ++j) {
                int b = this.pixels[k++] & 0xFF;
                int g = this.pixels[k++] & 0xFF;
                int r = this.pixels[k++] & 0xFF;
                int minpos = 0;
                int dmin = 0x1000000;
                int lenct = this.colorTab.length;
                for (int i3 = 0; i3 < lenct; ++i3) {
                    int db;
                    int dg;
                    int dr;
                    int d;
                    if ((d = (dr = r - (this.colorTab[i3++] & 0xFF)) * dr + (dg = g - (this.colorTab[i3++] & 0xFF)) * dg + (db = b - (this.colorTab[i3] & 0xFF)) * db) >= dmin) continue;
                    dmin = d;
                    minpos = i3 / 3;
                }
                this.indexedPixels[j] = (byte)minpos;
            }
            this.pixels = null;
            this.colorDepth = 8;
            this.lctSize = 7;
        }
    }

    protected int findClosest(byte[] colorTab, int r, int g, int b) {
        if (colorTab == null) {
            return -1;
        }
        int minpos = 0;
        int dmin = 0x1000000;
        int len = colorTab.length;
        for (int i = 0; i < len; ++i) {
            int db;
            int dg;
            int dr;
            int d;
            if ((d = (dr = r - (colorTab[i++] & 0xFF)) * dr + (dg = g - (colorTab[i++] & 0xFF)) * dg + (db = b - (colorTab[i] & 0xFF)) * db) >= dmin) continue;
            dmin = d;
            minpos = i / 3;
        }
        return minpos;
    }

    protected void writeGraphicCtrlExt() throws IOException {
        int disp;
        int transp;
        this.out.write(33);
        this.out.write(249);
        this.out.write(4);
        if (!this.transparent) {
            transp = 0;
            disp = 0;
        } else {
            transp = 1;
            disp = 2;
        }
        if (this.dispose >= 0) {
            disp = this.dispose & 7;
        }
        this.out.write(0 | (disp <<= 2) | 0 | transp);
        this.writeShort(this.delay);
        this.out.write(this.transIndex);
        this.out.write(0);
    }

    protected void writeImageDesc() throws IOException {
        this.out.write(44);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(this.width);
        this.writeShort(this.height);
        if (this.gctused) {
            this.out.write(0);
        } else {
            this.out.write(0x80 | this.lctSize);
        }
    }

    protected void writeLSDgct() throws IOException {
        this.writeShort(this.width);
        this.writeShort(this.height);
        this.out.write(0xF0 | this.lctSize);
        this.out.write(0);
        this.out.write(0);
    }

    protected void writeLSD() throws IOException {
        this.writeShort(this.width);
        this.writeShort(this.height);
        this.out.write(112);
        this.out.write(0);
        this.out.write(0);
    }

    protected void writeNetscapeExt() throws IOException {
        this.out.write(33);
        this.out.write(255);
        this.out.write(11);
        this.writeString("NETSCAPE2.0");
        this.out.write(3);
        this.out.write(1);
        this.writeShort(this.repeat);
        this.out.write(0);
    }

    protected void writePalette() throws IOException {
        this.out.write(this.colorTab, 0, this.colorTab.length);
        int n = 768 - this.colorTab.length;
        for (int i = 0; i < n; ++i) {
            this.out.write(0);
        }
    }

    protected void writePixels() throws IOException {
        LZWEncoder2 encoder = new LZWEncoder2(this.width, this.height, this.indexedPixels, this.colorDepth);
        encoder.encode(this.out);
    }

    protected void writeShort(int value) throws IOException {
        this.out.write(value & 0xFF);
        this.out.write(value >> 8 & 0xFF);
    }

    protected void writeString(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.out.write((byte)s.charAt(i));
        }
    }
}

