/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.Macro;
import ij.Prefs;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.gui.Toolbar;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.ThresholdAdjuster;
import ij.process.AutoThresholder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import java.awt.Choice;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class Thresholder
implements PlugIn,
Measurements,
ItemListener {
    public static final String[] methods = AutoThresholder.getMethods();
    public static final String[] backgrounds = new String[]{"Default", "Dark", "Light"};
    private double minThreshold;
    private double maxThreshold;
    private boolean autoThreshold;
    private boolean showLegacyDialog = true;
    private static boolean fill1 = true;
    private static boolean fill2 = true;
    private static boolean useBW = true;
    private boolean useLocal = true;
    private boolean listThresholds;
    private boolean createStack;
    private boolean convertToMask;
    private String method = methods[0];
    private String background = backgrounds[0];
    private static boolean staticUseLocal = true;
    private static boolean staticListThresholds;
    private static boolean staticCreateStack;
    private static String staticMethod;
    private static String staticBackground;
    private ImagePlus imp;
    private Vector choices;

    @Override
    public void run(String arg) {
        ImagePlus imp;
        this.convertToMask = arg.equals("mask");
        if (arg.equals("skip") || this.convertToMask) {
            this.showLegacyDialog = false;
        }
        if ((imp = IJ.getImage()).getStackSize() == 1) {
            Undo.setup(6, imp);
            this.applyThreshold(imp, false);
        } else {
            this.convertStack(imp);
        }
        IJ.showProgress(1.0);
    }

    void convertStack(ImagePlus imp) {
        this.showLegacyDialog = false;
        boolean thresholdSet = imp.isThreshold();
        this.imp = imp;
        if (!IJ.isMacro()) {
            this.method = staticMethod;
            this.background = staticBackground;
            this.useLocal = staticUseLocal;
            this.listThresholds = staticListThresholds;
            this.createStack = staticCreateStack;
            if (!thresholdSet) {
                this.updateThreshold(imp);
            }
        } else {
            String macroOptions = Macro.getOptions();
            if (macroOptions != null && macroOptions.indexOf("slice ") != -1) {
                Macro.setOptions(macroOptions.replaceAll("slice ", "only "));
            }
            this.useLocal = false;
        }
        boolean saveBlackBackground = Prefs.blackBackground;
        boolean oneSlice = false;
        GenericDialog gd = new GenericDialog("Convert Stack to Binary");
        gd.addChoice("Method:", methods, this.method);
        gd.addChoice("Background:", backgrounds, this.background);
        gd.addCheckbox("Calculate threshold for each image", this.useLocal);
        gd.addCheckbox("Only convert current image", oneSlice);
        gd.addCheckbox("Black background (of binary masks)", Prefs.blackBackground);
        gd.addCheckbox("List thresholds", this.listThresholds);
        gd.addCheckbox("Create new stack", this.createStack);
        this.choices = gd.getChoices();
        if (this.choices != null) {
            ((Choice)this.choices.elementAt(0)).addItemListener(this);
            ((Choice)this.choices.elementAt(1)).addItemListener(this);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.imp = null;
        gd.setSmartRecording(this.method.equals("Default"));
        int index = gd.getNextChoiceIndex();
        this.method = methods[index];
        gd.setSmartRecording(false);
        gd.setSmartRecording(this.background.equals("Default"));
        index = gd.getNextChoiceIndex();
        this.background = backgrounds[index];
        gd.setSmartRecording(false);
        this.useLocal = gd.getNextBoolean();
        oneSlice = gd.getNextBoolean();
        Prefs.blackBackground = gd.getNextBoolean();
        this.listThresholds = gd.getNextBoolean();
        this.createStack = gd.getNextBoolean();
        if (imp.getStack().isVirtual()) {
            oneSlice = false;
            this.createStack = true;
        }
        if (!IJ.isMacro()) {
            staticMethod = this.method;
            staticBackground = this.background;
            staticUseLocal = this.useLocal;
            staticListThresholds = this.listThresholds;
            staticCreateStack = this.createStack;
        }
        if (oneSlice) {
            this.useLocal = false;
            this.listThresholds = false;
            this.createStack = false;
            if (oneSlice && imp.getBitDepth() != 8) {
                IJ.error("Thresholder", "8-bit stack required to process a single slice.");
                return;
            }
        }
        Undo.reset();
        ImageProcessor ip = imp.getProcessor();
        double minThreshold = ip.getMinThreshold();
        double maxThreshold = ip.getMaxThreshold();
        int currentSlice = imp.getCurrentSlice();
        if (this.createStack) {
            imp = imp.duplicate();
            imp.setTitle(imp.getTitle().replace("DUP_", "MASK_"));
            if (minThreshold != -808080.0) {
                imp.getProcessor().setThreshold(minThreshold, maxThreshold, 0);
            }
            imp.setSlice(currentSlice);
        }
        if (this.useLocal) {
            this.convertStackToBinary(imp);
        } else {
            this.applyThreshold(imp, oneSlice);
        }
        Prefs.blackBackground = saveBlackBackground;
        if (this.createStack) {
            imp.setSlice(1);
            imp.show();
            imp.setSlice(currentSlice);
        } else if (thresholdSet) {
            if (imp.getProcessor().getLutUpdateMode() != 2) {
                imp.getProcessor().resetThreshold();
            }
            imp.updateAndDraw();
        }
    }

    private void applyThreshold(ImagePlus imp, boolean oneSlice) {
        boolean invertedLut;
        ImageProcessor ip2;
        boolean modernMacro;
        imp.deleteRoi();
        ImageProcessor ip = imp.getProcessor();
        ip.resetBinaryThreshold();
        int type = imp.getType();
        if (type == 1 || type == 2) {
            this.applyShortOrFloatThreshold(imp);
            return;
        }
        if (!imp.lock()) {
            return;
        }
        double saveMinThreshold = ip.getMinThreshold();
        double saveMaxThreshold = ip.getMaxThreshold();
        this.autoThreshold = saveMinThreshold == -808080.0;
        boolean useBlackAndWhite = false;
        boolean fill1 = true;
        boolean fill2 = true;
        String options = Macro.getOptions();
        boolean bl = modernMacro = options != null && !options.contains("thresholded") && !options.contains("remaining");
        if (this.autoThreshold || modernMacro || IJ.macroRunning() && options == null) {
            this.showLegacyDialog = false;
        }
        int fcolor = 255;
        int bcolor = 0;
        if (this.showLegacyDialog) {
            GenericDialog gd = new GenericDialog("Make Binary");
            gd.addCheckbox("Thresholded pixels to foreground color", fill1);
            gd.addCheckbox("Remaining pixels to background color", fill2);
            gd.addMessage("");
            gd.addCheckbox("Black foreground, white background", useBW);
            gd.showDialog();
            if (gd.wasCanceled()) {
                imp.unlock();
                return;
            }
            fill1 = gd.getNextBoolean();
            fill2 = gd.getNextBoolean();
            useBW = useBlackAndWhite = gd.getNextBoolean();
            int savePixel = ip.getPixel(0, 0);
            if (useBlackAndWhite) {
                ip.setColor(Color.black);
            } else {
                ip.setColor(Toolbar.getForegroundColor());
            }
            ip.drawPixel(0, 0);
            fcolor = ip.getPixel(0, 0);
            if (useBlackAndWhite) {
                ip.setColor(Color.white);
            } else {
                ip.setColor(Toolbar.getBackgroundColor());
            }
            ip.drawPixel(0, 0);
            bcolor = ip.getPixel(0, 0);
            ip.setColor(Toolbar.getForegroundColor());
            ip.putPixel(0, 0, savePixel);
        } else {
            this.convertToMask = true;
        }
        if (type == 4 && (ip2 = this.updateColorThresholdedImage(imp)) != null) {
            imp.setProcessor(ip2);
            this.autoThreshold = false;
            saveMinThreshold = 255.0;
            saveMaxThreshold = 255.0;
            type = 0;
        }
        if (type != 0) {
            this.convertToByte(imp);
        }
        ip = imp.getProcessor();
        if (this.autoThreshold) {
            this.autoThreshold(ip);
        } else {
            if (IJ.recording() && !Recorder.scriptMode() && (!IJ.isMacro() || Recorder.recordInMacros)) {
                Recorder.record("//setThreshold", (int)saveMinThreshold, (int)saveMaxThreshold);
            }
            this.minThreshold = saveMinThreshold;
            this.maxThreshold = saveMaxThreshold;
        }
        if (this.convertToMask && ip.isColorLut()) {
            ip.setColorModel(ip.getDefaultColorModel());
        }
        ip.resetThreshold();
        if (IJ.debugMode) {
            IJ.log("Thresholder (apply): " + this.minThreshold + "-" + this.maxThreshold + " " + fcolor + " " + bcolor + " " + fill1 + " " + fill2);
        }
        int[] lut = new int[256];
        for (int i = 0; i < 256; ++i) {
            lut[i] = (double)i >= this.minThreshold && (double)i <= this.maxThreshold ? (int)((byte)(fill1 ? fcolor : (byte)i)) : (int)((byte)(fill2 ? bcolor : (byte)i));
        }
        if (imp.getStackSize() > 1 && !oneSlice) {
            new StackProcessor(imp.getStack(), ip).applyTable(lut);
        } else {
            ip.applyTable(lut);
        }
        if (this.convertToMask && !oneSlice && ((invertedLut = imp.isInvertedLut()) && Prefs.blackBackground || !invertedLut && !Prefs.blackBackground)) {
            ip.invertLut();
            if (!IJ.isMacro() && ThresholdAdjuster.isDarkBackground() && !invertedLut && !Prefs.blackBackground) {
                IJ.log("\"Black background\" not set in Process>Binary>Options; inverting LUT");
            }
            if (IJ.debugMode) {
                IJ.log("Thresholder (inverting lut)");
            }
        }
        if (fill1 && fill2 && (fcolor == 0 && bcolor == 255 || fcolor == 255 && bcolor == 0)) {
            imp.getProcessor().setThreshold(fcolor, fcolor, 2);
            if (IJ.debugMode) {
                IJ.log("Thresholder: " + fcolor + "-" + fcolor + " (" + (Prefs.blackBackground ? "black" : "white") + " background)");
            }
        }
        imp.updateAndRepaintWindow();
        imp.unlock();
    }

    private ImageProcessor updateColorThresholdedImage(ImagePlus imp) {
        ImagePlus imp2;
        Object mask = imp.getProperty("Mask");
        if (mask == null || !(mask instanceof ByteProcessor)) {
            return null;
        }
        ImageProcessor maskIP = (ImageProcessor)mask;
        if (maskIP.getWidth() != imp.getWidth() || maskIP.getHeight() != imp.getHeight()) {
            return null;
        }
        Object originalImage = imp.getProperty("OriginalImage");
        if (originalImage != null && originalImage instanceof ImagePlus && (imp2 = (ImagePlus)originalImage).getBitDepth() == 24 && imp2.getWidth() == imp.getWidth() && imp2.getHeight() == imp.getHeight()) {
            imp.setProcessor(imp2.getProcessor());
            Undo.setup(6, imp);
        }
        return maskIP;
    }

    private void applyShortOrFloatThreshold(ImagePlus imp) {
        if (!imp.lock()) {
            return;
        }
        int width = imp.getWidth();
        int height = imp.getHeight();
        int size = width * height;
        boolean isFloat = imp.getType() == 2;
        int currentSlice = imp.getCurrentSlice();
        int nSlices = imp.getStackSize();
        ImageStack stack1 = imp.getStack();
        ImageStack stack2 = new ImageStack(width, height);
        ImageProcessor ip = imp.getProcessor();
        float t1 = (float)ip.getMinThreshold();
        float t2 = (float)ip.getMaxThreshold();
        if ((double)t1 == -808080.0) {
            double min = ip.getMin();
            double max = ip.getMax();
            ip = ip.convertToByte(true);
            this.autoThreshold(ip);
            t1 = (float)(min + (max - min) * (this.minThreshold / 255.0));
            t2 = (float)(min + (max - min) * (this.maxThreshold / 255.0));
        }
        IJ.showStatus("Converting to mask");
        for (int i = 1; i <= nSlices; ++i) {
            IJ.showProgress(i, nSlices);
            String label = stack1.getSliceLabel(i);
            ImageProcessor ip1 = stack1.getProcessor(i);
            ByteProcessor ip2 = new ByteProcessor(width, height);
            for (int j = 0; j < size; ++j) {
                float value = ip1.getf(j);
                if (value >= t1 && value <= t2) {
                    ((ImageProcessor)ip2).set(j, 255);
                    continue;
                }
                ((ImageProcessor)ip2).set(j, 0);
            }
            stack2.addSlice(label, ip2);
        }
        imp.setStack(null, stack2);
        ImageStack stack = imp.getStack();
        stack.setColorModel(LookUpTable.createGrayscaleColorModel(!Prefs.blackBackground));
        imp.setStack(null, stack);
        if (imp.isComposite()) {
            CompositeImage ci = (CompositeImage)imp;
            ci.setMode(3);
            ci.resetDisplayRanges();
            ci.updateAndDraw();
        }
        imp.getProcessor().setThreshold(255.0, 255.0, 2);
        if (IJ.debugMode) {
            IJ.log("Thresholder16: 255-255 (" + (Prefs.blackBackground ? "black" : "white") + " background)");
        }
        IJ.showStatus("");
        imp.unlock();
    }

    void convertStackToBinary(ImagePlus imp) {
        int nSlices = imp.getStackSize();
        double[] minValues = this.listThresholds ? new double[nSlices] : null;
        double[] maxValues = this.listThresholds ? new double[nSlices] : null;
        int bitDepth = imp.getBitDepth();
        if (bitDepth != 8) {
            IJ.showStatus("Converting to byte");
            ImageStack stack1 = imp.getStack();
            ImageStack stack2 = new ImageStack(imp.getWidth(), imp.getHeight());
            for (int i = 1; i <= nSlices; ++i) {
                IJ.showProgress(i, nSlices);
                String label = stack1.getSliceLabel(i);
                ImageProcessor ip = stack1.getProcessor(i);
                ip.resetMinAndMax();
                if (this.listThresholds) {
                    minValues[i - 1] = ip.getMin();
                    maxValues[i - 1] = ip.getMax();
                }
                stack2.addSlice(label, ip.convertToByte(true));
            }
            imp.setStack(null, stack2);
        }
        ImageStack stack = imp.getStack();
        IJ.showStatus("Auto-thresholding");
        if (this.listThresholds) {
            IJ.log("Thresholding method: " + this.method);
        }
        for (int i = 1; i <= nSlices; ++i) {
            IJ.showProgress(i, nSlices);
            ImageProcessor ip = stack.getProcessor(i);
            if (this.method.equals("Default") && this.background.equals("Default")) {
                ip.setAutoThreshold(1, 2);
            } else {
                ip.setAutoThreshold(this.method, !this.background.equals("Light"), 2);
            }
            this.minThreshold = ip.getMinThreshold();
            this.maxThreshold = ip.getMaxThreshold();
            if (this.listThresholds) {
                double t1 = this.minThreshold;
                double t2 = this.maxThreshold;
                if (bitDepth != 8) {
                    t1 = minValues[i - 1] + t1 / 255.0 * (maxValues[i - 1] - minValues[i - 1]);
                    t2 = minValues[i - 1] + t2 / 255.0 * (maxValues[i - 1] - minValues[i - 1]);
                }
                int digits = bitDepth == 32 ? 2 : 0;
                IJ.log("  " + i + ": " + IJ.d2s(t1, digits) + "-" + IJ.d2s(t2, digits));
            }
            int[] lut = new int[256];
            for (int j = 0; j < 256; ++j) {
                lut[j] = (double)j >= this.minThreshold && (double)j <= this.maxThreshold ? -1 : 0;
            }
            ip.applyTable(lut);
        }
        stack.setColorModel(LookUpTable.createGrayscaleColorModel(!Prefs.blackBackground));
        imp.setStack(null, stack);
        imp.getProcessor().setThreshold(255.0, 255.0, 2);
        if (imp.isComposite()) {
            CompositeImage ci = (CompositeImage)imp;
            ci.setMode(3);
            ci.resetDisplayRanges();
            ci.updateAndDraw();
        }
        IJ.showStatus("");
    }

    void convertToByte(ImagePlus imp) {
        int currentSlice = imp.getCurrentSlice();
        ImageStack stack1 = imp.getStack();
        ImageStack stack2 = imp.createEmptyStack();
        int nSlices = imp.getStackSize();
        for (int i = 1; i <= nSlices; ++i) {
            String label = stack1.getSliceLabel(i);
            ImageProcessor ip = stack1.getProcessor(i);
            ip.setMinAndMax(0.0, 255.0);
            stack2.addSlice(label, ip.convertToByte(true));
        }
        imp.setStack(null, stack2);
        imp.setSlice(currentSlice);
        imp.setCalibration(imp.getCalibration());
    }

    public static ByteProcessor createMask(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        if (ip instanceof ColorProcessor) {
            throw new IllegalArgumentException("Non-RGB image requires");
        }
        if (ip.getMinThreshold() == -808080.0) {
            throw new IllegalArgumentException("Image must be thresholded");
        }
        return ip.createMask();
    }

    void autoThreshold(ImageProcessor ip) {
        ip.setAutoThreshold(1, 2);
        this.minThreshold = ip.getMinThreshold();
        this.maxThreshold = ip.getMaxThreshold();
        if (IJ.debugMode) {
            IJ.log("Thresholder (auto): " + this.minThreshold + "-" + this.maxThreshold);
        }
    }

    public static void setMethod(String method) {
        staticMethod = method;
    }

    public static void setBackground(String background) {
        staticBackground = background;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.imp == null) {
            return;
        }
        Choice choice = (Choice)e.getSource();
        if (choice == this.choices.elementAt(0)) {
            this.method = choice.getSelectedItem();
        } else {
            this.background = choice.getSelectedItem();
        }
        this.updateThreshold(this.imp);
    }

    private void updateThreshold(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        if (this.method.equals("Default") && this.background.equals("Default")) {
            ip.setAutoThreshold(1, 0);
        } else {
            ip.setAutoThreshold(this.method, !this.background.equals("Light"), 0);
        }
        imp.updateAndDraw();
    }

    static {
        staticMethod = methods[0];
        staticBackground = backgrounds[0];
    }
}

