/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.objectinspector;

import com.github.sbridges.objectinspector.ComplexNode;
import com.github.sbridges.objectinspector.FieldAndName;
import com.github.sbridges.objectinspector.FieldAndNameComparator;
import com.github.sbridges.objectinspector.InspectorNode;
import com.github.sbridges.objectinspector.Value;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.TreeSet;

class ObjectNode
extends ComplexNode {
    private Value value;
    boolean isNull;
    Class myClass;
    TreeSet fieldsAndNames = new TreeSet(new FieldAndNameComparator());

    ObjectNode(Value value, String name, InspectorNode parent) {
        super(parent, name);
        this.value = value;
        this.init(value.getValue());
    }

    ObjectNode(String name, InspectorNode parent) {
        super(parent, name);
    }

    private void init(Object instance) {
        if (instance == null) {
            this.isNull = true;
            return;
        }
        this.isNull = false;
        this.myClass = instance.getClass();
        String pre = "";
        Class aClass = this.myClass;
        do {
            Field[] myFields = aClass.getDeclaredFields();
            for (int i = 0; i < myFields.length; ++i) {
                this.fieldsAndNames.add(new FieldAndName(myFields[i], pre));
            }
            if (aClass == Object.class) continue;
            String newName = (aClass = aClass.getSuperclass()).getName();
            int dotPos = newName.lastIndexOf(46);
            dotPos = dotPos < 0 ? 0 : ++dotPos;
            newName = newName.substring(dotPos, newName.length());
            pre = newName + "." + pre;
        } while (aClass != Object.class);
        this.setNumberOfChildren(this.fieldsAndNames.size());
    }

    protected InspectorNode generateChild(int index) {
        Iterator it = this.fieldsAndNames.iterator();
        for (int i = 0; i < index; ++i) {
            it.next();
        }
        FieldAndName fn = (FieldAndName)it.next();
        return ObjectNode.createNode(fn.field, this, this.value, fn.name);
    }

    public String getValueString() {
        Object instance = this.value.getValue();
        if (instance == null) {
            return "<null>";
        }
        return instance.getClass().getName() + "\n" + instance.toString();
    }

    public Object getValue() {
        return this.value.getValue();
    }

    protected Value getValueReference() {
        return this.value;
    }

    public boolean isValid() {
        if (super.isValid()) {
            Object myValue = this.value.getValue();
            if (myValue == null) {
                return this.isNull;
            }
            return myValue.getClass() == this.myClass;
        }
        return false;
    }
}

