/*
 * Decompiled with CFR 0.152.
 */
package fiji.scripting;

import fiji.scripting.Compiler;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

public class Weaver {
    private static final AtomicInteger K = new AtomicInteger(0);
    private static final Map<String, Map<String, Object>> bindings = new HashMap<String, Map<String, Object>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object steal(String className, String binding) {
        Map<String, Map<String, Object>> map = bindings;
        synchronized (map) {
            Map<String, Object> m = bindings.get(className);
            if (null == m) {
                System.out.println("No binding '" + binding + "' for class '" + className + "'");
                return null;
            }
            Object b = m.remove(binding);
            if (m.isEmpty()) {
                bindings.remove(className);
            }
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void put(String className, String binding, Object ob) {
        if (null == binding) {
            return;
        }
        Map<String, Map<String, Object>> map = bindings;
        synchronized (map) {
            Map<String, Object> m = bindings.get(className);
            if (null == m) {
                m = new HashMap<String, Object>();
                bindings.put(className, m);
            }
            m.put(binding, ob);
        }
    }

    public static final <T> Callable<T> inline(String code, Map<String, ?> bindings) throws Throwable {
        return Weaver.inline(code, bindings, null, false);
    }

    public static final <T> Callable<T> inline(String code, Map<String, ?> bindings, boolean showJavaCode) throws Throwable {
        return Weaver.inline(code, bindings, null, showJavaCode, new ArrayList());
    }

    public static final <T> Callable<T> inline(String code, Map<String, ?> bindings, Class<T> returnType) throws Throwable {
        return Weaver.inline(code, bindings, returnType, false, new ArrayList());
    }

    public static final <T> Callable<T> inline(String code, Map<String, ?> bindings, Class<T> returnType, List<Class<?>> imports) throws Throwable {
        return Weaver.inline(code, bindings, returnType, false, imports);
    }

    public static final <T> Callable<T> inline(String code, Map<String, ?> bindings, List<Class<?>> imports) throws Throwable {
        return Weaver.inline(code, bindings, null, false, imports);
    }

    public static final <T> Callable<T> inline(String code, Map<String, ?> bindings, Class<T> returnType, boolean showJavaCode) throws Throwable {
        return Weaver.inline(code, bindings, null, false, new ArrayList());
    }

    public static final <T> Callable<T> inline(String code, Map<String, ?> bindings, Class<T> returnType, boolean showJavaCode, List<Class<?>> imports) throws Throwable {
        StringBuilder sb = new StringBuilder(4096);
        int k = K.incrementAndGet();
        String className = "weave.gen" + k;
        Class rt = null == returnType ? Object.class : returnType;
        sb.append("package weave;\n").append("import java.util.concurrent.Callable;\n");
        for (Class<?> clazz : imports) {
            sb.append("import ").append(clazz.getName()).append(";\n");
        }
        sb.append("public final class gen").append(k).append(" implements Callable<").append(rt.getName()).append("> {\n");
        for (Map.Entry entry : bindings.entrySet()) {
            String name = (String)entry.getKey();
            Type t = Weaver.guessPublicClass(entry.getValue());
            sb.append("static private final ").append(t.type).append(' ').append(name).append(" = (").append(t.cast).append(") fiji.scripting.Weaver.steal(\"").append(className).append("\" ,\"").append(name).append("\");\n");
            Weaver.put(className, name, entry.getValue());
            System.out.println("binding is: " + (entry.getValue() == null ? null : entry.getValue().getClass()));
        }
        sb.append("public final ").append(rt.getName()).append(" call() { ").append(code).append("}\n}");
        if (showJavaCode) {
            Weaver.showJavaCode("gen" + k + ".java", sb.toString());
        }
        return (Callable)Weaver.generate(className, sb.toString());
    }

    private static Object generate(String className, String javaCode) throws Throwable {
        String relFilePath = "/" + className.replace('.', '/') + ".java";
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File f = new File(tmpDir, relFilePath);
        if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
            throw new Exception("Could not create directories for " + f);
        }
        FileWriter writer = new FileWriter(f);
        writer.write(javaCode);
        ((Writer)writer).close();
        Pattern pclass = Pattern.compile("^" + className.substring(className.lastIndexOf(46) + 1) + ".*class$");
        for (File object : f.getParentFile().listFiles()) {
            if (!pclass.matcher(object.getName()).matches() || object.delete()) continue;
            System.out.println("Failed to delete file " + f.getAbsolutePath());
        }
        Compiler.Result r = Compiler.compile(f.getAbsolutePath(), Compiler.getClasspath(), tmpDir.getAbsolutePath(), null, null);
        if (!r.success) {
            System.out.println(r.errorMessage);
            return null;
        }
        try (URLClassLoader loader = new URLClassLoader(new URL[]{tmpDir.toURI().toURL()}, Weaver.class.getClassLoader());){
            Class<?> outer = loader.loadClass(className);
            final String simpleName = className.substring(6);
            for (String innerClassFilename : new File(tmpDir.getAbsolutePath() + "/weave/").list(new FilenameFilter(){

                @Override
                public final boolean accept(File dir, String name) {
                    return name.startsWith(simpleName) && '$' == name.charAt(simpleName.length()) && name.endsWith(".class");
                }
            })) {
                String innerClassName = "weave." + innerClassFilename.substring(0, innerClassFilename.length() - 6);
                loader.loadClass(innerClassName);
            }
            Object obj = outer.newInstance();
            return obj;
        }
    }

    public static Object method(String method) throws Throwable {
        return Weaver.method(method, new ArrayList(), false);
    }

    public static Object method(String method, List<Class<?>> imports) throws Throwable {
        return Weaver.method(method, imports, false);
    }

    public static Object method(String method, List<Class<?>> imports, boolean showJavaCode) throws Throwable {
        StringBuilder sb = new StringBuilder(4096);
        int k = K.incrementAndGet();
        String className = "weave.gen" + k;
        sb.append("package weave;\n\n");
        for (Class<?> c : imports) {
            sb.append("import ").append(c.getName()).append(";\n");
        }
        sb.append("\npublic final class ").append("gen" + k).append(" {\n");
        sb.append(method);
        sb.append("\n}");
        if (showJavaCode) {
            Weaver.showJavaCode("gen" + k + ".java", sb.toString());
        }
        return Weaver.generate(className, sb.toString());
    }

    private static void showJavaCode(String filename, String code) {
        try {
            ClassLoader loader = Weaver.class.getClassLoader();
            try {
                Class<?> context_class = loader.loadClass("org.scijava.Context");
                Method runPlugIn = loader.loadClass("ij.IJ").getMethod("runPlugIn", String.class, String.class);
                Object context = runPlugIn.invoke(null, "org.scijava.Context", "");
                Class<?> editor_class = loader.loadClass("org.scijava.ui.swing.script.TextEditor");
                Constructor<?> editor_constructor = editor_class.getConstructor(context_class);
                Object editor = editor_constructor.newInstance(context);
                Method editor_cnd = editor_class.getMethod("createNewDocument", String.class, String.class);
                editor_cnd.invoke(editor, filename, code);
                Method editor_sv = editor_class.getMethod("setVisible", Boolean.TYPE);
                editor_sv.invoke(editor, true);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("###### Weaver.inline GENERATED CODE #####");
                System.out.println(code);
                System.out.println("###### END #####");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final Type guessPublicClass(Object ob) {
        if (null == ob) {
            return new Type("Object");
        }
        Class<?> c = ob.getClass();
        if (Long.class == c) {
            return new Type("long", "Long");
        }
        if (Double.class == c) {
            return new Type("double", "Double");
        }
        if (Float.class == c) {
            return new Type("float", "Float");
        }
        if (Byte.class == c) {
            return new Type("byte", "Byte");
        }
        if (Short.class == c) {
            return new Type("short", "Short");
        }
        if (Integer.class == c) {
            return new Type("int", "Integer");
        }
        if (Character.class == c) {
            return new Type("char", "Character");
        }
        while (c.isAnonymousClass() || 0 == (c.getModifiers() | 1)) {
            c = c.getSuperclass();
        }
        if (c.isArray()) {
            String s = c.getSimpleName();
            if (s.toLowerCase().equals(s)) {
                Pattern pat = Pattern.compile("^(\\[\\])+$");
                for (String name : new String[]{"byte", "char", "short", "int", "long", "float", "double"}) {
                    if (!s.startsWith(name) || !pat.matcher(s.substring(name.length())).matches()) continue;
                    return new Type(s);
                }
            }
            String name = c.getName();
            int nBrackets = name.indexOf(76);
            StringBuilder sb = new StringBuilder(32);
            sb.append(name, nBrackets + 1, name.length() - 1);
            for (int i = 0; i < nBrackets; ++i) {
                sb.append('[').append(']');
            }
            return new Type(sb.toString());
        }
        return new Type(c.getName());
    }

    private static class Type {
        final String type;
        final String cast;

        private Type(String type, String cast) {
            this.type = type;
            this.cast = cast;
        }

        private Type(String type) {
            this(type, type);
        }
    }
}

