/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.behaviour;

import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.BehaviourMap;
import org.scijava.ui.behaviour.ClickBehaviour;
import org.scijava.ui.behaviour.DragBehaviour;
import org.scijava.ui.behaviour.InputTrigger;
import org.scijava.ui.behaviour.InputTriggerMap;
import org.scijava.ui.behaviour.ScrollBehaviour;

public abstract class AbstractMouseAndKeyHandler {
    protected static final int DOUBLE_CLICK_INTERVAL = AbstractMouseAndKeyHandler.getDoubleClickInterval();
    private InputTriggerMap inputMap;
    private BehaviourMap behaviourMap;
    private int inputMapExpectedModCount;
    private int behaviourMapExpectedModCount;
    protected final ArrayList<BehaviourEntry<DragBehaviour>> buttonDrags = new ArrayList();
    protected final ArrayList<BehaviourEntry<DragBehaviour>> keyDrags = new ArrayList();
    protected final ArrayList<BehaviourEntry<ClickBehaviour>> buttonClicks = new ArrayList();
    protected final ArrayList<BehaviourEntry<ClickBehaviour>> keyClicks = new ArrayList();
    protected final ArrayList<BehaviourEntry<ScrollBehaviour>> scrolls = new ArrayList();

    private static int getDoubleClickInterval() {
        Object prop = Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        return prop == null ? 200 : (Integer)prop;
    }

    public void setInputMap(InputTriggerMap inputMap) {
        this.inputMap = inputMap;
        this.inputMapExpectedModCount = inputMap.modCount() - 1;
    }

    public void setBehaviourMap(BehaviourMap behaviourMap) {
        this.behaviourMap = behaviourMap;
        this.behaviourMapExpectedModCount = behaviourMap.modCount() - 1;
    }

    protected synchronized void update() {
        int imc = this.inputMap.modCount();
        int bmc = this.behaviourMap.modCount();
        if (imc != this.inputMapExpectedModCount || bmc != this.behaviourMapExpectedModCount) {
            this.inputMapExpectedModCount = imc;
            this.behaviourMapExpectedModCount = bmc;
            this.updateInternalMaps();
        }
    }

    private void updateInternalMaps() {
        this.buttonDrags.clear();
        this.keyDrags.clear();
        this.buttonClicks.clear();
        this.keyClicks.clear();
        this.scrolls.clear();
        for (Map.Entry<InputTrigger, Set<String>> entry : this.inputMap.getAllBindings().entrySet()) {
            InputTrigger buttons = entry.getKey();
            Set<String> behaviourKeys = entry.getValue();
            if (behaviourKeys == null) continue;
            for (String behaviourKey : behaviourKeys) {
                Behaviour behaviour = this.behaviourMap.get(behaviourKey);
                if (behaviour == null) continue;
                if (behaviour instanceof DragBehaviour) {
                    BehaviourEntry<DragBehaviour> dragEntry = new BehaviourEntry<DragBehaviour>(buttons, (DragBehaviour)behaviour);
                    if (buttons.isKeyTriggered()) {
                        this.keyDrags.add(dragEntry);
                    } else {
                        this.buttonDrags.add(dragEntry);
                    }
                }
                if (behaviour instanceof ClickBehaviour) {
                    BehaviourEntry<ClickBehaviour> clickEntry = new BehaviourEntry<ClickBehaviour>(buttons, (ClickBehaviour)behaviour);
                    if (buttons.isKeyTriggered()) {
                        this.keyClicks.add(clickEntry);
                    } else {
                        this.buttonClicks.add(clickEntry);
                    }
                }
                if (!(behaviour instanceof ScrollBehaviour)) continue;
                BehaviourEntry<ScrollBehaviour> scrollEntry = new BehaviourEntry<ScrollBehaviour>(buttons, (ScrollBehaviour)behaviour);
                this.scrolls.add(scrollEntry);
            }
        }
    }

    protected static class BehaviourEntry<T extends Behaviour> {
        private final InputTrigger buttons;
        private final T behaviour;

        public BehaviourEntry(InputTrigger buttons, T behaviour) {
            this.buttons = buttons;
            this.behaviour = behaviour;
        }

        public InputTrigger buttons() {
            return this.buttons;
        }

        public T behaviour() {
            return this.behaviour;
        }
    }
}

