/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.behaviour;

import gnu.trove.TIntCollection;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;

public class InputTrigger {
    public static final int SHIFT_DOWN_MASK = 64;
    public static final int CTRL_DOWN_MASK = 128;
    public static final int META_DOWN_MASK = 256;
    public static final int ALT_DOWN_MASK = 512;
    public static final int BUTTON1_DOWN_MASK = 1024;
    public static final int BUTTON2_DOWN_MASK = 2048;
    public static final int BUTTON3_DOWN_MASK = 4096;
    public static final int ALT_GRAPH_DOWN_MASK = 8192;
    public static final int DOUBLE_CLICK_MASK = 0x100000;
    public static final int SCROLL_MASK = 0x200000;
    public static final int WIN_DOWN_MASK = 0x400000;
    public static final int IGNORE_MASK = -1;
    private static final TIntSet emptySet = new TIntHashSet();
    public static final InputTrigger NOT_MAPPED = new InputTrigger(-1, emptySet, null, false, -1, emptySet);
    private static final String DOUBLE_CLICK_TEXT = "double-click";
    private static final String SCROLL_TEXT = "scroll";
    private static final String WINDOWS_TEXT = "win";
    private static final String NOT_MAPPED_TEXT = "not mapped";
    private static final String IGNORE_ALL_TEXT = "all";
    private final int mask;
    private final TIntSet pressedKeys;
    private final KeyStroke keyStroke;
    private final boolean ignoreNone;
    private final boolean ignoreAll;
    private final int ignoreMask;
    private final TIntSet ignoreKeys;
    private final TIntSet effectiveIgnoreKeys;
    private final int hashcode;
    private static Map<String, Integer> modifierKeywords;
    private static Map<InputTrigger, InputTrigger> cache;

    public static InputTrigger getFromString(String s) throws IllegalArgumentException {
        if (s == null || s.length() == 0) {
            return null;
        }
        if (s.equals(NOT_MAPPED_TEXT)) {
            return NOT_MAPPED;
        }
        try {
            String[] split = InputTrigger.splitAndTrim(s);
            String triggerdef = split[0];
            String ignoredef = split.length > 1 ? split[1] : null;
            MaskAndKeys mak = InputTrigger.getMaskAndKeysFromString(triggerdef);
            int mask = mak.mask;
            TIntSet pressedKeys = mak.pressedKeys;
            KeyStroke keyStroke = null;
            if ((mask & 0x101C00) == 0) {
                keyStroke = KeyStroke.getKeyStroke(triggerdef);
            }
            int ignoreMask = 0;
            TIntSet ignoreKeys = emptySet;
            boolean ignoreAll = false;
            if (ignoredef != null) {
                if (ignoredef.equals(IGNORE_ALL_TEXT)) {
                    ignoreAll = true;
                } else {
                    mak = InputTrigger.getMaskAndKeysFromString(ignoredef);
                    ignoreMask = mak.mask;
                    ignoreKeys = mak.pressedKeys;
                }
            }
            return InputTrigger.getCached(new InputTrigger(mask, pressedKeys, keyStroke, ignoreAll, ignoreMask, ignoreKeys));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("InputTrigger String \"" + s + "\" is formatted incorrectly");
        }
    }

    private static String[] splitAndTrim(String s) throws IllegalArgumentException {
        String[] split = s.split("\\|");
        if (split.length < 1 || split.length > 2) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].trim();
            if (split[i].length() != 0) continue;
            throw new IllegalArgumentException();
        }
        return split;
    }

    private static MaskAndKeys getMaskAndKeysFromString(String s) throws IllegalArgumentException {
        if (s == null || s.length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(s, " ");
        Map<String, Integer> modifierKeywords = InputTrigger.getModifierKeywords();
        int mask = 0;
        TIntHashSet pressedKeys = new TIntHashSet();
        int count = st.countTokens();
        for (int i = 1; i <= count; ++i) {
            String token = st.nextToken();
            if (token.equals("released") || token.equals("pressed") || token.equals("typed")) continue;
            Integer tokenMask = modifierKeywords.get(token);
            if (tokenMask != null) {
                mask |= tokenMask.intValue();
                continue;
            }
            KeyStroke ks = KeyStroke.getKeyStroke(token);
            if (ks == null || ks.getKeyCode() == 0) {
                throw new IllegalArgumentException();
            }
            pressedKeys.add(ks.getKeyCode());
        }
        return new MaskAndKeys(mask, (TIntSet)pressedKeys);
    }

    private InputTrigger(int mask, TIntSet pressedKeys, KeyStroke keyStroke, boolean ignoreAll, int ignoreMask, TIntSet ignoreKeys) {
        this.mask = mask;
        this.pressedKeys = pressedKeys;
        this.keyStroke = keyStroke;
        this.ignoreNone = !ignoreAll && ignoreMask == 0 && ignoreKeys.isEmpty();
        this.ignoreAll = ignoreAll;
        this.ignoreMask = ignoreMask;
        this.ignoreKeys = ignoreKeys;
        if (ignoreAll) {
            this.effectiveIgnoreKeys = null;
        } else {
            this.effectiveIgnoreKeys = new TIntHashSet((TIntCollection)ignoreKeys);
            this.effectiveIgnoreKeys.removeAll((TIntCollection)pressedKeys);
        }
        int value = 17;
        value = 31 * value + mask;
        value = 31 * value + pressedKeys.hashCode();
        value = 31 * value + ignoreMask;
        value = 31 * value + ignoreKeys.hashCode();
        this.hashcode = value += ignoreAll ? 1 : 0;
    }

    public int getMask() {
        return this.mask;
    }

    public TIntCollection getPressedKeys() {
        return this.pressedKeys;
    }

    public boolean isKeyTriggered() {
        return (this.mask & 0x201C00) == 0;
    }

    public boolean isKeyStroke() {
        return this.keyStroke != null;
    }

    public KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    public boolean matches(int mask, TIntSet keys) {
        return this.matches(mask, keys, (TIntSet)new TIntHashSet());
    }

    public boolean matches(int mask, TIntSet keys, TIntSet tmp) {
        if (this.ignoreNone) {
            if (this.mask != mask) {
                return false;
            }
            return keys.equals((Object)this.pressedKeys);
        }
        if (this.ignoreAll) {
            return this.matchesSubset(mask, keys);
        }
        if (this.mask != (mask & (~this.ignoreMask | this.mask))) {
            return false;
        }
        TIntSet effectiveKeys = tmp;
        effectiveKeys.clear();
        effectiveKeys.addAll((TIntCollection)keys);
        effectiveKeys.removeAll((TIntCollection)this.effectiveIgnoreKeys);
        return this.pressedKeys.equals((Object)effectiveKeys);
    }

    public boolean matchesSubset(int mask, TIntSet keys) {
        return this.matchesSubset(mask, keys, (TIntSet)new TIntHashSet());
    }

    public boolean matchesSubset(int mask, TIntSet keys, TIntSet tmp) {
        if (this.mask != (mask & this.mask)) {
            return false;
        }
        TIntSet effectiveKeys = tmp;
        effectiveKeys.clear();
        effectiveKeys.addAll((TIntCollection)keys);
        effectiveKeys.retainAll((TIntCollection)this.pressedKeys);
        return this.pressedKeys.equals((Object)effectiveKeys);
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!InputTrigger.class.isInstance(obj)) {
            return false;
        }
        InputTrigger o = (InputTrigger)obj;
        return this.mask == o.mask && this.ignoreMask == o.ignoreMask && this.pressedKeys.equals((Object)o.pressedKeys) && this.ignoreKeys.equals((Object)o.ignoreKeys) && this.ignoreAll == o.ignoreAll;
    }

    public String toString() {
        if (NOT_MAPPED.equals(this)) {
            return NOT_MAPPED_TEXT;
        }
        StringBuilder buf = new StringBuilder();
        this.addModifierTexts(this.mask, buf);
        this.addKeys(this.pressedKeys, buf);
        if (!this.ignoreNone) {
            buf.append(" |");
            if (this.ignoreAll) {
                buf.append(" ");
                buf.append(IGNORE_ALL_TEXT);
            } else {
                this.addModifierTexts(this.ignoreMask, buf);
                this.addKeys(this.ignoreKeys, buf);
            }
        }
        return buf.toString();
    }

    private void addKeys(TIntSet keys, StringBuilder buf) {
        for (int key : keys) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            String vkName = KeyStroke.getKeyStroke(key, 0).toString();
            buf.append(vkName.replace("pressed ", ""));
        }
    }

    private void addModifierTexts(int mask, StringBuilder buf) {
        this.addModifierText(mask, 64, "shift", buf);
        this.addModifierText(mask, 128, "ctrl", buf);
        this.addModifierText(mask, 256, "meta", buf);
        this.addModifierText(mask, 512, "alt", buf);
        this.addModifierText(mask, 8192, "altGraph", buf);
        this.addModifierText(mask, 1024, "button1", buf);
        this.addModifierText(mask, 2048, "button2", buf);
        this.addModifierText(mask, 4096, "button3", buf);
        this.addModifierText(mask, 0x100000, DOUBLE_CLICK_TEXT, buf);
        this.addModifierText(mask, 0x200000, SCROLL_TEXT, buf);
        this.addModifierText(mask, 0x400000, WINDOWS_TEXT, buf);
    }

    private void addModifierText(int mask, int flag, String name, StringBuilder buf) {
        if ((mask & flag) != 0) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(name);
        }
    }

    private static synchronized Map<String, Integer> getModifierKeywords() {
        if (modifierKeywords == null) {
            HashMap<String, Integer> uninitializedMap = new HashMap<String, Integer>(8, 1.0f);
            uninitializedMap.put("shift", 64);
            uninitializedMap.put("control", 128);
            uninitializedMap.put("ctrl", 128);
            uninitializedMap.put("meta", 256);
            uninitializedMap.put("alt", 512);
            uninitializedMap.put("altGraph", 8192);
            uninitializedMap.put("button1", 1024);
            uninitializedMap.put("button2", 2048);
            uninitializedMap.put("button3", 4096);
            uninitializedMap.put(DOUBLE_CLICK_TEXT, 0x100000);
            uninitializedMap.put(SCROLL_TEXT, 0x200000);
            uninitializedMap.put(WINDOWS_TEXT, 0x400000);
            modifierKeywords = Collections.synchronizedMap(uninitializedMap);
        }
        return modifierKeywords;
    }

    private static synchronized InputTrigger getCached(InputTrigger buttonsAndKeys) {
        InputTrigger b;
        if (cache == null) {
            cache = new HashMap<InputTrigger, InputTrigger>();
        }
        if ((b = cache.get(buttonsAndKeys)) == null) {
            cache.put(buttonsAndKeys, buttonsAndKeys);
            return buttonsAndKeys;
        }
        return b;
    }

    private static class MaskAndKeys {
        int mask;
        TIntSet pressedKeys;

        public MaskAndKeys(int mask, TIntSet pressedKeys) {
            this.mask = mask;
            this.pressedKeys = pressedKeys;
        }
    }
}

