/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple.ops;

import java.io.PrintStream;
import org.ejml.concurrency.EjmlConcurrency;
import org.ejml.data.Complex_F64;
import org.ejml.data.FMatrix;
import org.ejml.data.FMatrix1Row;
import org.ejml.data.FMatrixD1;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_FDRM;
import org.ejml.dense.row.CommonOps_MT_FDRM;
import org.ejml.dense.row.MatrixFeatures_FDRM;
import org.ejml.dense.row.NormOps_FDRM;
import org.ejml.dense.row.mult.VectorVectorMult_FDRM;
import org.ejml.ops.MatrixIO;
import org.ejml.simple.SimpleOperations;

public class SimpleOperations_FDRM
implements SimpleOperations<FMatrixRMaj> {
    @Override
    public void set(FMatrixRMaj A, int row, int column, double value) {
        A.set(row, column, (float)value);
    }

    @Override
    public void set(FMatrixRMaj A, int row, int column, double real, double imaginary) {
        throw new IllegalArgumentException("Does not support imaginary values");
    }

    @Override
    public double get(FMatrixRMaj A, int row, int column) {
        return A.get(row, column);
    }

    @Override
    public void get(FMatrixRMaj A, int row, int column, Complex_F64 value) {
        value.real = A.get(row, column);
        value.imaginary = 0.0;
    }

    @Override
    public void fill(FMatrixRMaj A, double value) {
        CommonOps_FDRM.fill((FMatrixD1)A, (float)((float)value));
    }

    @Override
    public void transpose(FMatrixRMaj input, FMatrixRMaj output) {
        if (EjmlConcurrency.useConcurrent((Matrix)input)) {
            CommonOps_MT_FDRM.transpose((FMatrixRMaj)input, (FMatrixRMaj)output);
        } else {
            CommonOps_FDRM.transpose((FMatrixRMaj)input, (FMatrixRMaj)output);
        }
    }

    @Override
    public void mult(FMatrixRMaj A, FMatrixRMaj B, FMatrixRMaj output) {
        if (EjmlConcurrency.useConcurrent((Matrix)A)) {
            CommonOps_MT_FDRM.mult((FMatrix1Row)A, (FMatrix1Row)B, (FMatrix1Row)output);
        } else {
            CommonOps_FDRM.mult((FMatrix1Row)A, (FMatrix1Row)B, (FMatrix1Row)output);
        }
    }

    @Override
    public void multTransA(FMatrixRMaj A, FMatrixRMaj B, FMatrixRMaj output) {
        if (EjmlConcurrency.useConcurrent((Matrix)A)) {
            CommonOps_MT_FDRM.multTransA((FMatrix1Row)A, (FMatrix1Row)B, (FMatrix1Row)output);
        } else {
            CommonOps_FDRM.multTransA((FMatrix1Row)A, (FMatrix1Row)B, (FMatrix1Row)output);
        }
    }

    @Override
    public void kron(FMatrixRMaj A, FMatrixRMaj B, FMatrixRMaj output) {
        CommonOps_FDRM.kron((FMatrixRMaj)A, (FMatrixRMaj)B, (FMatrixRMaj)output);
    }

    @Override
    public void plus(FMatrixRMaj A, FMatrixRMaj B, FMatrixRMaj output) {
        CommonOps_FDRM.add((FMatrixD1)A, (FMatrixD1)B, (FMatrixD1)output);
    }

    @Override
    public void minus(FMatrixRMaj A, FMatrixRMaj B, FMatrixRMaj output) {
        CommonOps_FDRM.subtract((FMatrixD1)A, (FMatrixD1)B, (FMatrixD1)output);
    }

    @Override
    public void minus(FMatrixRMaj A, double b, FMatrixRMaj output) {
        CommonOps_FDRM.subtract((FMatrixD1)A, (float)((float)b), (FMatrixD1)output);
    }

    @Override
    public void plus(FMatrixRMaj A, double b, FMatrixRMaj output) {
        CommonOps_FDRM.add((FMatrixD1)A, (float)((float)b), (FMatrixD1)output);
    }

    @Override
    public void plus(FMatrixRMaj A, double beta, FMatrixRMaj b, FMatrixRMaj output) {
        CommonOps_FDRM.add((FMatrixD1)A, (float)((float)beta), (FMatrixD1)b, (FMatrixD1)output);
    }

    @Override
    public void plus(double alpha, FMatrixRMaj A, double beta, FMatrixRMaj b, FMatrixRMaj output) {
        CommonOps_FDRM.add((float)((float)alpha), (FMatrixD1)A, (float)((float)beta), (FMatrixD1)b, (FMatrixD1)output);
    }

    @Override
    public double dot(FMatrixRMaj A, FMatrixRMaj v) {
        return VectorVectorMult_FDRM.innerProd((FMatrixD1)A, (FMatrixD1)v);
    }

    @Override
    public void scale(FMatrixRMaj A, double val, FMatrixRMaj output) {
        CommonOps_FDRM.scale((float)((float)val), (FMatrixD1)A, (FMatrixD1)output);
    }

    @Override
    public void divide(FMatrixRMaj A, double val, FMatrixRMaj output) {
        CommonOps_FDRM.divide((FMatrixD1)A, (float)((float)val), (FMatrixD1)output);
    }

    @Override
    public boolean invert(FMatrixRMaj A, FMatrixRMaj output) {
        return CommonOps_FDRM.invert((FMatrixRMaj)A, (FMatrixRMaj)output);
    }

    @Override
    public void setIdentity(FMatrixRMaj A) {
        CommonOps_FDRM.setIdentity((FMatrix1Row)A);
    }

    @Override
    public void pseudoInverse(FMatrixRMaj A, FMatrixRMaj output) {
        CommonOps_FDRM.pinv((FMatrixRMaj)A, (FMatrixRMaj)output);
    }

    @Override
    public boolean solve(FMatrixRMaj A, FMatrixRMaj X, FMatrixRMaj B) {
        return CommonOps_FDRM.solve((FMatrixRMaj)A, (FMatrixRMaj)B, (FMatrixRMaj)X);
    }

    @Override
    public void zero(FMatrixRMaj A) {
        A.zero();
    }

    @Override
    public double normF(FMatrixRMaj A) {
        return NormOps_FDRM.normF((FMatrixD1)A);
    }

    @Override
    public double conditionP2(FMatrixRMaj A) {
        return NormOps_FDRM.conditionP2((FMatrixRMaj)A);
    }

    @Override
    public double determinant(FMatrixRMaj A) {
        return CommonOps_FDRM.det((FMatrixRMaj)A);
    }

    @Override
    public double trace(FMatrixRMaj A) {
        return CommonOps_FDRM.trace((FMatrix1Row)A);
    }

    @Override
    public void setRow(FMatrixRMaj A, int row, int startColumn, double ... values) {
        for (int i = 0; i < values.length; ++i) {
            A.set(row, startColumn + i, (float)values[i]);
        }
    }

    @Override
    public void setColumn(FMatrixRMaj A, int column, int startRow, double ... values) {
        for (int i = 0; i < values.length; ++i) {
            A.set(startRow + i, column, (float)values[i]);
        }
    }

    @Override
    public void extract(FMatrixRMaj src, int srcY0, int srcY1, int srcX0, int srcX1, FMatrixRMaj dst, int dstY0, int dstX0) {
        CommonOps_FDRM.extract((FMatrix)src, (int)srcY0, (int)srcY1, (int)srcX0, (int)srcX1, (FMatrix)dst, (int)dstY0, (int)dstX0);
    }

    @Override
    public FMatrixRMaj diag(FMatrixRMaj A) {
        FMatrixRMaj output;
        if (MatrixFeatures_FDRM.isVector((Matrix)A)) {
            int N = Math.max(A.numCols, A.numRows);
            output = new FMatrixRMaj(N, N);
            CommonOps_FDRM.diag((FMatrixRMaj)output, (int)N, (float[])A.data);
        } else {
            int N = Math.min(A.numCols, A.numRows);
            output = new FMatrixRMaj(N, 1);
            CommonOps_FDRM.extractDiag((FMatrixRMaj)A, (FMatrixRMaj)output);
        }
        return output;
    }

    @Override
    public boolean hasUncountable(FMatrixRMaj M) {
        return MatrixFeatures_FDRM.hasUncountable((FMatrixD1)M);
    }

    @Override
    public void changeSign(FMatrixRMaj a) {
        CommonOps_FDRM.changeSign((FMatrixD1)a);
    }

    @Override
    public double elementMaxAbs(FMatrixRMaj A) {
        return CommonOps_FDRM.elementMaxAbs((FMatrixD1)A);
    }

    @Override
    public double elementMinAbs(FMatrixRMaj A) {
        return CommonOps_FDRM.elementMinAbs((FMatrixD1)A);
    }

    @Override
    public double elementSum(FMatrixRMaj A) {
        return CommonOps_FDRM.elementSum((FMatrixD1)A);
    }

    @Override
    public void elementMult(FMatrixRMaj A, FMatrixRMaj B, FMatrixRMaj output) {
        CommonOps_FDRM.elementMult((FMatrixD1)A, (FMatrixD1)B, (FMatrixD1)output);
    }

    @Override
    public void elementDiv(FMatrixRMaj A, FMatrixRMaj B, FMatrixRMaj output) {
        CommonOps_FDRM.elementDiv((FMatrixD1)A, (FMatrixD1)B, (FMatrixD1)output);
    }

    @Override
    public void elementPower(FMatrixRMaj A, FMatrixRMaj B, FMatrixRMaj output) {
        CommonOps_FDRM.elementPower((FMatrixD1)A, (FMatrixD1)B, (FMatrixD1)output);
    }

    @Override
    public void elementPower(FMatrixRMaj A, double b, FMatrixRMaj output) {
        CommonOps_FDRM.elementPower((FMatrixD1)A, (float)((float)b), (FMatrixD1)output);
    }

    @Override
    public void elementExp(FMatrixRMaj A, FMatrixRMaj output) {
        CommonOps_FDRM.elementExp((FMatrixD1)A, (FMatrixD1)output);
    }

    @Override
    public void elementLog(FMatrixRMaj A, FMatrixRMaj output) {
        CommonOps_FDRM.elementLog((FMatrixD1)A, (FMatrixD1)output);
    }

    @Override
    public boolean isIdentical(FMatrixRMaj A, FMatrixRMaj B, double tol) {
        return MatrixFeatures_FDRM.isIdentical((FMatrixD1)A, (FMatrixD1)B, (float)((float)tol));
    }

    @Override
    public void print(PrintStream out, Matrix mat, String format) {
        MatrixIO.print((PrintStream)out, (FMatrix)((FMatrixRMaj)mat), (String)format);
    }
}

