/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer;

import bdv.gui.BigWarpViewerFrame;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.BigWarpViewerPanel;
import bdv.viewer.DisplayMode;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SourceGroup;
import bdv.viewer.SynchronizedViewerState;
import bdv.viewer.ViewerPanel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import org.scijava.ui.behaviour.KeyStrokeAdder;
import org.scijava.ui.behaviour.util.AbstractNamedAction;
import org.scijava.ui.behaviour.util.Actions;
import org.scijava.ui.behaviour.util.InputActionBindings;

public class WarpNavigationActions
extends Actions {
    public static final String TOGGLE_INTERPOLATION = "toggle interpolation";
    public static final String TOGGLE_FUSED_MODE = "toggle fused mode";
    public static final String TOGGLE_GROUPING = "toggle grouping";
    public static final String SET_CURRENT_SOURCE = "set current source %d";
    public static final String TOGGLE_SOURCE_VISIBILITY = "toggle source visibility %d";
    public static final String ALIGN_PLANE = "align %s plane";
    public static final String ROTATE_PLANE = "rotate %s";
    public static final String DISPLAY_XFMS = "display transforms";
    public static final String EXPAND_CARDS = "expand and focus cards panel";
    public static final String COLLAPSE_CARDS = "collapse cards panel";
    public static final String[] EXPAND_CARDS_KEYS = new String[]{"P"};
    public static final String[] COLLAPSE_CARDS_KEYS = new String[]{"shift P", "ESCAPE"};

    public WarpNavigationActions(KeyStrokeAdder.Factory keyConfig) {
        super(keyConfig, new String[]{"bw_warpNav"});
    }

    public static void installActionBindings(InputActionBindings inputActionBindings, BigWarpViewerFrame frame, KeyStrokeAdder.Factory keyProperties, boolean is2d) {
        ActionMap actionMap = WarpNavigationActions.createActionMap(frame);
        InputMap inputMap = WarpNavigationActions.createInputMap(keyProperties, is2d);
        Actions actions = new Actions(inputMap, actionMap, keyProperties, new String[]{"navigation"});
        actions.install(inputActionBindings, "navigation");
    }

    public static InputMap createInputMap(KeyStrokeAdder.Factory keyProperties, boolean is2d) {
        InputMap inputMap = new InputMap();
        KeyStrokeAdder map = keyProperties.keyStrokeAdder(inputMap, new String[0]);
        map.put(TOGGLE_INTERPOLATION, new String[]{"I"});
        map.put(TOGGLE_FUSED_MODE, new String[]{"F"});
        map.put(TOGGLE_GROUPING, new String[]{"G"});
        String[] numkeys = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
        for (int i = 0; i < numkeys.length; ++i) {
            map.put(String.format(SET_CURRENT_SOURCE, i), new String[]{numkeys[i]});
            map.put(String.format(TOGGLE_SOURCE_VISIBILITY, i), new String[]{"shift " + numkeys[i]});
        }
        map.put(DISPLAY_XFMS, new String[]{"shift V"});
        if (!is2d) {
            map.put(String.format(ALIGN_PLANE, AbstractViewerPanel.AlignPlane.XY), new String[]{"shift Z"});
            map.put(String.format(ALIGN_PLANE, AbstractViewerPanel.AlignPlane.ZY), new String[]{"shift X"});
            map.put(String.format(ALIGN_PLANE, AbstractViewerPanel.AlignPlane.XZ), new String[]{"shift Y", "shift A"});
        } else {
            map.put(String.format(ROTATE_PLANE, rotationDirections2d.CLOCKWISE.name()), new String[]{"shift X"});
            map.put(String.format(ROTATE_PLANE, rotationDirections2d.COUNTERCLOCKWISE.name()), new String[]{"shift Z"});
        }
        map.put(EXPAND_CARDS, EXPAND_CARDS_KEYS);
        map.put(COLLAPSE_CARDS, COLLAPSE_CARDS_KEYS);
        return inputMap;
    }

    public static ActionMap createActionMap(BigWarpViewerFrame frame) {
        return WarpNavigationActions.createActionMap(frame, 10);
    }

    public static ActionMap createActionMap(BigWarpViewerFrame frame, int numSourceKeys) {
        ActionMap actionMap = new ActionMap();
        WarpNavigationActions.addToActionMap(actionMap, frame, numSourceKeys);
        return actionMap;
    }

    public static void addToActionMap(ActionMap actionMap, BigWarpViewerFrame frame, int numSourceKeys) {
        BigWarpViewerPanel viewer = frame.getViewerPanel();
        new ToggleInterPolationAction(viewer).put(actionMap);
        new ToggleFusedModeAction(viewer).put(actionMap);
        new ToggleGroupingAction(viewer).put(actionMap);
        for (int i = 0; i < numSourceKeys; ++i) {
            new SetCurrentSourceOrGroupAction(viewer, i).put(actionMap);
            new ToggleSourceOrGroupVisibilityAction(viewer, i).put(actionMap);
        }
        for (AbstractViewerPanel.AlignPlane plane : AbstractViewerPanel.AlignPlane.values()) {
            new AlignPlaneAction(viewer, plane).put(actionMap);
        }
        new RotatePlaneAction(viewer, rotationDirections2d.CLOCKWISE).put(actionMap);
        new RotatePlaneAction(viewer, rotationDirections2d.COUNTERCLOCKWISE).put(actionMap);
        new DisplayXfmAction(viewer).put(actionMap);
        new ExpandCardAction(frame).put(actionMap);
        new CollapseCardAction(frame).put(actionMap);
    }

    public static class CardAction
    extends NavigationAction {
        private static final long serialVersionUID = -8949725696799894130L;
        public BigWarpViewerFrame frame;

        public CardAction(BigWarpViewerFrame frame, String name) {
            super(name, frame.getViewerPanel());
            this.frame = frame;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.name().equals(WarpNavigationActions.EXPAND_CARDS)) {
                this.frame.expandAndFocusCardPanel();
            } else {
                this.frame.collapseCardPanel();
            }
        }
    }

    public static class ExpandCardAction
    extends NavigationAction {
        private static final long serialVersionUID = -4267852269622298980L;
        public BigWarpViewerFrame frame;

        public ExpandCardAction(BigWarpViewerFrame frame) {
            super(WarpNavigationActions.EXPAND_CARDS, frame.getViewerPanel());
            this.frame = frame;
        }

        public void actionPerformed(ActionEvent e) {
            this.frame.expandAndFocusCardPanel();
        }
    }

    public static class CollapseCardAction
    extends NavigationAction {
        private static final long serialVersionUID = -2337698189753056286L;
        public BigWarpViewerFrame frame;

        public CollapseCardAction(BigWarpViewerFrame frame) {
            super(WarpNavigationActions.COLLAPSE_CARDS, frame.getViewerPanel());
            this.frame = frame;
        }

        public void actionPerformed(ActionEvent e) {
            this.frame.collapseCardPanel();
        }
    }

    public static class AlignPlaneAction
    extends NavigationAction {
        private static final long serialVersionUID = -5868085804210873492L;
        private final AbstractViewerPanel.AlignPlane plane;

        public AlignPlaneAction(ViewerPanel viewer, AbstractViewerPanel.AlignPlane plane) {
            super(String.format(WarpNavigationActions.ALIGN_PLANE, plane.name()), viewer);
            this.plane = plane;
        }

        public void actionPerformed(ActionEvent e) {
            this.viewer.align(this.plane);
        }
    }

    public static class RotatePlaneAction
    extends NavigationAction {
        private rotationDirections2d direction;
        private static final long serialVersionUID = 1L;

        public RotatePlaneAction(BigWarpViewerPanel viewer, rotationDirections2d direction) {
            super(String.format(WarpNavigationActions.ROTATE_PLANE, direction.name()), viewer);
            this.direction = direction;
        }

        public void actionPerformed(ActionEvent e) {
            ((BigWarpViewerPanel)this.viewer).rotateView2d(this.direction == rotationDirections2d.CLOCKWISE);
        }
    }

    public static class DisplayXfmAction
    extends NavigationAction {
        private static final long serialVersionUID = 1L;

        public DisplayXfmAction(BigWarpViewerPanel viewer) {
            super(WarpNavigationActions.DISPLAY_XFMS, viewer);
        }

        public void actionPerformed(ActionEvent e) {
            ((BigWarpViewerPanel)this.viewer).displayViewerTransforms();
        }
    }

    public static class ToggleSourceOrGroupVisibilityAction
    extends NavigationAction {
        private final int index;
        private static final long serialVersionUID = 1L;

        public ToggleSourceOrGroupVisibilityAction(ViewerPanel viewer, int index) {
            super(String.format(WarpNavigationActions.TOGGLE_SOURCE_VISIBILITY, index), viewer);
            this.index = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            SynchronizedViewerState state;
            SynchronizedViewerState synchronizedViewerState = state = this.viewer.state();
            synchronized (synchronizedViewerState) {
                if (state.getDisplayMode().hasGrouping()) {
                    List groups = state.getGroups();
                    if (this.index >= 0 && this.index < groups.size()) {
                        SourceGroup group;
                        state.setGroupActive(group, !state.isGroupActive(group = (SourceGroup)groups.get(this.index)));
                    }
                } else {
                    List sources = state.getSources();
                    if (this.index >= 0 && this.index < sources.size()) {
                        SourceAndConverter source;
                        state.setSourceActive(source, !state.isSourceActive(source = (SourceAndConverter)sources.get(this.index)));
                    }
                }
            }
        }
    }

    public static class SetCurrentSourceOrGroupAction
    extends NavigationAction {
        private final int index;
        private static final long serialVersionUID = 1L;

        public SetCurrentSourceOrGroupAction(ViewerPanel viewer, int index) {
            super(String.format(WarpNavigationActions.SET_CURRENT_SOURCE, index), viewer);
            this.index = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            SynchronizedViewerState state;
            SynchronizedViewerState synchronizedViewerState = state = this.viewer.state();
            synchronized (synchronizedViewerState) {
                if (state.getDisplayMode().hasGrouping()) {
                    List groups = state.getGroups();
                    if (this.index >= 0 && this.index < groups.size()) {
                        SourceGroup group = (SourceGroup)groups.get(this.index);
                        state.setCurrentGroup(group);
                        ArrayList sources = new ArrayList(state.getSourcesInGroup(group));
                        if (!sources.isEmpty()) {
                            sources.sort(state.sourceOrder());
                            state.setCurrentSource((SourceAndConverter)sources.get(0));
                        }
                    }
                } else {
                    List sources = state.getSources();
                    if (this.index >= 0 && this.index < sources.size()) {
                        state.setCurrentSource((SourceAndConverter)sources.get(this.index));
                    }
                }
            }
        }
    }

    public static class ToggleGroupingAction
    extends NavigationAction {
        private static final long serialVersionUID = 1L;

        public ToggleGroupingAction(ViewerPanel viewer) {
            super(WarpNavigationActions.TOGGLE_GROUPING, viewer);
        }

        public void actionPerformed(ActionEvent e) {
            DisplayMode mode;
            SynchronizedViewerState state;
            state.setDisplayMode(mode.withGrouping(!(mode = (state = this.viewer.state()).getDisplayMode()).hasGrouping()));
        }
    }

    public static class ToggleFusedModeAction
    extends NavigationAction {
        private static final long serialVersionUID = 1L;

        public ToggleFusedModeAction(ViewerPanel viewer) {
            super(WarpNavigationActions.TOGGLE_FUSED_MODE, viewer);
        }

        public void actionPerformed(ActionEvent e) {
            DisplayMode mode;
            SynchronizedViewerState state;
            state.setDisplayMode(mode.withFused(!(mode = (state = this.viewer.state()).getDisplayMode()).hasFused()));
        }
    }

    public static class ToggleInterPolationAction
    extends NavigationAction {
        private static final long serialVersionUID = 1L;

        public ToggleInterPolationAction(ViewerPanel viewer) {
            super(WarpNavigationActions.TOGGLE_INTERPOLATION, viewer);
        }

        public void actionPerformed(ActionEvent e) {
            this.viewer.toggleInterpolation();
        }
    }

    private static abstract class NavigationAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = 1607667614920666360L;
        protected final ViewerPanel viewer;

        public NavigationAction(String name, ViewerPanel viewer) {
            super(name);
            this.viewer = viewer;
        }
    }

    public static enum rotationDirections2d {
        CLOCKWISE,
        COUNTERCLOCKWISE;

    }
}

