/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.scripts;

import bigwarp.landmarks.LandmarkTableModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class RescaleLandmarks {
    public static void main(String[] args) throws IOException {
        String pts_fn = args[0];
        String output_fn = args[1];
        double[] movingScales = RescaleLandmarks.parseArray(args[2]);
        double[] targetScales = RescaleLandmarks.parseArray(args[3]);
        int ndims = movingScales.length;
        LandmarkTableModel ltm = new LandmarkTableModel(ndims);
        ltm.load(new File(pts_fn));
        RescaleLandmarks.scaleLandmarks(ltm, movingScales, true);
        RescaleLandmarks.scaleLandmarks(ltm, targetScales, false);
        ltm.save(new File(output_fn));
        System.out.println("finished");
        System.exit(0);
    }

    public static void scaleLandmarks(LandmarkTableModel ltm, double[] scales, boolean isMoving) {
        ArrayList<Double[]> pts = ltm.getPoints(isMoving);
        for (int i = 0; i < ltm.getRowCount(); ++i) {
            RescaleLandmarks.scale(pts.get(i), scales);
        }
    }

    public static void scale(Double[] point, double[] scale) {
        for (int i = 0; i < point.length; ++i) {
            point[i] = point[i] * scale[i];
        }
    }

    public static double[] parseArray(String arrayString) {
        String[] strings = arrayString.split(",");
        double[] out = new double[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            out[i] = Double.parseDouble(strings[i]);
        }
        return out;
    }
}

