/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.source;

import bdv.util.BdvFunctions;
import bdv.util.BdvStackSource;
import bigwarp.source.GridSource;
import net.imglib2.AbstractRealLocalizable;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RealLocalizable;
import net.imglib2.RealRandomAccess;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.util.Intervals;

public class GridRealRandomAccess<T extends RealType<T>>
extends AbstractRealLocalizable
implements RealRandomAccess<T> {
    protected RealTransform warp;
    private T value;
    private GridSource.GRID_TYPE method = GridSource.GRID_TYPE.MOD;
    private double gridSpacing = 20.0;
    private double gridWidth = 2.0;
    private double gridHalfWidth = this.gridWidth / 2.0;
    private boolean is2d = false;

    protected GridRealRandomAccess(double[] dimensions) {
        this(dimensions, null, null);
    }

    protected GridRealRandomAccess(double[] dimensions, T value, RealTransform warp) {
        this(dimensions, value, warp, GridSource.GRID_TYPE.MOD);
    }

    protected GridRealRandomAccess(double[] dimensions, T value, RealTransform warp, GridSource.GRID_TYPE method) {
        super(dimensions.length);
        this.value = value;
        if (warp != null) {
            this.warp = warp.copy();
        }
        this.method = method;
        this.is2d = dimensions.length == 2 || dimensions[2] == 0.0;
    }

    public static void main(String[] args) {
        AffineTransform3D transform = new AffineTransform3D();
        transform.set(1.1, -0.2, 0.1, 0.0, 0.3, 0.9, -0.1, 0.0, -0.1, -0.2, 1.2, 0.0);
        FinalInterval itvl = Intervals.createMinMax((long[])new long[]{0L, 0L, 0L, 255L, 255L, 255L});
        AffineTransform3D srcXfm = new AffineTransform3D();
        GridSource<UnsignedByteType> src = new GridSource<UnsignedByteType>("grid", new UnsignedByteType(), (Interval)itvl, srcXfm, null);
        src.setMethod(GridSource.GRID_TYPE.LINE);
        BdvStackSource bdv = BdvFunctions.show(src);
    }

    public void setGridSpacing(double spacing) {
        this.gridSpacing = spacing;
    }

    public void setGridWidth(double width) {
        this.gridWidth = width;
        this.gridHalfWidth = width / 2.0;
    }

    public void setMethod(GridSource.GRID_TYPE method) {
        this.method = method;
    }

    public T get() {
        double[] mypt = new double[this.numDimensions()];
        this.localize(mypt);
        switch (this.method) {
            case LINE: {
                return this.getLine(mypt);
            }
        }
        return this.getMod(mypt);
    }

    private T getLine(double[] pt) {
        double[] warpRes;
        if (this.warp != null) {
            warpRes = new double[this.warp.numTargetDimensions()];
            this.warp.apply(pt, warpRes);
        } else {
            warpRes = pt;
        }
        int nd = warpRes.length;
        if (this.is2d) {
            nd = 2;
        }
        double val = -1.0;
        boolean i = false;
        for (int d = 0; d < nd; ++d) {
            double tmp = warpRes[d] % this.gridSpacing;
            if (tmp < 0.0) {
                tmp *= -1.0;
            }
            if (!((tmp = tmp <= this.gridHalfWidth ? this.gridHalfWidth - tmp : (tmp >= this.gridSpacing - this.gridHalfWidth ? tmp - this.gridSpacing + this.gridHalfWidth : 0.0)) > val)) continue;
            val = tmp;
        }
        RealType out = (RealType)this.value.copy();
        if (val < this.gridWidth) {
            out.setReal(val * (255.0 / this.gridHalfWidth));
        } else {
            out.setZero();
        }
        return (T)out;
    }

    private T getMod(double[] pt) {
        double[] warpRes;
        if (this.warp != null) {
            warpRes = new double[this.warp.numTargetDimensions()];
            this.warp.apply(pt, warpRes);
        } else {
            warpRes = pt;
        }
        double val = 0.0;
        for (int d = 0; d < warpRes.length; ++d) {
            double tmp = warpRes[d] % this.gridSpacing;
            if (tmp < 0.0) {
                tmp *= -1.0;
            }
            val += tmp;
        }
        RealType out = (RealType)this.value.copy();
        out.setReal(val);
        return (T)out;
    }

    private boolean withinRad(double[] pt1, double[] pt2, double rad) {
        double radSquared = rad * rad;
        double distSquared = 0.0;
        for (int d = 0; d < pt2.length; ++d) {
            distSquared += (pt1[d] - pt2[d]) * (pt1[d] - pt2[d]);
        }
        return distSquared < radSquared;
    }

    public RealRandomAccess<T> copyRealRandomAccess() {
        return this.copy();
    }

    public RealRandomAccess<T> copy() {
        if (this.warp == null) {
            GridRealRandomAccess<RealType> ra = new GridRealRandomAccess<RealType>(new double[this.position.length], (RealType)this.value.copy(), null, this.method);
            ra.gridSpacing = this.gridSpacing;
            ra.gridWidth = this.gridWidth;
            ra.gridHalfWidth = this.gridHalfWidth;
            return ra;
        }
        GridRealRandomAccess<RealType> ra = new GridRealRandomAccess<RealType>(new double[this.position.length], (RealType)this.value.copy(), this.warp, this.method);
        ra.gridSpacing = this.gridSpacing;
        ra.gridWidth = this.gridWidth;
        ra.gridHalfWidth = this.gridHalfWidth;
        return ra;
    }

    public RealRandomAccess<T> copyRandomAccess() {
        return this.copy();
    }

    public void fwd(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1.0;
    }

    public void bck(int d) {
        int n = d;
        this.position[n] = this.position[n] - 1.0;
    }

    public void move(int distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (double)distance;
    }

    public void move(long distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (double)distance;
    }

    public void move(Localizable localizable) {
        int d = 0;
        while (d < this.n) {
            int distance = localizable.getIntPosition(d);
            int n = d++;
            this.position[n] = this.position[n] + (double)distance;
        }
    }

    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
    }

    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
    }

    public void setPosition(Localizable localizable) {
        localizable.localize(this.position);
    }

    public void setPosition(int[] pos) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = pos[d];
        }
    }

    public void setPosition(long[] pos) {
        for (int d = 0; d < this.n; ++d) {
            int p = (int)pos[d];
            this.position[d] = p;
        }
    }

    public void setPosition(int pos, int d) {
        this.position[d] = pos;
    }

    public void setPosition(long pos, int d) {
        this.position[d] = (int)pos;
    }

    public void move(float distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (double)distance;
    }

    public void move(double distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + distance;
    }

    public void move(RealLocalizable localizable) {
        int d = 0;
        while (d < this.n) {
            double distance = localizable.getDoublePosition(d);
            int n = d++;
            this.position[n] = this.position[n] + distance;
        }
    }

    public void move(float[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
    }

    public void move(double[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + distance[d];
        }
    }

    public void setPosition(RealLocalizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            double pos;
            this.position[d] = pos = localizable.getDoublePosition(d);
        }
    }

    public void setPosition(float[] p) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = p[d];
        }
    }

    public void setPosition(double[] p) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = p[d];
        }
    }

    public void setPosition(float p, int d) {
        this.position[d] = p;
    }

    public void setPosition(double p, int d) {
        this.position[d] = p;
    }
}

