/*
 * Decompiled with CFR 0.152.
 */
package io.scif.bf;

import io.scif.AbstractChecker;
import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.DefaultImageMetadata;
import io.scif.DefaultMetaTable;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.HasColorTable;
import io.scif.HasFormat;
import io.scif.ImageMetadata;
import io.scif.MetaTable;
import io.scif.bf.wrapper.DataHandleAdapter;
import io.scif.config.SCIFIOConfig;
import io.scif.ome.services.OMEXMLService;
import io.scif.util.FormatTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.ClassList;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadataImpl;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.Interval;
import net.imglib2.display.ColorTable;
import net.imglib2.display.ColorTable16;
import net.imglib2.display.ColorTable8;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Color;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.location.FileLocation;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.LongArray;

@Plugin(type=Format.class, name="Bio-Formats Compatibility Format", priority=10000.0)
public class BioFormatsFormat
extends AbstractFormat {
    public static final String[] DO_NOT_CONVERT = new String[]{"loci.formats.in.APNGReader", "loci.formats.in.AVIReader", "loci.formats.in.BMPReader", "loci.formats.in.DicomReader", "loci.formats.in.EPSReader", "loci.formats.in.FakeReader", "loci.formats.in.FitsReader", "loci.formats.in.GIFReader", "loci.formats.in.ICSReader", "loci.formats.in.JPEGReader", "loci.formats.in.JPEG2000Reader", "loci.formats.in.MicromanagerReader", "loci.formats.in.MinimalTiffReader", "loci.formats.in.MNGReader", "loci.formats.in.NRRDReader", "loci.formats.in.PCXReader", "loci.formats.in.PGMReader", "loci.formats.in.PictReader", "loci.formats.in.QTReader", "loci.formats.in.SCIFIOReader", "loci.formats.in.SDTReader", "loci.formats.in.TextReader", "loci.formats.in.TiffDelegateReader", "loci.formats.in.TiffJAIReader", "loci.formats.in.TiffReader", "loci.formats.in.TileJPEGReader", "loci.formats.in.ZipReader"};
    private ClassList<IFormatReader> readerClasses;
    private ImageReader cachedReader;
    private int cachedReaderHash;

    public BioFormatsFormat() {
        this.cacheReaderClasses();
    }

    public ImageReader createImageReader() {
        this.cacheReaderClasses();
        return new ImageReader(this.readerClasses);
    }

    public ImageReader getCachedImageReader() {
        if (this.cacheReaderClasses() || this.cachedReader == null) {
            this.cachedReader = this.createImageReader();
        }
        return this.cachedReader;
    }

    public void addReader(Class<IFormatReader> readerClass) {
        this.readerClasses.addClass(readerClass);
    }

    protected String[] makeSuffixArray() {
        return null;
    }

    public String[] getSuffixes() {
        return this.getCachedImageReader().getSuffixes();
    }

    private boolean cacheReaderClasses() {
        Object[] defaultClasses = ImageReader.getDefaultReaderClasses().getClasses();
        int currentHash = Arrays.hashCode(defaultClasses);
        if (this.readerClasses == null || this.cachedReaderHash != currentHash) {
            ClassList targetClasses = new ClassList(IFormatReader.class);
            for (Object c : defaultClasses) {
                if (!this.convert((Class<? extends IFormatReader>)c)) continue;
                targetClasses.addClass((Class)c);
            }
            this.readerClasses = targetClasses;
            this.cachedReaderHash = currentHash;
            return true;
        }
        return false;
    }

    private boolean convert(Class<? extends IFormatReader> c) {
        for (String s : DO_NOT_CONVERT) {
            if (!s.equals(c.getName())) continue;
            return false;
        }
        return true;
    }

    private static ImageReader createImageReader(HasFormat thing) {
        return ((BioFormatsFormat)thing.getFormat()).createImageReader();
    }

    private static ImageReader getCachedImageReader(HasFormat thing) {
        return ((BioFormatsFormat)thing.getFormat()).getCachedImageReader();
    }

    private static ImageMetadata convertMetadata(IFormatReader reader, int s) {
        DefaultImageMetadata imgMeta = new DefaultImageMetadata();
        reader.setSeries(s);
        OMEXMLMetadataImpl store = (OMEXMLMetadataImpl)reader.getMetadataStore();
        ArrayList<CalibratedAxis> axes = new ArrayList<CalibratedAxis>();
        LongArray axisLengths = new LongArray();
        imgMeta.setPlanarAxisCount(2);
        BioFormatsFormat.parseChannelDimensions(reader, (ImageMetadata)imgMeta, DesiredChannels.INTERLEAVED, axes, axisLengths);
        String dimOrder = reader.getDimensionOrder().toUpperCase();
        CalibratedAxis axis = null;
        Length stageLabelX = null;
        Length stageLabelY = null;
        Length stageLabelZ = null;
        try {
            stageLabelX = store.getStageLabelX(s);
            stageLabelY = store.getStageLabelY(s);
            stageLabelZ = store.getStageLabelZ(s);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        block9: for (int i = 0; i < dimOrder.length(); ++i) {
            switch (dimOrder.charAt(i)) {
                case 'X': {
                    axis = FormatTools.createAxis((AxisType)Axes.X);
                    axes.add(axis);
                    axisLengths.add((Object)reader.getSizeX());
                    BioFormatsFormat.calibrate(store.getPixelsPhysicalSizeX(s), axis, stageLabelX);
                    continue block9;
                }
                case 'Y': {
                    axis = FormatTools.createAxis((AxisType)Axes.Y);
                    axes.add(axis);
                    axisLengths.add((Object)reader.getSizeY());
                    BioFormatsFormat.calibrate(store.getPixelsPhysicalSizeY(s), axis, stageLabelY);
                    BioFormatsFormat.parseChannelDimensions(reader, (ImageMetadata)imgMeta, DesiredChannels.PLANAR, axes, axisLengths);
                    continue block9;
                }
                case 'Z': {
                    axis = FormatTools.createAxis((AxisType)Axes.Z);
                    if (reader.getSizeZ() <= 1) continue block9;
                    axes.add(axis);
                    axisLengths.add((Object)reader.getSizeZ());
                    BioFormatsFormat.calibrate(store.getPixelsPhysicalSizeZ(s), axis, stageLabelZ);
                    continue block9;
                }
                case 'C': {
                    BioFormatsFormat.parseChannelDimensions(reader, (ImageMetadata)imgMeta, DesiredChannels.NONPLANAR, axes, axisLengths);
                    continue block9;
                }
                case 'T': {
                    if (reader.getSizeT() <= 1) continue block9;
                    axes.add(FormatTools.createAxis((AxisType)Axes.TIME));
                    axisLengths.add((Object)reader.getSizeT());
                }
            }
        }
        imgMeta.setAxes(axes.toArray(new CalibratedAxis[axes.size()]));
        imgMeta.setAxisLengths((long[])axisLengths.copyArray());
        imgMeta.setThumbSizeX((long)reader.getThumbSizeX());
        imgMeta.setThumbSizeY((long)reader.getThumbSizeY());
        imgMeta.setPixelType(reader.getPixelType());
        int bpp = reader.getBitsPerPixel();
        int bitsPerPixel = bpp == 0 ? FormatTools.getBitsPerPixel((int)reader.getPixelType()) : bpp;
        imgMeta.setBitsPerPixel(bitsPerPixel);
        imgMeta.setOrderCertain(reader.isOrderCertain());
        imgMeta.setLittleEndian(reader.isLittleEndian());
        imgMeta.setFalseColor(reader.isFalseColor());
        imgMeta.setMetadataComplete(reader.isMetadataComplete());
        DefaultMetaTable table = new DefaultMetaTable((Map)reader.getSeriesMetadata());
        imgMeta.setTable((MetaTable)table);
        imgMeta.setThumbnail(reader.isThumbnailSeries());
        return imgMeta;
    }

    private static void calibrate(Length pixelsPhysicalSize, CalibratedAxis axis, Length stageLabel) {
        if (pixelsPhysicalSize != null) {
            FormatTools.calibrate((CalibratedAxis)axis, (double)pixelsPhysicalSize.value().doubleValue(), (double)(stageLabel == null ? 0.0 : stageLabel.value().doubleValue()));
        }
    }

    private static void parseChannelDimensions(IFormatReader reader, ImageMetadata meta, DesiredChannels query, ArrayList<CalibratedAxis> axisTypes, LongArray axisLengths) {
        if (query == DesiredChannels.INTERLEAVED || query == DesiredChannels.PLANAR) {
            if (reader.isInterleaved() != (query == DesiredChannels.INTERLEAVED)) {
                return;
            }
            long length = 1L;
            if (reader.getRGBChannelCount() > 1) {
                length = reader.getRGBChannelCount();
            } else if (reader.isIndexed() && reader.getEffectiveSizeC() == 1) {
                meta.setIndexed(true);
            } else {
                return;
            }
            axisTypes.add(FormatTools.createAxis((AxisType)Axes.CHANNEL));
            meta.setPlanarAxisCount(meta.getPlanarAxisCount() + 1);
            axisLengths.add((Object)length);
        } else if (query == DesiredChannels.NONPLANAR && reader.getEffectiveSizeC() > 1) {
            meta.setIndexed(reader.isIndexed());
            AxisType type = null;
            type = reader.getRGBChannelCount() > 1 ? Axes.get((String)"Channels-planar") : Axes.CHANNEL;
            axisTypes.add(FormatTools.createAxis((AxisType)type));
            axisLengths.add((Object)reader.getEffectiveSizeC());
        }
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
            IFormatReader reader = ((Metadata)this.getMetadata()).getReader();
            reader.setSeries(imageIndex);
            try {
                Metadata meta = (Metadata)this.getMetadata();
                int xIndex = meta.get(imageIndex).getAxisIndex(Axes.X);
                int yIndex = meta.get(imageIndex).getAxisIndex(Axes.Y);
                int x = (int)bounds.min(xIndex);
                int y = (int)bounds.min(yIndex);
                int w = (int)bounds.dimension(xIndex);
                int h = (int)bounds.dimension(yIndex);
                reader.openBytes((int)planeIndex, plane.getBytes(), x, y, w, h);
                plane.setColorTable(((Metadata)this.getMetadata()).getColorTable(imageIndex, planeIndex));
            }
            catch (loci.formats.FormatException e) {
                throw new FormatException((Throwable)e);
            }
            return plane;
        }

        protected String[] createDomainArray() {
            return new String[0];
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        protected void typedParse(DataHandle<org.scijava.io.location.Location> stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            try {
                ImageReader reader = BioFormatsFormat.createImageReader((HasFormat)this);
                meta.setReader((IFormatReader)reader);
                OMEXMLMetadataImpl store = new OMEXMLMetadataImpl();
                reader.setMetadataStore((MetadataStore)store);
                reader.setOriginalMetadataPopulated(config.parserIsSaveOriginalMetadata());
                reader.setMetadataFiltered(config.parserIsFiltered());
                reader.setGroupFiles(config.groupableIsGroupFiles());
                if (stream.get() instanceof FileLocation) {
                    reader.setId(((FileLocation)stream.get()).getFile().getAbsolutePath());
                } else {
                    DataHandleAdapter value = new DataHandleAdapter(stream);
                    Location.getIdMap().put(((org.scijava.io.location.Location)stream.get()).getName(), value);
                    reader.setId(((org.scijava.io.location.Location)stream.get()).getName());
                }
                meta.setTable((MetaTable)new DefaultMetaTable((Map)reader.getGlobalMetadata()));
            }
            catch (loci.formats.FormatException e) {
                throw new FormatException((Throwable)e);
            }
        }
    }

    public static class Checker
    extends AbstractChecker {
        @Parameter
        DataHandleService handles;
        @Parameter
        LogService log;

        public boolean isFormat(org.scijava.io.location.Location loc) {
            if (!this.realSource(loc)) {
                return false;
            }
            return BioFormatsFormat.getCachedImageReader((HasFormat)this).isThisType(loc.getName());
        }

        public boolean isFormat(org.scijava.io.location.Location loc, SCIFIOConfig config) {
            try {
                DataHandle handle = (DataHandle)this.handles.create((Object)loc);
                if (handle == null || !handle.exists() || !this.realSource(loc)) {
                    return false;
                }
                if (loc instanceof FileLocation) {
                    return BioFormatsFormat.getCachedImageReader((HasFormat)this).isThisType(((FileLocation)loc).getFile().getAbsolutePath(), config.checkerIsOpen());
                }
                Location.getIdMap().put(loc.getName(), new DataHandleAdapter((DataHandle<org.scijava.io.location.Location>)handle));
            }
            catch (IOException exc) {
                this.log.error((Object)("Failed to create handle for location " + loc.toString()), (Throwable)exc);
                return false;
            }
            return BioFormatsFormat.getCachedImageReader((HasFormat)this).isThisType(loc.getName(), config.checkerIsOpen());
        }

        public boolean isFormat(DataHandle<org.scijava.io.location.Location> handle) throws IOException {
            if (!this.realSource(handle)) {
                return false;
            }
            Location.getIdMap().put(((org.scijava.io.location.Location)handle.get()).getName(), handle);
            return BioFormatsFormat.getCachedImageReader((HasFormat)this).isThisType((RandomAccessInputStream)new DataHandleAdapter(handle));
        }

        public boolean suffixSufficient() {
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean realSource(org.scijava.io.location.Location loc) {
            try (DataHandle handle = (DataHandle)this.handles.create((Object)loc);){
                boolean bl = handle != null && this.realSource((DataHandle<org.scijava.io.location.Location>)handle);
                return bl;
            }
            catch (IOException e) {
                return false;
            }
        }

        private boolean realSource(DataHandle<org.scijava.io.location.Location> handle) throws IOException {
            return FormatTools.validStream(handle, (int)1, (boolean)handle.isLittleEndian());
        }

        public boolean checkHeader(byte[] block) {
            return BioFormatsFormat.getCachedImageReader((HasFormat)this).isThisType(block);
        }
    }

    public static class Metadata
    extends AbstractMetadata
    implements HasColorTable {
        @Parameter
        private OMEXMLService omexmlService;
        private IFormatReader reader;
        private MetadataStore metadataStore;
        private String formatName;
        private final Map<String, ColorTable> colorTables16 = new WeakHashMap<String, ColorTable>();
        private final Map<String, ColorTable> colorTables8 = new WeakHashMap<String, ColorTable>();
        private final Map<MetadataRetrieve, ColorTable> colorTableXML = new WeakHashMap<MetadataRetrieve, ColorTable>();

        public IFormatReader getReader() {
            return this.reader;
        }

        public void setReader(IFormatReader reader) {
            this.reader = reader;
            this.formatName = null;
            this.metadataStore = null;
        }

        public MetadataStore getMetadataStore() {
            if (Objects.isNull(this.metadataStore)) {
                this.metadataStore = this.getReader().getMetadataStore();
            }
            return this.metadataStore;
        }

        public void populateImageMetadata() {
            for (int s = 0; s < this.reader.getSeriesCount(); ++s) {
                this.add(BioFormatsFormat.convertMetadata(this.reader, s));
            }
            this.formatName = super.getFormatName();
            this.formatName = this.formatName + " - Bio-Formats reader used: " + this.reader.getFormat();
            this.getMetadataStore();
        }

        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (this.reader != null) {
                this.reader.close(fileOnly);
            }
        }

        public String getFormatName() {
            return this.formatName == null ? super.getFormatName() : this.formatName;
        }

        public ColorTable getColorTable(int imageIndex, long planeIndex) {
            long channelIndex;
            if (imageIndex >= this.reader.getSeriesCount()) {
                imageIndex = 0;
            }
            String key = this.getKey(this.reader, imageIndex);
            ColorTable ct16 = this.colorTables16.get(key);
            ColorTable ct8 = this.colorTables8.get(key);
            if (ct16 != null || ct8 != null) {
                return ct16 == null ? ct8 : ct16;
            }
            int oldIndex = this.reader.getSeries();
            this.reader.setSeries(imageIndex);
            try {
                short[][] table16 = this.reader.get16BitLookupTable();
                if (table16 != null) {
                    this.reader.setSeries(oldIndex);
                    return this.colorTables16.put(key, (ColorTable)new ColorTable16(table16));
                }
                byte[][] table8 = this.reader.get8BitLookupTable();
                if (table8 != null) {
                    this.reader.setSeries(oldIndex);
                    return this.colorTables8.put(key, (ColorTable)new ColorTable8(table8));
                }
            }
            catch (IOException | loci.formats.FormatException e) {
                this.log().error(e);
            }
            ColorTable ct = null;
            MetadataRetrieve retrieve = this.omexmlService.asRetrieve(this.getMetadataStore());
            if (retrieve != null && (ct = this.colorTableXML.get(retrieve)) == null && (channelIndex = FormatTools.getNonPlanarAxisPosition((io.scif.Metadata)this, (int)imageIndex, (long)planeIndex, (AxisType)Axes.CHANNEL)) >= 0L && retrieve.getChannelCount(imageIndex) > 0 && channelIndex < (long)retrieve.getChannelCount(imageIndex)) {
                Color channelColor = retrieve.getChannelColor(imageIndex, (int)channelIndex);
                boolean eightBit = this.reader.getPixelType() == 1 || this.reader.getPixelType() == 0;
                ct = this.makeColorTable(channelColor, eightBit);
                this.colorTableXML.put(retrieve, ct);
            }
            return ct;
        }

        private String getKey(IFormatReader r, int imageIndex) {
            return "r" + r.hashCode() + "img" + imageIndex;
        }

        private ColorTable makeColorTable(Color color, boolean eightBit) {
            if (color == null) {
                return null;
            }
            int red = color.getRed();
            int green = color.getGreen();
            int blue = color.getBlue();
            ColorTable8 lut = null;
            int lutLength = 256;
            int lutDivisor = 255;
            if (eightBit) {
                byte[] r = new byte[256];
                byte[] g = new byte[256];
                byte[] b = new byte[256];
                for (int i = 0; i < 256; ++i) {
                    r[i] = (byte)(i * red / 255);
                    g[i] = (byte)(i * green / 255);
                    b[i] = (byte)(i * blue / 255);
                }
                lut = new ColorTable8((byte[][])new byte[][]{r, g, b});
            } else {
                short[] r = new short[65536];
                short[] g = new short[65536];
                short[] b = new short[65536];
                for (int i = 0; i < 256; ++i) {
                    int index = i * 256;
                    r[index] = (short)(i * red / 255 << 8);
                    g[index] = (short)(i * green / 255 << 8);
                    b[index] = (short)(i * blue / 255 << 8);
                }
                lut = new ColorTable16((short[][])new short[][]{r, g, b});
            }
            return lut;
        }
    }

    private static enum DesiredChannels {
        INTERLEAVED,
        PLANAR,
        NONPLANAR;

    }
}

