/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.tools;

import net.imagej.ChannelCollection;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.plugins.tools.PixelRecorder;
import org.scijava.app.StatusService;
import org.scijava.display.event.input.MsEvent;
import org.scijava.display.event.input.MsMovedEvent;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.tool.AbstractTool;
import org.scijava.tool.Tool;

@Plugin(type=Tool.class, name="Probe")
public class PixelProbe
extends AbstractTool {
    @Parameter
    private StatusService statusService;
    @Parameter
    private ImageDisplayService imageDisplayService;
    private PixelRecorder recorder;

    public boolean isAlwaysActive() {
        return true;
    }

    public void onMouseMove(MsMovedEvent evt) {
        ImageDisplay disp = this.imageDisplayService.getActiveImageDisplay();
        if (disp == null || !this.recorder().record((MsEvent)evt)) {
            this.statusService.clearStatus();
            return;
        }
        int xAxis = disp.dimensionIndex(Axes.X);
        int yAxis = disp.dimensionIndex(Axes.Y);
        int channelIndex = disp.dimensionIndex(Axes.CHANNEL);
        long cx = this.recorder().getCX();
        long cy = this.recorder().getCY();
        ChannelCollection values = this.recorder().getValues();
        StringBuilder builder = new StringBuilder();
        builder.append("x=");
        double xValue = ((CalibratedAxis)disp.axis(xAxis)).calibratedValue((double)cx);
        if (!Double.isNaN(xValue) && xValue != (double)cx) {
            String calibratedVal = String.format("%.2f", xValue);
            builder.append(calibratedVal);
        } else {
            builder.append(cx);
        }
        if (((CalibratedAxis)disp.axis(0)).unit() != null) {
            builder.append(" ");
            builder.append(((CalibratedAxis)disp.axis(0)).unit());
        }
        builder.append(", y=");
        double yValue = ((CalibratedAxis)disp.axis(yAxis)).calibratedValue((double)cy);
        if (!Double.isNaN(yValue) && yValue != (double)cy) {
            String calibratedVal = String.format("%.2f", yValue);
            builder.append(calibratedVal);
        } else {
            builder.append(cy);
        }
        if (((CalibratedAxis)disp.axis(1)).unit() != null) {
            builder.append(" ");
            builder.append(((CalibratedAxis)disp.axis(1)).unit());
        }
        builder.append(", value=");
        if (channelIndex == -1 || this.recorder().getDataset().dimension(channelIndex) == 1L) {
            String valueStr = this.valueString(values.getChannelValue(0L));
            builder.append(valueStr);
        } else {
            int currChannel = disp.getIntPosition(channelIndex);
            String valueStr = this.valueString(values.getChannelValue((long)currChannel));
            builder.append(valueStr);
            builder.append(" from (");
            int i = 0;
            while ((long)i < values.getChannelCount()) {
                valueStr = this.valueString(values.getChannelValue((long)i));
                if (i > 0) {
                    builder.append(",");
                }
                builder.append(valueStr);
                ++i;
            }
            builder.append(")");
        }
        this.recorder().releaseDataset();
        this.statusService.showStatus(builder.toString());
    }

    private String valueString(double value) {
        if (this.recorder().getDataset().isInteger()) {
            return String.format("%d", (long)value);
        }
        return String.format("%f", value);
    }

    private PixelRecorder recorder() {
        if (this.recorder == null) {
            this.recorder = new PixelRecorder(this.getContext(), false);
        }
        return this.recorder;
    }
}

