/*
 * Decompiled with CFR 0.152.
 */
package lineage;

import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import weka.classifiers.Classifier;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class LineageClassifier {
    private static final Hashtable<Thread, Operator> table = new Hashtable();
    protected static final String[] attrs = new String[]{"APD", "CPD", "STD", "MPD", "PM", "LEV", "SIM", "PRX", "PRM", "LR", "TR", "CLASS"};

    private static Classifier getClassifier() {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(LineageClassifier.class.getResourceAsStream("random_forest_top8_w1.1.model"));
            Classifier classifier = (Classifier)ois.readObject();
            return classifier;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != ois) {
                try {
                    ois.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean classify(double[] vector) throws Exception {
        Operator op;
        Hashtable<Thread, Operator> hashtable = table;
        synchronized (hashtable) {
            Thread t = Thread.currentThread();
            op = table.get(t);
            if (null == op) {
                op = new Operator();
                table.put(t, op);
            }
        }
        DenseInstance ins = new DenseInstance(1.0, vector);
        ins.setDataset(op.data);
        return 1 == (int)Math.round(op.c.classifyInstance((Instance)ins));
    }

    public static final void flush() {
        table.clear();
    }

    static /* synthetic */ Classifier access$000() {
        return LineageClassifier.getClassifier();
    }

    private static final class Operator {
        final Classifier c = LineageClassifier.access$000();
        final Instances data;

        Operator() {
            ArrayList<Attribute> a = new ArrayList<Attribute>();
            for (int i = 0; i < attrs.length - 1; ++i) {
                a.add(new Attribute(attrs[i]));
            }
            ArrayList<String> d = new ArrayList<String>();
            d.add("false");
            d.add("true");
            a.add(new Attribute(attrs[attrs.length - 1], d));
            this.data = new Instances("Buh", a, 0);
            this.data.setClassIndex(attrs.length - 1);
        }
    }
}

