/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJMatrix;
import VolumeJ.VJRenderView;
import VolumeJ.VJRenderer;
import VolumeJ.VJUserInterface;
import VolumeJ.VJViewspaceUtil;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileSaver;
import ij.process.ImageProcessor;

public class VJRenderViewCine
extends VJRenderView {
    protected int n;
    protected double stepx;
    protected double stepy;
    protected double stepz;
    protected boolean toDisk;

    public VJRenderViewCine(VJRenderer renderer, double scale, double rotx, double roty, double rotz, String message, int n, boolean toDisk) {
        super(renderer, scale, rotx, roty, rotz, message);
        this.n = n;
        this.toDisk = toDisk;
    }

    @Override
    public synchronized void run() {
        this.computeTransformationMatrix();
        this.renderer.setTransformation(this.m, this.mLight);
        this.running = true;
        this.renderer.setMessage("1/" + this.n);
        int[] vp = VJViewspaceUtil.suggestCineViewport(this.renderer.getVolume(), this.m, this.stepx, this.stepy, this.stepz, this.n);
        this.renderer.setViewport(vp[0], vp[1]);
        long bytesNeeded = (long)this.n * (long)vp[0] * (long)vp[1];
        if (this.toDisk) {
            IJ.showMessage((String)"VolumeJ", (String)"Renderings will not be shown but only written to the ImageJ directory as separate VolumeJ_Cine1xxxx.tif image files.");
        }
        ImagePlus imp = null;
        ImageStack rs = null;
        float ms = 0.0f;
        for (int j = 0; j < this.n && this.running; ++j) {
            this.renderer.setDescription("" + j + "/" + this.n);
            this.renderer.setSequenceNumber(j);
            ImageProcessor ip = this.renderToImageProcessor();
            ms = (float)((double)ms + this.renderer.getTimePerPixel());
            if (ip instanceof ImageProcessor) {
                if (!this.toDisk) {
                    if (j == 0) {
                        rs = new ImageStack(ip.getWidth(), ip.getHeight());
                        rs.addSlice("" + j, ip);
                        imp = new ImagePlus(this.message, rs);
                        imp.show();
                    } else {
                        rs.addSlice("" + j, ip);
                        imp.setStack(null, rs);
                        imp.setSlice(j + 1);
                    }
                } else {
                    imp = new ImagePlus(this.message, ip);
                    FileSaver fs = new FileSaver(imp);
                    fs.saveAsTiff("VolumeJ_Cine_" + (10000 + j) + ".tif");
                }
            }
            this.nextView(j);
        }
        float averagems = ms / (float)this.n;
        VJUserInterface.write("" + averagems + " ms/pixel.");
        System.gc();
        IJ.showStatus((String)("memory use " + this.memoryInUse()));
    }

    protected void nextView(int k) {
        VJMatrix mm = new VJMatrix();
        mm.rotatex(this.stepx);
        this.m.mul(mm);
        mm = new VJMatrix();
        mm.rotatey(this.stepy);
        this.m.mul(mm);
        mm = new VJMatrix();
        mm.rotatez(this.stepz);
        this.m.mul(mm);
        this.renderer.setTransformation(this.m);
        this.renderer.setMessage("" + (k + 1) + "/" + this.n + " used " + this.memoryInUse() / 1000L + "Kb ");
        if (IJ.debugMode) {
            VJUserInterface.write("VJRenderViewCine " + k + " rotated: x=" + this.stepx + " y=" + this.stepy + " z=" + this.stepz);
        }
    }

    public void setRotationSteps(float stepx, float stepy, float stepz) {
        this.stepx = stepx;
        this.stepy = stepy;
        this.stepz = stepz;
    }
}

