/*
 * Decompiled with CFR 0.152.
 */
package bijnum;

import bijnum.BIJmatrix;

public class BIJknn {
    public float[][] dataset = null;
    public float[] classset = null;
    public int n = 0;
    public static int inserts = 0;
    protected float[] kDistances;
    protected int[] kIndices;

    public BIJknn(int n) {
        this.n = n;
        inserts = 0;
    }

    public BIJknn(float[][] dataset, float[] classset, int n) {
        try {
            this.add(dataset, classset);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.n = n;
        inserts = 0;
    }

    public void add(float[][] extradataset, float[] extraclassset) throws Exception {
        int i;
        if (this.dataset == null && this.classset == null) {
            this.dataset = extradataset;
            this.classset = extraclassset;
            System.out.println("kNN initialized with: " + this.dataset.length + " vectors(" + this.dataset[0].length + ")");
            return;
        }
        if (this.dataset[0].length != extradataset[0].length) {
            throw new IllegalArgumentException("Vector lengths of existing and new data do not match");
        }
        float[][] tds = this.dataset;
        float[] tcs = this.classset;
        float[][] dataset = new float[tds.length + extradataset.length][];
        float[] classset = new float[tcs.length + extraclassset.length];
        for (i = 0; i < tds.length; ++i) {
            dataset[i] = tds[i];
            classset[i] = tcs[i];
        }
        for (i = tds.length; i < tds.length + extradataset.length; ++i) {
            dataset[i] = extradataset[i - extradataset.length];
            classset[i] = extraclassset[i - extradataset.length];
        }
        System.out.println("kNN added " + extradataset.length + " vectors, total now: " + dataset.length + " vectors");
    }

    public float[] classify(float[][] unknown, int k) {
        int[] kneighbors = new int[k];
        float[] kDistances = new float[k];
        float[] classification = new float[unknown.length];
        for (int i = 0; i < classification.length; ++i) {
            this.search(kneighbors, kDistances, unknown[i], k);
            int[] votes = new int[this.n];
            for (int l = 0; l < kneighbors.length; ++l) {
                try {
                    int n = (int)this.classset[kneighbors[l]];
                    votes[n] = votes[n] + 1;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.out.print("knn: index out of bounds. votes.length=" + votes.length + " kneighbors.length= " + kneighbors.length + " inserts= " + inserts);
                    for (int j = 0; j < kneighbors.length; ++j) {
                        System.out.print(" kneighbors[i]=" + kneighbors[j]);
                        System.out.print(" truth[kneighbors[i]]=" + this.classset[kneighbors[j]]);
                    }
                    System.out.println();
                }
            }
            int c = 0;
            for (int j = 0; j < votes.length; ++j) {
                if (votes[j] <= votes[c]) continue;
                c = j;
            }
            classification[i] = c;
        }
        return classification;
    }

    public void search(int[] kIndices, float[] kDistances, float[] v, int k) {
        kDistances[0] = Float.MAX_VALUE;
        kIndices[0] = -1;
        int n = 1;
        for (int j = 0; j < this.dataset.length; ++j) {
            int i;
            float distance = BIJknn.distance(v, this.dataset[j]);
            if (!(distance < kDistances[n - 1])) continue;
            for (i = n - 2; i >= 0 && !(kDistances[i] < distance); --i) {
            }
            int l = ++i;
            while (l < n - 1) {
                kDistances[i + 1] = kDistances[i];
                kIndices[i + 1] = kIndices[i];
            }
            kDistances[i] = distance;
            kIndices[i] = j;
            ++inserts;
            if (n >= k) continue;
            ++n;
        }
    }

    public void prune(int k) {
        float[] classification = this.classify(this.dataset, k);
        boolean[] keep = new boolean[this.dataset.length];
        for (int i = 0; i < classification.length; ++i) {
            keep[i] = this.classset[i] == classification[i];
        }
        int nr = 0;
        for (int i = 0; i < this.dataset.length; ++i) {
            if (!keep[i]) continue;
            ++nr;
        }
        System.out.println("BIJknn.prune(): removing " + (this.dataset.length - nr) + " nodes");
        int[] indices = new int[nr];
        int j = 0;
        for (int i = 0; i < this.dataset.length; ++i) {
            if (!keep[i]) continue;
            indices[j++] = i;
        }
        this.dataset = BIJmatrix.subset(this.dataset, indices);
        this.classset = BIJmatrix.subset(this.classset, indices);
    }

    protected static float distance(float[] a, float[] b) {
        double d = 0.0;
        for (int i = 0; i < a.length; ++i) {
            d += Math.pow(a[i] - b[i], 2.0);
        }
        return (float)d;
    }
}

