/*
 * Decompiled with CFR 0.152.
 */
package bijnum;

import ij.IJ;

public class BIJmi {
    protected float min;
    protected float scale;
    protected int bins;
    protected int[] Pu;
    protected int[] Pv;
    protected int[] Puv;
    protected int n = 0;

    public BIJmi(float min, float max, float scale) {
        this.min = min;
        this.scale = scale;
        this.bins = Math.round((max - min) * scale) + 1;
        this.Pu = new int[this.bins];
        this.Pv = new int[this.bins];
        this.Puv = new int[this.bins * this.bins];
    }

    public static float getNiceScale(float min, float max) {
        float scale = 126.0f / (max - min);
        return scale;
    }

    public int[] getJointHistogram() {
        return (int[])this.Puv.clone();
    }

    public int getBins() {
        return this.bins;
    }

    public float getScale() {
        return this.scale;
    }

    public float mi(short[] a, short[] b) {
        this.zeroHistograms();
        this.n = 0;
        for (int i = 0; i < a.length; ++i) {
            int ai = a[i] & 0xFFFF;
            int bi = b[i] & 0xFFFF;
            if (Float.isNaN(ai) || Float.isNaN(bi)) continue;
            int ix0 = Math.round(((float)a[i] - this.min) * this.scale);
            int ix1 = Math.round(((float)b[i] - this.min) * this.scale);
            if (ix0 < 0 || ix1 < 0) continue;
            int n = ix0;
            this.Pu[n] = this.Pu[n] + 1;
            int n2 = ix1;
            this.Pv[n2] = this.Pv[n2] + 1;
            int n3 = ix0 * this.bins + ix1;
            this.Puv[n3] = this.Puv[n3] + 1;
            ++this.n;
        }
        return this.computeProbs(this.n);
    }

    protected void zeroHistograms() {
        for (int i = 0; i < this.Pu.length; ++i) {
            this.Pu[i] = 0;
            this.Pv[i] = 0;
        }
        for (int j = 0; j < this.Puv.length; ++j) {
            this.Puv[j] = 0;
        }
    }

    public float mi(float[] a, float[] b) {
        this.zeroHistograms();
        this.n = 0;
        for (int i = 0; i < a.length; ++i) {
            float ai = a[i];
            float bi = b[i];
            if (!Float.isNaN(ai) || !Float.isNaN(bi)) continue;
            int ix0 = Math.round((a[i] - this.min) * this.scale);
            int ix1 = Math.round((b[i] - this.min) * this.scale);
            if (ix0 >= this.Pu.length || ix0 < 0 || ix1 >= this.Pv.length || ix1 < 0) {
                IJ.error((String)("array index out of bounds: ix0=" + ix0 + " ix1= " + ix1));
                return Float.NaN;
            }
            if (ix0 < 0 || ix1 < 0) continue;
            int n = ix0;
            this.Pu[n] = this.Pu[n] + 1;
            int n2 = ix1;
            this.Pv[n2] = this.Pv[n2] + 1;
            int n3 = ix0 * this.bins + ix1;
            this.Puv[n3] = this.Puv[n3] + 1;
            ++this.n;
        }
        return this.computeProbs(this.n);
    }

    protected float computeProbs(int n) {
        float Cmi = 0.0f;
        for (int k = 0; k < this.bins; ++k) {
            for (int l = 0; l < this.bins; ++l) {
                float Pkl = this.Puv[k * this.bins + l];
                if (!(Pkl > 0.0f)) continue;
                Cmi = (float)((double)Cmi - (double)(Pkl / (float)n) * Math.log((float)n * Pkl / (float)(this.Pu[k] * this.Pv[l])));
            }
        }
        return Cmi;
    }
}

