/*
 * Decompiled with CFR 0.152.
 */
package volume;

import volume.Kernel1D;

public class GaussianDerivative
extends Kernel1D {
    protected double scale;
    protected int order;

    public GaussianDerivative(double scale) {
        this.scale = scale;
        double sigma = Math.sqrt(2.0 * scale);
        this.order = 1;
        if (sigma != 0.0) {
            this.kFirst(sigma);
        }
    }

    public GaussianDerivative(double scale, int order) {
        this.scale = scale;
        double sigma = Math.sqrt(2.0 * scale);
        this.order = order;
        if (sigma != 0.0) {
            switch (order) {
                case 0: {
                    this.kZero(sigma);
                    break;
                }
                case 1: {
                    this.kFirst(sigma);
                    break;
                }
                case 2: {
                    this.kSecond(sigma);
                    break;
                }
                default: {
                    System.out.println("GaussianDerivative: order too large.");
                    break;
                }
            }
        } else {
            System.out.println("GaussianDerivative: order too large.");
        }
    }

    private void kZero(double sigma) {
        int width = (int)(6.0 * sigma + 1.0);
        if (width % 2 == 0) {
            ++width;
        }
        this.halfwidth = width / 2;
        this.k = new double[this.halfwidth * 2 + 1];
        double sigmaSquare = sigma * sigma;
        for (int l = -this.halfwidth; l <= this.halfwidth; ++l) {
            this.k[l + this.halfwidth] = 1.0 / (Math.sqrt(Math.PI * 2) * sigma) * Math.exp((double)(-l * l) / (2.0 * sigmaSquare));
        }
    }

    private void kFirst(double sigma) {
        int width = (int)(6.0 * sigma + 1.0);
        if (width % 2 == 0) {
            ++width;
        }
        this.halfwidth = width / 2;
        this.k = new double[this.halfwidth * 2 + 1];
        double sigmaSquare = sigma * sigma;
        double factor = 1.0 / (Math.sqrt(Math.PI * 2) * sigma * sigma * sigma);
        for (int l = -this.halfwidth; l <= this.halfwidth; ++l) {
            this.k[l + this.halfwidth] = -factor * (double)l * Math.exp((double)(-l * l) / (2.0 * sigmaSquare));
        }
    }

    private void kSecond(double sigma) {
        int width = (int)(6.0 * sigma + 1.0);
        if (width % 2 == 0) {
            ++width;
        }
        this.halfwidth = width / 2;
        this.k = new double[this.halfwidth * 2 + 1];
        double sigmaSquare = sigma * sigma;
        double factor = 1.0 / (Math.sqrt(Math.PI * 2) * sigma * sigma * sigma);
        for (int l = -this.halfwidth; l <= this.halfwidth; ++l) {
            this.k[l + this.halfwidth] = (Math.pow(l, 2.0) / sigmaSquare - 1.0) * factor * Math.exp((double)(-l * l) / (2.0 * sigmaSquare));
        }
    }

    @Override
    public String toString() {
        return "Gaussian kernel order " + this.order + " scale=" + this.scale;
    }
}

