/*
 * Decompiled with CFR 0.152.
 */
package volume;

import ij.IJ;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import volume.VolumeFloat;

public class VolumeIO
extends VolumeFloat {
    public VolumeIO(int width, int height, int depth) {
        super(width, height, depth);
    }

    public VolumeIO(String fileName) {
        this.getDimensions(fileName);
        this.v = new float[this.depth][this.height][this.width];
        this.read(fileName);
        this.edge = 0;
    }

    public void write(String fileName) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(fileName);
        }
        catch (IOException e) {
            IJ.log((String)("" + e));
            return;
        }
        byte[] buffer = new byte[6];
        int i = 0;
        buffer[i * 2] = (byte)(this.width >>> 8 & 0xFF);
        buffer[i * 2 + 1] = (byte)(this.width & 0xFF);
        buffer[++i * 2] = (byte)(this.height >>> 8 & 0xFF);
        buffer[i * 2 + 1] = (byte)(this.height & 0xFF);
        buffer[++i * 2] = (byte)(this.depth >>> 8 & 0xFF);
        buffer[i * 2 + 1] = (byte)(this.depth & 0xFF);
        try {
            ((OutputStream)os).write(buffer, 0, buffer.length);
        }
        catch (IOException e) {
            IJ.log((String)("" + e));
            return;
        }
        int size = this.width * this.height * this.depth;
        for (int t = 0; t < this.depth; ++t) {
            byte[] buffer2 = new byte[this.width * this.height * 4];
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int tmp = Float.floatToIntBits(this.v[t][y][x]);
                    buffer2[y * this.width * 4 + x * 4 + 0] = (byte)(tmp >> 24 & 0xFF);
                    buffer2[y * this.width * 4 + x * 4 + 1] = (byte)(tmp >> 16 & 0xFF);
                    buffer2[y * this.width * 4 + x * 4 + 2] = (byte)(tmp >> 8 & 0xFF);
                    buffer2[y * this.width * 4 + x * 4 + 3] = (byte)(tmp & 0xFF);
                }
                IJ.showStatus((String)("Writing... " + 100 * (y * this.height + t * this.height * this.width) / size + "%"));
            }
            try {
                ((OutputStream)os).write(buffer2, 0, buffer2.length);
                continue;
            }
            catch (IOException e) {
                IJ.log((String)("" + e));
                return;
            }
        }
        try {
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            IJ.log((String)("" + e));
            return;
        }
    }

    private void getDimensions(String fileName) {
        FileInputStream os = null;
        try {
            os = new FileInputStream(fileName);
        }
        catch (IOException e) {
            IJ.log((String)("" + e));
            return;
        }
        byte[] buffer = new byte[6];
        try {
            ((InputStream)os).read(buffer, 0, buffer.length);
        }
        catch (IOException e) {
            IJ.log((String)("" + e));
            return;
        }
        int j = 0;
        this.width = (buffer[j * 2] & 0xFF) << 8 | buffer[j * 2 + 1] & 0xFF;
        this.height = (buffer[++j * 2] & 0xFF) << 8 | buffer[j * 2 + 1] & 0xFF;
        this.depth = (buffer[++j * 2] & 0xFF) << 8 | buffer[j * 2 + 1] & 0xFF;
        try {
            ((InputStream)os).close();
        }
        catch (IOException e) {
            IJ.log((String)("" + e));
            return;
        }
    }

    private void read(String fileName) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(fileName);
        }
        catch (IOException e) {
            IJ.log((String)("" + e));
            return;
        }
        int size = this.depth * this.height * this.width;
        byte[] buffer = new byte[6];
        try {
            ((InputStream)is).read(buffer, 0, buffer.length);
        }
        catch (IOException e) {
            IJ.log((String)("" + e));
            return;
        }
        for (int t = 0; t < this.depth; ++t) {
            byte[] buffer2 = new byte[this.width * this.height * 4];
            try {
                ((InputStream)is).read(buffer2, 0, buffer2.length);
            }
            catch (IOException e) {
                IJ.log((String)("" + e));
                return;
            }
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int tmp = (buffer2[y * this.width * 4 + x * 4 + 0] & 0xFF) << 24 | (buffer2[y * this.width * 4 + x * 4 + 1] & 0xFF) << 16 | (buffer2[y * this.width * 4 + x * 4 + 2] & 0xFF) << 8 | buffer2[y * this.width * 4 + x * 4 + 3] & 0xFF;
                    this.v[t][y][x] = Float.intBitsToFloat(tmp);
                }
                IJ.showStatus((String)("Reading... " + 100 * (y * this.height + t * this.height * this.width) / size + "%"));
            }
        }
        try {
            ((InputStream)is).close();
        }
        catch (IOException e) {
            IJ.log((String)("" + e));
            return;
        }
    }

    public boolean delete(String filename) {
        File file = new File(filename);
        boolean result = file.delete();
        if (!result) {
            IJ.error((String)("unable to delete " + filename));
        }
        return result;
    }
}

