/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.style;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import org.knowm.xchart.style.GGPlot2Theme;
import org.knowm.xchart.style.MatlabTheme;
import org.knowm.xchart.style.Theme;
import org.knowm.xchart.style.XChartTheme;
import org.knowm.xchart.style.markers.Marker;

public abstract class Styler {
    Theme theme = new XChartTheme();
    boolean hasAnnotations = false;
    private Font baseFont;
    private Color chartBackgroundColor;
    private Color chartFontColor;
    private int chartPadding;
    private Color[] seriesColors;
    private BasicStroke[] seriesLines;
    private Marker[] seriesMarkers;
    private Font chartTitleFont;
    private boolean isChartTitleVisible;
    private boolean isChartTitleBoxVisible;
    private Color chartTitleBoxBackgroundColor;
    private Color chartTitleBoxBorderColor;
    private int chartTitlePadding;
    private boolean isLegendVisible;
    private Color legendBackgroundColor;
    private Color legendBorderColor;
    private Font legendFont;
    private int legendPadding;
    private int legendSeriesLineLength;
    private LegendPosition legendPosition;
    private LegendLayout legendLayout = LegendLayout.Vertical;
    private Color plotBackgroundColor;
    private Color plotBorderColor;
    private boolean isPlotBorderVisible;
    private double plotContentSize = 0.92;
    private boolean isToolTipsEnabled;
    private boolean isToolTipsAlwaysVisible;
    private ToolTipType toolTipType;
    private Color toolTipBackgroundColor;
    private Color toolTipBorderColor;
    private Font toolTipFont;
    private Color toolTipHighlightColor;
    private Font annotationsFont;
    private boolean antiAlias = true;
    private String decimalPattern;
    private HashMap<Integer, YAxisPosition> yAxisAlignmentMap = new HashMap();

    void setAllStyles() {
        this.baseFont = this.theme.getBaseFont();
        this.chartBackgroundColor = this.theme.getChartBackgroundColor();
        this.chartFontColor = this.theme.getChartFontColor();
        this.chartPadding = this.theme.getChartPadding();
        this.seriesColors = this.theme.getSeriesColors();
        this.seriesLines = this.theme.getSeriesLines();
        this.seriesMarkers = this.theme.getSeriesMarkers();
        this.chartTitleFont = this.theme.getChartTitleFont();
        this.isChartTitleVisible = this.theme.isChartTitleVisible();
        this.isChartTitleBoxVisible = this.theme.isChartTitleBoxVisible();
        this.chartTitleBoxBackgroundColor = this.theme.getChartTitleBoxBackgroundColor();
        this.chartTitleBoxBorderColor = this.theme.getChartTitleBoxBorderColor();
        this.chartTitlePadding = this.theme.getChartTitlePadding();
        this.isLegendVisible = this.theme.isLegendVisible();
        this.legendBackgroundColor = this.theme.getLegendBackgroundColor();
        this.legendBorderColor = this.theme.getLegendBorderColor();
        this.legendFont = this.theme.getLegendFont();
        this.legendPadding = this.theme.getLegendPadding();
        this.legendSeriesLineLength = this.theme.getLegendSeriesLineLength();
        this.legendPosition = this.theme.getLegendPosition();
        this.plotBackgroundColor = this.theme.getPlotBackgroundColor();
        this.plotBorderColor = this.theme.getPlotBorderColor();
        this.isPlotBorderVisible = this.theme.isPlotBorderVisible();
        this.plotContentSize = this.theme.getPlotContentSize();
        this.isToolTipsEnabled = this.theme.isToolTipsEnabled();
        this.toolTipType = this.theme.getToolTipType();
        this.toolTipBackgroundColor = this.theme.getToolTipBackgroundColor();
        this.toolTipBorderColor = this.theme.getToolTipBorderColor();
        this.toolTipFont = this.theme.getToolTipFont();
        this.toolTipHighlightColor = this.theme.getToolTipHighlightColor();
        this.annotationsFont = this.theme.getAnnotationFont();
        this.decimalPattern = null;
    }

    public Font getBaseFont() {
        return this.baseFont;
    }

    public Styler setBaseFont(Font baseFont) {
        this.baseFont = baseFont;
        return this;
    }

    public Color getChartBackgroundColor() {
        return this.chartBackgroundColor;
    }

    public Styler setChartBackgroundColor(Color color) {
        this.chartBackgroundColor = color;
        return this;
    }

    public Color getChartFontColor() {
        return this.chartFontColor;
    }

    public Styler setChartFontColor(Color color) {
        this.chartFontColor = color;
        return this;
    }

    public int getChartPadding() {
        return this.chartPadding;
    }

    public Styler setChartPadding(int chartPadding) {
        this.chartPadding = chartPadding;
        return this;
    }

    public Color[] getSeriesColors() {
        return this.seriesColors;
    }

    public Styler setSeriesColors(Color[] seriesColors) {
        this.seriesColors = seriesColors;
        return this;
    }

    public BasicStroke[] getSeriesLines() {
        return this.seriesLines;
    }

    public Styler setSeriesLines(BasicStroke[] seriesLines) {
        this.seriesLines = seriesLines;
        return this;
    }

    public Marker[] getSeriesMarkers() {
        return this.seriesMarkers;
    }

    public Styler setSeriesMarkers(Marker[] seriesMarkers) {
        this.seriesMarkers = seriesMarkers;
        return this;
    }

    public Font getChartTitleFont() {
        return this.chartTitleFont;
    }

    public Styler setChartTitleFont(Font chartTitleFont) {
        this.chartTitleFont = chartTitleFont;
        return this;
    }

    public boolean isChartTitleVisible() {
        return this.isChartTitleVisible;
    }

    public Styler setChartTitleVisible(boolean isChartTitleVisible) {
        this.isChartTitleVisible = isChartTitleVisible;
        return this;
    }

    public boolean isChartTitleBoxVisible() {
        return this.isChartTitleBoxVisible;
    }

    public Styler setChartTitleBoxVisible(boolean isChartTitleBoxVisible) {
        this.isChartTitleBoxVisible = isChartTitleBoxVisible;
        return this;
    }

    public Color getChartTitleBoxBackgroundColor() {
        return this.chartTitleBoxBackgroundColor;
    }

    public Styler setChartTitleBoxBackgroundColor(Color chartTitleBoxBackgroundColor) {
        this.chartTitleBoxBackgroundColor = chartTitleBoxBackgroundColor;
        return this;
    }

    public Color getChartTitleBoxBorderColor() {
        return this.chartTitleBoxBorderColor;
    }

    public Styler setChartTitleBoxBorderColor(Color chartTitleBoxBorderColor) {
        this.chartTitleBoxBorderColor = chartTitleBoxBorderColor;
        return this;
    }

    public int getChartTitlePadding() {
        return this.chartTitlePadding;
    }

    public Styler setChartTitlePadding(int chartTitlePadding) {
        this.chartTitlePadding = chartTitlePadding;
        return this;
    }

    public Color getLegendBackgroundColor() {
        return this.legendBackgroundColor;
    }

    public Styler setLegendBackgroundColor(Color color) {
        this.legendBackgroundColor = color;
        return this;
    }

    public Color getLegendBorderColor() {
        return this.legendBorderColor;
    }

    public Styler setLegendBorderColor(Color legendBorderColor) {
        this.legendBorderColor = legendBorderColor;
        return this;
    }

    public Font getLegendFont() {
        return this.legendFont;
    }

    public Styler setLegendFont(Font font) {
        this.legendFont = font;
        return this;
    }

    public boolean isLegendVisible() {
        return this.isLegendVisible;
    }

    public Styler setLegendVisible(boolean isLegendVisible) {
        this.isLegendVisible = isLegendVisible;
        return this;
    }

    public int getLegendPadding() {
        return this.legendPadding;
    }

    public Styler setLegendPadding(int legendPadding) {
        this.legendPadding = legendPadding;
        return this;
    }

    public int getLegendSeriesLineLength() {
        return this.legendSeriesLineLength;
    }

    public Styler setLegendSeriesLineLength(int legendSeriesLineLength) {
        this.legendSeriesLineLength = legendSeriesLineLength < 0 ? 0 : legendSeriesLineLength;
        return this;
    }

    public LegendPosition getLegendPosition() {
        return this.legendPosition;
    }

    public Styler setLegendPosition(LegendPosition legendPosition) {
        this.legendPosition = legendPosition;
        return this;
    }

    public LegendLayout getLegendLayout() {
        return this.legendLayout;
    }

    public void setLegendLayout(LegendLayout legendLayout) {
        this.legendLayout = legendLayout;
    }

    public Color getPlotBackgroundColor() {
        return this.plotBackgroundColor;
    }

    public Styler setPlotBackgroundColor(Color plotBackgroundColor) {
        this.plotBackgroundColor = plotBackgroundColor;
        return this;
    }

    public Color getPlotBorderColor() {
        return this.plotBorderColor;
    }

    public Styler setPlotBorderColor(Color plotBorderColor) {
        this.plotBorderColor = plotBorderColor;
        return this;
    }

    public boolean isPlotBorderVisible() {
        return this.isPlotBorderVisible;
    }

    public Styler setPlotBorderVisible(boolean isPlotBorderVisible) {
        this.isPlotBorderVisible = isPlotBorderVisible;
        return this;
    }

    public double getPlotContentSize() {
        return this.plotContentSize;
    }

    public Styler setPlotContentSize(double plotContentSize) {
        if (plotContentSize < 0.0 || plotContentSize > 1.0) {
            throw new IllegalArgumentException("Plot content size must be tween 0 and 1!!!");
        }
        this.plotContentSize = plotContentSize;
        return this;
    }

    public boolean isToolTipsEnabled() {
        return this.isToolTipsEnabled;
    }

    public Styler setToolTipsEnabled(boolean toolTipsEnabled) {
        this.isToolTipsEnabled = toolTipsEnabled;
        return this;
    }

    public boolean isToolTipsAlwaysVisible() {
        return this.isToolTipsAlwaysVisible;
    }

    public Styler setToolTipsAlwaysVisible(boolean toolTipsAlwaysVisible) {
        this.isToolTipsAlwaysVisible = toolTipsAlwaysVisible;
        return this;
    }

    public ToolTipType getToolTipType() {
        return this.toolTipType;
    }

    public Styler setToolTipType(ToolTipType toolTipType) {
        this.toolTipType = toolTipType;
        return this;
    }

    public Color getToolTipBackgroundColor() {
        return this.toolTipBackgroundColor;
    }

    public Styler setToolTipBackgroundColor(Color toolTipBackgroundColor) {
        this.toolTipBackgroundColor = toolTipBackgroundColor;
        return this;
    }

    public Color getToolTipBorderColor() {
        return this.toolTipBorderColor;
    }

    public Styler setToolTipBorderColor(Color toolTipBorderColor) {
        this.toolTipBorderColor = toolTipBorderColor;
        return this;
    }

    public Font getToolTipFont() {
        return this.toolTipFont;
    }

    public Styler setToolTipFont(Font toolTipFont) {
        this.toolTipFont = toolTipFont;
        return this;
    }

    public Color getToolTipHighlightColor() {
        return this.toolTipHighlightColor;
    }

    public Styler setToolTipHighlightColor(Color toolTipHighlightColor) {
        this.toolTipHighlightColor = toolTipHighlightColor;
        return this;
    }

    public Boolean hasAnnotations() {
        return this.hasAnnotations;
    }

    public Styler setHasAnnotations(boolean hasAnnotations) {
        this.hasAnnotations = hasAnnotations;
        return this;
    }

    public Font getAnnotationsFont() {
        return this.annotationsFont;
    }

    public Styler setAnnotationsFont(Font annotationsFont) {
        this.annotationsFont = annotationsFont;
        return this;
    }

    public String getDecimalPattern() {
        return this.decimalPattern;
    }

    public Styler setDecimalPattern(String decimalPattern) {
        this.decimalPattern = decimalPattern;
        return this;
    }

    public YAxisPosition getYAxisGroupPosistion(int yAxisGroup) {
        return this.yAxisAlignmentMap.get(yAxisGroup);
    }

    public void setYAxisGroupPosition(int yAxisGroup, YAxisPosition yAxisPosition) {
        this.yAxisAlignmentMap.put(yAxisGroup, yAxisPosition);
    }

    public Theme getTheme() {
        return this.theme;
    }

    public boolean getAntiAlias() {
        return this.antiAlias;
    }

    public void setAntiAlias(boolean newVal) {
        this.antiAlias = newVal;
    }

    public static enum YAxisPosition {
        Left,
        Right;

    }

    public static enum ToolTipType {
        xLabels,
        yLabels,
        xAndYLabels;

    }

    public static enum TextAlignment {
        Left,
        Centre,
        Right;

    }

    public static enum ChartTheme {
        XChart,
        GGPlot2,
        Matlab;


        public Theme newInstance(ChartTheme chartTheme) {
            switch (chartTheme) {
                case GGPlot2: {
                    return new GGPlot2Theme();
                }
                case Matlab: {
                    return new MatlabTheme();
                }
            }
            return new XChartTheme();
        }
    }

    public static enum LegendLayout {
        Vertical,
        Horizontal;

    }

    public static enum LegendPosition {
        OutsideE,
        InsideNW,
        InsideNE,
        InsideSE,
        InsideSW,
        InsideN,
        InsideS,
        OutsideS;

    }
}

