/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.timelapsedisplay;

import fiji.plugin.timelapsedisplay.FileOpenMenuEntry;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.chart.ui.TextAnchor;

public class MouseListenerTimelapse
implements ChartMouseListener {
    final ChartPanel panel;
    ValueMarker valueMarker;
    boolean markerShown = false;
    int referenceTimePoint;
    final boolean enableReferenceTimePoint;
    final ArrayList<FileOpenMenuEntry> updateList = new ArrayList();

    MouseListenerTimelapse(ChartPanel panel) {
        this(panel, -1, false);
    }

    MouseListenerTimelapse(ChartPanel panel, boolean enableReferenceTimePoint) {
        this(panel, -1, enableReferenceTimePoint);
    }

    MouseListenerTimelapse(ChartPanel panel, int referenceTimePoint, boolean enableReferenceTimePoint) {
        this.panel = panel;
        this.referenceTimePoint = referenceTimePoint;
        this.enableReferenceTimePoint = enableReferenceTimePoint;
        if (enableReferenceTimePoint || referenceTimePoint != -1) {
            this.valueMarker = this.makeMarker(referenceTimePoint);
            if (referenceTimePoint >= 0) {
                ((XYPlot)panel.getChart().getPlot()).addDomainMarker((Marker)this.valueMarker);
                this.markerShown = true;
            }
        }
    }

    public int getReferenceTimePoint() {
        return this.referenceTimePoint;
    }

    protected ValueMarker makeMarker(int timePoint) {
        ValueMarker valueMarker = new ValueMarker((double)timePoint);
        valueMarker.setStroke((Stroke)new BasicStroke(1.5f));
        valueMarker.setPaint((Paint)new Color(0.0f, 0.3647059f, 0.03529412f));
        valueMarker.setLabel(" Reference\n Timepoint " + timePoint);
        valueMarker.setLabelAnchor(RectangleAnchor.BOTTOM);
        valueMarker.setLabelTextAnchor(TextAnchor.BOTTOM_LEFT);
        return valueMarker;
    }

    public void chartMouseClicked(ChartMouseEvent e) {
        if (e.getTrigger().getButton() == 1 && this.enableReferenceTimePoint) {
            this.referenceTimePoint = MouseListenerTimelapse.getChartXLocation(e.getTrigger().getPoint(), this.panel);
            this.valueMarker.setValue((double)this.referenceTimePoint);
            this.valueMarker.setLabel(" Reference\n Timepoint " + this.referenceTimePoint);
            if (!this.markerShown) {
                ((XYPlot)e.getChart().getPlot()).addDomainMarker((Marker)this.valueMarker);
                this.markerShown = true;
            }
        }
    }

    public static int getChartXLocation(Point point, ChartPanel panel) {
        Point2D p = panel.translateScreenToJava2D(point);
        Rectangle2D plotArea = panel.getScreenDataArea();
        XYPlot plot = (XYPlot)panel.getChart().getPlot();
        double chartX = plot.getDomainAxis().java2DToValue(p.getX(), plotArea, plot.getDomainAxisEdge());
        return (int)Math.round(chartX);
    }

    public void chartMouseMoved(ChartMouseEvent e) {
    }
}

