/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.pointdescriptor.matcher;

import java.util.ArrayList;
import mpicbg.models.PointMatch;
import mpicbg.pointdescriptor.AbstractPointDescriptor;
import mpicbg.pointdescriptor.matcher.Matcher;

public class SubsetMatcher
implements Matcher {
    final int subsetSize;
    final int numNeighbors;
    final int numCombinations;
    final int numMatchings;
    final int[][] neighbors;

    public SubsetMatcher(int subsetSize, int numNeighbors) {
        this.subsetSize = subsetSize;
        this.numNeighbors = numNeighbors;
        this.neighbors = SubsetMatcher.computePD(numNeighbors, subsetSize, 0);
        this.numCombinations = this.neighbors.length;
        this.numMatchings = this.numCombinations * this.numCombinations;
    }

    public int[][] getNeighbors() {
        return this.neighbors;
    }

    public int getSubsetSize() {
        return this.subsetSize;
    }

    public int getNumNeighbors() {
        return this.numNeighbors;
    }

    public int getNumCombinations() {
        return this.numCombinations;
    }

    public int getNumMatchings() {
        return this.numMatchings;
    }

    @Override
    public int getRequiredNumNeighbors() {
        return this.numNeighbors;
    }

    @Override
    public ArrayList<ArrayList<PointMatch>> createCandidates(AbstractPointDescriptor<?, ?> pd1, AbstractPointDescriptor<?, ?> pd2) {
        ArrayList<ArrayList<PointMatch>> matchesList = new ArrayList<ArrayList<PointMatch>>();
        for (int a = 0; a < this.numCombinations; ++a) {
            for (int b = 0; b < this.numCombinations; ++b) {
                ArrayList<PointMatch> matches = new ArrayList<PointMatch>(this.subsetSize);
                for (int i = 0; i < this.subsetSize; ++i) {
                    PointMatch pointMatch = new PointMatch(pd1.getDescriptorPoint(this.neighbors[a][i]), pd2.getDescriptorPoint(this.neighbors[b][i]));
                    matches.add(pointMatch);
                }
                matchesList.add(matches);
            }
        }
        return matchesList;
    }

    @Override
    public double getNormalizationFactor(ArrayList<PointMatch> matches, Object fitResult) {
        return 1.0;
    }

    private static int factorial(int n) {
        int fact = 1;
        for (int i = n; i > 1; --i) {
            fact *= i;
        }
        return fact;
    }

    protected static int[][] computePD(int n, int k, int offset) {
        int numCombinations = SubsetMatcher.factorial(n) / (SubsetMatcher.factorial(k) * SubsetMatcher.factorial(n - k));
        int[][] combinations = new int[numCombinations][k];
        for (int i = 0; i < k; ++i) {
            combinations[0][i] = i + offset;
        }
        int finalval = n - k + offset;
        for (int ci = 1; ci < numCombinations; ++ci) {
            int j;
            int[] c = combinations[ci - 1];
            int[] nc = combinations[ci];
            int i = k - 1;
            while (c[i] == finalval + i) {
                --i;
            }
            for (j = 0; j < i; ++j) {
                nc[j] = c[j];
            }
            j = c[i];
            while (i < k) {
                nc[i] = ++j;
                ++i;
            }
        }
        return combinations;
    }

    protected static int[][] computePDRecursive(int tolerance, int n, int offset) {
        if (tolerance == 0) {
            int[][] neighbors = new int[1][n];
            for (int i = 0; i < n; ++i) {
                neighbors[0][i] = i + offset;
            }
            return neighbors;
        }
        ArrayList<int[][]> allneighbors = new ArrayList<int[][]>();
        int size = 1;
        for (int k = tolerance + n - 1; k > tolerance - 1; --k) {
            int[][] neighbors = SubsetMatcher.computePDRecursive(tolerance - 1, k - tolerance + 1, offset);
            allneighbors.add(neighbors);
            size += neighbors.length;
        }
        int[][] neighbors = new int[size][n];
        int pos = 0;
        for (int[][] subn : allneighbors) {
            for (int i = 0; i < subn.length; ++i) {
                int j;
                for (j = 0; j < subn[i].length; ++j) {
                    neighbors[i + pos][j] = subn[i][j];
                }
                for (j = subn[i].length; j < n; ++j) {
                    neighbors[i + pos][j] = j + offset + tolerance;
                }
            }
            pos += subn.length;
        }
        for (int j = 0; j < n; ++j) {
            neighbors[pos][j] = j + offset + tolerance;
        }
        return neighbors;
    }
}

