/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.fusion;

import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.interpolation.Interpolator;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.util.Util;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.spim.fusion.CombinedPixelWeightener;
import mpicbg.spim.fusion.CombinedPixelWeightenerFactory;
import mpicbg.spim.fusion.IsolatedPixelWeightener;
import mpicbg.spim.fusion.IsolatedPixelWeightenerFactory;
import mpicbg.spim.fusion.SPIMImageFusion;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.mpicbg.Java3d;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.ViewStructure;
import spim.vecmath.Point3d;

public class MappingFusionSequential
extends SPIMImageFusion {
    final Image<FloatType> fusedImage;
    final Image<FloatType> weights;
    final int numParalellStacks;

    public MappingFusionSequential(ViewStructure viewStructure, ViewStructure referenceViewStructure, ArrayList<IsolatedPixelWeightenerFactory<?>> isolatedWeightenerFactories, ArrayList<CombinedPixelWeightenerFactory<?>> combinedWeightenerFactories, int numParalellStacks) {
        super(viewStructure, referenceViewStructure, isolatedWeightenerFactories, combinedWeightenerFactories);
        if (viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Reserving memory for fused image.");
        }
        ImageFactory fusedImageFactory = new ImageFactory((Type)new FloatType(), this.conf.processImageFactory);
        this.fusedImage = fusedImageFactory.createImage(new int[]{this.imgW, this.imgH, this.imgD}, "Fused image");
        this.weights = fusedImageFactory.createImage(new int[]{this.imgW, this.imgH, this.imgD}, "Weights image");
        this.numParalellStacks = numParalellStacks;
        if (this.fusedImage == null) {
            if (viewStructure.getDebugLevel() <= 2) {
                IOFunctions.println("MappingFusionSequentialImages.constructor: Cannot create output image: " + this.conf.processImageFactory.getErrorMessage());
            }
            if (this.weights != null) {
                this.weights.close();
            }
            return;
        }
        if (this.weights == null) {
            if (viewStructure.getDebugLevel() <= 2) {
                IOFunctions.println("MappingFusionSequentialImages.constructor: Cannot create weights image: " + this.conf.processImageFactory.getErrorMessage());
            }
            this.fusedImage.close();
            return;
        }
    }

    @Override
    public void fuseSPIMImages(int channelIndex) {
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Unloading source images.");
        }
        for (ViewDataBeads view : this.viewStructure.getViews()) {
            view.closeImage();
        }
        if (channelIndex > 0) {
            Cursor iteratorFused = this.fusedImage.createCursor();
            Cursor iteratorWeights = this.weights.createCursor();
            while (iteratorFused.hasNext()) {
                iteratorFused.fwd();
                iteratorWeights.fwd();
                ((FloatType)iteratorFused.getType()).set(0.0f);
                ((FloatType)iteratorWeights.getType()).set(0.0f);
            }
            iteratorFused.close();
            iteratorWeights.close();
        }
        final ArrayList<ViewDataBeads> views = new ArrayList<ViewDataBeads>();
        for (ViewDataBeads view : this.viewStructure.getViews()) {
            if (view.getChannelIndex() != channelIndex) continue;
            views.add(view);
        }
        final int numViews = views.size();
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Computing output image (Channel " + channelIndex + ").");
        }
        final boolean[] useView = new boolean[numViews];
        final AbstractAffineModel3D[] models = new AbstractAffineModel3D[numViews];
        for (int i = 0; i < numViews; ++i) {
            boolean bl = useView[i] = Math.max(((ViewDataBeads)views.get(i)).getViewErrorStatistics().getNumConnectedViews(), ((ViewDataBeads)views.get(i)).getTile().getConnectedTiles().size()) > 0 || ((ViewDataBeads)views.get(i)).getViewStructure().getNumViews() == 1;
            if (!((ViewDataBeads)views.get(i)).getUseForRegistration()) {
                int angle = ((ViewDataBeads)views.get(i)).getAcqusitionAngle();
                int timepoint = ((ViewDataBeads)views.get(i)).getViewStructure().getTimePoint();
                for (ViewDataBeads view2 : this.viewStructure.getViews()) {
                    if (view2.getAcqusitionAngle() != angle || timepoint != view2.getViewStructure().getTimePoint() || !view2.getUseForRegistration()) continue;
                    useView[i] = true;
                }
            }
            models[i] = (AbstractAffineModel3D)((ViewDataBeads)views.get(i)).getTile().getModel();
        }
        final int[][] imageSizes = new int[numViews][];
        for (int i = 0; i < numViews; ++i) {
            imageSizes[i] = ((ViewDataBeads)views.get(i)).getImageSize();
        }
        for (int v = 0; v < numViews; v += this.numParalellStacks) {
            int endView;
            int startView;
            final int viewIndexStart = v;
            final int viewIndexEnd = Math.min(v + this.numParalellStacks, numViews);
            final ArrayList processViews = new ArrayList();
            for (int viewIndex = viewIndexStart; viewIndex < viewIndexEnd; ++viewIndex) {
                processViews.add(views.get(viewIndex));
            }
            if (this.combinedWeightenerFactories.size() > 0) {
                startView = 0;
                endView = numViews;
            } else {
                startView = viewIndexStart;
                endView = viewIndexEnd;
            }
            for (ViewDataBeads view : processViews) {
                if (this.viewStructure.getDebugLevel() <= 1) {
                    IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Loading view: " + view.getName());
                }
                view.getImage(this.conf.inputImageFactory, false);
            }
            if (this.viewStructure.getDebugLevel() <= 1 && this.isolatedWeightenerFactories.size() > 0) {
                String methods = "(" + ((IsolatedPixelWeightenerFactory)this.isolatedWeightenerFactories.get(0)).getDescriptiveName();
                for (int i = 1; i < this.isolatedWeightenerFactories.size(); ++i) {
                    methods = methods + ", " + ((IsolatedPixelWeightenerFactory)this.isolatedWeightenerFactories.get(i)).getDescriptiveName();
                }
                methods = methods + ")";
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Init isolated weighteners for views " + viewIndexStart + " to " + (viewIndexEnd - 1) + ": " + methods);
            }
            final AtomicInteger ai = new AtomicInteger(0);
            Thread[] threads = SimpleMultiThreading.newThreads((int)this.conf.numberOfThreads);
            final int numThreads = threads.length;
            IsolatedPixelWeightener[][] isoWinit = new IsolatedPixelWeightener[this.isolatedWeightenerFactories.size()][numViews];
            for (int j = 0; j < isoWinit.length; ++j) {
                final int i = j;
                final IsolatedPixelWeightener[][] isoW = isoWinit;
                for (int ithread = 0; ithread < threads.length; ++ithread) {
                    threads[ithread] = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            int myNumber = ai.getAndIncrement();
                            for (int view = viewIndexStart; view < viewIndexEnd; ++view) {
                                if (view % numThreads != myNumber) continue;
                                IOFunctions.println("Computing " + ((IsolatedPixelWeightenerFactory)MappingFusionSequential.this.isolatedWeightenerFactories.get(i)).getDescriptiveName() + " for " + views.get(view));
                                isoW[i][view] = ((IsolatedPixelWeightenerFactory)MappingFusionSequential.this.isolatedWeightenerFactories.get(i)).createInstance((ViewDataBeads)views.get(view));
                            }
                        }
                    });
                }
                SimpleMultiThreading.startAndJoin((Thread[])threads);
            }
            try {
                boolean successful = true;
                for (IsolatedPixelWeightener[] iso : isoWinit) {
                    for (int view = viewIndexStart; view < viewIndexEnd; ++view) {
                        if (iso[view] != null) continue;
                        successful = false;
                    }
                }
                if (!successful) {
                    IOFunctions.println("WARNING: Not enough memory for running the content-based fusion, running without it");
                    isoWinit = new IsolatedPixelWeightener[0][0];
                }
            }
            catch (Exception e) {
                IOFunctions.println("WARNING: Not enough memory for running the content-based fusion, running without it");
                isoWinit = new IsolatedPixelWeightener[0][0];
            }
            for (int view = viewIndexStart; view < viewIndexEnd; ++view) {
                ((ViewDataBeads)views.get(view)).getImage(false);
            }
            final IsolatedPixelWeightener[][] isoW = isoWinit;
            ai.set(0);
            threads = SimpleMultiThreading.newThreads((int)numThreads);
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        block25: {
                            try {
                                int i;
                                int view;
                                int i2;
                                int myNumber = ai.getAndIncrement();
                                double[] tmp = new double[3];
                                if (MappingFusionSequential.this.viewStructure.getDebugLevel() <= 1 && MappingFusionSequential.this.combinedWeightenerFactories.size() > 0 && myNumber == 0) {
                                    String methods = "(" + ((CombinedPixelWeightenerFactory)MappingFusionSequential.this.combinedWeightenerFactories.get(0)).getDescriptiveName();
                                    for (i2 = 1; i2 < MappingFusionSequential.this.combinedWeightenerFactories.size(); ++i2) {
                                        methods = methods + ", " + ((CombinedPixelWeightenerFactory)MappingFusionSequential.this.combinedWeightenerFactories.get(i2)).getDescriptiveName();
                                    }
                                    methods = methods + ")";
                                    IOFunctions.println("Initialize combined weighteners for for views " + viewIndexStart + " to " + (viewIndexEnd - 1) + " " + methods + " (" + numThreads + " threads)");
                                }
                                CombinedPixelWeightener[] combW = new CombinedPixelWeightener[MappingFusionSequential.this.combinedWeightenerFactories.size()];
                                for (i2 = 0; i2 < combW.length; ++i2) {
                                    combW[i2] = ((CombinedPixelWeightenerFactory)MappingFusionSequential.this.combinedWeightenerFactories.get(i2)).createInstance(views);
                                }
                                LocalizableByDimCursor[][] isoIterators = new LocalizableByDimCursor[isoW.length][numViews];
                                for (int i3 = 0; i3 < isoW.length; ++i3) {
                                    for (view = viewIndexStart; view < viewIndexEnd; ++view) {
                                        isoIterators[i3][view] = isoW[i3][view].getResultIterator();
                                    }
                                }
                                Interpolator[] interpolators = new Interpolator[numViews];
                                for (view = viewIndexStart; view < viewIndexEnd; ++view) {
                                    interpolators[view] = ((ViewDataBeads)views.get(view)).getImage(false).createInterpolator(MappingFusionSequential.this.conf.interpolatorFactorOutput);
                                }
                                Point3d[] tmpCoordinates = new Point3d[numViews];
                                int[][] loc = new int[numViews][3];
                                double[][] locf = new double[numViews][3];
                                boolean[] use = new boolean[numViews];
                                for (int i4 = 0; i4 < tmpCoordinates.length; ++i4) {
                                    tmpCoordinates[i4] = new Point3d();
                                }
                                if (MappingFusionSequential.this.viewStructure.getDebugLevel() <= 1 && myNumber == 0) {
                                    for (ViewDataBeads view2 : processViews) {
                                        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Starting fusion for: " + view2.getName());
                                    }
                                }
                                LocalizableCursor iteratorFused = MappingFusionSequential.this.fusedImage.createLocalizableCursor();
                                LocalizableCursor iteratorWeights = MappingFusionSequential.this.weights.createLocalizableCursor();
                                while (iteratorFused.hasNext()) {
                                    iteratorFused.next();
                                    iteratorWeights.next();
                                    if (iteratorFused.getPosition(2) % numThreads != myNumber) continue;
                                    int x = iteratorFused.getPosition(0) + MappingFusionSequential.this.cropOffsetX;
                                    int y = iteratorFused.getPosition(1) + MappingFusionSequential.this.cropOffsetY;
                                    int z = iteratorFused.getPosition(2) + MappingFusionSequential.this.cropOffsetZ;
                                    int num = 0;
                                    for (int i5 = startView; i5 < endView; ++i5) {
                                        if (useView[i5]) {
                                            tmpCoordinates[i5].x = (float)(x * MappingFusionSequential.this.scale) + MappingFusionSequential.this.min.x;
                                            tmpCoordinates[i5].y = (float)(y * MappingFusionSequential.this.scale) + MappingFusionSequential.this.min.y;
                                            tmpCoordinates[i5].z = (float)(z * MappingFusionSequential.this.scale) + MappingFusionSequential.this.min.z;
                                            Java3d.applyInverseInPlace(models[i5], tmpCoordinates[i5], tmp);
                                            loc[i5][0] = (int)Util.round((double)tmpCoordinates[i5].x);
                                            loc[i5][1] = (int)Util.round((double)tmpCoordinates[i5].y);
                                            loc[i5][2] = (int)Util.round((double)tmpCoordinates[i5].z);
                                            locf[i5][0] = tmpCoordinates[i5].x;
                                            locf[i5][1] = tmpCoordinates[i5].y;
                                            locf[i5][2] = tmpCoordinates[i5].z;
                                            if (loc[i5][0] >= 0 && loc[i5][1] >= 0 && loc[i5][2] >= 0 && loc[i5][0] < imageSizes[i5][0] && loc[i5][1] < imageSizes[i5][1] && loc[i5][2] < imageSizes[i5][2]) {
                                                use[i5] = true;
                                                if (i5 < viewIndexStart || i5 >= viewIndexEnd) continue;
                                                ++num;
                                                continue;
                                            }
                                            use[i5] = false;
                                            continue;
                                        }
                                        use[i5] = false;
                                    }
                                    if (num <= 0) continue;
                                    if (combW.length > 0) {
                                        for (CombinedPixelWeightener w : combW) {
                                            w.updateWeights(locf, use);
                                        }
                                    }
                                    for (int view3 = viewIndexStart; view3 < viewIndexEnd; ++view3) {
                                        if (!use[view3]) continue;
                                        float weight = 1.0f;
                                        if (combW.length > 0) {
                                            for (CombinedPixelWeightener w : combW) {
                                                weight = (float)((double)weight * w.getWeight(view3));
                                            }
                                        }
                                        for (int i6 = 0; i6 < isoW.length; ++i6) {
                                            isoIterators[i6][view3].setPosition(loc[view3]);
                                            weight *= ((FloatType)isoIterators[i6][view3].getType()).get();
                                        }
                                        tmp[0] = tmpCoordinates[view3].x;
                                        tmp[1] = tmpCoordinates[view3].y;
                                        tmp[2] = tmpCoordinates[view3].z;
                                        interpolators[view3].moveTo(tmp);
                                        float intensity = ((FloatType)interpolators[view3].getType()).get();
                                        float value = weight * intensity;
                                        ((FloatType)iteratorWeights.getType()).set(((FloatType)iteratorWeights.getType()).get() + weight);
                                        ((FloatType)iteratorFused.getType()).set(((FloatType)iteratorFused.getType()).get() + value);
                                    }
                                }
                                iteratorFused.close();
                                iteratorWeights.close();
                                for (int view4 = viewIndexStart; view4 < viewIndexEnd; ++view4) {
                                    interpolators[view4].close();
                                }
                                for (i = 0; i < isoW.length; ++i) {
                                    for (int view5 = viewIndexStart; view5 < viewIndexEnd; ++view5) {
                                        isoIterators[i][view5].close();
                                    }
                                }
                                for (i = 0; i < combW.length; ++i) {
                                    combW[i].close();
                                }
                            }
                            catch (NoninvertibleModelException e) {
                                if (MappingFusionSequential.this.viewStructure.getDebugLevel() > 2) break block25;
                                IOFunctions.println("MappingFusionParalell(): Model not invertible for " + MappingFusionSequential.this.viewStructure);
                            }
                        }
                    }
                });
            }
            SimpleMultiThreading.startAndJoin((Thread[])threads);
            for (int view = viewIndexStart; view < viewIndexEnd; ++view) {
                ((ViewDataBeads)views.get(view)).closeImage();
            }
            try {
                for (int i = 0; i < isoW.length; ++i) {
                    for (int view = viewIndexStart; view < viewIndexEnd; ++view) {
                        isoW[i][view].close();
                    }
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("Computing final output image (Channel " + channelIndex + ").");
        }
        Cursor iteratorFused = this.fusedImage.createCursor();
        Cursor iteratorWeights = this.weights.createCursor();
        while (iteratorFused.hasNext()) {
            iteratorFused.fwd();
            iteratorWeights.fwd();
            float weight = ((FloatType)iteratorWeights.getType()).get();
            if (!(weight > 0.0f)) continue;
            ((FloatType)iteratorFused.getType()).set(((FloatType)iteratorFused.getType()).get() / weight);
        }
        iteratorFused.close();
        iteratorWeights.close();
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Done computing output image (Channel " + channelIndex + ").");
        }
    }

    @Override
    public Image<FloatType> getFusedImage() {
        return this.fusedImage;
    }

    @Override
    public void closeImages() {
        this.fusedImage.close();
        this.weights.close();
    }
}

