/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.io;

import fiji.plugin.Multi_View_Deconvolution;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.linear.LinearInterpolatorFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.util.Util;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.AffineModel3D;
import mpicbg.models.RigidModel3D;
import mpicbg.models.TranslationModel3D;
import mpicbg.spim.io.ConfigurationParserException;
import mpicbg.spim.io.IOFunctions;
import spimopener.SPIMExperiment;

public class SPIMConfiguration {
    public String timepointPattern;
    public int[] timepoints;
    public String anglePattern;
    public int[] angles;
    public int[] illuminations;
    public String inputFilePattern;
    public int[] channels;
    public int[] channelsRegister;
    public int[] channelsFuse;
    public int[][] channelsMirror;
    public String channelPattern;
    public String channelsToRegister;
    public String channelsToFuse;
    public String mirrorChannels = "";
    public int[] registrationAssignmentForFusion = null;
    public File[][][][] file;
    public String inputdirectory;
    public String outputdirectory;
    public String registrationFiledirectory;
    public String debugLevel;
    public int debugLevelInt = 1;
    public boolean showImageJWindow = false;
    public boolean collectRegistrationStatistics = false;
    public String transformationModel = "Affine";
    public boolean timeLapseRegistration = false;
    public boolean fuseReferenceTimepoint = true;
    public int referenceTimePoint = 1;
    public SPIMExperiment spimExperiment = null;
    public ContainerFactory inputImageFactory = new ArrayContainerFactory();
    public ContainerFactory processImageFactory = new ArrayContainerFactory();
    public String tempDir = null;
    public OutOfBoundsStrategyFactory<FloatType> strategyFactoryOutput = new OutOfBoundsStrategyValueFactory();
    public InterpolatorFactory<FloatType> interpolatorFactorOutput = new LinearInterpolatorFactory(this.strategyFactoryOutput);
    public OutOfBoundsStrategyFactory<FloatType> strategyFactoryGauss = new OutOfBoundsStrategyMirrorFactory();
    public int writeOutputImage = 1;
    public boolean showOutputImage = false;
    public boolean useEntropy = false;
    public boolean useIntegralContentBased = false;
    public boolean useGaussContentBased = false;
    public boolean useLinearBlening = true;
    public boolean paralellFusion = true;
    public boolean sequentialFusion = false;
    public int numParalellViews = 1;
    public boolean multipleImageFusion = false;
    public boolean isDeconvolution = false;
    public boolean deconvolutionLoadSequentially = false;
    public boolean deconvolutionJustShowOverlap = false;
    public int deconvolutionDisplayPSF = 1;
    public boolean extractPSF = true;
    public boolean transformPSFs = true;
    public ArrayList<String> psfFiles = null;
    public Multi_View_Deconvolution instance = null;
    public boolean fuseOnly = false;
    public boolean registerOnly = false;
    public boolean readSegmentation = false;
    public boolean writeSegmentation = true;
    public boolean readRegistration = false;
    public boolean writeRegistration = true;
    public boolean overrideImageZStretching = false;
    public double zStretching = 1.0;
    public int background = 0;
    public int doFit = 0;
    public boolean doGaussKeepImagesOpen = false;
    public SegmentationTypes segmentation = SegmentationTypes.DOG;
    public float threshold = 0.9f;
    public float fixedThreshold = 0.02f;
    public boolean useFixedThreshold = false;
    public double circularityFactor = 0.5;
    public int minBlackBorder = 1;
    public int minSize = 10;
    public int maxSize = 3375;
    public boolean useCenterOfMass = false;
    public float[] minPeakValue = new float[]{0.01f};
    public float[] minInitialPeakValue = null;
    public float identityRadius = 3.0f;
    public float maximaTolerance = 0.01f;
    public float imageSigma = 0.5f;
    public float[] initialSigma = new float[]{1.8f};
    public int stepsPerOctave = 4;
    public int steps = 3;
    public boolean detectSmallestStructures = false;
    public int scaleSpaceNumberOfThreads = 0;
    public int[] integralImgRadius1 = new int[]{2};
    public int[] integralImgRadius2 = new int[]{3};
    public float[] integralImgThreshold = new float[]{0.02f};
    public double differenceThreshold = 50.0;
    public double ratioOfDistance = 10.0;
    public int neighbors = 3;
    public boolean useAssociatedBeads = false;
    public boolean useRANSAC = true;
    public float max_epsilon = 5.0f;
    public float min_inlier_ratio = 0.1f;
    public int numIterations = 1000;
    public int scale = 1;
    public int cropOffsetX = 0;
    public int cropOffsetY = 0;
    public int cropOffsetZ = 0;
    public int cropSizeX = 0;
    public int cropSizeY = 0;
    public int cropSizeZ = 0;
    public int numberOfThreads = 0;
    public float sigma = 0.25f;
    public int cutOffRadiusGauss = 2;
    public int histogramBins = 256;
    public int windowSizeX = 19;
    public int windowSizeY = 19;
    public float alpha = 1.5f;
    public float fusionSigma1 = 20.0f;
    public float fusionSigma2 = 40.0f;

    public AbstractAffineModel3D getModel() {
        if (this.transformationModel.equals("Translation")) {
            return new TranslationModel3D();
        }
        if (this.transformationModel.equals("Rigid")) {
            return new RigidModel3D();
        }
        return new AffineModel3D();
    }

    public int getIndexForTimePoint(int timepoint) {
        for (int i = 0; i < this.timepoints.length; ++i) {
            if (this.timepoints[i] != timepoint) continue;
            return i;
        }
        return -1;
    }

    public static ArrayList<Integer> parseIntegerString(String integers) throws ConfigurationParserException {
        if (integers.trim().length() == 0) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> tmp = null;
        try {
            String[] entries;
            tmp = new ArrayList<Integer>();
            for (String s : entries = integers.split(",")) {
                if ((s = s.trim()).contains("-")) {
                    int i;
                    int step;
                    int start = 0;
                    int end = 0;
                    start = Integer.parseInt(s.substring(0, s.indexOf("-")));
                    if (s.indexOf(":") < 0) {
                        end = Integer.parseInt(s.substring(s.indexOf("-") + 1, s.length()));
                        step = 1;
                    } else {
                        end = Integer.parseInt(s.substring(s.indexOf("-") + 1, s.indexOf(":")));
                        step = Integer.parseInt(s.substring(s.indexOf(":") + 1, s.length()));
                    }
                    if (end > start) {
                        for (i = start; i <= end; i += step) {
                            tmp.add(i);
                        }
                        continue;
                    }
                    for (i = start; i >= end; i -= step) {
                        tmp.add(i);
                    }
                    continue;
                }
                tmp.add(Integer.parseInt(s));
            }
        }
        catch (Exception e) {
            throw new ConfigurationParserException("Cannot parse pattern '" + integers + "'");
        }
        return tmp;
    }

    public void parseAngles() throws ConfigurationParserException {
        ArrayList<Integer> tmp = SPIMConfiguration.parseIntegerString(this.anglePattern);
        this.angles = new int[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            this.angles[i] = tmp.get(i);
        }
        if (this.angles.length == 0) {
            String replaceTL = SPIMConfiguration.getReplaceStringTimePoints(this.inputFilePattern);
            int numDigitsTL = replaceTL.length() - 2;
            String replaceAngle = SPIMConfiguration.getReplaceStringAngle(this.inputFilePattern);
            String filePattern = this.inputFilePattern;
            filePattern = filePattern.replace(replaceTL, SPIMConfiguration.getLeadingZeros(numDigitsTL, this.timepoints[0]));
            filePattern = filePattern.replace(replaceAngle, "*");
            String filePatternStart = filePattern.substring(0, filePattern.indexOf(42));
            String filePatternEnd = filePattern.substring(filePattern.indexOf(42) + 1, filePattern.length());
            String[] listing = this.getDirListing(this.inputdirectory, filePatternStart, filePatternEnd);
            this.angles = new int[listing.length];
            for (int i = 0; i < listing.length; ++i) {
                String entry = listing[i];
                entry = entry.substring(filePatternStart.length(), entry.length() - filePatternEnd.length());
                this.angles[i] = Integer.parseInt(entry);
            }
        }
    }

    public void parseChannels() throws ConfigurationParserException {
        boolean contains;
        int i;
        Object tmp;
        if (this.channelPattern != null && this.channelPattern.trim().length() > 0) {
            tmp = SPIMConfiguration.parseIntegerString(this.channelPattern);
            this.channels = new int[((ArrayList)tmp).size()];
            for (i = 0; i < ((ArrayList)tmp).size(); ++i) {
                this.channels[i] = ((ArrayList)tmp).get(i);
            }
        } else {
            this.channels = new int[1];
            if (this.isHuiskenFormat()) {
                this.channels[0] = this.spimExperiment.channelStart;
            }
        }
        IOFunctions.println("ChannelPattern: " + this.channelPattern);
        IOFunctions.println("Channels: " + Util.printCoordinates((int[])this.channels));
        if (this.channelsToRegister != null && this.channelsToRegister.trim().length() > 0) {
            tmp = SPIMConfiguration.parseIntegerString(this.channelsToRegister);
            this.channelsRegister = new int[((ArrayList)tmp).size()];
            for (i = 0; i < ((ArrayList)tmp).size(); ++i) {
                this.channelsRegister[i] = ((ArrayList)tmp).get(i);
            }
        } else {
            this.channelsRegister = new int[1];
            if (this.isHuiskenFormat()) {
                this.channelsRegister[0] = this.spimExperiment.channelStart;
            }
        }
        IOFunctions.println("ChannelsToRegister: " + this.channelsToRegister);
        IOFunctions.println("ChannelsRegister: " + Util.printCoordinates((int[])this.channelsRegister));
        if (this.channelsToFuse != null && this.channelsToFuse.trim().length() > 0) {
            tmp = SPIMConfiguration.parseIntegerString(this.channelsToFuse);
            this.channelsFuse = new int[((ArrayList)tmp).size()];
            for (i = 0; i < ((ArrayList)tmp).size(); ++i) {
                this.channelsFuse[i] = ((ArrayList)tmp).get(i);
            }
        } else {
            this.channelsFuse = new int[]{this.channelsRegister[0]};
            if (this.isHuiskenFormat()) {
                this.channelsFuse[0] = this.spimExperiment.channelStart;
            }
        }
        IOFunctions.println("ChannelsToFuse: " + this.channelsToFuse);
        IOFunctions.println("ChannelsFuse: " + Util.printCoordinates((int[])this.channelsFuse));
        for (Object cR : (Object)this.channelsRegister) {
            contains = false;
            for (int c : this.channels) {
                if (c != cR) continue;
                contains = true;
            }
            if (contains) continue;
            throw new ConfigurationParserException("Channel " + (int)cR + " that should be used for registration is not part of the channels " + Util.printCoordinates((int[])this.channels));
        }
        for (Object cF : (Object)this.channelsFuse) {
            contains = false;
            for (int c : this.channels) {
                if (c != cF) continue;
                contains = true;
            }
            if (contains) continue;
            throw new ConfigurationParserException("Channel " + (int)cF + " that should be used for fusion is not part of the channels " + Util.printCoordinates((int[])this.channels));
        }
        tmp = this.channels;
        i = ((Object)tmp).length;
        for (int j = 0; j < i; ++j) {
            Object c = tmp[j];
            contains = false;
            for (int cR : this.channelsRegister) {
                if (c != cR) continue;
                contains = true;
            }
            for (int cF : this.channelsFuse) {
                if (c != cF) continue;
                contains = true;
            }
            if (contains) continue;
            throw new ConfigurationParserException("Channel " + (int)c + " is not used for anything (not registration, not fusion); stopping. ");
        }
        if (this.segmentation == SegmentationTypes.DOG && !this.fuseOnly) {
            int numChannelsRegister = this.channelsRegister.length;
            if (numChannelsRegister != this.initialSigma.length || numChannelsRegister != this.minPeakValue.length) {
                throw new ConfigurationParserException("The number of channels with beads does not match the number of DoG parameters.");
            }
            if (this.minInitialPeakValue == null || this.minInitialPeakValue.length != numChannelsRegister) {
                this.minInitialPeakValue = new float[numChannelsRegister];
                for (i = 0; i < numChannelsRegister; ++i) {
                    this.minInitialPeakValue[i] = this.minPeakValue[i] / 10.0f;
                }
            }
        }
        if (this.mirrorChannels.trim().length() > 0) {
            String[] mirror = this.mirrorChannels.trim().split(",");
            this.channelsMirror = new int[mirror.length][2];
            i = 0;
            for (String entry : mirror) {
                entry = entry.trim();
                try {
                    int channel = Integer.parseInt(entry.substring(0, entry.length() - 1));
                    String direction = entry.substring(entry.length() - 1, entry.length()).toLowerCase();
                    if (direction.equalsIgnoreCase("h")) {
                        this.channelsMirror[i][0] = channel;
                        this.channelsMirror[i][1] = 0;
                    } else if (direction.equalsIgnoreCase("v")) {
                        this.channelsMirror[i][0] = channel;
                        this.channelsMirror[i][1] = 1;
                    } else {
                        throw new ConfigurationParserException("Cannot parse channel mirroring information: " + entry + ": " + direction + " is unknown.");
                    }
                    ++i;
                }
                catch (Exception e) {
                    throw new ConfigurationParserException("Cannot parse channel mirroring information: " + this.mirrorChannels.trim() + ": " + e);
                }
            }
        }
    }

    public void parseIlluminations() throws ConfigurationParserException {
        this.illuminations = this.hasAlternatingIllumination() ? new int[]{0, 1} : new int[]{0};
    }

    protected String[] getDirListing(String directory, final String filePatternStart, final String filePatternEnd) {
        File dir = new File(directory);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(filePatternStart) && name.endsWith(filePatternEnd);
            }
        };
        return dir.list(filter);
    }

    public void parseTimePoints() throws ConfigurationParserException {
        ArrayList<Integer> tmp = SPIMConfiguration.parseIntegerString(this.timepointPattern);
        this.timepoints = new int[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            this.timepoints[i] = tmp.get(i);
        }
    }

    public static String getReplaceStringChannels(String inputFilePattern) {
        String replacePattern = null;
        int numDigitsTL = 0;
        int i1 = inputFilePattern.indexOf("{c");
        int i2 = inputFilePattern.indexOf("c}");
        if (i1 >= 0 && i2 > 0) {
            replacePattern = "{";
            numDigitsTL = i2 - i1;
            for (int i = 0; i < numDigitsTL; ++i) {
                replacePattern = replacePattern + "c";
            }
            replacePattern = replacePattern + "}";
        }
        return replacePattern;
    }

    public static String getReplaceStringTimePoints(String inputFilePattern) {
        String replacePattern = null;
        int numDigitsTL = 0;
        int i1 = inputFilePattern.indexOf("{t");
        int i2 = inputFilePattern.indexOf("t}");
        if (i1 >= 0 && i2 > 0) {
            replacePattern = "{";
            numDigitsTL = i2 - i1;
            for (int i = 0; i < numDigitsTL; ++i) {
                replacePattern = replacePattern + "t";
            }
            replacePattern = replacePattern + "}";
        }
        return replacePattern;
    }

    public static String getReplaceStringAngle(String inputFilePattern) {
        String replacePattern = null;
        int numDigitsTL = 0;
        int i1 = inputFilePattern.indexOf("{a");
        int i2 = inputFilePattern.indexOf("a}");
        if (i1 >= 0 && i2 > 0) {
            replacePattern = "{";
            numDigitsTL = i2 - i1;
            for (int i = 0; i < numDigitsTL; ++i) {
                replacePattern = replacePattern + "a";
            }
            replacePattern = replacePattern + "}";
        }
        return replacePattern;
    }

    public boolean isHuiskenFormat() {
        return this.spimExperiment != null;
    }

    public boolean hasAlternatingIllumination() {
        return this.isHuiskenFormat() && this.spimExperiment.d < this.spimExperiment.planeEnd + 1 - this.spimExperiment.planeStart;
    }

    public SPIMExperiment getSpimExperiment() {
        return this.spimExperiment;
    }

    public double getZStretchingHuisken() {
        return this.spimExperiment.pd / this.spimExperiment.pw;
    }

    public void getFilenamesHuisken() throws ConfigurationParserException {
        this.parseTimePoints();
        this.parseAngles();
        this.parseChannels();
        this.parseIlluminations();
        this.file = new File[this.timepoints.length][this.channels.length][this.angles.length][this.illuminations.length];
        String pathFormatString = "reg-t%05d-a%03d-c%03d-i%01d";
        for (int tp = 0; tp < this.timepoints.length; ++tp) {
            for (int channel = 0; channel < this.channels.length; ++channel) {
                for (int angle = 0; angle < this.angles.length; ++angle) {
                    for (int illumination = 0; illumination < this.illuminations.length; ++illumination) {
                        this.file[tp][channel][angle][illumination] = new File(this.inputdirectory, String.format("reg-t%05d-a%03d-c%03d-i%01d", this.timepoints[tp], this.angles[angle], this.channels[channel], this.illuminations[illumination]));
                    }
                }
            }
        }
    }

    public void getFileNames() throws ConfigurationParserException {
        String replaceTL = SPIMConfiguration.getReplaceStringTimePoints(this.inputFilePattern);
        String replaceAngle = SPIMConfiguration.getReplaceStringAngle(this.inputFilePattern);
        String replaceChannel = SPIMConfiguration.getReplaceStringChannels(this.inputFilePattern);
        if (replaceTL == null) {
            replaceTL = "\\";
        }
        if (replaceAngle == null) {
            replaceAngle = "\\";
        }
        if (replaceChannel == null) {
            replaceChannel = "\\";
        }
        int numDigitsTL = Math.max(0, replaceTL.length() - 2);
        int numDigitsAngle = Math.max(0, replaceAngle.length() - 2);
        int numDigitsChannel = Math.max(0, replaceChannel.length() - 2);
        this.parseTimePoints();
        this.parseAngles();
        this.parseChannels();
        this.parseIlluminations();
        if (replaceAngle.equals("\\")) {
            throw new ConfigurationParserException("You gave no pattern to substitute the angles in the file name");
        }
        if (this.angles.length < 2) {
            IOFunctions.println("Warning: You gave less than two angles to process: " + this.anglePattern);
        }
        if (this.timepoints.length > 1 && replaceTL.equals("\\")) {
            throw new ConfigurationParserException("You gave more than one timepoint but no pattern to replace");
        }
        this.file = new File[this.timepoints.length][this.channels.length][this.angles.length][this.illuminations.length];
        for (int tp = 0; tp < this.timepoints.length; ++tp) {
            for (int channel = 0; channel < this.channels.length; ++channel) {
                for (int angle = 0; angle < this.angles.length; ++angle) {
                    for (int illumination = 0; illumination < this.illuminations.length; ++illumination) {
                        String fileName = this.inputFilePattern;
                        if (replaceTL != null) {
                            fileName = fileName.replace(replaceTL, SPIMConfiguration.getLeadingZeros(numDigitsTL, this.timepoints[tp]));
                        }
                        fileName = fileName.replace(replaceAngle, SPIMConfiguration.getLeadingZeros(numDigitsAngle, this.angles[angle]));
                        fileName = fileName.replace(replaceChannel, SPIMConfiguration.getLeadingZeros(numDigitsChannel, this.channels[channel]));
                        this.file[tp][channel][angle][illumination] = new File(this.inputdirectory, fileName);
                    }
                }
            }
        }
    }

    public int getTimePointIndex(int timepoint) {
        for (int i = 0; i < this.timepoints.length; ++i) {
            if (this.timepoints[i] != timepoint) continue;
            return i;
        }
        return -1;
    }

    private static String getLeadingZeros(int zeros, int number) {
        String output = "" + number;
        while (output.length() < zeros) {
            output = "0" + output;
        }
        return output;
    }

    public void printProperties() {
        IOFunctions.println("timepointPattern: " + this.timepointPattern);
        if (this.timepoints != null) {
            System.out.print("Time Points: ");
            for (int tp : this.timepoints) {
                System.out.print(tp + " ");
            }
            IOFunctions.println();
        }
        IOFunctions.println("anglePattern: " + this.anglePattern);
        if (this.angles != null) {
            System.out.print("Angles: ");
            for (int angle : this.angles) {
                System.out.print(angle + " ");
            }
            IOFunctions.println();
        }
        IOFunctions.println("inputFilePattern: " + this.inputFilePattern);
        if (this.file != null) {
            for (int x = 0; x < this.file.length; ++x) {
                for (int y = 0; y < this.file[x].length; ++y) {
                    IOFunctions.println("File[" + x + "][" + y + "] = " + this.file[x][y]);
                }
            }
        }
        IOFunctions.println("inputdirectory: " + this.inputdirectory);
        IOFunctions.println("outputdirectory: " + this.outputdirectory);
        IOFunctions.println("registrationFiledirectory: " + this.registrationFiledirectory);
        IOFunctions.println("debugLevel: " + this.debugLevel);
        IOFunctions.println("showImageJWindow: " + this.showImageJWindow);
        IOFunctions.println("timeLapseRegistration: " + this.timeLapseRegistration);
        IOFunctions.println("referenceTimePoint: " + this.referenceTimePoint);
        this.inputImageFactory.printProperties();
        this.processImageFactory.printProperties();
        IOFunctions.println("tempDir: " + this.tempDir);
        this.strategyFactoryOutput.printProperties();
        this.strategyFactoryGauss.printProperties();
        IOFunctions.println("writeOutputImage: " + this.writeOutputImage);
        IOFunctions.println("showOutputImage: " + this.showOutputImage);
        IOFunctions.println("segmentation type: " + (Object)((Object)this.segmentation));
        IOFunctions.println("useEntropy: " + this.useEntropy);
        IOFunctions.println("useGaussContentBased: " + this.useGaussContentBased);
        IOFunctions.println("useIntegralContentBased: " + this.useIntegralContentBased);
        IOFunctions.println("useLinearBlening: " + this.useLinearBlening);
        IOFunctions.println("paralellFusion: " + this.paralellFusion);
        IOFunctions.println("sequentialFusion: " + this.sequentialFusion);
        IOFunctions.println("multipleImageFusion: " + this.multipleImageFusion);
        IOFunctions.println("registerOnly: " + this.registerOnly);
        IOFunctions.println("readSegmentation: " + this.readSegmentation);
        IOFunctions.println("writeSegmentation: " + this.writeSegmentation);
        IOFunctions.println("readRegistration: " + this.readRegistration);
        IOFunctions.println("writeRegistration: " + this.writeRegistration);
        IOFunctions.println("zStretching: " + this.zStretching);
        IOFunctions.println("background: " + this.background);
        IOFunctions.println("threshold: " + this.threshold);
        IOFunctions.println("fixed threshold: " + this.fixedThreshold);
        IOFunctions.println("useFixedThreshold: " + this.useFixedThreshold);
        IOFunctions.println("minBlackBorder: " + this.minBlackBorder);
        IOFunctions.println("minSize: " + this.minSize);
        IOFunctions.println("maxSize: " + this.maxSize);
        IOFunctions.println("useCenterOfMass: " + this.useCenterOfMass);
        IOFunctions.println("minPeakValue: " + this.minPeakValue);
        IOFunctions.println("minInitialPeakValue: " + this.minInitialPeakValue);
        IOFunctions.println("identityRadius: " + this.identityRadius);
        IOFunctions.println("maximaTolerance: " + this.maximaTolerance);
        IOFunctions.println("imageSigma: " + this.imageSigma);
        IOFunctions.println("initialSigma: " + this.initialSigma);
        IOFunctions.println("stepsPerOctave: " + this.stepsPerOctave);
        IOFunctions.println("steps: " + this.steps);
        IOFunctions.println("differenceThreshold: " + this.differenceThreshold);
        IOFunctions.println("ratioOfDistance: " + this.ratioOfDistance);
        IOFunctions.println("neighbors: " + this.neighbors);
        IOFunctions.println("useAssociatedBeads: " + this.useAssociatedBeads);
        IOFunctions.println("useRANSAC: " + this.useRANSAC);
        IOFunctions.println("max_epsilon: " + this.max_epsilon);
        IOFunctions.println("min_inlier_ratio: " + this.min_inlier_ratio);
        IOFunctions.println("numIterations: " + this.numIterations);
        IOFunctions.println("scale: " + this.scale);
        IOFunctions.println("cropOffsetX: " + this.cropOffsetX);
        IOFunctions.println("cropOffsetY: " + this.cropOffsetY);
        IOFunctions.println("cropOffsetZ: " + this.cropOffsetZ);
        IOFunctions.println("cropSizeX: " + this.cropSizeX);
        IOFunctions.println("cropSizeY: " + this.cropSizeY);
        IOFunctions.println("cropSizeZ: " + this.cropSizeZ);
        IOFunctions.println("numberOfThreads: " + this.numberOfThreads);
        IOFunctions.println("sigma: " + this.sigma);
        IOFunctions.println("cutOffRadiusGauss: " + this.cutOffRadiusGauss);
        IOFunctions.println("histogramBins: " + this.histogramBins);
        IOFunctions.println("windowSizeX: " + this.windowSizeX);
        IOFunctions.println("windowSizeY: " + this.windowSizeY);
        IOFunctions.println("alpha: " + this.alpha);
        IOFunctions.println("fusionSigma1: " + this.fusionSigma1);
        IOFunctions.println("fusionSigma2: " + this.fusionSigma2);
    }

    public static enum SegmentationTypes {
        THRESHOLD,
        DOG,
        DOM;

    }
}

