/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.util;

import mpicbg.imglib.util.Util;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.AffineModel3D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.RigidModel3D;
import spim.vecmath.Matrix4d;
import spim.vecmath.Transform3D;
import spim.vecmath.Vector3d;

public class TransformUtils {
    public static double[][] getMinMaxDim(int[] dimensions, CoordinateTransform transform) {
        int numDimensions = dimensions.length;
        double[] tmp = new double[numDimensions];
        double[][] minMaxDim = new double[numDimensions][2];
        for (int d = 0; d < numDimensions; ++d) {
            minMaxDim[d][0] = Double.MAX_VALUE;
            minMaxDim[d][1] = -1.7976931348623157E308;
        }
        boolean[][] positions = new boolean[Util.pow((int)2, (int)numDimensions)][numDimensions];
        Util.setCoordinateRecursive((int)(numDimensions - 1), (int)numDimensions, (int[])new int[numDimensions], (boolean[][])positions);
        for (int i = 0; i < positions.length; ++i) {
            int d;
            for (d = 0; d < numDimensions; ++d) {
                tmp[d] = positions[i][d] ? (double)dimensions[d] : 0.0;
            }
            transform.applyInPlace(tmp);
            for (d = 0; d < numDimensions; ++d) {
                if (tmp[d] < minMaxDim[d][0]) {
                    minMaxDim[d][0] = tmp[d];
                }
                if (!(tmp[d] > minMaxDim[d][1])) continue;
                minMaxDim[d][1] = tmp[d];
            }
        }
        return minMaxDim;
    }

    public static Matrix4d getMatrix4d(AffineModel3D model) {
        Matrix4d matrix = new Matrix4d();
        double[] m = new double[12];
        model.getMatrix(m);
        matrix.m00 = m[0];
        matrix.m01 = m[1];
        matrix.m02 = m[2];
        matrix.m03 = m[3];
        matrix.m10 = m[4];
        matrix.m11 = m[5];
        matrix.m12 = m[6];
        matrix.m13 = m[7];
        matrix.m20 = m[8];
        matrix.m21 = m[9];
        matrix.m22 = m[10];
        matrix.m23 = m[11];
        matrix.m30 = 0.0;
        matrix.m31 = 0.0;
        matrix.m32 = 0.0;
        matrix.m33 = 0.0;
        return matrix;
    }

    public static Matrix4d getMatrix4d(RigidModel3D model) {
        Matrix4d matrix = new Matrix4d();
        double[] m = new double[12];
        model.getMatrix(m);
        matrix.m00 = m[0];
        matrix.m01 = m[1];
        matrix.m02 = m[2];
        matrix.m03 = m[3];
        matrix.m10 = m[4];
        matrix.m11 = m[5];
        matrix.m12 = m[6];
        matrix.m13 = m[7];
        matrix.m20 = m[8];
        matrix.m21 = m[9];
        matrix.m22 = m[10];
        matrix.m23 = m[11];
        matrix.m30 = 0.0;
        matrix.m31 = 0.0;
        matrix.m32 = 0.0;
        matrix.m33 = 0.0;
        return matrix;
    }

    public static Transform3D getTransform3D1(AbstractAffineModel3D<?> model) {
        Transform3D transform = new Transform3D();
        double[] m = model.getMatrix(null);
        double[] m2 = new double[16];
        transform.get(m2);
        for (int i = 0; i < m.length; ++i) {
            m2[i] = m[i];
        }
        transform.set(m2);
        return transform;
    }

    public static <M extends AbstractAffineModel3D<M>> Transform3D getTransform3D(M model) {
        Transform3D transform = new Transform3D();
        double[] m = model.getMatrix(null);
        double[] m2 = new double[16];
        transform.get(m2);
        for (int i = 0; i < m.length; ++i) {
            m2[i] = m[i];
        }
        transform.set(m2);
        return transform;
    }

    public static AffineModel3D getAffineModel3D(Transform3D transform) {
        double[] m = new double[16];
        transform.get(m);
        AffineModel3D model = new AffineModel3D();
        model.set(m[0], m[1], m[2], m[3], m[4], m[5], m[6], m[7], m[8], m[9], m[10], m[11]);
        return model;
    }

    public static RigidModel3D getRigidModel3D(Transform3D transform) {
        double[] m = new double[16];
        transform.get(m);
        RigidModel3D model = new RigidModel3D();
        model.set(m[0], m[1], m[2], m[3], m[4], m[5], m[6], m[7], m[8], m[9], m[10], m[11]);
        return model;
    }

    public static void main(String[] args) {
        AffineModel3D m = new AffineModel3D();
        m.set(0.879122257232666, (double)0.425894f, 0.21391233801841736, (double)-169.3024f, -0.47269102931022644, (double)0.836501f, (double)0.2771809f, 42.627777099609375, (double)-0.0608882f, -0.34479033946990967, 0.9367028474807739, 246.5963897705078);
        Transform3D t = TransformUtils.getTransform3D1(m);
        Vector3d s = new Vector3d();
        t.getScale(s);
        System.out.println(s);
    }
}

