/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin;

import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.data.sequence.VoxelDimensions;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.KDTree;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.neighborsearch.KNearestNeighborSearchOnKDTree;
import spim.fiji.plugin.Interest_Point_Registration;
import spim.fiji.plugin.queryXML.LoadParseQueryXML;
import spim.fiji.plugin.thinout.ChannelProcessThinOut;
import spim.fiji.plugin.thinout.Histogram;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.interestpoints.InterestPoint;
import spim.fiji.spimdata.interestpoints.InterestPointList;
import spim.fiji.spimdata.interestpoints.ViewInterestPointLists;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;

public class ThinOut_Detections
implements PlugIn {
    public static boolean[] defaultShowHistogram;
    public static int[] defaultSubSampling;
    public static String[] defaultNewLabels;
    public static int[] defaultRemoveKeep;
    public static double[] defaultCutoffThresholdMin;
    public static double[] defaultCutoffThresholdMax;
    public static String[] removeKeepChoice;
    public static double defaultThresholdMinValue;
    public static double defaultThresholdMaxValue;
    public static int defaultSubSamplingValue;
    public static String defaultNewLabelText;
    public static int defaultRemoveKeepValue;

    public void run(String arg) {
        ArrayList<ViewId> viewIds;
        LoadParseQueryXML xml = new LoadParseQueryXML();
        if (!xml.queryXML("", true, false, true, true)) {
            return;
        }
        SpimData2 data = (SpimData2)((Object)xml.getData());
        ArrayList<ChannelProcessThinOut> channels = ThinOut_Detections.getChannelsAndLabels(data, viewIds = SpimData2.getAllViewIdsSorted(data, xml.getViewSetupsToProcess(), xml.getTimePointsToProcess()));
        if (channels == null) {
            return;
        }
        if (!ThinOut_Detections.getThinOutThresholds(data, viewIds, channels)) {
            return;
        }
        if (!ThinOut_Detections.thinOut(data, viewIds, channels, true)) {
            return;
        }
        SpimData2.saveXML(data, xml.getXMLFileName(), xml.getClusterExtension());
    }

    public static boolean thinOut(SpimData2 spimData, List<ViewId> viewIds, List<ChannelProcessThinOut> channels, boolean save) {
        ViewInterestPoints vip = spimData.getViewInterestPoints();
        for (ChannelProcessThinOut channel : channels) {
            double minDistance = channel.getMin();
            double maxDistance = channel.getMax();
            boolean keepRange = channel.keepRange();
            for (ViewId viewId : viewIds) {
                ViewDescription vd = ((SequenceDescription)spimData.getSequenceDescription()).getViewDescription(viewId);
                if (!vd.isPresent() || ((ViewSetup)vd.getViewSetup()).getChannel().getId() != channel.getChannel().getId()) continue;
                ViewInterestPointLists vipl = vip.getViewInterestPointLists(viewId);
                InterestPointList oldIpl = vipl.getInterestPointList(channel.getLabel());
                if (oldIpl.getInterestPoints() == null) {
                    oldIpl.loadInterestPoints();
                }
                VoxelDimensions voxelSize = ((ViewSetup)vd.getViewSetup()).getVoxelSize();
                ArrayList<RealPoint> list1 = new ArrayList<RealPoint>();
                ArrayList<RealPoint> list2 = new ArrayList<RealPoint>();
                ArrayList<double[]> points = new ArrayList<double[]>();
                for (InterestPoint ip : oldIpl.getInterestPoints()) {
                    list1.add(new RealPoint(new double[]{ip.getL()[0] * voxelSize.dimension(0), ip.getL()[1] * voxelSize.dimension(1), ip.getL()[2] * voxelSize.dimension(2)}));
                    list2.add(new RealPoint(new double[]{ip.getL()[0] * voxelSize.dimension(0), ip.getL()[1] * voxelSize.dimension(1), ip.getL()[2] * voxelSize.dimension(2)}));
                    points.add(ip.getL());
                }
                KDTree tree = new KDTree(list1, list1);
                KNearestNeighborSearchOnKDTree nn = new KNearestNeighborSearchOnKDTree(tree, 2);
                InterestPointList newIpl = new InterestPointList(oldIpl.getBaseDir(), new File(oldIpl.getFile().getParentFile(), "tpId_" + viewId.getTimePointId() + "_viewSetupId_" + viewId.getViewSetupId() + "." + channel.getNewLabel()));
                newIpl.setInterestPoints(new ArrayList<InterestPoint>());
                int id = 0;
                for (int j = 0; j < list2.size(); ++j) {
                    RealPoint p = (RealPoint)list2.get(j);
                    nn.search((RealLocalizable)p);
                    double d = nn.getDistance(1);
                    if (!(keepRange && d >= minDistance && d <= maxDistance) && (keepRange || !(d < minDistance) && !(d > maxDistance))) continue;
                    newIpl.getInterestPoints().add(new InterestPoint(id++, (double[])((double[])points.get(j)).clone()));
                }
                if (keepRange) {
                    newIpl.setParameters("thinned-out '" + channel.getLabel() + "', kept range from " + minDistance + " to " + maxDistance);
                } else {
                    newIpl.setParameters("thinned-out '" + channel.getLabel() + "', removed range from " + minDistance + " to " + maxDistance);
                }
                vipl.addInterestPointList(channel.getNewLabel(), newIpl);
                IOFunctions.println(new Date(System.currentTimeMillis()) + ": TP=" + vd.getTimePointId() + " ViewSetup=" + vd.getViewSetupId() + ", Detections: " + oldIpl.getInterestPoints().size() + " >>> " + newIpl.getInterestPoints().size());
                if (!save || newIpl.saveInterestPoints()) continue;
                IOFunctions.println("Error saving interest point list: " + new File(newIpl.getBaseDir(), newIpl.getFile().toString() + newIpl.getInterestPointsExt()));
                return false;
            }
        }
        return true;
    }

    public static boolean getThinOutThresholds(SpimData2 spimData, List<ViewId> viewIds, List<ChannelProcessThinOut> channels) {
        ChannelProcessThinOut channel;
        int c;
        for (ChannelProcessThinOut channel2 : channels) {
            if (!channel2.showHistogram()) continue;
            ThinOut_Detections.plotHistogram(spimData, viewIds, channel2);
        }
        if (defaultCutoffThresholdMin == null || defaultCutoffThresholdMin.length != channels.size() || defaultCutoffThresholdMax == null || defaultCutoffThresholdMax.length != channels.size()) {
            defaultCutoffThresholdMin = new double[channels.size()];
            defaultCutoffThresholdMax = new double[channels.size()];
            for (int i = 0; i < channels.size(); ++i) {
                ThinOut_Detections.defaultCutoffThresholdMin[i] = defaultThresholdMinValue;
                ThinOut_Detections.defaultCutoffThresholdMax[i] = defaultThresholdMaxValue;
            }
        }
        if (defaultRemoveKeep == null || defaultRemoveKeep.length != channels.size()) {
            defaultRemoveKeep = new int[channels.size()];
            for (int i = 0; i < channels.size(); ++i) {
                ThinOut_Detections.defaultRemoveKeep[i] = defaultRemoveKeepValue;
            }
        }
        GenericDialog gd = new GenericDialog("Define cut-off threshold");
        for (c = 0; c < channels.size(); ++c) {
            channel = channels.get(c);
            gd.addChoice("Channel_" + channel.getChannel().getName() + "_", removeKeepChoice, removeKeepChoice[defaultRemoveKeep[c]]);
            gd.addNumericField("Channel_" + channel.getChannel().getName() + "_range_lower_threshold", defaultCutoffThresholdMin[c], 2);
            gd.addNumericField("Channel_" + channel.getChannel().getName() + "_range_upper_threshold", defaultCutoffThresholdMax[c], 2);
            gd.addMessage("");
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        for (c = 0; c < channels.size(); ++c) {
            channel = channels.get(c);
            ThinOut_Detections.defaultRemoveKeep[c] = gd.getNextChoiceIndex();
            int removeKeep = ThinOut_Detections.defaultRemoveKeep[c];
            if (removeKeep == 1) {
                channel.setKeepRange(true);
            } else {
                channel.setKeepRange(false);
            }
            ThinOut_Detections.defaultCutoffThresholdMin[c] = gd.getNextNumber();
            channel.setMin(ThinOut_Detections.defaultCutoffThresholdMin[c]);
            ThinOut_Detections.defaultCutoffThresholdMax[c] = gd.getNextNumber();
            channel.setMax(ThinOut_Detections.defaultCutoffThresholdMax[c]);
            if (channel.getMin() >= channel.getMax()) {
                IOFunctions.println("You selected the minimal threshold larger than the maximal threshold for channel " + channel.getChannel().getName());
                IOFunctions.println("Stopping.");
                return false;
            }
            if (channel.keepRange()) {
                IOFunctions.println("Channel " + channel.getChannel().getName() + ": keep only distances from " + channel.getMin() + " >>> " + channel.getMax());
                continue;
            }
            IOFunctions.println("Channel " + channel.getChannel().getName() + ": remove distances from " + channel.getMin() + " >>> " + channel.getMax());
        }
        return true;
    }

    public static Histogram plotHistogram(SpimData2 spimData, List<ViewId> viewIds, ChannelProcessThinOut channel) {
        ViewInterestPoints vip = spimData.getViewInterestPoints();
        ArrayList<Double> distances = new ArrayList<Double>();
        Random rnd = new Random(System.currentTimeMillis());
        String unit = null;
        for (ViewId viewId : viewIds) {
            ViewDescription vd = ((SequenceDescription)spimData.getSequenceDescription()).getViewDescription(viewId);
            if (!vd.isPresent() || ((ViewSetup)vd.getViewSetup()).getChannel().getId() != channel.getChannel().getId()) continue;
            ViewInterestPointLists vipl = vip.getViewInterestPointLists(viewId);
            InterestPointList ipl = vipl.getInterestPointList(channel.getLabel());
            VoxelDimensions voxelSize = ((ViewSetup)vd.getViewSetup()).getVoxelSize();
            if (ipl.getInterestPoints() == null) {
                ipl.loadInterestPoints();
            }
            if (unit == null) {
                unit = ((ViewSetup)vd.getViewSetup()).getVoxelSize().unit();
            }
            ArrayList<RealPoint> list = new ArrayList<RealPoint>();
            for (InterestPoint ip : ipl.getInterestPoints()) {
                list.add(new RealPoint(new double[]{ip.getL()[0] * voxelSize.dimension(0), ip.getL()[1] * voxelSize.dimension(1), ip.getL()[2] * voxelSize.dimension(2)}));
            }
            KDTree tree = new KDTree(list, list);
            KNearestNeighborSearchOnKDTree nn = new KNearestNeighborSearchOnKDTree(tree, 2);
            for (RealPoint p : list) {
                if (!(rnd.nextDouble() < 1.0 / (double)channel.getSubsampling())) continue;
                nn.search((RealLocalizable)p);
                distances.add(nn.getDistance(1));
            }
        }
        Histogram h = new Histogram(distances, 100, "Distance Histogram [Channel=" + channel.getChannel().getName() + "]", unit);
        h.showHistogram();
        IOFunctions.println("Channel " + channel.getChannel().getName() + ": min distance=" + h.getMin() + ", max distance=" + h.getMax());
        return h;
    }

    public static ArrayList<ChannelProcessThinOut> getChannelsAndLabels(SpimData2 spimData, List<ViewId> viewIds) {
        int i;
        GenericDialog gd = new GenericDialog("Choose segmentations to thin out");
        ArrayList<Channel> channels = SpimData2.getAllChannelsSorted(spimData, viewIds);
        int nAllChannels = ((SequenceDescription)spimData.getSequenceDescription()).getAllChannelsOrdered().size();
        if (Interest_Point_Registration.defaultChannelLabels == null || Interest_Point_Registration.defaultChannelLabels.length != nAllChannels) {
            Interest_Point_Registration.defaultChannelLabels = new int[nAllChannels];
        }
        if (defaultShowHistogram == null || defaultShowHistogram.length != channels.size()) {
            defaultShowHistogram = new boolean[channels.size()];
            for (i = 0; i < channels.size(); ++i) {
                ThinOut_Detections.defaultShowHistogram[i] = true;
            }
        }
        if (defaultSubSampling == null || defaultSubSampling.length != channels.size()) {
            defaultSubSampling = new int[channels.size()];
            for (i = 0; i < channels.size(); ++i) {
                ThinOut_Detections.defaultSubSampling[i] = defaultSubSamplingValue;
            }
        }
        if (defaultNewLabels == null || defaultNewLabels.length != channels.size()) {
            defaultNewLabels = new String[channels.size()];
            for (i = 0; i < channels.size(); ++i) {
                ThinOut_Detections.defaultNewLabels[i] = defaultNewLabelText;
            }
        }
        ArrayList<String[]> channelLabels = new ArrayList<String[]>();
        int j = 0;
        for (Channel channel : channels) {
            String[] labels = Interest_Point_Registration.getAllInterestPointLabelsForChannel(spimData, viewIds, channel, "thin out");
            if (Interest_Point_Registration.defaultChannelLabels[j] >= labels.length) {
                Interest_Point_Registration.defaultChannelLabels[j] = 0;
            }
            String ch = channel.getName().replace(' ', '_');
            gd.addCheckbox("Channel_" + ch + "_Display_distance_histogram", defaultShowHistogram[j]);
            gd.addChoice("Channel_" + ch + "_Interest_points", labels, labels[Interest_Point_Registration.defaultChannelLabels[j]]);
            gd.addStringField("Channel_" + ch + "_New_label", defaultNewLabels[j], 20);
            gd.addNumericField("Channel_" + ch + "_Subsample histogram", (double)defaultSubSampling[j], 0, 5, "times");
            channelLabels.add(labels);
            ++j;
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        ArrayList<ChannelProcessThinOut> channelsToProcess = new ArrayList<ChannelProcessThinOut>();
        j = 0;
        for (Channel channel : channels) {
            boolean showHistogram = ThinOut_Detections.defaultShowHistogram[j] = gd.getNextBoolean();
            int channelChoice = Interest_Point_Registration.defaultChannelLabels[j] = gd.getNextChoiceIndex();
            String newLabel = ThinOut_Detections.defaultNewLabels[j] = gd.getNextString();
            int subSampling = ThinOut_Detections.defaultSubSampling[j] = (int)Math.round(gd.getNextNumber());
            if (channelChoice < ((String[])channelLabels.get(j)).length - 1) {
                String label = ((String[])channelLabels.get(j))[channelChoice];
                if (label.contains(" (WARNING: Only available for ")) {
                    label = label.substring(0, label.indexOf(" (WARNING: Only available for "));
                }
                channelsToProcess.add(new ChannelProcessThinOut(channel, label, newLabel, showHistogram, subSampling));
            }
            ++j;
        }
        return channelsToProcess;
    }

    public static void main(String[] args) {
        new ThinOut_Detections().run(null);
    }

    static {
        removeKeepChoice = new String[]{"Remove Range", "Keep Range"};
        defaultThresholdMinValue = 0.0;
        defaultThresholdMaxValue = 5.0;
        defaultSubSamplingValue = 1;
        defaultNewLabelText = "thinned-out";
        defaultRemoveKeepValue = 0;
    }
}

