/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.explorer.popup;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import spim.fiji.spimdata.explorer.ViewSetupExplorerPanel;
import spim.fiji.spimdata.explorer.popup.ViewExplorerSetable;

public class RemoveTransformationPopup
extends JMenu
implements ViewExplorerSetable {
    public static final int askWhenMoreThan = 5;
    private static final long serialVersionUID = 5234649267634013390L;
    ViewSetupExplorerPanel<?, ?> panel;
    protected static String[] types = new String[]{"Latest/Newest Transformation", "First/Oldest Transformation"};

    public RemoveTransformationPopup() {
        super("Remove Transformation");
        JMenuItem lastest = new JMenuItem(types[0]);
        JMenuItem oldest = new JMenuItem(types[1]);
        lastest.addActionListener(new MyActionListener(0));
        oldest.addActionListener(new MyActionListener(1));
        this.add(lastest);
        this.add(oldest);
    }

    public JMenuItem setViewExplorer(ViewSetupExplorerPanel<?, ?> panel) {
        this.panel = panel;
        return this;
    }

    public class MyActionListener
    implements ActionListener {
        final int index;

        public MyActionListener(int index) {
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RemoveTransformationPopup.this.panel == null) {
                IOFunctions.println("Panel not set for " + this.getClass().getSimpleName());
                return;
            }
            List<ViewId> viewIds = RemoveTransformationPopup.this.panel.selectedRowsViewId();
            ViewRegistrations vr = RemoveTransformationPopup.this.panel.getSpimData().getViewRegistrations();
            for (ViewId viewId : viewIds) {
                ViewRegistration v = (ViewRegistration)vr.getViewRegistrations().get(viewId);
                if (this.index == 0) {
                    v.getTransformList().remove(0);
                } else {
                    v.getTransformList().remove(v.getTransformList().size() - 1);
                }
                v.updateModel();
            }
            RemoveTransformationPopup.this.panel.updateContent();
            ViewSetupExplorerPanel.bdvPopup().updateBDV();
        }
    }
}

