/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.export;

import ij.ImagePlus;
import ij.gui.GenericDialog;
import java.util.List;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewSetup;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.exception.ImgLibException;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import spim.fiji.spimdata.SpimData2;
import spim.process.fusion.FusionHelper;
import spim.process.fusion.boundingbox.BoundingBoxGUI;
import spim.process.fusion.export.DefaultImgTitler;
import spim.process.fusion.export.FixedNameImgTitler;
import spim.process.fusion.export.ImgExport;
import spim.process.fusion.export.ImgExportTitle;
import spim.process.fusion.export.ImgTitler;

public class DisplayImage
implements ImgExportTitle {
    final boolean virtualDisplay;
    ImgTitler imgTitler = new DefaultImgTitler();

    public DisplayImage() {
        this(false);
    }

    public DisplayImage(boolean virtualDisplay) {
        this.virtualDisplay = virtualDisplay;
    }

    public <T extends RealType<T> & NativeType<T>> void exportImage(RandomAccessibleInterval<T> img, String title) {
        ImgTitler current = this.getImgTitler();
        this.setImgTitler(new FixedNameImgTitler(title));
        this.exportImage(img, null, null, null);
        this.setImgTitler(current);
    }

    public <T extends RealType<T> & NativeType<T>> void exportImage(RandomAccessibleInterval<T> img, BoundingBoxGUI bb, String title) {
        ImgTitler current = this.getImgTitler();
        this.setImgTitler(new FixedNameImgTitler(title));
        this.exportImage(img, bb, null, null);
        this.setImgTitler(current);
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> boolean exportImage(RandomAccessibleInterval<T> img, BoundingBoxGUI bb, TimePoint tp, ViewSetup vs) {
        return this.exportImage(img, bb, tp, vs, Double.NaN, Double.NaN);
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> boolean exportImage(RandomAccessibleInterval<T> img, BoundingBoxGUI bb, TimePoint tp, ViewSetup vs, double min, double max) {
        if (img == null) {
            return false;
        }
        float[] minmax = Double.isNaN(min) || Double.isNaN(max) ? FusionHelper.minMax(img) : new float[]{(float)min, (float)max};
        ImagePlus imp = DisplayImage.getImagePlusInstance(img, this.virtualDisplay, this.getImgTitler().getImageTitle(tp, vs), minmax[0], minmax[1]);
        if (bb != null) {
            imp.getCalibration().xOrigin = -(bb.min(0) / (long)bb.getDownSampling());
            imp.getCalibration().yOrigin = -(bb.min(1) / (long)bb.getDownSampling());
            imp.getCalibration().zOrigin = -(bb.min(2) / (long)bb.getDownSampling());
            imp.getCalibration().pixelHeight = imp.getCalibration().pixelDepth = (double)bb.getDownSampling();
            imp.getCalibration().pixelWidth = imp.getCalibration().pixelDepth;
        }
        imp.updateAndDraw();
        imp.show();
        return true;
    }

    public static <T extends RealType<T> & NativeType<T>> ImagePlus getImagePlusInstance(RandomAccessibleInterval<T> img, boolean virtualDisplay, String title, double min, double max) {
        ImagePlus imp = null;
        if (img instanceof ImagePlusImg) {
            try {
                imp = ((ImagePlusImg)img).getImagePlus();
            }
            catch (ImgLibException imgLibException) {
                // empty catch block
            }
        }
        if (imp == null) {
            imp = virtualDisplay ? ImageJFunctions.wrap(img, (String)title) : ImageJFunctions.wrap(img, (String)title).duplicate();
        }
        imp.setTitle(title);
        imp.setDimensions(1, (int)img.dimension(2), 1);
        imp.setDisplayRange(min, max);
        return imp;
    }

    @Override
    public boolean queryParameters(SpimData2 spimData, boolean is16bit) {
        return true;
    }

    @Override
    public void queryAdditionalParameters(GenericDialog gd, SpimData2 spimData) {
    }

    @Override
    public boolean parseAdditionalParameters(GenericDialog gd, SpimData2 spimData) {
        return true;
    }

    @Override
    public ImgExport newInstance() {
        return new DisplayImage();
    }

    @Override
    public String getDescription() {
        return "Display using ImageJ";
    }

    @Override
    public void setImgTitler(ImgTitler imgTitler) {
        this.imgTitler = imgTitler;
    }

    @Override
    public ImgTitler getImgTitler() {
        return this.imgTitler;
    }

    @Override
    public void setXMLData(List<TimePoint> timepointsToProcess, List<ViewSetup> newViewSetups) {
    }

    @Override
    public boolean finish() {
        return false;
    }
}

