/*
 * Decompiled with CFR 0.152.
 */
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.MultiLineLabel;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.ZProjector;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import stitching.CommonFunctions;
import stitching.GridLayout;
import stitching.ImageInformation;
import stitching.OverlapProperties;
import stitching.Point2D;
import stitching.Point3D;
import stitching.model.Model;
import stitching.model.NotEnoughDataPointsException;
import stitching.model.Point;
import stitching.model.PointMatch;
import stitching.model.Tile;
import stitching.model.TileConfiguration;
import stitching.model.TranslationModel2D;
import stitching.model.TranslationModel3D;
import stitching.utils.Log;

public class Stitch_Image_Collection
implements PlugIn {
    private final String myURL = "http://fly.mpi-cbg.de/~preibisch/contact.html";
    public int dim = -1;
    public double alpha;
    public double thresholdR;
    public double thresholdDisplacementRelative;
    public double thresholdDisplacementAbsolute;
    public String rgbOrder;
    public static String fileNameStatic = "TileConfiguration.txt";
    public static boolean computeOverlapStatic = true;
    public static String handleRGBStatic = CommonFunctions.colorList[CommonFunctions.colorList.length - 1];
    public static String rgbOrderStatic = CommonFunctions.rgbTypes[0];
    public static String fusionMethodStatic = CommonFunctions.methodListCollection[1];
    public static double alphaStatic = 1.5;
    public static double thresholdRStatic = 0.3;
    public static double thresholdDisplacementRelativeStatic = 2.5;
    public static double thresholdDisplacementAbsoluteStatic = 3.5;
    public static boolean previewOnlyStatic = false;

    public void run(String arg0) {
        boolean previewOnly;
        String fusionMethod;
        String handleRGB;
        boolean computeOverlap;
        String fileName;
        GenericDialogPlus gd = new GenericDialogPlus("Stitch Image Collection");
        gd.addFileField("Layout file", fileNameStatic, 50);
        gd.addCheckbox("compute_overlap (otherwise use the coordinates given in the layout file)", computeOverlapStatic);
        gd.addChoice("Channels_for_Registration", CommonFunctions.colorList, handleRGBStatic);
        gd.addChoice("rgb_order", CommonFunctions.rgbTypes, rgbOrderStatic);
        gd.addChoice("Fusion_Method", CommonFunctions.methodListCollection, CommonFunctions.methodListCollection[1]);
        gd.addNumericField("Fusion alpha", alphaStatic, 2);
        gd.addNumericField("Regression Threshold", thresholdRStatic, 2);
        gd.addNumericField("Max/Avg Displacement Threshold", thresholdDisplacementRelativeStatic, 2);
        gd.addNumericField("Absolute Avg Displacement Threshold", thresholdDisplacementAbsoluteStatic, 2);
        gd.addCheckbox("Create_only_Preview", previewOnlyStatic);
        gd.addMessage("");
        gd.addMessage("This Plugin is developed by Stephan Preibisch\nhttp://fly.mpi-cbg.de/~preibisch/contact.html");
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        CommonFunctions.addHyperLinkListener(text, "http://fly.mpi-cbg.de/~preibisch/contact.html");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        fileNameStatic = fileName = gd.getNextString();
        computeOverlapStatic = computeOverlap = gd.getNextBoolean();
        handleRGBStatic = handleRGB = gd.getNextChoice();
        rgbOrderStatic = this.rgbOrder = gd.getNextChoice();
        fusionMethodStatic = fusionMethod = gd.getNextChoice();
        alphaStatic = this.alpha = gd.getNextNumber();
        thresholdRStatic = this.thresholdR = gd.getNextNumber();
        thresholdDisplacementRelativeStatic = this.thresholdDisplacementRelative = gd.getNextNumber();
        thresholdDisplacementAbsoluteStatic = this.thresholdDisplacementAbsolute = gd.getNextNumber();
        previewOnlyStatic = previewOnly = gd.getNextBoolean();
        this.work(fileName, previewOnly, computeOverlap, fusionMethod, handleRGB, true);
    }

    public ImagePlus work(String fileName, boolean createPreview, boolean computeOverlap, String fusionMethod, String handleRGB, boolean showImage) {
        ArrayList<ImageInformation> imageInformationList = this.readLayoutFile(fileName);
        return this.work(imageInformationList, createPreview, computeOverlap, fusionMethod, handleRGB, fileName, showImage);
    }

    public ImagePlus work(GridLayout gridLayout, boolean createPreview, boolean computeOverlap, String fileName, boolean showImage) {
        this.alpha = gridLayout.alpha;
        this.thresholdR = gridLayout.thresholdR;
        this.thresholdDisplacementRelative = gridLayout.thresholdDisplacementRelative;
        this.thresholdDisplacementAbsolute = gridLayout.thresholdDisplacementAbsolute;
        this.dim = gridLayout.dim;
        this.rgbOrder = gridLayout.rgbOrder;
        return this.work(gridLayout.imageInformationList, createPreview, computeOverlap, gridLayout.fusionMethod, gridLayout.handleRGB, fileName, showImage);
    }

    public ImagePlus work(ArrayList<ImageInformation> imageInformationList, boolean createPreview, boolean computeOverlap, String fusionMethod, String handleRGB, String fileName, boolean showImage) {
        ArrayList<ImageInformation> newImageInformationList;
        Log.timestamp("Stitching the following files:");
        for (ImageInformation iI : imageInformationList) {
            Log.info("" + iI);
        }
        ArrayList<OverlapProperties> overlappingTiles = this.findOverlappingTiles(imageInformationList, createPreview, fusionMethod);
        if (createPreview) {
            return null;
        }
        if (computeOverlap) {
            this.computePhaseCorrelations(overlappingTiles, handleRGB);
            newImageInformationList = this.optimize(overlappingTiles, imageInformationList.get(0));
            if (newImageInformationList == null) {
                return null;
            }
        } else {
            newImageInformationList = imageInformationList;
        }
        Log.timestamp("Final image positions in the fused image:");
        for (ImageInformation i : newImageInformationList) {
            if (this.dim == 3) {
                Log.info("Tile " + i.id + " (" + i.imageName + "): " + i.position[0] + ", " + i.position[1] + ", " + i.position[2]);
                continue;
            }
            Log.info("Tile " + i.id + " (" + i.imageName + "): " + i.position[0] + ", " + i.position[1]);
        }
        this.writeOutputConfiguration(fileName, newImageInformationList);
        float[] max = Stitch_Image_Collection.getAndApplyMinMax(newImageInformationList, this.dim);
        if (this.dim == 3) {
            Log.timestamp("Size of bounding box for output image: " + max[0] + ", " + max[1] + ", " + max[2]);
        } else {
            Log.timestamp("Size of bounding box for output image: " + max[0] + ", " + max[1]);
        }
        ImagePlus fused = Stitch_Image_Collection.fuseImages(newImageInformationList, max, "Stitched Image", fusionMethod, this.rgbOrder, this.dim, this.alpha, showImage);
        if (showImage) {
            fused.show();
        }
        Log.timestamp("Finished Stitching.");
        return fused;
    }

    protected void writeOutputConfiguration(String fileName, ArrayList<ImageInformation> imageInformationList) {
        try {
            String outputfileName = fileName.endsWith(".registered") ? fileName : fileName + ".registered";
            PrintWriter out = Stitch_Image_Grid.openFileWrite(outputfileName);
            out.println("# Define the number of dimensions we are working on");
            out.println("dim = " + this.dim);
            out.println("");
            out.println("# Define the image coordinates");
            for (ImageInformation iI : imageInformationList) {
                String name = iI.imageName;
                if (iI.seriesNumber >= 0) {
                    name = name + "(((" + iI.seriesNumber + ")))";
                }
                if (this.dim == 3) {
                    out.println(name + "; ; (" + iI.position[0] + ", " + iI.position[1] + ", " + iI.position[2] + ")");
                    continue;
                }
                out.println(name + "; ; (" + iI.position[0] + ", " + iI.position[1] + ")");
            }
            out.close();
        }
        catch (Exception e) {
            Log.error("Cannot write registered configuration file: " + e);
        }
    }

    public static ImagePlus fuseImages(final ArrayList<ImageInformation> imageInformationList, float[] max, final String name, String fusionMethod, String rgbOrder, final int dim, final double alpha, final boolean showOutput) {
        ImagePlus fusedImp;
        final int type = fusionMethod.equals("Min. Intensity") ? 3 : (fusionMethod.equals("Linear Blending") ? 1 : (fusionMethod.equals("Max. Intensity") ? 2 : (fusionMethod.equals("Red-Cyan Overlay") && imageInformationList.size() == 2 ? 4 : (fusionMethod.equals("None") ? 5 : 0))));
        if (type == 0) {
            Log.info("Average Fusion started.");
        } else if (type == 2) {
            Log.info("Maximum Fusion started.");
        } else if (type == 3) {
            Log.info("Minimum Fusion started.");
        } else if (type == 1) {
            Log.info("Linear Blending Fusion started.");
        } else if (type == 4) {
            Log.info("Red-Cyan Fusion started.");
        } else if (type == 5) {
            Log.info("Overlapping (non fusion) started.");
        }
        final int imageType = imageInformationList.get((int)0).imageType;
        final int imgW = Math.round(max[0]);
        final int imgH = Math.round(max[1]);
        final int imgD = dim == 3 ? Math.round(max[2]) : 1;
        final float[] minmax = new float[]{Float.MAX_VALUE, Float.MIN_VALUE};
        if (type == 4) {
            fusedImp = IJ.createImage((String)(name + " - 0%"), (String)"rgb black", (int)imgW, (int)imgH, (int)imgD);
        } else if (imageType == 0) {
            fusedImp = IJ.createImage((String)(name + " - 0%"), (String)"8-bit black", (int)imgW, (int)imgH, (int)imgD);
        } else if (imageType == 1) {
            fusedImp = IJ.createImage((String)(name + " - 0%"), (String)"16-bit black", (int)imgW, (int)imgH, (int)imgD);
        } else if (imageType == 2) {
            fusedImp = IJ.createImage((String)(name + " - 0%"), (String)"32-bit black", (int)imgW, (int)imgH, (int)imgD);
        } else if (imageType == 4) {
            fusedImp = IJ.createImage((String)(name + " - 0%"), (String)"rgb black", (int)imgW, (int)imgH, (int)imgD);
        } else {
            IJ.error((String)("Unsupported/Unknown Image Type: " + imageType));
            return null;
        }
        Calibration cal = null;
        final ImageStack fusedStack = fusedImp.getStack();
        if (showOutput) {
            fusedImp.show();
        }
        try {
            fusedImp.setSlice(imgD / 2 + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type == 5 || type == 2 || type == 4) {
            int count = 0;
            int dimension = dim;
            for (ImageInformation iI : imageInformationList) {
                int z;
                ImagePlus imp = iI.imp == null ? CommonFunctions.loadImage("", iI.imageName, iI.seriesNumber, rgbOrder) : iI.imp;
                cal = Stitch_Image_Collection.updateCalibration(cal, iI.imp.getCalibration());
                Object[] imageStack1 = imp.getStack().getImageArray();
                int w1 = imp.getStack().getWidth();
                int h1 = imp.getStack().getHeight();
                int d1 = imp.getStack().getSize();
                if (type == 4 && imageType == 2) {
                    for (z = 0; z < d1; ++z) {
                        for (int y = 0; y < h1; ++y) {
                            for (int x = 0; x < w1; ++x) {
                                float pixel = CommonFunctions.getPixelMin(imageType, imageStack1, w1, h1, d1, x, y, z, 0.0);
                                if (pixel > minmax[1]) {
                                    minmax[1] = pixel;
                                }
                                if (!(pixel < minmax[0])) continue;
                                minmax[0] = pixel;
                            }
                        }
                    }
                }
                for (z = 0; z < d1; ++z) {
                    ImageProcessor fusedIp = dim == 3 ? fusedStack.getProcessor(z + 1 + Math.round(iI.position[2])) : fusedStack.getProcessor(z + 1);
                    int[] pixelrgbimg = new int[3];
                    for (int y = 0; y < h1; ++y) {
                        for (int x = 0; x < w1; ++x) {
                            if (imageType == 4) {
                                int i;
                                int[] pixelrgbSRC = dimension == 3 ? CommonFunctions.getPixelMinRGB(imageStack1, w1, h1, d1, x, y, z, 0.0) : CommonFunctions.getPixelMinRGB(imageStack1, w1, h1, d1, x, y, 0, 0.0);
                                fusedIp.getPixel(x + Math.round(iI.position[0]), y + Math.round(iI.position[1]), pixelrgbimg);
                                if (type == 2) {
                                    for (i = 0; i < pixelrgbSRC.length; ++i) {
                                        pixelrgbimg[i] = Math.max(pixelrgbSRC[i], pixelrgbimg[i]);
                                    }
                                } else if (type == 4) {
                                    if (count == 0) {
                                        pixelrgbimg[0] = (pixelrgbSRC[0] + pixelrgbSRC[1] + pixelrgbSRC[2]) / 3;
                                    } else if (count == 1) {
                                        pixelrgbimg[1] = pixelrgbimg[2] = (pixelrgbSRC[0] + pixelrgbSRC[1] + pixelrgbSRC[2]) / 3;
                                    }
                                } else if (type == 5) {
                                    for (i = 0; i < pixelrgbSRC.length; ++i) {
                                        pixelrgbimg[i] = pixelrgbSRC[i];
                                    }
                                }
                                fusedIp.putPixel(x + Math.round(iI.position[0]), y + Math.round(iI.position[1]), pixelrgbimg);
                                continue;
                            }
                            float pixel = dimension == 3 ? CommonFunctions.getPixelMin(imageType, imageStack1, w1, h1, d1, x, y, z, 0.0) : CommonFunctions.getPixelMin(imageType, imageStack1, w1, h1, d1, x, y, 0, 0.0);
                            if (type == 2) {
                                pixel = Math.max(pixel, fusedIp.getPixelValue(x + Math.round(iI.position[0]), y + Math.round(iI.position[1])));
                                if (imageType == 0 || imageType == 1) {
                                    fusedIp.putPixel(x + Math.round(iI.position[0]), y + Math.round(iI.position[1]), (int)((double)pixel + 0.5));
                                    continue;
                                }
                                fusedIp.putPixelValue(x + Math.round(iI.position[0]), y + Math.round(iI.position[1]), (double)pixel);
                                if (pixel > minmax[1]) {
                                    minmax[1] = pixel;
                                }
                                if (!(pixel < minmax[0])) continue;
                                minmax[0] = pixel;
                                continue;
                            }
                            if (type == 4) {
                                fusedIp.getPixel(x + Math.round(iI.position[0]), y + Math.round(iI.position[1]), pixelrgbimg);
                                if (imageType == 0) {
                                    if (count == 0) {
                                        pixelrgbimg[0] = Math.round(pixel);
                                    } else if (count == 1) {
                                        pixelrgbimg[1] = pixelrgbimg[2] = Math.round(pixel);
                                    }
                                } else if (imageType == 1) {
                                    if (count == 0) {
                                        pixelrgbimg[0] = Math.round(pixel / 256.0f);
                                    } else if (count == 1) {
                                        pixelrgbimg[1] = pixelrgbimg[2] = Math.round(pixel / 256.0f);
                                    }
                                } else if (count == 0) {
                                    pixelrgbimg[0] = Math.round((pixel - minmax[0]) / (minmax[1] - minmax[0]) * 255.0f);
                                } else if (count == 1) {
                                    pixelrgbimg[1] = pixelrgbimg[2] = Math.round((pixel - minmax[0]) / (minmax[1] - minmax[0]) * 255.0f);
                                }
                                fusedIp.putPixel(x + Math.round(iI.position[0]), y + Math.round(iI.position[1]), pixelrgbimg);
                                continue;
                            }
                            if (type != 5) continue;
                            fusedIp.putPixelValue(x + Math.round(iI.position[0]), y + Math.round(iI.position[1]), (double)pixel);
                        }
                    }
                }
                if (iI.closeAtEnd) {
                    imp.close();
                }
                if (type == 2 && imageType == 2) {
                    fusedImp.getProcessor().setMinAndMax((double)minmax[0], (double)minmax[1]);
                }
                if (showOutput) {
                    fusedImp.updateAndDraw();
                }
                fusedImp.setTitle(name + " - " + ++count / imageInformationList.size() + "%");
            }
        } else {
            final AtomicInteger ai = new AtomicInteger(0);
            final AtomicInteger progress = new AtomicInteger(1);
            Thread[] threads = CommonFunctions.newThreads();
            final int numThreads = threads.length;
            for (ImageInformation iI : imageInformationList) {
                iI.tmp = iI.imp == null ? CommonFunctions.loadImage("", iI.imageName, iI.seriesNumber, rgbOrder) : iI.imp;
                cal = Stitch_Image_Collection.updateCalibration(cal, iI.imp.getCalibration());
                iI.imageStack = iI.tmp.getStack().getImageArray();
                iI.w = iI.tmp.getStack().getWidth();
                iI.h = iI.tmp.getStack().getHeight();
                iI.d = iI.tmp.getStack().getSize();
            }
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(new Runnable(){

                    /*
                     * Exception decompiling
                     */
                    @Override
                    public void run() {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[MONITOR]], but top level block is 26[SIMPLE_IF_ELSE]
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                });
            }
            CommonFunctions.startAndJoin(threads);
            for (ImageInformation iI : imageInformationList) {
                if (iI.closeAtEnd) {
                    iI.tmp.close();
                }
                iI.tmp = null;
                iI.imageStack = null;
            }
        }
        if (imageType == 2) {
            fusedImp.getProcessor().setMinAndMax((double)minmax[0], (double)minmax[1]);
        }
        fusedImp.setTitle(name);
        fusedImp.updateAndDraw();
        if (cal != null) {
            fusedImp.setCalibration(cal);
        }
        return fusedImp;
    }

    protected static Calibration updateCalibration(Calibration cal, Calibration newOne) {
        if (cal == null) {
            cal = newOne.copy();
        } else if (!cal.equals(newOne)) {
            Log.error("Calibration mismatch: ");
            Log.error("  First   image: " + cal.toString());
            Log.error("  Current image: " + newOne.toString());
        }
        return cal;
    }

    private static final void computeLinearWeights(ImageInformation[] indices, int num, int[] pos, float[] weights, int[] minDistance, double alpha) {
        int i;
        if (num == 1) {
            weights[0] = 1.0f;
            return;
        }
        float sumInverseWeights = 0.0f;
        for (i = 0; i < num; ++i) {
            ImageInformation iI = indices[i];
            minDistance[i] = 1;
            for (int dim = 0; dim < iI.dim; ++dim) {
                int localImgPos = pos[dim] - Math.round(iI.position[dim]);
                int value = Math.min(localImgPos, Math.round(iI.size[dim]) - localImgPos - 1) + 1;
                int n = i;
                minDistance[n] = minDistance[n] * value;
            }
            int n = i;
            minDistance[n] = minDistance[n] + 1;
            weights[i] = (float)Math.pow(minDistance[i], alpha);
            sumInverseWeights += weights[i];
        }
        i = 0;
        while (i < num) {
            int n = i++;
            weights[n] = weights[n] / sumInverseWeights;
        }
    }

    private static final int avg(int[][] values, int channel, float[] weights, int num) {
        if (num == 0) {
            return 0;
        }
        double avg = 0.0;
        for (int i = 0; i < num; ++i) {
            avg += (double)((float)values[i][channel] * weights[i]);
        }
        return (int)(avg + 0.5);
    }

    private static final float avg(float[] values, float[] weights, int num) {
        if (num == 0) {
            return 0.0f;
        }
        double avg = 0.0;
        for (int i = 0; i < num; ++i) {
            avg += (double)(values[i] * weights[i]);
        }
        return (float)avg;
    }

    private static final int avg(int[][] values, int channel, int num) {
        if (num == 0) {
            return 0;
        }
        double avg = 0.0;
        for (int i = 0; i < num; ++i) {
            avg += (double)values[i][channel];
        }
        return (int)(avg / (double)num + 0.5);
    }

    private static final float avg(float[] values, int num) {
        if (num == 0) {
            return 0.0f;
        }
        double avg = 0.0;
        for (int i = 0; i < num; ++i) {
            avg += (double)values[i];
        }
        return (float)(avg / (double)num);
    }

    private static final int getMin(int[][] values, int channel, int num) {
        if (num == 0) {
            return 0;
        }
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < num; ++i) {
            if (values[i][channel] >= min) continue;
            min = values[i][channel];
        }
        return min;
    }

    private static final float getMin(float[] values, int num) {
        if (num == 0) {
            return 0.0f;
        }
        float min = values[0];
        for (int i = 0; i < num; ++i) {
            if (!(values[i] < min)) continue;
            min = values[i];
        }
        return min;
    }

    private static final int round(float value) {
        return (int)(value + 0.5f * Math.signum(value));
    }

    private static final int getImagesAtCoordinate(ArrayList<ImageInformation> imageInformationList, ImageInformation[] indices, int[] pos) {
        int num = 0;
        for (ImageInformation iI : imageInformationList) {
            boolean isInside = true;
            for (int dim = 0; dim < iI.dim && isInside; ++dim) {
                if (pos[dim] >= Stitch_Image_Collection.round(iI.position[dim]) && pos[dim] < Stitch_Image_Collection.round(iI.position[dim] + iI.size[dim])) continue;
                isInside = false;
            }
            if (!isInside) continue;
            indices[num++] = iI;
        }
        return num;
    }

    protected static float[] getAndApplyMinMax(ArrayList<ImageInformation> imageInformationList, int dim) {
        int i;
        float[] min = new float[dim];
        float[] max = new float[dim];
        for (int i2 = 0; i2 < min.length; ++i2) {
            min[i2] = Float.MAX_VALUE;
            max[i2] = Float.MIN_VALUE;
        }
        for (ImageInformation iI : imageInformationList) {
            for (i = 0; i < min.length; ++i) {
                if (iI.position[i] < min[i]) {
                    min[i] = iI.position[i];
                }
                if (!(iI.position[i] + iI.size[i] > max[i])) continue;
                max[i] = iI.position[i] + iI.size[i];
            }
        }
        for (ImageInformation iI : imageInformationList) {
            for (i = 0; i < min.length; ++i) {
                int n = i;
                iI.position[n] = iI.position[n] - min[i];
            }
        }
        for (int i3 = 0; i3 < min.length; ++i3) {
            int n = i3;
            max[n] = max[n] - min[i3];
            min[i3] = 0.0f;
        }
        return max;
    }

    private ArrayList<ImageInformation> optimize(ArrayList<OverlapProperties> overlappingTiles, ImageInformation firstImage) {
        TileConfiguration tc;
        boolean redo;
        do {
            redo = false;
            ArrayList<Tile> tiles = new ArrayList<Tile>();
            for (OverlapProperties o : overlappingTiles) {
                Point p2;
                Point p1;
                if (o.R < this.thresholdR) {
                    o.validOverlap = false;
                }
                if (!o.validOverlap) continue;
                Iterator<ArrayList<Tile>> t1 = o.i1;
                ImageInformation t2 = o.i2;
                if (this.dim == 3) {
                    p1 = new Point(new float[]{0.0f, 0.0f, 0.0f});
                    p2 = new Point(new float[]{o.translation3D.x, o.translation3D.y, o.translation3D.z});
                } else {
                    p1 = new Point(new float[]{0.0f, 0.0f});
                    p2 = new Point(new float[]{o.translation2D.x, o.translation2D.y});
                }
                ((Tile)((Object)t1)).addMatch(new PointMatch(p2, p1, (float)o.R, o));
                t2.addMatch(new PointMatch(p1, p2, (float)o.R, o));
                ((Tile)((Object)t1)).addConnectedTile(t2);
                t2.addConnectedTile((Tile)((Object)t1));
                if (!tiles.contains(t1)) {
                    tiles.add((Tile)((Object)t1));
                }
                if (tiles.contains(t2)) continue;
                tiles.add(t2);
            }
            Log.info("Tile size: " + tiles.size());
            if (tiles.size() == 0) {
                Log.error("Error: No correlated tiles found, setting the first tile to (0,0,0).");
                for (int d = 0; d < firstImage.position.length; ++d) {
                    firstImage.position[d] = 0.0f;
                }
                ArrayList<ImageInformation> imageInformationList = new ArrayList<ImageInformation>();
                imageInformationList.add(firstImage);
                Log.info(" image information list size =" + imageInformationList.size());
                return imageInformationList;
            }
            ArrayList<ArrayList<Tile>> graphs = Tile.identifyConnectedGraphs(tiles);
            Log.info("Number of tile graphs = " + graphs.size());
            ArrayList<Object> largestGraph = new ArrayList();
            for (ArrayList<Tile> graph : graphs) {
                if (graph.size() <= largestGraph.size()) continue;
                largestGraph = graph;
            }
            for (ArrayList<Tile> graph : graphs) {
                if (graph == largestGraph) continue;
                tiles.removeAll(graph);
            }
            tc = new TileConfiguration();
            tc.addTiles(tiles);
            tc.fixTile(tiles.get(0));
            try {
                tc.optimize(10.0f, 10000, 200);
                double avgError = tc.getAvgError();
                double maxError = tc.getMaxError();
                if (!(avgError * this.thresholdDisplacementRelative < maxError && maxError > 0.75) && !(avgError > this.thresholdDisplacementAbsolute)) continue;
                Log.info("maxError more than " + this.thresholdDisplacementRelative + " times bigger than avgerror.");
                Tile worstTile = tc.getWorstError();
                ArrayList<PointMatch> matches = worstTile.getMatches();
                float longestDisplacement = Float.MIN_VALUE;
                PointMatch worstMatch = null;
                for (PointMatch p : matches) {
                    if (!(p.getDistance() > longestDisplacement)) continue;
                    longestDisplacement = p.getDistance();
                    worstMatch = p;
                }
                Log.info("Identified link between " + worstMatch.o.i1.imageName + " and " + worstMatch.o.i2.imageName + " (R=" + worstMatch.o.R + ") to be bad. Reoptimizing.");
                worstMatch.o.validOverlap = false;
                redo = true;
                for (Tile t : tiles) {
                    t.resetTile();
                }
            }
            catch (NotEnoughDataPointsException e) {
                Log.error(e);
            }
        } while (redo);
        ArrayList<ImageInformation> imageInformationList = new ArrayList<ImageInformation>();
        for (Tile t : tc.getTiles()) {
            ((ImageInformation)t).position = this.dim == 3 ? (float[])((TranslationModel3D)t.getModel()).getTranslation().clone() : (float[])((TranslationModel2D)t.getModel()).getTranslation().clone();
            imageInformationList.add((ImageInformation)t);
        }
        Collections.sort(imageInformationList);
        Log.info(" image information list size =" + imageInformationList.size());
        return imageInformationList;
    }

    private void computePhaseCorrelations(ArrayList<OverlapProperties> overlappingTiles, String handleRGB) {
        for (OverlapProperties o : overlappingTiles) {
            Object stitch;
            ImagePlus imp2;
            ImagePlus imp1;
            if (o.i1.imp == null) {
                imp1 = CommonFunctions.loadImage("", o.i1.imageName, o.i1.seriesNumber, this.rgbOrder);
                o.i1.closeAtEnd = true;
            } else {
                imp1 = o.i1.imp;
            }
            if (o.i2.imp == null) {
                imp2 = CommonFunctions.loadImage("", o.i2.imageName, o.i2.seriesNumber, this.rgbOrder);
                o.i2.closeAtEnd = true;
            } else {
                imp2 = o.i2.imp;
            }
            this.setROI(imp1, o.i1, o.i2);
            this.setROI(imp2, o.i2, o.i1);
            if (this.dim == 3) {
                stitch = new Stitching_3D();
                ((Stitching_3D)stitch).checkPeaks = 5;
                ((Stitching_3D)stitch).coregister = false;
                ((Stitching_3D)stitch).fusedImageName = "Fused " + imp1.getTitle() + " " + imp2.getTitle();
                ((Stitching_3D)stitch).fuseImages = false;
                ((Stitching_3D)stitch).handleRGB1 = handleRGB;
                ((Stitching_3D)stitch).handleRGB2 = handleRGB;
                ((Stitching_3D)stitch).imgStack1 = imp1.getTitle();
                ((Stitching_3D)stitch).imgStack2 = imp2.getTitle();
                ((Stitching_3D)stitch).imp1 = imp1;
                ((Stitching_3D)stitch).imp2 = imp2;
                ((Stitching_3D)stitch).doLogging = false;
                ((Stitching_3D)stitch).computeOverlap = true;
                try {
                    ((Stitching_3D)stitch).work();
                    o.R = ((Stitching_3D)stitch).getCrossCorrelationResult().R;
                    o.translation3D = ((Stitching_3D)stitch).getTranslation();
                }
                catch (Exception e) {
                    o.R = -1.0;
                    o.translation3D = new Point3D(0, 0, 0);
                }
                Log.info(o.i1.id + " overlaps " + o.i2.id + ": " + o.R + " translation: " + o.translation3D);
                continue;
            }
            if (this.dim == 2) {
                stitch = new Stitching_2D();
                ((Stitching_2D)stitch).checkPeaks = 5;
                ((Stitching_2D)stitch).fusedImageName = "Fused " + imp1.getTitle() + " " + imp2.getTitle();
                ((Stitching_2D)stitch).fuseImages = false;
                ((Stitching_2D)stitch).handleRGB1 = handleRGB;
                ((Stitching_2D)stitch).handleRGB2 = handleRGB;
                ((Stitching_2D)stitch).image1 = imp1.getTitle();
                ((Stitching_2D)stitch).image2 = imp2.getTitle();
                ImageProcessor ip1 = imp1.getProcessor().duplicate();
                IJ.run((ImagePlus)imp1, (String)"Enhance Contrast", (String)"saturated=0.1 normalize");
                ((Stitching_2D)stitch).imp1 = imp1;
                ImageProcessor ip2 = imp2.getProcessor().duplicate();
                IJ.run((ImagePlus)imp2, (String)"Enhance Contrast", (String)"saturated=0.1 normalize");
                ((Stitching_2D)stitch).imp2 = imp2;
                ((Stitching_2D)stitch).doLogging = false;
                ((Stitching_2D)stitch).computeOverlap = true;
                try {
                    ((Stitching_2D)stitch).work();
                    o.R = ((Stitching_2D)stitch).getCrossCorrelationResult().R;
                    o.translation2D = ((Stitching_2D)stitch).getTranslation();
                }
                catch (Exception e) {
                    o.R = -1.0;
                    o.translation2D = new Point2D(0, 0);
                }
                imp1.setProcessor(imp1.getTitle(), ip1);
                imp2.setProcessor(imp2.getTitle(), ip2);
                Log.info(o.i1.id + " overlaps " + o.i2.id + ": " + o.R + " translation: " + o.translation2D);
                continue;
            }
            IJ.error((String)("Dimensionality of images: " + this.dim + " is not supported yet."));
            return;
        }
    }

    private void setROI(ImagePlus imp, ImageInformation i1, ImageInformation i2) {
        int[] start = new int[2];
        int[] end = new int[2];
        for (int dim = 0; dim < 2; ++dim) {
            if (i2.offset[dim] >= i1.offset[dim] && i2.offset[dim] <= i1.offset[dim] + i1.size[dim]) {
                start[dim] = Math.round(i2.offset[dim] - i1.offset[dim]);
                if (i2.offset[dim] + i2.size[dim] <= i1.offset[dim] + i1.size[dim]) {
                    end[dim] = Math.round(i2.offset[dim] + i2.size[dim] - i1.offset[dim]);
                    continue;
                }
                end[dim] = Math.round(i1.size[dim]);
                continue;
            }
            if (i2.offset[dim] + i2.size[dim] <= i1.offset[dim] + i1.size[dim]) {
                start[dim] = 0;
                end[dim] = Math.round(i2.offset[dim] + i2.size[dim] - i1.offset[dim]);
                continue;
            }
            start[dim] = -1;
            end[dim] = -1;
        }
        imp.setRoi(new Rectangle(start[0], start[1], end[0] - start[0], end[1] - start[1]));
    }

    private ArrayList<OverlapProperties> findOverlappingTiles(ArrayList<ImageInformation> imageInformationList, boolean createPreview, String fusionMethod) {
        ZProjector zp = new ZProjector();
        int endX = 0;
        int endY = 0;
        int startX = 0;
        int startY = 0;
        int count = 0;
        for (ImageInformation iI : imageInformationList) {
            if (iI.imp == null) {
                iI.imp = CommonFunctions.loadImage("", iI.imageName, iI.seriesNumber, this.rgbOrder);
                iI.closeAtEnd = true;
            } else {
                iI.closeAtEnd = false;
            }
            if (iI.imp == null) {
                IJ.error((String)("Cannot load " + iI.imageName + " ignoring."));
                iI.invalid = true;
                continue;
            }
            if (iI.imp.getStackSize() > 1) {
                iI.size[0] = iI.imp.getWidth();
                iI.size[1] = iI.imp.getHeight();
                iI.size[2] = iI.imp.getStackSize();
            } else {
                iI.size[0] = iI.imp.getWidth();
                iI.size[1] = iI.imp.getHeight();
            }
            iI.imageType = iI.imp.getType();
            if (createPreview) {
                if (iI.imp.getStackSize() > 1) {
                    zp.setMethod(1);
                    zp.setImage(iI.imp);
                    if (iI.imp.getType() == 4 || iI.imp.getType() == 3) {
                        zp.doRGBProjection();
                        iI.maxIntensity = zp.getProjection();
                        iI.maxIntensity.setProcessor(iI.maxIntensity.getTitle(), iI.maxIntensity.getProcessor().convertToFloat());
                    } else {
                        zp.doProjection();
                        iI.maxIntensity = zp.getProjection();
                        iI.maxIntensity.setProcessor(iI.maxIntensity.getTitle(), iI.maxIntensity.getProcessor().convertToFloat());
                    }
                } else {
                    iI.maxIntensity = new ImagePlus(iI.imp.getTitle(), iI.imp.getProcessor().convertToFloat());
                }
                if (count++ == 0) {
                    startX = Math.round(iI.offset[0]);
                    startY = Math.round(iI.offset[1]);
                    endX = startX + iI.maxIntensity.getWidth();
                    endY = startY + iI.maxIntensity.getHeight();
                } else {
                    if (Math.round(iI.offset[0]) < startX) {
                        startX = Math.round(iI.offset[0]);
                    }
                    if (Math.round(iI.offset[1]) < startY) {
                        startY = Math.round(iI.offset[1]);
                    }
                    if (Math.round(iI.offset[0]) + iI.maxIntensity.getWidth() > endX) {
                        endX = Math.round(iI.offset[0]) + iI.maxIntensity.getWidth();
                    }
                    if (Math.round(iI.offset[1]) + iI.maxIntensity.getHeight() > endY) {
                        endY = Math.round(iI.offset[1]) + iI.maxIntensity.getHeight();
                    }
                }
            }
            if (!fusionMethod.equals(CommonFunctions.methodListCollection[2]) || !iI.closeAtEnd) continue;
            iI.imp.close();
        }
        int i = 0;
        while (i < imageInformationList.size()) {
            ImageInformation iI;
            iI = imageInformationList.get(i);
            if (iI.invalid) {
                imageInformationList.remove(i);
                Log.info("Removed: " + iI.imageName);
                continue;
            }
            ++i;
        }
        ArrayList<OverlapProperties> overlappingTiles = new ArrayList<OverlapProperties>();
        for (int i2 = 0; i2 < imageInformationList.size() - 1; ++i2) {
            for (int j = i2 + 1; j < imageInformationList.size(); ++j) {
                ImageInformation i1 = imageInformationList.get(i2);
                ImageInformation i22 = imageInformationList.get(j);
                boolean overlapping = true;
                for (int dim = 0; dim < i1.dim; ++dim) {
                    if (i22.offset[dim] >= i1.offset[dim] && i22.offset[dim] <= i1.offset[dim] + i1.size[dim] || i22.offset[dim] + i22.size[dim] >= i1.offset[dim] && i22.offset[dim] + i22.size[dim] <= i1.offset[dim] + i1.size[dim] || i22.offset[dim] <= i1.offset[dim] && i22.offset[dim] >= i1.offset[dim] + i1.size[dim]) continue;
                    overlapping = false;
                }
                if (!overlapping) continue;
                OverlapProperties o = new OverlapProperties();
                o.i1 = i1;
                o.i2 = i22;
                overlappingTiles.add(o);
                i1.overlaps = true;
                i22.overlaps = true;
            }
        }
        if (createPreview) {
            Log.debug("startX: " + startX + " startY: " + startY);
            Log.debug("endX: " + endX + " endY: " + endY);
            FloatProcessor out = new FloatProcessor(endX - startX, endY - startY);
            for (ImageInformation iI : imageInformationList) {
                FloatProcessor fp = (FloatProcessor)iI.maxIntensity.getProcessor();
                for (int y = 0; y < fp.getHeight(); ++y) {
                    for (int x = 0; x < fp.getWidth(); ++x) {
                        float newValue = fp.getPixelValue(x, y);
                        float oldValue = out.getPixelValue(x - startX + Math.round(iI.offset[0]), y - startY + Math.round(iI.offset[1]));
                        out.putPixelValue(x - startX + Math.round(iI.offset[0]), y - startY + Math.round(iI.offset[1]), (double)Math.max(newValue, oldValue));
                    }
                }
            }
            ImagePlus preview = new ImagePlus("Preview", (ImageProcessor)out);
            preview.getProcessor().resetMinAndMax();
            preview.show();
        }
        return overlappingTiles;
    }

    private ArrayList<ImageInformation> readLayoutFile(String fileName) {
        ArrayList<ImageInformation> imageInformationList = new ArrayList<ImageInformation>();
        try {
            BufferedReader in = Stitch_Image_Collection.openFileRead(fileName);
            int lineNo = 0;
            while (in.ready()) {
                String[] entries;
                String line = in.readLine().trim();
                ++lineNo;
                if (line.startsWith("#") || line.length() <= 3) continue;
                if (line.startsWith("dim")) {
                    entries = line.split("=");
                    if (entries.length != 2) {
                        Log.error("Stitch_Many_Cubes.readLayoutFile: Line " + lineNo + " does not look like [ dim = n ]: " + line);
                        IJ.error((String)("Stitch_Many_Cubes.readLayoutFile: Line " + lineNo + " does not look like [ dim = n ]: " + line));
                        return null;
                    }
                    try {
                        this.dim = Integer.parseInt(entries[1].trim());
                        continue;
                    }
                    catch (NumberFormatException e) {
                        Log.error("Stitch_Many_Cubes.readLayoutFile: Line " + lineNo + ": Cannot parse dimensionality: " + entries[1].trim());
                        IJ.error((String)("Stitch_Many_Cubes.readLayoutFile: Line " + lineNo + ": Cannot parse dimensionality: " + entries[1].trim()));
                        return null;
                    }
                }
                if (this.dim < 0) {
                    Log.error("Stitch_Many_Cubes.readLayoutFile: Line " + lineNo + ": Header missing, should look like [dim = n], but first line is: " + line);
                    IJ.error((String)("Stitch_Many_Cubes.readLayoutFile: Line " + lineNo + ": Header missing, should look like [dim = n], but first line is: " + line));
                    return null;
                }
                if (this.dim < 2 || this.dim > 3) {
                    Log.error("Stitch_Many_Cubes.readLayoutFile: Line " + lineNo + ": only dimensions of 2 and 3 are supported: " + line);
                    IJ.error((String)("Stitch_Many_Cubes.readLayoutFile: Line " + lineNo + ": only dimensions of 2 and 3 are supported: " + line));
                    return null;
                }
                entries = line.split(";");
                if (entries.length != 3) {
                    Log.error("Stitch_Many_Cubes.readLayoutFile: Line " + lineNo + " does not have 3 entries! [fileName; ImagePlus; (x,y,...)]");
                    IJ.error((String)("Stitch_Many_Cubes.readLayoutFile: Line " + lineNo + " does not have 3 entries! [fileName; ImagePlus; (x,y,...)]"));
                    return null;
                }
                String imageName = entries[0].trim();
                String imp = entries[1].trim();
                if (imageName.length() == 0 && imp.length() == 0) {
                    Log.error("Stitch_Many_Cubes.readLayoutFile: Line " + lineNo + ": You have to give a filename or a ImagePlus [fileName; ImagePlus; (x,y,...)]: " + line);
                    IJ.error((String)("Stitch_Many_Cubes.readLayoutFile: Line " + lineNo + ": You have to give a filename or a ImagePlus [fileName; ImagePlus; (x,y,...)]: " + line));
                    return null;
                }
                String point = entries[2].trim();
                if (!point.startsWith("(") || !point.endsWith(")")) {
                    Log.error("Stitch_Many_Cubes.readLayoutFile: Line " + lineNo + ": Wrong format of coordinates: (x,y,...): " + point);
                    IJ.error((String)("Stitch_Many_Cubes.readLayoutFile: Line " + lineNo + ": Wrong format of coordinates: (x,y,...): " + point));
                    return null;
                }
                String[] points = (point = point.substring(1, point.length() - 1)).split(",");
                if (points.length != this.dim) {
                    Log.error("Stitch_Many_Cubes.readLayoutFile: Line " + lineNo + ": Wrong format of coordinates: (x,y,z,..), dim = " + this.dim + ": " + point);
                    IJ.error((String)("Stitch_Many_Cubes.readLayoutFile: Line " + lineNo + ": Wrong format of coordinates: (x,y,z,...), dim = " + this.dim + ": " + point));
                    return null;
                }
                ImageInformation imageInformation = this.dim == 3 ? new ImageInformation(this.dim, imageInformationList.size(), (Model)new TranslationModel3D()) : new ImageInformation(this.dim, imageInformationList.size(), (Model)new TranslationModel2D());
                imageInformation.imageName = imageName;
                if (imageInformation.imageName.contains("(((") && imageInformation.imageName.contains(")))")) {
                    int index1 = imageInformation.imageName.indexOf("(((");
                    int index2 = imageInformation.imageName.indexOf(")))");
                    String seriesString = imageInformation.imageName.substring(index1 + 3, index2);
                    imageInformation.seriesNumber = Integer.parseInt(seriesString);
                    imageInformation.imageName = imageInformation.imageName.substring(0, index1);
                }
                imageInformation.imp = imp.length() > 0 ? WindowManager.getImage((String)imp) : null;
                if (imageInformation.imp == null && imp.length() > 0) {
                    Log.error("Stitch_Many_Cubes.readLayoutFile: Line " + lineNo + ": Cannot find ImagePlus, is not opened: " + imp);
                    IJ.error((String)("Stitch_Many_Cubes.readLayoutFile: Line " + lineNo + ": Cannot find ImagePlus, is not opened: " + imp));
                    return null;
                }
                for (int i = 0; i < this.dim; ++i) {
                    try {
                        imageInformation.offset[i] = Float.parseFloat(points[i].trim());
                        imageInformation.position[i] = imageInformation.offset[i];
                        continue;
                    }
                    catch (NumberFormatException e) {
                        Log.error("Stitch_Many_Cubes.readLayoutFile: Line " + lineNo + ": Cannot parse number: " + points[i].trim());
                        IJ.error((String)("Stitch_Many_Cubes.readLayoutFile: Line " + lineNo + ": Cannot parse number: " + points[i].trim()));
                        return null;
                    }
                }
                imageInformationList.add(imageInformation);
            }
        }
        catch (IOException e) {
            Log.error("Stitch_Many_Cubes.readLayoutFile: " + e);
            IJ.error((String)("Stitch_Many_Cubes.readLayoutFile: " + e));
            return null;
        }
        return imageInformationList;
    }

    public static BufferedReader openFileRead(String fileName) {
        BufferedReader inputFile;
        try {
            inputFile = new BufferedReader(new FileReader(fileName));
        }
        catch (IOException e) {
            Log.error("Stitch_Many_Cubes.openFileRead(): " + e);
            inputFile = null;
        }
        return inputFile;
    }

    static /* synthetic */ int access$000(ArrayList x0, ImageInformation[] x1, int[] x2) {
        return Stitch_Image_Collection.getImagesAtCoordinate(x0, x1, x2);
    }

    static /* synthetic */ int access$100(int[][] x0, int x1, int x2) {
        return Stitch_Image_Collection.getMin(x0, x1, x2);
    }

    static /* synthetic */ float access$200(float[] x0, int x1) {
        return Stitch_Image_Collection.getMin(x0, x1);
    }

    static /* synthetic */ int access$300(int[][] x0, int x1, int x2) {
        return Stitch_Image_Collection.avg(x0, x1, x2);
    }

    static /* synthetic */ float access$400(float[] x0, int x1) {
        return Stitch_Image_Collection.avg(x0, x1);
    }

    static /* synthetic */ void access$500(ImageInformation[] x0, int x1, int[] x2, float[] x3, int[] x4, double x5) {
        Stitch_Image_Collection.computeLinearWeights(x0, x1, x2, x3, x4, x5);
    }

    static /* synthetic */ int access$600(int[][] x0, int x1, float[] x2, int x3) {
        return Stitch_Image_Collection.avg(x0, x1, x2, x3);
    }

    static /* synthetic */ float access$700(float[] x0, float[] x1, int x2) {
        return Stitch_Image_Collection.avg(x0, x1, x2);
    }
}

