/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.stitching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.Tile;
import mpicbg.models.TranslationModel2D;
import mpicbg.models.TranslationModel3D;
import mpicbg.stitching.ComparePair;
import mpicbg.stitching.ImagePlusTimePoint;
import mpicbg.stitching.PointMatchStitching;
import mpicbg.stitching.StitchingParameters;
import mpicbg.stitching.TileConfigurationStitching;
import stitching.utils.Log;

public class GlobalOptimization {
    public static boolean ignoreZ = false;

    public static ArrayList<ImagePlusTimePoint> optimize(Vector<ComparePair> pairs, ImagePlusTimePoint fixedImage, StitchingParameters params) {
        TileConfigurationStitching tc;
        boolean redo;
        do {
            redo = false;
            ArrayList<ImagePlusTimePoint> tiles = new ArrayList<ImagePlusTimePoint>();
            for (ComparePair pair : pairs) {
                if ((double)pair.getCrossCorrelation() >= params.regThreshold && pair.getIsValidOverlap()) {
                    Point p2;
                    Point p1;
                    ImagePlusTimePoint t1 = pair.getTile1();
                    ImagePlusTimePoint t2 = pair.getTile2();
                    if (params.dimensionality == 3) {
                        p1 = new Point(new double[]{0.0, 0.0, 0.0});
                        p2 = ignoreZ ? new Point(new double[]{-pair.getRelativeShift()[0], -pair.getRelativeShift()[1], 0.0}) : new Point(new double[]{-pair.getRelativeShift()[0], -pair.getRelativeShift()[1], -pair.getRelativeShift()[2]});
                    } else {
                        p1 = new Point(new double[]{0.0, 0.0});
                        p2 = new Point(new double[]{-pair.getRelativeShift()[0], -pair.getRelativeShift()[1]});
                    }
                    t1.addMatch(new PointMatchStitching(p1, p2, pair.getCrossCorrelation(), pair));
                    t2.addMatch(new PointMatchStitching(p2, p1, pair.getCrossCorrelation(), pair));
                    t1.addConnectedTile(t2);
                    t2.addConnectedTile(t1);
                    if (!tiles.contains(t1)) {
                        tiles.add(t1);
                    }
                    if (!tiles.contains(t2)) {
                        tiles.add(t2);
                    }
                    pair.setIsValidOverlap(true);
                    continue;
                }
                pair.setIsValidOverlap(false);
            }
            if (tiles.size() == 0) {
                TranslationModel3D model;
                if (params.dimensionality == 3) {
                    Log.error("Error: No correlated tiles found, setting the first tile to (0, 0, 0).");
                    model = (TranslationModel3D)fixedImage.getModel();
                    model.set(0.0, 0.0, 0.0);
                } else {
                    Log.error("Error: No correlated tiles found, setting the first tile to (0, 0).");
                    model = (TranslationModel2D)fixedImage.getModel();
                    model.set(0.0, 0.0);
                }
                ArrayList<ImagePlusTimePoint> imageInformationList = new ArrayList<ImagePlusTimePoint>();
                imageInformationList.add(fixedImage);
                Log.info(" number of tiles = " + imageInformationList.size());
                return imageInformationList;
            }
            tc = new TileConfigurationStitching();
            tc.addTiles(tiles);
            if (fixedImage.getConnectedTiles().size() > 0) {
                tc.fixTile(fixedImage);
            } else {
                for (int i = 0; i < tiles.size(); ++i) {
                    if (((Tile)tiles.get(i)).getConnectedTiles().size() <= 0) continue;
                    tc.fixTile((Tile)tiles.get(i));
                    break;
                }
            }
            try {
                tc.preAlign();
                tc.optimize(10.0, 1000, 200);
                double avgError = tc.getError();
                double maxError = tc.getMaxError();
                if (!(avgError * params.relativeThreshold < maxError && maxError > 0.95) && !(avgError > params.absoluteThreshold)) continue;
                double longestDisplacement = 0.0;
                PointMatch worstMatch = null;
                for (Tile t : tc.getTiles()) {
                    for (PointMatch p : t.getMatches()) {
                        if (!(p.getDistance() > longestDisplacement)) continue;
                        longestDisplacement = p.getDistance();
                        worstMatch = p;
                    }
                }
                ComparePair pair = ((PointMatchStitching)worstMatch).getPair();
                Log.info("Identified link between " + pair.getImagePlus1().getTitle() + "[" + pair.getTile1().getTimePoint() + "] and " + pair.getImagePlus2().getTitle() + "[" + pair.getTile2().getTimePoint() + "] (R=" + pair.getCrossCorrelation() + ") to be bad. Reoptimizing.");
                ((PointMatchStitching)worstMatch).getPair().setIsValidOverlap(false);
                redo = true;
                for (Tile tile : tiles) {
                    tile.getConnectedTiles().clear();
                    tile.getMatches().clear();
                }
            }
            catch (Exception e) {
                Log.error("Cannot compute global optimization: " + e, e);
            }
        } while (redo);
        ArrayList<ImagePlusTimePoint> imageInformationList = new ArrayList<ImagePlusTimePoint>();
        for (Tile t : tc.getTiles()) {
            imageInformationList.add((ImagePlusTimePoint)t);
        }
        Collections.sort(imageInformationList);
        return imageInformationList;
    }
}

