/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.stitching.fusion;

import net.imglib2.EuclideanSpace;
import net.imglib2.RandomAccessible;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.img.Img;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;

public class ImageInterpolation<T extends RealType<T>> {
    final Img<T> image;
    final RealRandomAccessible<T> interpolated;
    final InterpolatorFactory<T, RandomAccessible<T>> interpolatorFactory;

    public ImageInterpolation(Img<T> image, InterpolatorFactory<T, RandomAccessible<T>> interpolatorFactory, boolean mirror) {
        this.image = image;
        this.interpolatorFactory = interpolatorFactory;
        this.interpolated = mirror ? Views.interpolate((EuclideanSpace)Views.extendMirrorSingle(image), interpolatorFactory) : Views.interpolate((EuclideanSpace)Views.extendZero(image), interpolatorFactory);
    }

    public Img<T> getImg() {
        return this.image;
    }

    public RealRandomAccess<T> createInterpolator() {
        return this.interpolated.realRandomAccess();
    }
}

