/*
 * Decompiled with CFR 0.152.
 */
package stitching;

import edu.mines.jtk.dsp.FftComplex;
import edu.mines.jtk.dsp.FftReal;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.MultiLineLabel;
import ij.io.Opener;
import ij.plugin.BrowserLauncher;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import loci.formats.ChannelSeparator;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.meta.MetadataRetrieve;
import ome.units.quantity.Length;
import stitching.FloatArray2D;
import stitching.FloatArray3D;
import stitching.Quicksortable;
import stitching.utils.Log;

public class CommonFunctions {
    public static String[] methodList = new String[]{"Average", "Linear Blending", "Max. Intensity", "Min. Intensity", "Red-Cyan Overlay"};
    public static final int AVG = 0;
    public static final int LIN_BLEND = 1;
    public static final int MAX = 2;
    public static final int MIN = 3;
    public static final int RED_CYAN = 4;
    public static final int NONE = 5;
    public static String[] methodListCollection = new String[]{"Average", "Linear Blending", "Max. Intensity", "Min. Intensity", "None"};
    public static String[] rgbTypes = new String[]{"rgb", "rbg", "grb", "gbr", "brg", "bgr"};
    public static String[] colorList = new String[]{"Red", "Green", "Blue", "Red and Green", "Red and Blue", "Green and Blue", "Red, Green and Blue"};
    public static String[] fusionMethodList = new String[]{"Linear Blending", "Average", "Median", "Max. Intensity", "Min. Intensity", "Intensity of random input tile", "Overlay into composite image", "Do not fuse images"};
    public static String[] fusionMethodListSimple = new String[]{"Overlay into composite image", "Do not fuse images"};
    public static String[] fusionMethodListGrid = new String[]{"Linear Blending", "Average", "Median", "Max. Intensity", "Min. Intensity", "Intensity of random input tile", "Do not fuse images (only write TileConfiguration)"};
    public static String[] timeSelect = new String[]{"Apply registration of first time-point to all other time-points", "Register images adjacently over time", "Register all images over all time-points globally (expensive!)"};
    public static String[] cpuMemSelect = new String[]{"Save memory (but be slower)", "Save computation time (but use more RAM)"};

    public static ImagePlus loadImage(String directory, String file, int seriesNumber) {
        return CommonFunctions.loadImage(directory, file, seriesNumber, "rgb");
    }

    public static ImagePlus loadImage(String directory, String file, int seriesNumber, String rgb) {
        ImagePlus imp = null;
        String smallFile = file.toLowerCase();
        if (smallFile.endsWith("tif") || smallFile.endsWith("tiff") || smallFile.endsWith("jpg") || smallFile.endsWith("png") || smallFile.endsWith("bmp") || smallFile.endsWith("gif") || smallFile.endsWith("jpeg")) {
            imp = new Opener().openImage(new File(directory, file).getPath());
        } else {
            imp = CommonFunctions.openLOCIImagePlus(directory, file, seriesNumber, rgb);
            if (imp == null) {
                imp = new Opener().openImage(new File(directory, file).getPath());
            }
        }
        return imp;
    }

    public static final void addHyperLinkListener(final MultiLineLabel text, final String myURL) {
        if (text != null && myURL != null) {
            text.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        BrowserLauncher.openURL((String)myURL);
                    }
                    catch (Exception ex) {
                        IJ.error((String)("" + ex));
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    text.setForeground(Color.BLUE);
                    text.setCursor(new Cursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    text.setForeground(Color.BLACK);
                    text.setCursor(new Cursor(0));
                }
            });
        }
    }

    public static ImagePlus openLOCIImagePlus(String path, String fileName, int seriesNumber, String rgb) {
        return CommonFunctions.openLOCIImagePlus(path, fileName, seriesNumber, rgb, -1, -1);
    }

    public static ImagePlus openLOCIImagePlus(String path, String fileName, int seriesNumber) {
        return CommonFunctions.openLOCIImagePlus(path, fileName, seriesNumber, "rgb", -1, -1);
    }

    public static ImagePlus openLOCIImagePlus(String path, String fileName, int seriesNumber, String rgb, int from, int to) {
        int i;
        if (path.length() > 1 && !(path = path.replace('\\', '/')).endsWith("/")) {
            path = path + "/";
        }
        rgb = rgb.toLowerCase().trim();
        int[][] colorAssign = new int[rgb.length()][];
        int[] colorWeight = new int[3];
        for (i = 0; i < colorAssign.length; ++i) {
            if (rgb.charAt(i) == 'r') {
                colorAssign[i] = new int[1];
                colorAssign[i][0] = 0;
                colorWeight[0] = colorWeight[0] + 1;
                continue;
            }
            if (rgb.charAt(i) == 'b') {
                colorAssign[i] = new int[1];
                colorAssign[i][0] = 2;
                colorWeight[2] = colorWeight[2] + 1;
                continue;
            }
            if (rgb.charAt(i) == 'g') {
                colorAssign[i] = new int[1];
                colorAssign[i][0] = 1;
                colorWeight[1] = colorWeight[1] + 1;
                continue;
            }
            colorAssign[i] = new int[0];
        }
        for (i = 0; i < colorWeight.length; ++i) {
            if (colorWeight[i] != 0) continue;
            colorWeight[i] = 1;
        }
        ImagePlus imp = null;
        String id = path + fileName;
        ChannelSeparator r = new ChannelSeparator();
        try {
            int end;
            int start;
            int channels;
            r.setId(id);
            if (seriesNumber >= 0) {
                r.setSeries(seriesNumber);
            }
            int width = r.getSizeX();
            int height = r.getSizeY();
            int depth = r.getSizeZ();
            int timepoints = r.getSizeT();
            int pixelType = r.getPixelType();
            int bytesPerPixel = FormatTools.getBytesPerPixel((int)pixelType);
            String pixelTypeString = FormatTools.getPixelTypeString((int)pixelType);
            if (timepoints > 1) {
                Log.warn("More than one timepoint. Not implemented yet. Returning first timepoint");
            }
            if (r.getSizeC() > 3) {
                Log.warn("More than three channels. ImageJ supports only 3 channels, returning the first three channels.");
                channels = 3;
            } else {
                channels = r.getSizeC();
            }
            if (pixelType != 1 && pixelType != 3) {
                Log.error("PixelType " + pixelTypeString + " not supported yet, returning. ");
                return null;
            }
            if (from < 0 || to < 0 || to < from) {
                start = 0;
                end = depth;
            } else {
                start = from;
                end = to > depth ? depth : to;
            }
            ImageStack stack = new ImageStack(width, height);
            boolean t = false;
            for (int z = start; z < end; ++z) {
                int c;
                int x;
                int y;
                byte[][] b = new byte[channels][width * height * bytesPerPixel];
                for (int c2 = 0; c2 < channels; ++c2) {
                    int index = r.getIndex(z, c2, 0);
                    r.openBytes(index, b[c2]);
                }
                if (channels == 1) {
                    if (pixelType == 1) {
                        ByteProcessor bp = new ByteProcessor(width, height, b[0], null);
                        stack.addSlice("" + (z + 1), (ImageProcessor)bp);
                        continue;
                    }
                    if (pixelType != 3) continue;
                    short[] data = new short[width * height];
                    for (int i2 = 0; i2 < data.length; ++i2) {
                        data[i2] = CommonFunctions.getShortValue(b[0], i2 * 2);
                    }
                    ShortProcessor sp = new ShortProcessor(width, height, data, null);
                    stack.addSlice("" + (z + 1), (ImageProcessor)sp);
                    continue;
                }
                ColorProcessor cp = new ColorProcessor(width, height);
                int[] color = new int[3];
                if (pixelType == 1) {
                    for (y = 0; y < height; ++y) {
                        for (x = 0; x < width; ++x) {
                            color[2] = 0;
                            color[1] = 0;
                            color[0] = 0;
                            for (c = 0; c < channels; ++c) {
                                for (int e = 0; e < colorAssign[c].length; ++e) {
                                    int n = colorAssign[c][e];
                                    color[n] = color[n] + (b[c][x + y * width] & 0xFF);
                                }
                            }
                            color[0] = color[0] / colorWeight[0];
                            color[1] = color[1] / colorWeight[1];
                            color[2] = color[2] / colorWeight[2];
                            cp.putPixel(x, y, color);
                        }
                    }
                } else if (pixelType == 3) {
                    for (y = 0; y < height; ++y) {
                        for (x = 0; x < width; ++x) {
                            color[2] = 0;
                            color[1] = 0;
                            color[0] = 0;
                            for (c = 0; c < channels; ++c) {
                                color[c] = (byte)(CommonFunctions.getShortValue(b[c], 2 * (x + y * width)) / 256);
                            }
                            cp.putPixel(x, y, color);
                        }
                    }
                }
                stack.addSlice("" + (z + 1), (ImageProcessor)cp);
            }
            imp = new ImagePlus(fileName, stack);
        }
        catch (IOException exc) {
            IJ.handleException((Throwable)exc);
            return null;
        }
        catch (FormatException exc) {
            IJ.handleException((Throwable)exc);
            return null;
        }
        return imp;
    }

    private static final short getShortValue(byte[] b, int i) {
        return (short)CommonFunctions.getShortValueInt(b, i);
    }

    private static final int getShortValueInt(byte[] b, int i) {
        return ((b[i] & 0xFF) << 8) + (b[i + 1] & 0xFF);
    }

    public static float getPixelValueRGB(int rgb, int rgbType) {
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        if (rgbType == 0) {
            return r;
        }
        if (rgbType == 1) {
            return g;
        }
        if (rgbType == 2) {
            return b;
        }
        if (rgbType == 3) {
            return (float)(r + g) / 2.0f;
        }
        if (rgbType == 4) {
            return (float)(r + b) / 2.0f;
        }
        if (rgbType == 5) {
            return (float)(g + b) / 2.0f;
        }
        return (float)(r + g + b) / 3.0f;
    }

    public static FloatArray3D zeroPad(FloatArray3D ip, int width, int height, int depth) {
        FloatArray3D image = new FloatArray3D(width, height, depth);
        int offsetX = (width - ip.width) / 2;
        int offsetY = (height - ip.height) / 2;
        int offsetZ = (depth - ip.depth) / 2;
        if (offsetX < 0) {
            IJ.error((String)("Stitching_3D.ZeroPad(): Zero-Padding size in X smaller than image! " + width + " < " + ip.width));
            return null;
        }
        if (offsetY < 0) {
            IJ.error((String)("Stitching_3D.ZeroPad(): Zero-Padding size in Y smaller than image! " + height + " < " + ip.height));
            return null;
        }
        if (offsetZ < 0) {
            IJ.error((String)("Stitching_3D.ZeroPad(): Zero-Padding size in Z smaller than image! " + depth + " < " + ip.depth));
            return null;
        }
        for (int z = 0; z < ip.depth; ++z) {
            for (int y = 0; y < ip.height; ++y) {
                for (int x = 0; x < ip.width; ++x) {
                    image.set(ip.get(x, y, z), x + offsetX, y + offsetY, z + offsetZ);
                }
            }
        }
        return image;
    }

    public static FloatArray3D[] zeroPadImages(FloatArray3D img1, FloatArray3D img2) {
        int width = Math.max(img1.width, img2.width);
        int height = Math.max(img1.height, img2.height);
        int depth = Math.max(img1.depth, img2.depth);
        int widthFFT = FftReal.nfftFast((int)width);
        int heightFFT = FftComplex.nfftFast((int)height);
        int depthFFT = FftComplex.nfftFast((int)depth);
        FloatArray3D[] result = new FloatArray3D[2];
        result[0] = CommonFunctions.zeroPad(img1, widthFFT, heightFFT, depthFFT);
        img1.data = null;
        result[1] = CommonFunctions.zeroPad(img2, widthFFT, heightFFT, depthFFT);
        img2.data = null;
        return result;
    }

    public static FloatArray2D zeroPad(FloatArray2D ip, int width, int height) {
        FloatArray2D image = new FloatArray2D(width, height);
        int offsetX = (width - ip.width) / 2;
        int offsetY = (height - ip.height) / 2;
        if (offsetX < 0) {
            IJ.error((String)("Stitching_3D.ZeroPad(): Zero-Padding size in X smaller than image! " + width + " < " + ip.width));
            return null;
        }
        if (offsetY < 0) {
            IJ.error((String)("Stitching_3D.ZeroPad(): Zero-Padding size in Y smaller than image! " + height + " < " + ip.height));
            return null;
        }
        for (int y = 0; y < ip.height; ++y) {
            for (int x = 0; x < ip.width; ++x) {
                image.set(ip.get(x, y), x + offsetX, y + offsetY);
            }
        }
        return image;
    }

    public static FloatArray2D[] zeroPadImages(FloatArray2D img1, FloatArray2D img2) {
        int width = Math.max(img1.width, img2.width);
        int height = Math.max(img1.height, img2.height);
        int widthFFT = FftReal.nfftFast((int)width);
        int heightFFT = FftComplex.nfftFast((int)height);
        FloatArray2D[] result = new FloatArray2D[2];
        result[0] = CommonFunctions.zeroPad(img1, widthFFT, heightFFT);
        img1.data = null;
        img1 = null;
        result[1] = CommonFunctions.zeroPad(img2, widthFFT, heightFFT);
        img2.data = null;
        img2 = null;
        return result;
    }

    public static void quicksort(Quicksortable[] data, int left, int right) {
        if (data == null || data.length < 2) {
            return;
        }
        int i = left;
        int j = right;
        double x = data[(left + right) / 2].getQuicksortValue();
        while (true) {
            if (data[i].getQuicksortValue() < x) {
                ++i;
                continue;
            }
            while (x < data[j].getQuicksortValue()) {
                --j;
            }
            if (i <= j) {
                Quicksortable temp = data[i];
                data[i] = data[j];
                data[j] = temp;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (left < j) {
            CommonFunctions.quicksort(data, left, j);
        }
        if (i < right) {
            CommonFunctions.quicksort(data, i, right);
        }
    }

    public static FloatArray2D pffft2D(FloatArray2D values, boolean scale) {
        int x;
        float[] tempOut;
        int height = values.height;
        int width = values.width;
        int complexWidth = (width / 2 + 1) * 2;
        FloatArray2D result = new FloatArray2D(complexWidth, height);
        float[] tempIn = new float[width];
        FftReal fft = new FftReal(width);
        for (int y = 0; y < height; ++y) {
            tempOut = new float[complexWidth];
            for (x = 0; x < width; ++x) {
                tempIn[x] = values.get(x, y);
            }
            fft.realToComplex(-1, tempIn, tempOut);
            if (scale) {
                fft.scale(width, tempOut);
            }
            for (x = 0; x < complexWidth; ++x) {
                result.set(tempOut[x], x, y);
            }
        }
        tempIn = new float[height * 2];
        FftComplex fftc = new FftComplex(height);
        for (x = 0; x < complexWidth / 2; ++x) {
            int y;
            tempOut = new float[height * 2];
            for (y = 0; y < height; ++y) {
                tempIn[y * 2] = result.get(x * 2, y);
                tempIn[y * 2 + 1] = result.get(x * 2 + 1, y);
            }
            fftc.complexToComplex(-1, tempIn, tempOut);
            for (y = 0; y < height; ++y) {
                result.set(tempOut[y * 2], x * 2, y);
                result.set(tempOut[y * 2 + 1], x * 2 + 1, y);
            }
        }
        return result;
    }

    public static FloatArray2D pffftInv2D(FloatArray2D values, int nfft) {
        int y;
        float[] tempOut;
        int height = values.height;
        int width = nfft;
        int complexWidth = (width / 2 + 1) * 2;
        FloatArray2D result = new FloatArray2D(width, height);
        float[] tempIn = new float[height * 2];
        FftComplex fftc = new FftComplex(height);
        for (int x = 0; x < complexWidth / 2; ++x) {
            tempOut = new float[height * 2];
            for (y = 0; y < height; ++y) {
                tempIn[y * 2] = values.get(x * 2, y);
                tempIn[y * 2 + 1] = values.get(x * 2 + 1, y);
            }
            fftc.complexToComplex(1, tempIn, tempOut);
            for (y = 0; y < height; ++y) {
                values.set(tempOut[y * 2], x * 2, y);
                values.set(tempOut[y * 2 + 1], x * 2 + 1, y);
            }
        }
        tempIn = new float[complexWidth];
        FftReal fft = new FftReal(width);
        for (y = 0; y < height; ++y) {
            int x;
            tempOut = new float[width];
            for (x = 0; x < complexWidth; ++x) {
                tempIn[x] = values.get(x, y);
            }
            fft.complexToReal(1, tempIn, tempOut);
            fft.scale(width, tempOut);
            for (x = 0; x < width; ++x) {
                result.set(tempOut[x], x, y);
            }
        }
        return result;
    }

    public static FloatArray3D pffft3DMT(final FloatArray3D values, final boolean scale) {
        int ithread;
        final int height = values.height;
        final int width = values.width;
        final int depth = values.depth;
        final int complexWidth = (width / 2 + 1) * 2;
        final FloatArray3D result = new FloatArray3D(complexWidth, height, depth);
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = CommonFunctions.newThreads();
        final int numThreads = threads.length;
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    float[] tempIn = new float[width];
                    FftReal fft = new FftReal(width);
                    for (int z = 0; z < depth; ++z) {
                        if (z % numThreads != myNumber) continue;
                        for (int y = 0; y < height; ++y) {
                            int x;
                            float[] tempOut = new float[complexWidth];
                            for (x = 0; x < width; ++x) {
                                tempIn[x] = values.get(x, y, z);
                            }
                            fft.realToComplex(-1, tempIn, tempOut);
                            if (scale) {
                                fft.scale(width, tempOut);
                            }
                            for (x = 0; x < complexWidth; ++x) {
                                result.set(tempOut[x], x, y, z);
                            }
                        }
                    }
                }
            });
        }
        CommonFunctions.startAndJoin(threads);
        ai.set(0);
        threads = CommonFunctions.newThreads();
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    float[] tempIn = new float[height * 2];
                    FftComplex fftc = new FftComplex(height);
                    int myNumber = ai.getAndIncrement();
                    for (int z = 0; z < depth; ++z) {
                        if (z % numThreads != myNumber) continue;
                        for (int x = 0; x < complexWidth / 2; ++x) {
                            int y;
                            float[] tempOut = new float[height * 2];
                            for (y = 0; y < height; ++y) {
                                tempIn[y * 2] = result.get(x * 2, y, z);
                                tempIn[y * 2 + 1] = result.get(x * 2 + 1, y, z);
                            }
                            fftc.complexToComplex(-1, tempIn, tempOut);
                            for (y = 0; y < height; ++y) {
                                result.set(tempOut[y * 2], x * 2, y, z);
                                result.set(tempOut[y * 2 + 1], x * 2 + 1, y, z);
                            }
                        }
                    }
                }
            });
        }
        CommonFunctions.startAndJoin(threads);
        ai.set(0);
        threads = CommonFunctions.newThreads();
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    float[] tempIn = new float[depth * 2];
                    FftComplex fftc = new FftComplex(depth);
                    int myNumber = ai.getAndIncrement();
                    for (int y = 0; y < height; ++y) {
                        if (y % numThreads != myNumber) continue;
                        for (int x = 0; x < complexWidth / 2; ++x) {
                            int z;
                            float[] tempOut = new float[depth * 2];
                            for (z = 0; z < depth; ++z) {
                                tempIn[z * 2] = result.get(x * 2, y, z);
                                tempIn[z * 2 + 1] = result.get(x * 2 + 1, y, z);
                            }
                            fftc.complexToComplex(-1, tempIn, tempOut);
                            for (z = 0; z < depth; ++z) {
                                result.set(tempOut[z * 2], x * 2, y, z);
                                result.set(tempOut[z * 2 + 1], x * 2 + 1, y, z);
                            }
                        }
                    }
                }
            });
        }
        CommonFunctions.startAndJoin(threads);
        return result;
    }

    public static FloatArray2D computePhaseCorrelationMatrix(FloatArray2D fft1, FloatArray2D fft2, int width) {
        FloatArray2D pcm = new FloatArray2D(CommonFunctions.computePhaseCorrelationMatrix(fft1.data, fft2.data, false), fft1.width, fft1.height);
        fft2.data = null;
        fft1.data = null;
        fft2 = null;
        fft1 = null;
        FloatArray2D ipcm = CommonFunctions.pffftInv2D(pcm, width);
        pcm.data = null;
        pcm = null;
        return ipcm;
    }

    public static FloatArray2D computeFFT(FloatArray2D img) {
        FloatArray2D fft = CommonFunctions.pffft2D(img, false);
        return fft;
    }

    public static FloatArray3D computePhaseCorrelationMatrix(FloatArray3D fft1, FloatArray3D fft2, int width) {
        FloatArray3D pcm = new FloatArray3D(CommonFunctions.computePhaseCorrelationMatrix(fft1.data, fft2.data, false), fft1.width, fft1.height, fft1.depth);
        fft2.data = null;
        fft1.data = null;
        fft2 = null;
        fft1 = null;
        FloatArray3D ipcm = CommonFunctions.pffftInv3DMT(pcm, width);
        pcm.data = null;
        pcm = null;
        return ipcm;
    }

    public static FloatArray3D computeFFT(FloatArray3D img) {
        FloatArray3D fft = CommonFunctions.pffft3DMT(img, false);
        return fft;
    }

    public static float[] computePhaseCorrelationMatrix(float[] fft1, float[] fft2, boolean inPlace) {
        CommonFunctions.normalizeComplexVectorsToUnitVectors(fft1);
        CommonFunctions.normalizeComplexVectorsToUnitVectors(fft2);
        float[] fftTemp1 = fft1;
        float[] fftTemp2 = fft2;
        if (inPlace) {
            CommonFunctions.complexConjugate(fft2);
        } else {
            CommonFunctions.complexConjugate(fftTemp2);
        }
        if (inPlace) {
            CommonFunctions.multiply(fft1, fft2, true);
        } else {
            fftTemp1 = CommonFunctions.multiply(fftTemp1, fftTemp2, false);
        }
        return inPlace ? null : fftTemp1;
    }

    public static void normalizeComplexVectorsToUnitVectors(float[] complex) {
        int wComplex = complex.length / 2;
        for (int pos = 0; pos < wComplex; ++pos) {
            double length = Math.sqrt(Math.pow(complex[pos * 2], 2.0) + Math.pow(complex[pos * 2 + 1], 2.0));
            if (length > 1.0E-5) {
                int n = pos * 2 + 1;
                complex[n] = (float)((double)complex[n] / length);
                int n2 = pos * 2;
                complex[n2] = (float)((double)complex[n2] / length);
                continue;
            }
            complex[pos * 2] = 0.0f;
            complex[pos * 2 + 1] = 0.0f;
        }
    }

    public static void complexConjugate(float[] complex) {
        int wComplex = complex.length / 2;
        for (int pos = 0; pos < wComplex; ++pos) {
            complex[pos * 2 + 1] = -complex[pos * 2 + 1];
        }
    }

    public static float multiplyComplexReal(float a, float b, float c, float d) {
        return a * c - b * d;
    }

    public static float multiplyComplexImg(float a, float b, float c, float d) {
        return a * d + b * c;
    }

    public static float[] multiply(float[] complexA, float[] complexB, boolean overwriteA) {
        if (complexA.length != complexB.length) {
            return null;
        }
        float[] complexResult = null;
        if (!overwriteA) {
            complexResult = new float[complexA.length];
        }
        int wComplex = complexA.length / 2;
        if (!overwriteA) {
            for (int pos = 0; pos < wComplex; ++pos) {
                float a = complexA[pos * 2];
                float b = complexA[pos * 2 + 1];
                float c = complexB[pos * 2];
                float d = complexB[pos * 2 + 1];
                complexResult[pos * 2] = CommonFunctions.multiplyComplexReal(a, b, c, d);
                complexResult[pos * 2 + 1] = CommonFunctions.multiplyComplexImg(a, b, c, d);
            }
        } else {
            for (int pos = 0; pos < wComplex; ++pos) {
                float a = complexA[pos * 2];
                float b = complexA[pos * 2 + 1];
                float c = complexB[pos * 2];
                float d = complexB[pos * 2 + 1];
                complexA[pos * 2] = CommonFunctions.multiplyComplexReal(a, b, c, d);
                complexA[pos * 2 + 1] = CommonFunctions.multiplyComplexImg(a, b, c, d);
            }
        }
        if (overwriteA) {
            return complexA;
        }
        return complexResult;
    }

    public static FloatArray3D pffftInv3DMT(final FloatArray3D values, int nfft) {
        int ithread;
        final int depth = values.depth;
        final int height = values.height;
        final int width = nfft;
        final int complexWidth = (width / 2 + 1) * 2;
        final FloatArray3D result = new FloatArray3D(width, height, depth);
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = CommonFunctions.newThreads();
        final int numThreads = threads.length;
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    float[] tempIn = new float[depth * 2];
                    FftComplex fftc = new FftComplex(depth);
                    for (int y = 0; y < height; ++y) {
                        if (y % numThreads != myNumber) continue;
                        for (int x = 0; x < complexWidth / 2; ++x) {
                            int z;
                            float[] tempOut = new float[complexWidth];
                            tempOut = new float[depth * 2];
                            for (z = 0; z < depth; ++z) {
                                tempIn[z * 2] = values.get(x * 2, y, z);
                                tempIn[z * 2 + 1] = values.get(x * 2 + 1, y, z);
                            }
                            fftc.complexToComplex(1, tempIn, tempOut);
                            for (z = 0; z < depth; ++z) {
                                values.set(tempOut[z * 2], x * 2, y, z);
                                values.set(tempOut[z * 2 + 1], x * 2 + 1, y, z);
                            }
                        }
                    }
                }
            });
        }
        CommonFunctions.startAndJoin(threads);
        ai.set(0);
        threads = CommonFunctions.newThreads();
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    float[] tempIn = new float[height * 2];
                    FftComplex fftc = new FftComplex(height);
                    int myNumber = ai.getAndIncrement();
                    for (int z = 0; z < depth; ++z) {
                        if (z % numThreads != myNumber) continue;
                        for (int x = 0; x < complexWidth / 2; ++x) {
                            int y;
                            float[] tempOut = new float[height * 2];
                            for (y = 0; y < height; ++y) {
                                tempIn[y * 2] = values.get(x * 2, y, z);
                                tempIn[y * 2 + 1] = values.get(x * 2 + 1, y, z);
                            }
                            fftc.complexToComplex(1, tempIn, tempOut);
                            for (y = 0; y < height; ++y) {
                                values.set(tempOut[y * 2], x * 2, y, z);
                                values.set(tempOut[y * 2 + 1], x * 2 + 1, y, z);
                            }
                        }
                    }
                }
            });
        }
        CommonFunctions.startAndJoin(threads);
        ai.set(0);
        threads = CommonFunctions.newThreads();
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    float[] tempIn = new float[complexWidth];
                    FftReal fft = new FftReal(width);
                    int myNumber = ai.getAndIncrement();
                    for (int z = 0; z < depth; ++z) {
                        if (z % numThreads != myNumber) continue;
                        for (int y = 0; y < height; ++y) {
                            int x;
                            float[] tempOut = new float[width];
                            for (x = 0; x < complexWidth; ++x) {
                                tempIn[x] = values.get(x, y, z);
                            }
                            fft.complexToReal(1, tempIn, tempOut);
                            int i = 0;
                            while (i < tempOut.length) {
                                int n = i++;
                                tempOut[n] = tempOut[n] / (float)(width * height * depth);
                            }
                            for (x = 0; x < width; ++x) {
                                result.set(tempOut[x], x, y, z);
                            }
                        }
                    }
                }
            });
        }
        CommonFunctions.startAndJoin(threads);
        return result;
    }

    public static void startTask(Runnable run, int numThreads) {
        Thread[] threads = CommonFunctions.newThreads(numThreads);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(run);
        }
        CommonFunctions.startAndJoin(threads);
    }

    public static Thread[] newThreads() {
        int nthread = Runtime.getRuntime().availableProcessors();
        return new Thread[nthread];
    }

    public static Thread[] newThreads(int numThreads) {
        return new Thread[numThreads];
    }

    public static void startAndJoin(Thread[] threads) {
        int ithread;
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread].setPriority(5);
            threads[ithread].start();
        }
        try {
            for (ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread].join();
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public static final int[] getPixelMinRGB(Object[] imageStack, int width, int height, int depth, int x, int y, int z, double min) {
        int[] rgb = new int[3];
        if (x < 0 || y < 0 || z < 0 || x >= width || y >= height || z >= depth) {
            rgb[1] = rgb[2] = (int)min;
            rgb[0] = rgb[2];
            return rgb;
        }
        int[] pixelTmp = (int[])imageStack[z];
        int color = pixelTmp[x + y * width] & 0xFFFFFF;
        rgb[0] = (color & 0xFF0000) >> 16;
        rgb[1] = (color & 0xFF00) >> 8;
        rgb[2] = color & 0xFF;
        return rgb;
    }

    public static final float getPixelMin(int imageType, Object[] imageStack, int width, int height, int depth, int x, int y, int z, double min) {
        if (x < 0 || y < 0 || z < 0 || x >= width || y >= height || z >= depth) {
            return (float)min;
        }
        if (imageType == 0) {
            byte[] pixelTmp = (byte[])imageStack[z];
            return pixelTmp[x + y * width] & 0xFF;
        }
        if (imageType == 1) {
            short[] pixelTmp = (short[])imageStack[z];
            return pixelTmp[x + y * width] & 0xFFFF;
        }
        float[] pixelTmp = (float[])imageStack[z];
        return pixelTmp[x + y * width];
    }

    public static final double[] getPlanePosition(IFormatReader r, MetadataRetrieve retrieve, int series, int t) {
        return CommonFunctions.getPlanePosition(r, retrieve, series, t, false, false, false);
    }

    public static final double[] getPlanePosition(IFormatReader r, MetadataRetrieve retrieve, int series, int t, boolean invertX, boolean invertY, boolean ignoreZStage) {
        HashMap<Integer, Integer> planeMap = new HashMap<Integer, Integer>();
        int planeCount = retrieve.getPlaneCount(series);
        for (int p = 0; p < planeCount; ++p) {
            int theZ = (Integer)retrieve.getPlaneTheZ(series, p).getValue();
            int theC = (Integer)retrieve.getPlaneTheC(series, p).getValue();
            int theT = (Integer)retrieve.getPlaneTheT(series, p).getValue();
            int index = r.getIndex(theZ, theC, theT);
            planeMap.put(index, p);
        }
        int index = r.getIndex(0, 0, t);
        int planeIndex = planeMap.containsKey(index) ? (Integer)planeMap.get(index) : 0;
        boolean hasPlane = planeIndex < retrieve.getPlaneCount(series);
        Length stageLabelX = null;
        Length stageLabelY = null;
        Length stageLabelZ = null;
        try {
            stageLabelX = retrieve.getStageLabelX(series);
            stageLabelY = retrieve.getStageLabelY(series);
            stageLabelZ = retrieve.getStageLabelZ(series);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        double locationX = CommonFunctions.getPosition(hasPlane ? retrieve.getPlanePositionX(series, planeIndex) : null, stageLabelX, invertX);
        double locationY = CommonFunctions.getPosition(hasPlane ? retrieve.getPlanePositionY(series, planeIndex) : null, stageLabelY, invertY);
        double locationZ = ignoreZStage ? 0.0 : CommonFunctions.getPosition(hasPlane ? retrieve.getPlanePositionZ(series, planeIndex) : null, stageLabelZ, false);
        Log.debug("locationX:  " + locationX);
        Log.debug("locationY:  " + locationY);
        Log.debug("locationZ:  " + locationZ);
        return new double[]{locationX, locationY, locationZ};
    }

    private static double getPosition(Length planePos, Length stageLabel, boolean invert) {
        if (planePos != null) {
            return invert ? -planePos.value().doubleValue() : planePos.value().doubleValue();
        }
        if (stageLabel != null) {
            return invert ? -stageLabel.value().doubleValue() : stageLabel.value().doubleValue();
        }
        return 0.0;
    }
}

