/*
 * Decompiled with CFR 0.152.
 */
package tools;

import fiji.tool.AbstractTool;
import fiji.tool.ToolWithOptions;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.plugin.frame.RoiManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JList;

public class RoiPicker
extends AbstractTool
implements ActionListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
ToolWithOptions {
    private ImagePlus imp;
    private ImageCanvas canvas;
    private Set<Integer> roiSet;
    private List<Integer> roiIndices;
    int roiIndex;

    public void run(String arg) {
        super.run(arg);
    }

    public String getToolName() {
        return "Roi Picker";
    }

    public String getToolIcon() {
        return "Cee0P31f1ff3f31PC000P01785abc9678P";
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        ImageCanvas source = (ImageCanvas)e.getSource();
        if (source != this.canvas) {
            ImageWindow window = (ImageWindow)source.getParent();
            this.imp = window.getImagePlus();
            this.canvas = source;
        }
        double x = this.canvas.offScreenXD(e.getX());
        double y = this.canvas.offScreenYD(e.getY());
        RoiManager rm = RoiManager.getInstance();
        if (rm == null) {
            return;
        }
        Roi[] rois = rm.getRoisAsArray();
        int[] position = this.imp.convertIndexToPosition(this.imp.getCurrentSlice());
        HashSet<Integer> matchedSet = new HashSet<Integer>();
        ArrayList<Integer> matchedIndices = new ArrayList<Integer>();
        for (int i = 0; i < rois.length; ++i) {
            Roi r = rois[i];
            if (!this.containsPoint(r, position, x, y)) continue;
            Integer index = i;
            matchedSet.add(index);
            matchedIndices.add(index);
        }
        if (this.same(this.roiSet, matchedSet)) {
            this.incrementIndex();
        } else {
            this.roiSet = matchedSet;
            this.roiIndices = matchedIndices;
            this.roiIndex = this.roiIndices.size();
        }
        if (matchedIndices.size() > 0) {
            this.selectRois(rm);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
    }

    public void showOptionDialog() {
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    protected void handleRecording() {
    }

    public static void select(String style, String x1, String y1, String x2, String y2, String width, String headLength) {
    }

    private boolean same(Set<?> set1, Set<?> set2) {
        if (set1 == null || set2 == null) {
            return set1 == set2;
        }
        if (set1.size() != set2.size()) {
            return false;
        }
        for (Object r : set1) {
            if (set2.contains(r)) continue;
            return false;
        }
        return true;
    }

    private boolean containsPoint(Roi r, int[] position, double x, double y) {
        return r.getCPosition() == position[0] && r.getZPosition() == position[1] && r.getTPosition() == position[2] && r.contains((int)Math.floor(x), (int)Math.floor(y));
    }

    private void selectRois(RoiManager rm) {
        if (this.roiIndices.size() == 1) {
            rm.select(this.roiIndices.get(0).intValue());
            IJ.showStatus((String)"1 of 1 Rois selected.");
        } else if (this.roiIndex < this.roiIndices.size()) {
            rm.select(this.roiIndices.get(this.roiIndex).intValue());
            IJ.showStatus((String)(this.roiIndex + 1 + " of " + this.roiIndices.size() + " Rois selected. Click to cycle..."));
        } else {
            rm.select(this.roiIndices.get(0).intValue());
            for (int i = 1; i < this.roiIndices.size(); ++i) {
                rm.select(this.roiIndices.get(i).intValue(), true, false);
            }
            IJ.showStatus((String)(this.roiIndices.size() + " overlapping Rois. Click to cycle..."));
        }
        try {
            Field listField = RoiManager.class.getDeclaredField("list");
            listField.setAccessible(true);
            int scrollIndex = this.roiIndex == this.roiIndices.size() ? 0 : this.roiIndex;
            JList list = (JList)listField.get(rm);
            list.ensureIndexIsVisible(this.roiIndices.get(scrollIndex));
        }
        catch (SecurityException e) {
            IJ.error((String)"RoiPicker: SecurityException when updating RoiManager.");
        }
        catch (NoSuchFieldException e) {
            IJ.error((String)"RoiPicker: NoSuchFieldException when updating RoiManager.");
        }
        catch (IllegalArgumentException e) {
            IJ.error((String)"RoiPicker: IllegalArgumentException when updating RoiManager.");
        }
        catch (IllegalAccessException e) {
            IJ.error((String)"RoiPicker: IllegalAccessException when updating RoiManager.");
        }
    }

    private void incrementIndex() {
        this.roiIndex = (this.roiIndex + 1) % (this.roiIndices.size() + 1);
    }
}

