/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation.utils;

import java.util.concurrent.atomic.AtomicLong;
import trainableSegmentation.utils.Cursor2D;

public class PixelRecord
implements Comparable<PixelRecord> {
    private Cursor2D cursor = null;
    private double value = 0.0;
    private static final AtomicLong seq = new AtomicLong();
    private final long seqNum;

    public PixelRecord(Cursor2D cursor, double value) {
        this.cursor = cursor;
        this.value = value;
        this.seqNum = seq.getAndIncrement();
    }

    public PixelRecord(int x, int y, double value) {
        this.cursor = new Cursor2D(x, y);
        this.value = value;
        this.seqNum = seq.getAndIncrement();
    }

    public Cursor2D getCursor() {
        return this.cursor;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public int compareTo(PixelRecord v2) {
        int res = Double.compare(this.value, v2.value);
        if (res == 0) {
            res = this.seqNum < v2.seqNum ? -1 : 1;
        }
        return res;
    }
}

