/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.imageplus;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import net.imglib2.exception.ImgLibException;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.type.NativeType;
import net.imglib2.util.Fraction;

public class FloatImagePlus<T extends NativeType<T>>
extends ImagePlusImg<T, FloatArray> {
    final ImagePlus imp;

    public FloatImagePlus(long[] dim, Fraction entitiesPerPixel) {
        super(dim, entitiesPerPixel);
        if (entitiesPerPixel.getRatio() == 1.0) {
            ImageStack stack = new ImageStack(this.width, this.height);
            for (int i = 0; i < this.numSlices; ++i) {
                stack.addSlice("", (ImageProcessor)new FloatProcessor(this.width, this.height));
            }
            this.imp = new ImagePlus("image", stack);
            this.imp.setDimensions(this.channels, this.depth, this.frames);
            if (this.numSlices > 1) {
                this.imp.setOpenAsHyperStack(true);
            }
            this.mirror.clear();
            for (int t = 0; t < this.frames; ++t) {
                for (int z = 0; z < this.depth; ++z) {
                    for (int c = 0; c < this.channels; ++c) {
                        this.mirror.add(new FloatArray((float[])this.imp.getStack().getProcessor(this.imp.getStackIndex(c + 1, z + 1, t + 1)).getPixels()));
                    }
                }
            }
        } else {
            this.imp = null;
            this.mirror.clear();
            for (int i = 0; i < this.numSlices; ++i) {
                this.mirror.add(new FloatArray(this.numEntities(entitiesPerPixel)));
            }
        }
    }

    public FloatImagePlus(ImagePlus imp) {
        super(imp);
        this.imp = imp;
        this.mirror.clear();
        for (int t = 0; t < this.frames; ++t) {
            for (int z = 0; z < this.depth; ++z) {
                for (int c = 0; c < this.channels; ++c) {
                    this.mirror.add(new FloatArray((float[])imp.getStack().getProcessor(imp.getStackIndex(c + 1, z + 1, t + 1)).getPixels()));
                }
            }
        }
    }

    public void setPlane(int no, FloatArray plane) {
        System.arraycopy(plane.getCurrentStorageArray(), 0, ((FloatArray)this.mirror.get(no)).getCurrentStorageArray(), 0, plane.getCurrentStorageArray().length);
    }

    @Override
    public void close() {
        if (this.imp != null) {
            this.imp.close();
        }
    }

    @Override
    public ImagePlus getImagePlus() throws ImgLibException {
        if (this.imp == null) {
            throw new ImgLibException((Object)this, "has no ImagePlus instance, it is not a standard type of ImagePlus (" + this.entitiesPerPixel + " entities per pixel)");
        }
        return this.imp;
    }
}

