/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.vaa3d.reader;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.NewImage;
import ij.io.OpenDialog;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import org.janelia.vaa3d.reader.V3dRawImageStream;

public class Vaa3d_Reader
extends ImagePlus
implements PlugIn {
    public void run(String fileName) {
        URL url = this.getUrl(fileName);
        if (null == url) {
            return;
        }
        if (!this.parse(url)) {
            return;
        }
        if (null == fileName || 0 == fileName.trim().length()) {
            this.show();
        }
    }

    private URL getUrl(String arg) {
        File file = new File(arg);
        try {
            if (file.exists()) {
                return file.toURI().toURL();
            }
            URL url = new URL(arg);
            return url;
        }
        catch (MalformedURLException url) {
            if (!Interpreter.isBatchMode()) {
                OpenDialog od = new OpenDialog("Choose a .v3draw file", null);
                String dir = od.getDirectory();
                if (null == dir) {
                    return null;
                }
                file = new File(dir, od.getFileName());
                try {
                    if (file.exists()) {
                        return file.toURI().toURL();
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private boolean parse(URL url) {
        int c;
        V3dRawImageStream sliceStream;
        try {
            InputStream is = url.openStream();
            sliceStream = new V3dRawImageStream(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        int width = sliceStream.getDimension(0);
        int height = sliceStream.getDimension(1);
        int n_slices = sliceStream.getDimension(2);
        int n_channels = sliceStream.getDimension(3);
        int bytesPerPixel = sliceStream.getPixelBytes();
        if (!Interpreter.isBatchMode()) {
            IJ.showStatus((String)"Allocating volume memory...");
        }
        ImagePlus hyperStack = NewImage.createImage((String)new File(url.getPath()).getName(), (int)width, (int)height, (int)(n_channels * n_slices), (int)(8 * bytesPerPixel), (int)1);
        if (n_channels > 1) {
            hyperStack.setDimensions(n_channels, n_slices, 1);
            hyperStack = new CompositeImage(hyperStack, 1);
            hyperStack.setOpenAsHyperStack(true);
        }
        if (!Interpreter.isBatchMode()) {
            IJ.showStatus((String)"Loading volume...");
        }
        int nSlicePixels = width * height;
        double[] max = new double[n_channels];
        for (c = 0; c < n_channels; ++c) {
            max[c] = -1.7976931348623157E308;
            hyperStack.setC(c + 1);
            for (int z = 0; z < n_slices; ++z) {
                hyperStack.setZ(z + 1);
                try {
                    ByteProcessor ip;
                    sliceStream.loadNextSlice();
                    if (!Interpreter.isBatchMode()) {
                        IJ.showProgress((int)(c * n_slices + z), (int)(n_channels * n_slices));
                    }
                    ByteBuffer bb = sliceStream.getCurrentSlice().getByteBuffer();
                    bb.rewind();
                    switch (bytesPerPixel) {
                        case 1: {
                            ip = new ByteProcessor(width, height);
                            byte[] ar8 = new byte[nSlicePixels];
                            bb.get(ar8, 0, nSlicePixels);
                            ip.setPixels((Object)ar8);
                            break;
                        }
                        case 2: {
                            ip = new ShortProcessor(width, height);
                            short[] ar16 = new short[nSlicePixels];
                            bb.asShortBuffer().get(ar16);
                            ip.setPixels((Object)ar16);
                            break;
                        }
                        case 4: {
                            ip = new FloatProcessor(width, height);
                            float[] ar32 = new float[nSlicePixels];
                            bb.asFloatBuffer().get(ar32);
                            ip.setPixels((Object)ar32);
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    ip.resetMinAndMax();
                    if (ip.getMax() > max[c]) {
                        max[c] = ip.getMax();
                    }
                    hyperStack.setProcessor((ImageProcessor)ip);
                    continue;
                }
                catch (IOException exc) {
                    return false;
                }
            }
        }
        hyperStack.setC(1);
        hyperStack.setZ(1);
        if (!Interpreter.isBatchMode()) {
            IJ.showStatus((String)"Volume load complete.");
        }
        if (!Interpreter.isBatchMode()) {
            IJ.showProgress((double)1.0);
        }
        this.setImage(hyperStack);
        this.setTitle(hyperStack.getTitle());
        this.setCalibration(new Calibration((ImagePlus)this));
        for (c = 0; c < n_channels; ++c) {
            this.setC(c + 1);
            if (max[c] > 0.0) {
                this.setDisplayRange(0.0, max[c]);
                continue;
            }
            if (this.getBitDepth() > 8) {
                this.setDisplayRange(0.0, 4095.0);
                continue;
            }
            this.setDisplayRange(0.0, 255.0);
        }
        this.setC(1);
        this.setOpenAsHyperStack(true);
        return true;
    }
}

