/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import org.ojalgo.access.Structure2D;

public class Raw2D {
    public static void exchangeColumns(double[][] target, int columnA, int columnB) {
        int tmpLength = target.length;
        for (int i = 0; i < tmpLength; ++i) {
            double tmpElem = target[i][columnA];
            target[i][columnA] = target[i][columnB];
            target[i][columnB] = tmpElem;
        }
    }

    public static void exchangeRows(double[][] target, int rowA, int rowB) {
        double[] tmpRow = target[rowA];
        target[rowA] = target[rowB];
        target[rowB] = tmpRow;
    }

    public static void fillAll(double[][] target, double value) {
        int tmpLength = target.length;
        for (int i = 0; i < tmpLength; ++i) {
            int tmpInnerLength = target[i].length;
            for (int j = 0; j < tmpInnerLength; ++j) {
                target[i][j] = value;
            }
        }
    }

    public static void fillAll(double[][] target, DoubleSupplier supplier) {
        int tmpLength = target.length;
        for (int i = 0; i < tmpLength; ++i) {
            int tmpInnerLength = target[i].length;
            for (int j = 0; j < tmpInnerLength; ++j) {
                target[i][j] = supplier.getAsDouble();
            }
        }
    }

    public static void fillColumn(double[][] target, int row, int column, double value) {
        int tmpLength = target.length;
        for (int i = row; i < tmpLength; ++i) {
            target[i][column] = value;
        }
    }

    public static void fillColumn(double[][] target, int row, int column, DoubleSupplier supplier) {
        int tmpLength = target.length;
        for (int i = row; i < tmpLength; ++i) {
            target[i][column] = supplier.getAsDouble();
        }
    }

    public static void fillDiagonal(double[][] target, int row, int column, double value) {
        int tmpLength = target.length;
        int ij = 0;
        while (row + ij < tmpLength && column + ij < target[row + ij].length) {
            target[row + ij][column + ij] = value;
            ++ij;
        }
    }

    public static void fillDiagonal(double[][] target, int row, int column, DoubleSupplier supplier) {
        int tmpLength = target.length;
        int ij = 0;
        while (row + ij < tmpLength && column + ij < target[row + ij].length) {
            target[row + ij][column + ij] = supplier.getAsDouble();
            ++ij;
        }
    }

    public static void fillMatching(double[][] target, double left, DoubleBinaryOperator function, double[][] right) {
        int tmpLength = target.length;
        for (int i = 0; i < tmpLength; ++i) {
            int tmpInnerLength = target[i].length;
            for (int j = 0; j < tmpInnerLength; ++j) {
                target[i][j] = function.applyAsDouble(left, right[i][j]);
            }
        }
    }

    public static void fillMatching(double[][] target, double[][] left, DoubleBinaryOperator function, double right) {
        int tmpLength = target.length;
        for (int i = 0; i < tmpLength; ++i) {
            int tmpInnerLength = target[i].length;
            for (int j = 0; j < tmpInnerLength; ++j) {
                target[i][j] = function.applyAsDouble(left[i][j], right);
            }
        }
    }

    public static void fillMatching(double[][] target, double[][] left, DoubleBinaryOperator function, double[][] right) {
        int tmpLength = target.length;
        for (int i = 0; i < tmpLength; ++i) {
            int tmpInnerLength = target[i].length;
            for (int j = 0; j < tmpInnerLength; ++j) {
                target[i][j] = function.applyAsDouble(left[i][j], right[i][j]);
            }
        }
    }

    public static void fillRange(double[][] target, int first, int limit, double value) {
        int tmpLength = target.length;
        for (int index = first; index < limit; ++index) {
            int tmpRow = Structure2D.row(index, tmpLength);
            int tmpColumn = Structure2D.column(index, tmpLength);
            target[tmpRow][tmpColumn] = value;
        }
    }

    public static void fillRange(double[][] target, int first, int limit, DoubleSupplier supplier) {
        int tmpLength = target.length;
        for (int index = first; index < limit; ++index) {
            int tmpRow = Structure2D.row(index, tmpLength);
            int tmpColumn = Structure2D.column(index, tmpLength);
            target[tmpRow][tmpColumn] = supplier.getAsDouble();
        }
    }

    public static void fillRow(double[][] target, int row, int column, double value) {
        int tmpLength = target[row].length;
        for (int j = column; j < tmpLength; ++j) {
            target[row][j] = value;
        }
    }

    public static void fillRow(double[][] target, int row, int column, DoubleSupplier supplier) {
        int tmpLength = target[row].length;
        for (int j = column; j < tmpLength; ++j) {
            target[row][j] = supplier.getAsDouble();
        }
    }

    public static void modifyAll(double[][] target, DoubleUnaryOperator function) {
        int tmpLength = target.length;
        for (int i = 0; i < tmpLength; ++i) {
            int tmpInnerLength = target[i].length;
            for (int j = 0; j < tmpInnerLength; ++j) {
                target[i][j] = function.applyAsDouble(target[i][j]);
            }
        }
    }

    public static void modifyColumn(double[][] target, int row, int column, DoubleUnaryOperator function) {
        int tmpLength = target.length;
        for (int i = row; i < tmpLength; ++i) {
            target[i][column] = function.applyAsDouble(target[i][column]);
        }
    }

    public static void modifyDiagonal(double[][] target, int row, int column, DoubleUnaryOperator function) {
        int tmpLength = target.length;
        int ij = 0;
        while (row + ij < tmpLength && column + ij < target[row + ij].length) {
            target[row + ij][column + ij] = function.applyAsDouble(target[row + ij][column + ij]);
            ++ij;
        }
    }

    public static void modifyRow(double[][] target, int row, int column, DoubleUnaryOperator function) {
        int tmpLength = target[row].length;
        for (int j = column; j < tmpLength; ++j) {
            target[row][j] = function.applyAsDouble(target[row][j]);
        }
    }

    public static void visitAll(double[][] target, DoubleConsumer visitor) {
        int tmpLength = target.length;
        for (int i = 0; i < tmpLength; ++i) {
            int tmpInnerLength = target[i].length;
            for (int j = 0; j < tmpInnerLength; ++j) {
                visitor.accept(target[i][j]);
            }
        }
    }

    public static void visitColumn(double[][] target, int row, int column, DoubleConsumer visitor) {
        int tmpLength = target[row].length;
        for (int j = column; j < tmpLength; ++j) {
            visitor.accept(target[row][j]);
        }
    }

    public static void visitDiagonal(double[][] target, int row, int column, DoubleConsumer visitor) {
        int tmpLength = target.length;
        int ij = 0;
        while (row + ij < tmpLength && column + ij < target[row + ij].length) {
            visitor.accept(target[row + ij][column + ij]);
            ++ij;
        }
    }

    public static void visitRange(double[][] target, int first, int limit, DoubleConsumer visitor) {
        int tmpStructure = target.length;
        for (int index = first; index < limit; ++index) {
            visitor.accept(target[Structure2D.row(index, tmpStructure)][Structure2D.column(index, tmpStructure)]);
        }
    }

    public static void visitRow(double[][] target, int row, int column, DoubleConsumer visitor) {
        int tmpLength = target.length;
        for (int i = row; i < tmpLength; ++i) {
            visitor.accept(target[i][column]);
        }
    }
}

