/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.multiary;

import org.ojalgo.access.Access1D;
import org.ojalgo.function.multiary.FirstOrderApproximation;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.function.multiary.SecondOrderApproximation;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.Scalar;

abstract class AbstractMultiary<N extends Number, F extends AbstractMultiary<N, ?>>
implements MultiaryFunction<N>,
MultiaryFunction.Constant<N, F>,
MultiaryFunction.TwiceDifferentiable<N> {
    private Scalar<N> myConstant = null;

    protected AbstractMultiary() {
    }

    @Override
    public final F constant(Number constant) {
        this.setConstant(constant);
        return (F)this;
    }

    @Override
    public final N getConstant() {
        return this.getScalarConstant().get();
    }

    @Override
    public Access1D<N> getLinearFactors() {
        return this.getGradient(this.factory().builder().makeZero(this.arity(), 1).get());
    }

    @Override
    public final void setConstant(Number constant) {
        this.myConstant = constant != null ? this.factory().scalar().convert(constant) : null;
    }

    @Override
    public final FirstOrderApproximation<N> toFirstOrderApproximation(Access1D<N> arg) {
        return new FirstOrderApproximation<N>(this, arg);
    }

    @Override
    public final SecondOrderApproximation<N> toSecondOrderApproximation(Access1D<N> arg) {
        return new SecondOrderApproximation<N>(this, arg);
    }

    protected abstract PhysicalStore.Factory<N, ?> factory();

    protected final Scalar<N> getScalarConstant() {
        return this.myConstant != null ? this.myConstant : this.factory().scalar().zero();
    }
}

