/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.AbstractMatrix;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.MatrixFactory;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.PrimitiveMatrix;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.GenericDenseStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.task.DeterminantTask;
import org.ojalgo.matrix.task.InverterTask;
import org.ojalgo.matrix.task.SolverTask;
import org.ojalgo.scalar.ComplexNumber;

public final class ComplexMatrix
extends AbstractMatrix<ComplexNumber, ComplexMatrix> {
    public static final BasicMatrix.Factory<ComplexMatrix> FACTORY = new MatrixFactory<ComplexNumber, ComplexMatrix>(ComplexMatrix.class, GenericDenseStore.COMPLEX);

    ComplexMatrix(MatrixStore<ComplexNumber> aStore) {
        super(aStore);
    }

    public PrimitiveMatrix getArgument() {
        return (PrimitiveMatrix)((MatrixFactory)PrimitiveMatrix.FACTORY).instantiate(MatrixUtils.getComplexArgument(this.getStore()));
    }

    public PrimitiveMatrix getImaginary() {
        return (PrimitiveMatrix)((MatrixFactory)PrimitiveMatrix.FACTORY).instantiate(MatrixUtils.getComplexImaginary(this.getStore()));
    }

    public PrimitiveMatrix getModulus() {
        return (PrimitiveMatrix)((MatrixFactory)PrimitiveMatrix.FACTORY).instantiate(MatrixUtils.getComplexModulus(this.getStore()));
    }

    public PrimitiveMatrix getReal() {
        return (PrimitiveMatrix)((MatrixFactory)PrimitiveMatrix.FACTORY).instantiate(MatrixUtils.getComplexReal(this.getStore()));
    }

    @Override
    ElementsSupplier<ComplexNumber> cast(Access1D<?> matrix) {
        if (matrix instanceof ComplexMatrix) {
            return ((ComplexMatrix)matrix).getStore();
        }
        if (matrix instanceof ComplexDenseStore) {
            return (ComplexDenseStore)matrix;
        }
        if (matrix instanceof ElementsSupplier && matrix.count() > 0L && matrix.get(0L) instanceof ComplexNumber) {
            return (ElementsSupplier)((Object)matrix);
        }
        if (matrix instanceof Access2D) {
            Access2D tmpAccess2D = (Access2D)matrix;
            return this.getStore().physical().builder().makeWrapper(tmpAccess2D);
        }
        return (ElementsSupplier)this.getStore().physical().columns(matrix);
    }

    @Override
    DeterminantTask<ComplexNumber> getDeterminantTask(MatrixStore<ComplexNumber> template) {
        return DeterminantTask.COMPLEX.make(template, this.isHermitian(), false);
    }

    @Override
    MatrixFactory<ComplexNumber, ComplexMatrix> getFactory() {
        return (MatrixFactory)FACTORY;
    }

    @Override
    InverterTask<ComplexNumber> getInverterTask(MatrixStore<ComplexNumber> base) {
        return InverterTask.COMPLEX.make(base, this.isHermitian(), false);
    }

    @Override
    SolverTask<ComplexNumber> getSolverTask(MatrixStore<ComplexNumber> templateBody, Access2D<?> templateRHS) {
        return SolverTask.COMPLEX.make(templateBody, templateRHS, this.isHermitian(), false);
    }
}

