/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.RecoverableCondition;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.array.blas.DOT;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.decomposition.LDL;
import org.ojalgo.matrix.decomposition.RawDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.RawStore;

final class RawLDL
extends RawDecomposition
implements LDL<Double> {
    private boolean mySPD = false;

    RawLDL() {
    }

    @Override
    public Double calculateDeterminant(Access2D<?> matrix) {
        double[][] retVal = this.reset(matrix, false);
        this.doDecompose(retVal, matrix);
        return this.getDeterminant();
    }

    @Override
    public boolean decompose(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix) {
        double[][] retVal = this.reset(matrix, false);
        RawStore tmpRawInPlaceStore = this.getRawInPlaceStore();
        matrix.supplyTo(tmpRawInPlaceStore);
        return this.doDecompose(retVal, tmpRawInPlaceStore);
    }

    @Override
    public MatrixStore<Double> getD() {
        return this.getRawInPlaceStore().logical().diagonal(false).get();
    }

    @Override
    public Double getDeterminant() {
        double[][] tmpData = this.getRawInPlaceData();
        double retVal = PrimitiveMath.ONE;
        for (int ij = 0; ij < tmpData.length; ++ij) {
            retVal *= tmpData[ij][ij];
        }
        return retVal;
    }

    @Override
    public MatrixStore<Double> getInverse() {
        int tmpRowDim = this.getRowDim();
        return this.doGetInverse(this.allocate(tmpRowDim, tmpRowDim));
    }

    @Override
    public MatrixStore<Double> getInverse(PhysicalStore<Double> preallocated) {
        return this.doGetInverse(preallocated);
    }

    @Override
    public MatrixStore<Double> getL() {
        RawStore tmpRawInPlaceStore = this.getRawInPlaceStore();
        MatrixStore.LogicalBuilder tmpBuilder = tmpRawInPlaceStore.logical();
        MatrixStore.LogicalBuilder tmpTriangular = tmpBuilder.triangular(false, true);
        return tmpTriangular.get();
    }

    @Override
    public int getRank() {
        return 0;
    }

    @Override
    public MatrixStore<Double> getSolution(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs) {
        PrimitiveDenseStore tmpPreallocated = this.allocate(rhs.countRows(), rhs.countColumns());
        return this.getSolution(rhs, tmpPreallocated);
    }

    @Override
    public MatrixStore<Double> getSolution(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs, PhysicalStore<Double> preallocated) {
        return this.doSolve(rhs, preallocated);
    }

    @Override
    public MatrixStore<Double> invert(Access2D<?> original, PhysicalStore<Double> preallocated) throws RecoverableCondition {
        double[][] retVal = this.reset(original, false);
        this.doDecompose(retVal, original);
        if (this.isSolvable()) {
            return this.getInverse(preallocated);
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public boolean isFullRank() {
        return this.getRank() == this.getMinDim();
    }

    public boolean isSPD() {
        return this.mySPD;
    }

    @Override
    public PhysicalStore<Double> preallocate(Structure2D template) {
        return this.allocate(template.countRows(), template.countRows());
    }

    @Override
    public PhysicalStore<Double> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.allocate(templateBody.countRows(), templateRHS.countColumns());
    }

    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs) throws RecoverableCondition {
        return this.solve(body, rhs, this.preallocate(body, rhs));
    }

    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> preallocated) throws RecoverableCondition {
        double[][] retVal = this.reset(body, false);
        this.doDecompose(retVal, body);
        if (this.isSolvable()) {
            return this.doSolve(MatrixStore.PRIMITIVE.makeWrapper(rhs), preallocated);
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    private boolean doDecompose(double[][] data, Access2D<?> input) {
        int tmpDiagDim = this.getRowDim();
        this.mySPD = this.getColDim() == tmpDiagDim;
        double[] tmpRowIJ = new double[tmpDiagDim];
        for (int ij = 0; ij < tmpDiagDim; ++ij) {
            double[] tmpRowI = data[ij];
            for (int j = 0; j < ij; ++j) {
                tmpRowIJ[j] = tmpRowI[j] * data[j][j];
            }
            tmpRowI[ij] = input.doubleValue(ij, ij) - DOT.invoke(tmpRowI, 0, tmpRowIJ, 0, 0, ij);
            double tmpD = tmpRowI[ij];
            this.mySPD &= tmpD > PrimitiveMath.ZERO;
            for (int i = ij + 1; i < tmpDiagDim; ++i) {
                tmpRowI = data[i];
                tmpRowI[ij] = (input.doubleValue(i, ij) - DOT.invoke(tmpRowI, 0, tmpRowIJ, 0, 0, ij)) / tmpD;
            }
        }
        return this.computed(true);
    }

    private MatrixStore<Double> doGetInverse(PhysicalStore<Double> preallocated) {
        preallocated.fillAll(PrimitiveMath.ZERO);
        preallocated.fillDiagonal(0L, 0L, PrimitiveMath.ONE);
        RawStore tmpBody = this.getRawInPlaceStore();
        preallocated.substituteForwards(tmpBody, true, false, true);
        int i = 0;
        while ((long)i < preallocated.countRows()) {
            preallocated.modifyRow(i, 0L, PrimitiveFunction.DIVIDE.second(tmpBody.doubleValue(i, i)));
            ++i;
        }
        preallocated.substituteBackwards(tmpBody, true, true, true);
        return preallocated;
    }

    private MatrixStore<Double> doSolve(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs, PhysicalStore<Double> preallocated) {
        rhs.supplyTo(preallocated);
        RawStore tmpBody = this.getRawInPlaceStore();
        preallocated.substituteForwards(tmpBody, true, false, false);
        int i = 0;
        while ((long)i < preallocated.countRows()) {
            preallocated.modifyRow(i, 0L, PrimitiveFunction.DIVIDE.second(tmpBody.doubleValue(i, i)));
            ++i;
        }
        preallocated.substituteBackwards(tmpBody, true, true, false);
        return preallocated;
    }

    @Override
    protected boolean checkSolvability() {
        return this.isComputed() && this.isSolvable();
    }
}

