/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.geometry;

import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.geometry.GeometryMatrix;
import org.ojalgo.matrix.geometry.Primitive32Vector3;
import org.ojalgo.matrix.geometry.Primitive32Vector4;
import org.ojalgo.matrix.transformation.TransformationMatrix;

public class Primitive32Matrix4
implements GeometryMatrix<Primitive32Matrix4>,
TransformationMatrix<Double, Primitive32Vector4> {
    public float m00;
    public float m10;
    public float m20;
    public float m30;
    public float m01;
    public float m11;
    public float m21;
    public float m31;
    public float m02;
    public float m12;
    public float m22;
    public float m32;
    public float m03;
    public float m13;
    public float m23;
    public float m33;

    public Primitive32Matrix4() {
    }

    public Primitive32Matrix4(float m00, float m10, float m20, float m30, float m01, float m11, float m21, float m31, float m02, float m12, float m22, float m32, float m03, float m13, float m23, float m33) {
        this.m00 = m00;
        this.m10 = m10;
        this.m20 = m20;
        this.m30 = m30;
        this.m01 = m01;
        this.m11 = m11;
        this.m21 = m21;
        this.m31 = m31;
        this.m02 = m02;
        this.m12 = m12;
        this.m22 = m22;
        this.m32 = m32;
        this.m03 = m03;
        this.m13 = m13;
        this.m23 = m23;
        this.m33 = m33;
    }

    @Override
    public final long countColumns() {
        return 4L;
    }

    @Override
    public final long countRows() {
        return 4L;
    }

    @Override
    public final double doubleValue(int row, int col) {
        switch (col) {
            case 0: {
                switch (row) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m10;
                    }
                    case 2: {
                        return this.m20;
                    }
                    case 3: {
                        return this.m30;
                    }
                }
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return this.m01;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m21;
                    }
                    case 3: {
                        return this.m31;
                    }
                }
            }
            case 2: {
                switch (row) {
                    case 0: {
                        return this.m02;
                    }
                    case 1: {
                        return this.m12;
                    }
                    case 2: {
                        return this.m22;
                    }
                    case 3: {
                        return this.m32;
                    }
                }
            }
            case 3: {
                switch (row) {
                    case 0: {
                        return this.m03;
                    }
                    case 1: {
                        return this.m13;
                    }
                    case 2: {
                        return this.m23;
                    }
                    case 3: {
                        return this.m33;
                    }
                }
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Primitive32Matrix4)) {
            return false;
        }
        Primitive32Matrix4 other = (Primitive32Matrix4)obj;
        if (Float.floatToIntBits(this.m00) != Float.floatToIntBits(other.m00)) {
            return false;
        }
        if (Float.floatToIntBits(this.m01) != Float.floatToIntBits(other.m01)) {
            return false;
        }
        if (Float.floatToIntBits(this.m02) != Float.floatToIntBits(other.m02)) {
            return false;
        }
        if (Float.floatToIntBits(this.m03) != Float.floatToIntBits(other.m03)) {
            return false;
        }
        if (Float.floatToIntBits(this.m10) != Float.floatToIntBits(other.m10)) {
            return false;
        }
        if (Float.floatToIntBits(this.m11) != Float.floatToIntBits(other.m11)) {
            return false;
        }
        if (Float.floatToIntBits(this.m12) != Float.floatToIntBits(other.m12)) {
            return false;
        }
        if (Float.floatToIntBits(this.m13) != Float.floatToIntBits(other.m13)) {
            return false;
        }
        if (Float.floatToIntBits(this.m20) != Float.floatToIntBits(other.m20)) {
            return false;
        }
        if (Float.floatToIntBits(this.m21) != Float.floatToIntBits(other.m21)) {
            return false;
        }
        if (Float.floatToIntBits(this.m22) != Float.floatToIntBits(other.m22)) {
            return false;
        }
        if (Float.floatToIntBits(this.m23) != Float.floatToIntBits(other.m23)) {
            return false;
        }
        if (Float.floatToIntBits(this.m30) != Float.floatToIntBits(other.m30)) {
            return false;
        }
        if (Float.floatToIntBits(this.m31) != Float.floatToIntBits(other.m31)) {
            return false;
        }
        if (Float.floatToIntBits(this.m32) != Float.floatToIntBits(other.m32)) {
            return false;
        }
        return Float.floatToIntBits(this.m33) == Float.floatToIntBits(other.m33);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.m00);
        result = 31 * result + Float.floatToIntBits(this.m01);
        result = 31 * result + Float.floatToIntBits(this.m02);
        result = 31 * result + Float.floatToIntBits(this.m03);
        result = 31 * result + Float.floatToIntBits(this.m10);
        result = 31 * result + Float.floatToIntBits(this.m11);
        result = 31 * result + Float.floatToIntBits(this.m12);
        result = 31 * result + Float.floatToIntBits(this.m13);
        result = 31 * result + Float.floatToIntBits(this.m20);
        result = 31 * result + Float.floatToIntBits(this.m21);
        result = 31 * result + Float.floatToIntBits(this.m22);
        result = 31 * result + Float.floatToIntBits(this.m23);
        result = 31 * result + Float.floatToIntBits(this.m30);
        result = 31 * result + Float.floatToIntBits(this.m31);
        result = 31 * result + Float.floatToIntBits(this.m32);
        result = 31 * result + Float.floatToIntBits(this.m33);
        return result;
    }

    public final void multiply(Primitive32Vector3 right, float right3, Primitive32Vector3 product) {
        float right0 = right.v0;
        float right1 = right.v1;
        float right2 = right.v2;
        product.v0 = this.m00 * right0 + this.m01 * right1 + this.m02 * right2 + this.m03 * right3;
        product.v1 = this.m10 * right0 + this.m11 * right1 + this.m12 * right2 + this.m13 * right3;
        product.v2 = this.m20 * right0 + this.m21 * right1 + this.m22 * right2 + this.m23 * right3;
    }

    public final void multiply(Primitive32Vector4 right, Primitive32Vector4 product) {
        float right0 = right.v0;
        float right1 = right.v1;
        float right2 = right.v2;
        float right3 = right.v3;
        product.v0 = this.m00 * right0 + this.m01 * right1 + this.m02 * right2 + this.m03 * right3;
        product.v1 = this.m10 * right0 + this.m11 * right1 + this.m12 * right2 + this.m13 * right3;
        product.v2 = this.m20 * right0 + this.m21 * right1 + this.m22 * right2 + this.m23 * right3;
        product.v3 = this.m30 * right0 + this.m31 * right1 + this.m32 * right2 + this.m33 * right3;
    }

    @Override
    public final void negate(Primitive32Matrix4 matrix) {
        this.m00 = -matrix.m00;
        this.m01 = -matrix.m01;
        this.m02 = -matrix.m02;
        this.m03 = -matrix.m03;
        this.m10 = -matrix.m10;
        this.m11 = -matrix.m11;
        this.m12 = -matrix.m12;
        this.m13 = -matrix.m13;
        this.m20 = -matrix.m20;
        this.m21 = -matrix.m21;
        this.m22 = -matrix.m22;
        this.m23 = -matrix.m23;
        this.m30 = -matrix.m30;
        this.m31 = -matrix.m31;
        this.m32 = -matrix.m32;
        this.m33 = -matrix.m33;
    }

    public final String toString() {
        return Access2D.toString(this);
    }

    public final void transform(Primitive32Vector3 transformable, float v3) {
        this.multiply(transformable, v3, transformable);
    }

    @Override
    public final void transform(Primitive32Vector4 transformable) {
        this.multiply(transformable, transformable);
    }

    @Override
    public final void transpose(Primitive32Matrix4 matrix) {
        this.m00 = matrix.m00;
        this.m01 = matrix.m10;
        this.m02 = matrix.m20;
        this.m03 = matrix.m30;
        this.m10 = matrix.m01;
        this.m11 = matrix.m11;
        this.m12 = matrix.m21;
        this.m13 = matrix.m31;
        this.m20 = matrix.m02;
        this.m21 = matrix.m12;
        this.m22 = matrix.m22;
        this.m23 = matrix.m32;
        this.m30 = matrix.m03;
        this.m31 = matrix.m13;
        this.m32 = matrix.m23;
        this.m33 = matrix.m33;
    }
}

