/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.algebra.VectorSpace;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.Scalar;

public final class ApplyLDL
extends MatrixOperation {
    public static final ApplyLDL SETUP = new ApplyLDL();
    public static int THRESHOLD = 256;

    public static void invoke(BigDecimal[] data, int structure, int firstColumn, int columnLimit, BigDecimal[] multipliers, int iterationPoint) {
        BigDecimal tmpDiagVal = data[iterationPoint + iterationPoint * structure];
        for (int j = firstColumn; j < columnLimit; ++j) {
            AXPY.invoke(data, j * structure, tmpDiagVal.multiply(multipliers[j]).negate(), multipliers, 0, j, structure);
        }
    }

    public static void invoke(double[] data, int structure, int firstColumn, int columnLimit, double[] multipliers, int iterationPoint) {
        double tmpDiagVal = data[iterationPoint + iterationPoint * structure];
        for (int j = firstColumn; j < columnLimit; ++j) {
            AXPY.invoke(data, j * structure, -(tmpDiagVal * multipliers[j]), multipliers, 0, j, structure);
        }
    }

    public static <N extends Number> void invoke(N[] data, int structure, int firstColumn, int columnLimit, N[] multipliers, int iterationPoint) {
        Scalar tmpDiagVal = (Scalar)data[iterationPoint + iterationPoint * structure];
        for (int j = firstColumn; j < columnLimit; ++j) {
            AXPY.invoke(data, (int)(j * structure), ((Scalar)tmpDiagVal.multiply((Scalar)((VectorSpace)multipliers[j]).conjugate()).negate()).get(), multipliers, (int)0, (int)j, (int)structure);
        }
    }

    private ApplyLDL() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

