/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.task.iterative;

import org.ojalgo.RecoverableCondition;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.task.iterative.StationaryIterativeSolver;
import org.ojalgo.type.context.NumberContext;

public final class JacobiSolver
extends StationaryIterativeSolver {
    @Override
    public final MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> current) throws RecoverableCondition {
        Object tmpBody = null;
        tmpBody = body instanceof MatrixStore && body.get(0L) instanceof Double ? (MatrixStore)body : MatrixStore.PRIMITIVE.makeWrapper(body).get();
        MatrixStore tmpBodyDiagonal = (MatrixStore)PrimitiveDenseStore.FACTORY.columns(tmpBody.sliceDiagonal(0L, 0L));
        Object tmpRHS = null;
        tmpRHS = rhs instanceof MatrixStore && rhs.get(0L) instanceof Double ? (MatrixStore)rhs : MatrixStore.PRIMITIVE.makeWrapper(rhs).get();
        PhysicalStore<Double> tmpIncrement = this.preallocate(body, rhs);
        double tmpNormErr = Double.POSITIVE_INFINITY;
        double tmpNormRHS = (Double)tmpRHS.aggregateAll(Aggregator.NORM2);
        int tmpIterations = 0;
        int tmpLimit = this.getIterationsLimit();
        NumberContext tmpCntxt = this.getAccuracyContext();
        double tmpRelaxation = this.getRelaxationFactor();
        do {
            current.premultiply((Access1D<Double>)tmpBody).operateOnMatching((MatrixStore<Double>)tmpRHS, (BinaryFunction<Double>)PrimitiveFunction.SUBTRACT).supplyTo(tmpIncrement);
            tmpNormErr = (Double)tmpIncrement.aggregateAll(Aggregator.NORM2);
            tmpIncrement.modifyMatching(PrimitiveFunction.DIVIDE, tmpBodyDiagonal);
            if (this.getAccuracyContext().isDifferent(PrimitiveMath.ONE, tmpRelaxation)) {
                tmpIncrement.multiply(tmpRelaxation);
            }
            current.modifyMatching(PrimitiveFunction.ADD, tmpIncrement);
            ++tmpIterations;
            if (!this.isDebugPrinterSet()) continue;
            this.debug(tmpIterations, current);
        } while (tmpIterations < tmpLimit && !tmpCntxt.isSmall(tmpNormRHS, tmpNormErr));
        return current;
    }
}

