/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.localThickness;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class Distance_Ridge
implements PlugInFilter {
    private ImagePlus imp;
    private ImagePlus resultImage;
    public float[][] data;
    public boolean runSilent = false;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 8;
    }

    public void run(ImageProcessor ip) {
        int i;
        float[] sk;
        this.resultImage = null;
        ImageStack stack = this.imp.getStack();
        int w = stack.getWidth();
        int h = stack.getHeight();
        int d = this.imp.getStackSize();
        ImageStack newStack = new ImageStack(w, h);
        float[][] sNew = new float[d][];
        for (int k = 0; k < d; ++k) {
            FloatProcessor ipk = new FloatProcessor(w, h);
            newStack.addSlice(null, (ImageProcessor)ipk);
            sNew[k] = (float[])ipk.getPixels();
        }
        float[][] s = new float[d][];
        for (int k = 0; k < d; ++k) {
            s[k] = (float[])stack.getPixels(k + 1);
        }
        IJ.showStatus((String)"Distance Ridge: scanning the data");
        float distMax = 0.0f;
        for (int k = 0; k < d; ++k) {
            sk = s[k];
            for (int j = 0; j < h; ++j) {
                int wj = w * j;
                for (i = 0; i < w; ++i) {
                    int ind = i + wj;
                    float skind = sk[ind];
                    if (!(skind > distMax)) continue;
                    distMax = skind;
                }
            }
        }
        int rSqMax = (int)(distMax * distMax + 0.5f) + 1;
        boolean[] occurs = new boolean[rSqMax];
        for (int i2 = 0; i2 < rSqMax; ++i2) {
            occurs[i2] = false;
        }
        for (int k = 0; k < d; ++k) {
            sk = s[k];
            for (int j = 0; j < h; ++j) {
                int wj = w * j;
                for (int i3 = 0; i3 < w; ++i3) {
                    int ind = i3 + wj;
                    float skind = sk[ind];
                    occurs[(int)(skind * skind + 0.5f)] = true;
                }
            }
        }
        int numRadii = 0;
        for (i = 0; i < rSqMax; ++i) {
            if (!occurs[i]) continue;
            ++numRadii;
        }
        int[] distSqIndex = new int[rSqMax];
        int[] distSqValues = new int[numRadii];
        int indDS = 0;
        for (int i4 = 0; i4 < rSqMax; ++i4) {
            if (!occurs[i4]) continue;
            distSqIndex[i4] = indDS;
            distSqValues[indDS++] = i4;
        }
        IJ.showStatus((String)"Distance Ridge: creating search templates");
        int[][] rSqTemplate = this.createTemplate(distSqValues);
        for (int k = 0; k < d; ++k) {
            IJ.showStatus((String)("Distance Ridge: processing slice " + (k + 1) + "/" + (d + 1)));
            sk = s[k];
            float[] skNew = sNew[k];
            for (int j = 0; j < h; ++j) {
                int wj = w * j;
                for (int i5 = 0; i5 < w; ++i5) {
                    int ind = i5 + wj;
                    float skind = sk[ind];
                    if (!(skind > 0.0f)) continue;
                    boolean notRidgePoint = false;
                    int sk0Sq = (int)(skind * skind + 0.5f);
                    int sk0SqInd = distSqIndex[sk0Sq];
                    for (int dz = -1; dz <= 1; ++dz) {
                        int k1 = k + dz;
                        if (k1 >= 0 && k1 < d) {
                            float[] sk1 = s[k1];
                            int numCompZ = dz == 0 ? 0 : 1;
                            for (int dy = -1; dy <= 1; ++dy) {
                                int j1 = j + dy;
                                int wj1 = w * j1;
                                if (j1 >= 0 && j1 < h) {
                                    int numCompY = dy == 0 ? 0 : 1;
                                    for (int dx = -1; dx <= 1; ++dx) {
                                        float sk1i1wj1;
                                        int sk1Sq;
                                        int numCompX;
                                        int numComp;
                                        int i1 = i5 + dx;
                                        if (i1 >= 0 && i1 < w && (numComp = (numCompX = dx == 0 ? 0 : 1) + numCompY + numCompZ) > 0 && (sk1Sq = (int)((sk1i1wj1 = sk1[i1 + wj1]) * sk1i1wj1 + 0.5f)) >= rSqTemplate[numComp - 1][sk0SqInd]) {
                                            notRidgePoint = true;
                                        }
                                        if (notRidgePoint) break;
                                    }
                                }
                                if (notRidgePoint) break;
                            }
                        }
                        if (notRidgePoint) break;
                    }
                    if (notRidgePoint) continue;
                    skNew[ind] = sk[ind];
                }
            }
        }
        IJ.showStatus((String)"Distance Ridge complete");
        String title = this.stripExtension(this.imp.getTitle());
        int slices = this.imp.getNSlices();
        int channels = this.imp.getNChannels();
        int frames = this.imp.getNFrames();
        this.resultImage = IJ.createHyperStack((String)(title + "_DR"), (int)w, (int)h, (int)channels, (int)slices, (int)frames, (int)32);
        this.resultImage.setStack(newStack, channels, slices, frames);
        this.resultImage.getProcessor().setMinAndMax(0.0, (double)distMax);
        if (!this.runSilent) {
            this.resultImage.show();
            IJ.run((String)"Fire");
        }
    }

    int[][] createTemplate(int[] distSqValues) {
        int[][] t = new int[][]{this.scanCube(1, 0, 0, distSqValues), this.scanCube(1, 1, 0, distSqValues), this.scanCube(1, 1, 1, distSqValues)};
        return t;
    }

    int[] scanCube(int dx, int dy, int dz, int[] distSqValues) {
        int numRadii = distSqValues.length;
        int[] r1Sq = new int[numRadii];
        if (dx == 0 && dy == 0 && dz == 0) {
            for (int rSq = 0; rSq < numRadii; ++rSq) {
                r1Sq[rSq] = Integer.MAX_VALUE;
            }
        } else {
            int dxAbs = -Math.abs(dx);
            int dyAbs = -Math.abs(dy);
            int dzAbs = -Math.abs(dz);
            for (int rSqInd = 0; rSqInd < numRadii; ++rSqInd) {
                int rSq = distSqValues[rSqInd];
                int max = 0;
                int r = 1 + (int)Math.sqrt(rSq);
                for (int k = 0; k <= r; ++k) {
                    int scank = k * k;
                    int dk = (k - dzAbs) * (k - dzAbs);
                    for (int j = 0; j <= r; ++j) {
                        int iPlus;
                        int dkji;
                        int scankj = scank + j * j;
                        if (scankj > rSq || (dkji = dk + (j - dyAbs) * (j - dyAbs) + (iPlus = (int)Math.sqrt(rSq - scankj) - dxAbs) * iPlus) <= max) continue;
                        max = dkji;
                    }
                }
                r1Sq[rSqInd] = max;
            }
        }
        return r1Sq;
    }

    String stripExtension(String name) {
        int dotIndex;
        if (name != null && (dotIndex = name.lastIndexOf(".")) >= 0) {
            name = name.substring(0, dotIndex);
        }
        return name;
    }

    public ImagePlus getResultImage() {
        return this.resultImage;
    }

    public void purge() {
        this.data = null;
        this.resultImage = null;
        this.imp = null;
    }
}

